/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.touchcomp.touchnfce.BaseDialog;
import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.ResourceBundle;
import javafx.embed.swing.SwingFXUtils;
import javafx.fxml.FXML;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyEvent;

public class QrCodeController
extends BaseDialog {
    @FXML
    private ImageView logo;
    public static final String QRCODE = "qrCode";
    String textoQrcode = "";

    @Override
    public void initializeController(ResourceBundle resources) {
        this.textoQrcode = (String)this.getParams().get(QRCODE);
        this.setImagem(this.textoQrcode);
    }

    @Override
    public void eventKey(KeyEvent evt) {
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void requestFocusOnOpen() {
    }

    private void setImagem(String text) {
        int width = 600;
        int height = 600;
        String format = "png";
        String filePath = "qrcode.png";
        try {
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix bitMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, width, height, new HashMap());
            Path path = FileSystems.getDefault().getPath(filePath, new String[0]);
            BufferedImage b = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
            MatrixToImageWriter.writeToPath((BitMatrix)bitMatrix, (String)format, (Path)path);
            Desktop.getDesktop().open(path.toFile());
            WritableImage img = SwingFXUtils.toFXImage((BufferedImage)b, null);
            this.logo.setImage((Image)img);
            System.out.println("QR Code gerado com sucesso!");
        }
        catch (WriterException | IOException e) {
            System.out.println("Erro ao gerar QR Code: " + e.getMessage());
        }
    }
}

