/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.sincronizardados.thread;

import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorexceptions.exceptions.impl.zip.ExceptionZip;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.sincronizardados.thread.BaseSinc;
import com.touchcomp.touchnfce.model.DadosSincronizacao;
import com.touchcomp.touchnfce.sinc.receive.SincBase;
import com.touchcomp.touchnfce.sinc.receive.SincFactory;
import com.touchcomp.touchnfce.sinc.receive.SincListener;
import com.touchcomp.touchnfce.sinc.receive.SincParams;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.control.TextArea;

public class SincReceive
extends BaseSinc
implements SincListener,
Runnable {
    private static SincReceive instance;
    private String sincRecebimento = "";
    private TextArea txtDadosRecebidos;
    private boolean isFinish = true;

    private SincReceive(TextArea txtDadosRecebidos) {
        this.txtDadosRecebidos = txtDadosRecebidos;
    }

    public static SincReceive getInstance(TextArea txtDadosRecebidos) {
        if (instance == null) {
            instance = new SincReceive(txtDadosRecebidos);
        } else {
            SincReceive.instance.txtDadosRecebidos = txtDadosRecebidos;
        }
        return instance;
    }

    @Override
    public void run() {
        try {
            if (!this.isFinish) {
                System.out.println("Sincronizacao ja esta em andamento em segundo plano. ");
                return;
            }
            if (this.checkLockSinc().booleanValue()) {
                this.updateTextArea("A sincroniza\u00e7\u00e3o est\u00e1 bloqueada nas op\u00e7\u00f5es de sua empresa.\n");
                return;
            }
            this.updateTextArea("");
            this.isFinish = false;
            this.sincRecebimento = "";
            DadosSincronizacao dadosSincronizacao = StaticObjects.getDadosSincronizacao();
            SincParams params = new SincParams(dadosSincronizacao);
            SincFactory.getInstance().setListener(this);
            SincFactory.getInstance().startSincRecebimento(params);
            this.isFinish = true;
        }
        catch (ExceptionDecodeHexString64 | ExceptionIO | ExceptionReflection | ExceptionWebService | ExceptionZip ex) {
            this.isFinish = true;
            this.updateTextArea(ex.getMessage());
            ex.printStackTrace();
            Logger.getLogger(SincReceive.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException e) {
            this.isFinish = true;
            this.updateTextArea(e.getMessage());
            e.printStackTrace();
            Logger.getLogger(SincReceive.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (ExceptionCertificado exceptionCertificado) {
            this.isFinish = true;
            exceptionCertificado.printStackTrace();
            this.updateTextArea(exceptionCertificado.getMessage());
            Logger.getLogger(SincReceive.class.getName()).log(Level.SEVERE, null, exceptionCertificado);
        }
        catch (Exception ex) {
            this.isFinish = true;
            this.updateTextArea(ex.getMessage());
            ex.printStackTrace();
            Logger.getLogger(SincReceive.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.isFinish = true;
        }
    }

    private void updateTextArea(String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        if (this.txtDadosRecebidos == null) {
            return;
        }
        Platform.runLater(() -> this.txtDadosRecebidos.appendText(message));
    }

    @Override
    public void beforeSincRec(List<SincBase> sincs) {
        this.txtDadosRecebidos.clear();
        this.updateTextArea("Iniciando Sincronizacao.");
    }

    @Override
    public void onSincDataSizeRec(SincBase base, double perc) {
        this.sincRecebimento = "Verificando Dados: " + base.getDescSinc() + " " + ToolFormatter.formataNumero((Number)perc, (int)2) + "%\n";
        this.updateTextArea(this.sincRecebimento);
    }

    @Override
    public void onSincDataRec(SincBase base, double perc) {
        this.sincRecebimento = "Sincronizando Recebimento: " + base.getDescSinc() + " " + ToolFormatter.formataNumero((Number)perc, (int)2) + "%\n";
        this.updateTextArea(this.sincRecebimento);
    }

    @Override
    public void afterSincRec(List<SincBase> sincs, Date in, Date end, Long durationInSeconds) {
        this.updateTextArea(this.sincRecebimento);
        this.updateTextArea("Sincronizacao terminada.");
    }

    @Override
    public void onSincProgressItemRec(long perc) {
    }
}

