/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.splash;

import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.splash.impl.SplashController;
import com.touchcomp.touchnfce.properties.PropertiesLoader;
import com.touchcomp.touchnfce.utils.Style;
import com.touchcomp.touchnfce.utils.UtilImageSvg;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.apache.batik.transcoder.TranscoderException;

public abstract class SplashMain<T>
extends Task<T>
implements Initializable {
    protected final Stage dialog = new Stage();
    protected final Scene scene;
    protected Label text;

    public SplashMain(Window owner) {
        this.dialog.initStyle(StageStyle.UNDECORATED);
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        if (owner != null) {
            this.dialog.initOwner(owner);
        }
        this.scene = this.createScene();
        this.dialog.setScene(this.scene);
        this.setOnFailed(this::onFailed);
        this.setOnSucceeded(this::onSuccess);
    }

    protected Stage getStage() {
        return this.dialog;
    }

    private Scene createScene() {
        ImageView logo = new ImageView();
        try {
            UtilImageSvg.generateImageFromSvg("logo_splash");
            Image image = new Image((InputStream)new FileInputStream("target/classes/images/logo_splash.png"));
            logo.setImage(image);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(SplashController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
        catch (IOException | TranscoderException ex) {
            Logger.getLogger(SplashController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
        BorderPane p = new BorderPane();
        this.text = new Label("Processando opera\u00e7\u00e3o..");
        PropertiesLoader props = PropertiesLoader.get();
        Style style = new Style();
        this.text.setStyle(style.getCorTexto(props.getCorTexto()) + "-fx-font: 23pt \"Microsoft New Tai Lue\"");
        p.setBottom((Node)this.text);
        p.setRight(null);
        p.setLeft(null);
        p.setTop(null);
        p.setCenter((Node)logo);
        p.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        p.setStyle(style.getCorBody(props.getCorBackground_1(), props.getCorBackground_2(), props.getCorBackground_3(), props.getCorBackground_4(), props.getCorBackground_5()));
        return new Scene((Parent)p, 900.0, 350.0);
    }

    private void onSuccess(WorkerStateEvent workerStateEvent) {
        Platform.runLater(this::closeDialog);
        this.successTask();
    }

    protected abstract void successTask();

    protected void onFailed(WorkerStateEvent workerStateEvent) {
        Platform.runLater(this::closeDialog);
        this.errorTask(workerStateEvent);
    }

    protected abstract void errorTask(WorkerStateEvent var1);

    private void closeDialog() {
        this.dialog.close();
        Main.get().getPrimaryStage().requestFocus();
    }

    public SplashMain() {
        this(null);
    }

    protected abstract T call() throws Exception;

    public void show() {
        this.dialog.centerOnScreen();
        this.dialog.show();
        Executors.newSingleThreadExecutor().submit((Runnable)((Object)this));
    }

    public void showAndWait() {
        this.dialog.centerOnScreen();
        Executors.newSingleThreadExecutor().submit((Runnable)((Object)this));
        this.dialog.showAndWait();
        Main.get().getPrimaryStage().requestFocus();
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    public void updateStatus(String str) {
        if (this.text != null) {
            Platform.runLater(() -> this.text.setText(str));
        }
    }
}

