/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.splash.impl;

import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.DadosSincronizacao;
import com.touchcomp.touchnfce.properties.PropertiesLoader;
import com.touchcomp.touchnfce.service.impl.ServiceOtimizacaoBanco;
import com.touchcomp.touchnfce.sinc.receive.SincBase;
import com.touchcomp.touchnfce.sinc.receive.SincFactory;
import com.touchcomp.touchnfce.sinc.receive.SincListener;
import com.touchcomp.touchnfce.sinc.receive.SincParams;
import com.touchcomp.touchnfce.utils.Style;
import com.touchcomp.touchnfce.utils.UtilImageSvg;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;
import org.apache.batik.transcoder.TranscoderException;

public class SplashController
implements Initializable {
    @FXML
    private ImageView imgLogoTouch;
    @FXML
    private ProgressBar progressBarLoading;
    @FXML
    private Label lblStatus;
    @FXML
    private AnchorPane body;
    @FXML
    private ImageView logo;

    public void initialize(URL url, ResourceBundle rb) {
        PropertiesLoader props = PropertiesLoader.get();
        Style style = new Style();
        this.body.setStyle(style.getCorBody(props.getCorBackground_1(), props.getCorBackground_2(), props.getCorBackground_3(), props.getCorBackground_4(), props.getCorBackground_5()));
        this.lblStatus.setAlignment(Pos.CENTER);
        this.lblStatus.setTextAlignment(TextAlignment.CENTER);
        this.lblStatus.setStyle(style.getCorTexto(props.getCorTexto()) + "-fx-font: 23pt \"Microsoft New Tai Lue\"");
        this.inicializaImagem();
        this.rotateImageTouch();
        this.executeExampleProgressBar();
    }

    private void inicializaImagem() {
        try {
            UtilImageSvg.generateImageFromSvg("logo_splash");
            Image image = new Image((InputStream)new FileInputStream("target/classes/images/logo_splash.png"));
            this.logo.setImage(image);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(SplashController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
        catch (IOException | TranscoderException ex) {
            Logger.getLogger(SplashController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
    }

    public void executeExampleProgressBar() {
        Service servico = new Service(){

            protected Task createTask() {
                return new MyTask(SplashController.this);
            }
        };
        this.lblStatus.textProperty().bind((ObservableValue)servico.messageProperty());
        this.progressBarLoading.progressProperty().bind((ObservableValue)servico.progressProperty());
        servico.restart();
    }

    private void rotateImageTouch() {
        RotateTransition rt = new RotateTransition(Duration.millis((double)10000.0), (Node)this.imgLogoTouch);
        rt.setByAngle(360.0);
        rt.setCycleCount(-1);
        rt.setInterpolator(Interpolator.LINEAR);
        rt.play();
    }

    private class MyTask
    extends Task
    implements SincListener {
        Throwable throwable;

        private MyTask(SplashController splashController) {
        }

        protected void failed() {
            Logger.getLogger(SplashController.class.getName()).log(Level.SEVERE, null, this.throwable);
            Alerts.showAlertError("Ocorreu uma falha ao sincronizar: ", "Ocorreu uma falha ao sincronizar: " + (this.throwable != null ? this.throwable.getMessage() : ""));
            Main.get().mudaTelaUndecorated(Controllers.OPCOES_SINCRONIZACAO);
            Main.get().getPrimaryStage().setMaximized(true);
        }

        protected Void call() throws Exception {
            SincFactory.getInstance().setListener(this);
            try {
                DadosSincronizacao dadosSincronizacao = StaticObjects.getDadosSincronizacao();
                SincParams params = new SincParams(dadosSincronizacao);
                SincFactory.getInstance().setListener(this);
                SincFactory.getInstance().startSincRecebimento(params);
                this.otimizarBanco();
            }
            catch (ExceptionIO ex) {
                this.throwable = ex;
                Logger.getLogger(SplashController.class.getName()).log(Level.SEVERE, null, ex);
                Alerts.showAlertError("Erro", ex.getMessage());
            }
            catch (ExceptionDecodeHexString64 | ExceptionReflection | ExceptionWebService ex) {
                this.throwable = ex;
                Logger.getLogger(SplashController.class.getName()).log(Level.SEVERE, null, ex);
                Alerts.showAlertError("Erro", ex.getMessage());
            }
            catch (Throwable ex) {
                this.throwable = ex;
                Logger.getLogger(SplashController.class.getName()).log(Level.SEVERE, null, ex);
                Alerts.showAlertError("Erro", ex.getMessage());
            }
            return null;
        }

        private void otimizarBanco() {
            try {
                ServiceOtimizacaoBanco service = Main.getBean(ServiceOtimizacaoBanco.class);
                service.otimizarBanco();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        protected void succeeded() {
            super.succeeded();
            Alerts.showAlertInfo("A Sincroniza\u00e7\u00e3o foi finalizada. O sistema ser\u00e1 encerrado. Execute novamente o mesmo para logar e realizar as configura\u00e7\u00f5es finais.");
            System.exit(0);
        }

        @Override
        public void beforeSincRec(List<SincBase> sincs) {
            this.updateMessage("Iniciando sincroniza\u00e7\u00e3o");
        }

        @Override
        public void onSincDataSizeRec(SincBase base, double perc) {
            this.updateMessage("Quantidade reg.: " + base.getDescSinc());
            this.updateProgress(perc, 100.0);
        }

        @Override
        public void onSincDataRec(SincBase base, double perc) {
            this.updateMessage(base.getDescSinc());
        }

        @Override
        public void afterSincRec(List<SincBase> sincs, Date in, Date end, Long durationInSeconds) {
        }

        @Override
        public void onSincProgressItemRec(long perc) {
            this.updateProgress(perc, 100L);
        }
    }
}

