/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.splash.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoEmissao;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.splash.SplashMain;
import com.touchcomp.touchnfce.helpers.nfcesefaz.HelperNFCeSefazBase;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeLoteNotas;
import com.touchcomp.touchnfce.model.NFCePagamento;
import com.touchcomp.touchnfce.model.TipoEmissaoNFe;
import com.touchcomp.touchnfce.model.Usuario;
import com.touchcomp.touchnfce.print.impl.PrintBoleto;
import com.touchcomp.touchnfce.service.impl.ServiceNFCe;
import com.touchcomp.touchnfce.service.impl.ServiceNFCePagamentoCDC;
import com.touchcomp.touchnfce.sinc.receive.SincOthers;
import com.touchcomp.touchnfce.sinc.send.SincEnvFactory;
import com.touchcomp.touchnfce.tasks.utils.UtilEnviaNFCeWebService;
import com.touchcomp.touchnfce.utils.UtilCronoanalise;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import com.touchcomp.touchnfce.utils.UtilNFCeCalculos;
import com.touchcomp.touchnfce.utils.sitef.UtilSitefPagamento;
import com.touchcomp.touchvomodel.vo.geracaoboleto.DTOResultProcessGerBol;
import java.io.File;
import java.rmi.RemoteException;
import javafx.application.Platform;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.Initializable;

public class SplashEnvioNFCe
extends SplashMain<NFCeLoteNotas>
implements Initializable {
    ServiceNFCe serviceNFCe = Main.getBean(ServiceNFCe.class);

    @Override
    protected void successTask() {
        this.updateStatus("Imprimindo...");
        UtilCronoanalise.addTask("Imprimindo NFCE");
        UtilEnviaNFCeWebService.posEnvio(StaticObjects.getNfceAberta());
        StaticObjects.clearNFCe();
        Main.get().getHeaderController().setTextHeader("");
        UtilCronoanalise.endAndPrintAll();
        this.vaiTelaVenda();
    }

    @Override
    protected void errorTask(WorkerStateEvent workerStateEvent) {
        Alerts.showAlertError("Erro ao enviar a NFCe:\n\n" + workerStateEvent.getSource().getException().getMessage());
        StaticObjects.reloadNFCeAberta();
        this.vaiTelaVenda();
    }

    @Override
    protected NFCeLoteNotas call() throws Exception {
        try {
            UtilCronoanalise.start();
            UtilCronoanalise.addTask("Criando Lote de notas fiscais");
            TipoEmissaoNFe tipoEmissao = this.getTipoEmissaoNFe();
            NFCe nf = UtilEnviaNFCeWebService.criaLoteNotas(StaticObjects.getNfceAberta());
            nf.setEnviado((short)1);
            UtilNFCe.ajustaDataEmissao(nf);
            this.tratativasNFCeByPedido(nf);
            this.setNumeroNFCeItemSomenteItemAtivo(nf);
            UtilCronoanalise.addTask("Definindo observacoes");
            UtilNFCeCalculos.definirObservacoes(nf);
            UtilCronoanalise.addTask("Salva NFCe");
            this.tratativasNFCeByPedidoPos(nf);
            nf = UtilNFCe.save(nf);
            if (!tipoEmissao.getCodigo().equals(EnumConstNFeTipoEmissao.NORMAL.getValue())) {
                nf = this.enviarContigencia(nf);
            } else if (!EnumConstNFeStatus.isStatusFinal((Integer)(nf = this.enviarNormal(nf)).getStatus()) && !EnumConstNFeStatus.isRejeitada((Integer)nf.getStatus()) && ToolMethods.isEquals((Object)nf.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
                this.updateStatus("N\u00e3o foi poss\u00edvel enviar, mudando para contig\u00eancia...");
                nf = this.mudarEnviarContigencia(nf, StaticObjects.getUsuario());
            }
            new HelperNFCeSefazBase().atualizaDadosCancDenegInutNota(nf);
            if (ToolMethods.isEquals((Object)nf.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
                this.updateStatus("NFe processada.");
            } else {
                this.updateStatus("NFCe processada.");
            }
            UtilCronoanalise.addTask("Confirma pagamentos CDC");
            nf = this.confirmarPagamentosCDC(nf);
            UtilCronoanalise.addTask("Sincroniza/gera boletos");
            nf = this.sincronizaNFByGerarBoleto(nf);
            return nf.getLoteNotas();
        }
        catch (Exception ex) {
            TLogger.get(((Object)((Object)this)).getClass()).error((Throwable)ex);
            throw ex;
        }
    }

    private void setNumeroNFCeItemSomenteItemAtivo(NFCe nf) {
        int numeroItem = 1;
        for (NFCeItem item : nf.getItens()) {
            if (ToolMethods.isEquals((Object)item.getStatus(), (Object)1)) {
                item.setNumeroItem(numeroItem);
                ++numeroItem;
                continue;
            }
            item.setNumeroItem(0);
        }
    }

    private NFCe mudarEnviarContigencia(NFCe nf, Usuario usuario) throws Exception {
        NFCe nova = UtilNFCe.getNewNFCeContigencia(nf, usuario);
        nova = StaticObjects.setNfceAberta(nova);
        nova = UtilEnviaNFCeWebService.criaLoteNotas(nova);
        nova = UtilNFCe.save(nova);
        return this.enviarContigencia(nova);
    }

    private NFCe enviarNormal(NFCe nf) throws InterruptedException {
        Short tentativas = 1;
        Short nrTentativas = StaticObjects.getOpcoes().getTentativasEnvio();
        Short timeoutSeg = StaticObjects.getOpcoes().getTimeoutErroEnvio();
        if (nrTentativas == null || nrTentativas < 1) {
            nrTentativas = 3;
        }
        if (timeoutSeg == null || timeoutSeg < 1) {
            timeoutSeg = 20;
        }
        do {
            if (tentativas > 1) {
                Thread.sleep(timeoutSeg * 1000);
                this.updateStatus("Houve um problema ao comunicar, tentando novamente " + tentativas + "/" + nrTentativas);
            } else if (ToolMethods.isEquals((Object)nf.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
                this.updateStatus("Enviando NFe.");
            } else {
                this.updateStatus("Enviando NFCe.");
            }
            try {
                nf = UtilEnviaNFCeWebService.execute(nf);
            }
            catch (Throwable ex) {
                this.updateStatus("Houve um erro ao enviar a NFCe. \nSer\u00e3o realizadas novas tentativas:\n " + ex.getMessage());
                ex.printStackTrace();
                if (ex instanceof RemoteException) {
                    Short s = tentativas;
                    tentativas = (short)(tentativas + 1);
                    continue;
                }
                throw new RuntimeException(ex);
            }
            Short s = tentativas;
            tentativas = (short)(tentativas + 1);
        } while (tentativas <= nrTentativas && !EnumConstNFeStatus.isStatusFinal((Integer)nf.getStatus()) && !EnumConstNFeStatus.isRejeitada((Integer)nf.getStatus()));
        return nf;
    }

    private NFCe enviarContigencia(NFCe nfCe) throws Exception {
        return UtilEnviaNFCeWebService.execute(nfCe);
    }

    private NFCe confirmarPagamentosCDC(NFCe nfce) {
        ServiceNFCePagamentoCDC service = Main.getBean(ServiceNFCePagamentoCDC.class);
        for (NFCePagamento n : nfce.getPagamentos()) {
            if (n.getNfcePagamentoCDC() == null) continue;
            this.updateStatus("Confirmando pagamentos CDC.");
            int retorno = new UtilSitefPagamento().finalizarTransacaoSiTef(1, n.getSerialForSinc(), nfce.getDataEmissao(), nfce.getDataEmissao());
            if (retorno != 0) continue;
            n.getNfcePagamentoCDC().setStatus((short)1);
            n.setNfcePagamentoCDC(service.merge(n.getNfcePagamentoCDC()));
        }
        return nfce;
    }

    private void vaiTelaVenda() {
        Main.get().mudaTela(Controllers.VENDA);
    }

    private NFCe sincronizaNFByGerarBoleto(NFCe nf) {
        if (!EnumConstNFeStatus.isStatusAutorizadaOuContigencia((Integer)nf.getStatus())) {
            return nf;
        }
        if (!UtilNFCe.possuiPagBoleto(nf) && !UtilNFCe.possuiItensReceita(nf)) {
            return nf;
        }
        try {
            nf = this.verificaEnvioImediato(nf);
            this.verificaEnviaBoleto(nf);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Alerts.showAlertError("Houve erros ao gerar os boletos:\n" + ex.getMessage());
                }
            });
        }
        return nf;
    }

    private NFCe verificaEnvioImediato(NFCe nf) throws Exception {
        if (!ToolMethods.isAffirmative((Number)nf.getSincronizacaoManual())) {
            return nf;
        }
        return this.sincronizaNFCe(nf);
    }

    private void verificaEnviaBoleto(NFCe nf) throws Exception {
        if (!UtilNFCe.possuiPagBoleto(nf)) {
            return;
        }
        DTOResultProcessGerBol resultTemp = SincOthers.getBoletoCobrancaByNFCe(nf.getIdentificadorERP(), nf.getModeloDocFiscal().getCodigo());
        if (resultTemp == null || !ToolMethods.isStrWithData((String)resultTemp.getFile())) {
            return;
        }
        File file = ToolFile.createTempFile((String)"boleto_NFCe", (String)".pdf");
        ToolFile.writeBytesOnFile((File)file, (byte[])ToolHexString.decodeToByte((String)resultTemp.getFile()));
        new PrintBoleto(file);
    }

    private NFCe sincronizaNFCe(NFCe nf) throws Exception {
        this.updateStatus("Sincronizando NFCe/NFe junto ao servidor");
        nf = this.setTipoSincronizacaoManualNFCe(nf, (short)1);
        SincEnvFactory.getInstance().startSincNFCeImediatamente(nf);
        NFCe vo = (NFCe)this.serviceNFCe.get(nf.getIdentificador());
        return vo;
    }

    private TipoEmissaoNFe getTipoEmissaoNFe() {
        return StaticObjects.getNfceAberta().getPeriodoEmissaoNFCe() != null ? StaticObjects.getNfceAberta().getPeriodoEmissaoNFCe().getTipoEmissaoNfe() : StaticObjects.getNfceAberta().getPeriodoEmissaoNFe().getTipoEmissaoNfe();
    }

    private void tratativasNFCeByPedido(NFCe nf) {
        if (nf.getPedido() == null) {
            return;
        }
        nf.setSincronizacaoManual((short)0);
    }

    private void tratativasNFCeByPedidoPos(NFCe nf) {
        if (nf.getPedido() == null) {
            return;
        }
        nf.setSincronizacaoManual((short)0);
        if (UtilNFCe.possuiPagBoleto(nf)) {
            nf.setSincronizacaoManual((short)1);
            return;
        }
        if (UtilNFCe.possuiItensReceita(nf)) {
            nf.setSincronizacaoManual((short)1);
            return;
        }
    }

    private NFCe setTipoSincronizacaoManualNFCe(NFCe nfce, short tipoSincronizacao) {
        NFCe vo = (NFCe)this.serviceNFCe.get(nfce.getIdentificador());
        vo.setSincronizacaoManual(tipoSincronizacao);
        return this.serviceNFCe.save(vo);
    }
}

