/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.splash.impl;

import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.email.LogEmail;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.splash.SplashMain;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.tasks.utils.UtilEmail;
import java.util.LinkedList;
import java.util.List;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.Initializable;

public class SplashEnvioNFCeEmail
extends SplashMain<LogEmail>
implements Initializable {
    private NFCe nfce;
    private NFCeOpcoes opcoes;
    private List<String> outrosEmails = new LinkedList<String>();

    public SplashEnvioNFCeEmail(NFCe nfce, NFCeOpcoes opcoes, List<String> outrosEmails) {
        this.nfce = nfce;
        this.opcoes = opcoes;
        this.outrosEmails = outrosEmails;
    }

    public SplashEnvioNFCeEmail(NFCe nfce, NFCeOpcoes opcoes) {
        this.nfce = nfce;
        this.opcoes = opcoes;
    }

    @Override
    protected void successTask() {
        Alerts.showAlertInfo("Email enviado com sucesso!");
        Main.get().mudaTela(StaticObjects.getUltimaPagina());
    }

    @Override
    protected void errorTask(WorkerStateEvent workerStateEvent) {
        Alerts.showAlertError("Erro ao enviar a NFCe por email:\n\n" + workerStateEvent.getSource().getException().getMessage());
    }

    @Override
    protected LogEmail call() throws Exception {
        try {
            return UtilEmail.enviaNFePorEmail(this.nfce, this.opcoes, this.outrosEmails, true);
        }
        catch (Exception ex) {
            TLogger.get(((Object)((Object)this)).getClass()).error((Throwable)ex);
            throw ex;
        }
    }
}

