/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.splash.impl;

import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.ToastText;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.splash.SplashMain;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.service.impl.ServicePedidoEnv;
import com.touchcomp.touchnfce.sinc.send.SincEnvFactory;
import com.touchcomp.touchnfce.utils.pedido.UtilPedido;
import javafx.application.Platform;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.Initializable;

public class SplashEnvioPedido
extends SplashMain<Pedido>
implements Initializable {
    private Pedido pedido;
    ServicePedidoEnv servicePedido = Main.getBean(ServicePedidoEnv.class);

    public SplashEnvioPedido(Pedido pedido) {
        this.setPedido(pedido);
    }

    @Override
    protected void successTask() {
        UtilPedido.showOpcaoImpressaoPreVenda(this.pedido);
        ToastText.makeText(Main.get().getPrimaryStage(), "Pr\u00e9 Venda Sincronizada com Sucesso", 2000, 100, 100);
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getGerarControleVendaPedido(), (Object)1) && ToolMethods.isEquals((Object)this.pedido.getSituacaoPedidos().getGerarFinanceiroNFCe(), (Object)1)) {
            Main.get().mudaTela(Controllers.CONTROLE_ENTREGA_ITENS_PEDIDO);
        } else {
            StaticObjects.clearPedido();
            Main.get().mudaTela(Controllers.PRE_VENDA);
        }
    }

    @Override
    protected void errorTask(final WorkerStateEvent workerStateEvent) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Alerts.showAlertError("Erro ao Sincronizar a Pr\u00e9 Venda:\n\n" + workerStateEvent.getSource().getException().getMessage());
            }
        });
    }

    @Override
    protected Pedido call() throws Exception {
        try {
            this.servicePedido.save(this.getPedido());
            this.sincronizaPedido();
            return null;
        }
        catch (Exception ex) {
            TLogger.get(((Object)((Object)this)).getClass()).error((Throwable)ex);
            throw ex;
        }
    }

    private void sincronizaPedido() throws ExceptionIO, ExceptionReflection, ExceptionWebService, ExceptionDecodeHexString64, InterruptedException, Exception {
        SincEnvFactory.getInstance().startSincPedido(this.pedido);
        Thread.sleep(1000L);
    }

    public Pedido getPedido() {
        return this.pedido;
    }

    public void setPedido(Pedido pedido) {
        this.pedido = pedido;
    }
}

