/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.splash.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoEmissao;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.splash.SplashMain;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.print.impl.PrintDanfce;
import com.touchcomp.touchnfce.print.impl.PrintDanfe;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.Initializable;

public class SplashImpressaoDanfce
extends SplashMain
implements Initializable {
    private NFCe currentNfce;

    public SplashImpressaoDanfce(NFCe currentNfce) {
        this.currentNfce = currentNfce;
    }

    @Override
    protected void successTask() {
        Alerts.showAlertInfo("Comprovante impresso com sucesso!");
    }

    @Override
    protected void errorTask(WorkerStateEvent workerStateEvent) {
        Alerts.showAlertError("Erro ao imprimir comprovante:\n\n" + workerStateEvent.getSource().getException().getMessage());
    }

    protected Object call() throws Exception {
        try {
            if (this.currentNfce.getXml() == null) {
                throw new Exception("Nota sem XML. Provavelmente foi cancelada/inutilizada");
            }
            if (!UtilNFCe.isStatusValidoImpressao(this.currentNfce)) {
                throw new Exception("Status inv\u00e1lido para impress\u00e3o: " + this.currentNfce.getStatus() + "/" + this.currentNfce.getMotivo());
            }
            if (ToolMethods.isEquals((Object)this.currentNfce.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
                new PrintDanfe().printDanfce(this.currentNfce, StaticObjects.getOpcoes().getNrImpressoesNFe());
            } else if (this.currentNfce.getPeriodoEmissaoNFCe().getTipoEmissaoNfe().getCodigo().shortValue() == EnumConstNFeTipoEmissao.CONTIGENCIA_OFFLINE.getValue() || this.currentNfce.getPeriodoEmissaoNFCe().getTipoEmissaoNfe().getCodigo().shortValue() == EnumConstNFeTipoEmissao.CONTIGENCIA_EMISSAO_FS.getValue() || this.currentNfce.getPeriodoEmissaoNFCe().getTipoEmissaoNfe().getCodigo().shortValue() == EnumConstNFeTipoEmissao.CONTIGENCIA_FSDA.getValue()) {
                new PrintDanfce().printDanfce(this.currentNfce, (short)0, StaticObjects.getOpcoes().getNrImpressoesNFCe());
                new PrintDanfce().printDanfce(this.currentNfce, (short)1, StaticObjects.getOpcoes().getNrImpressoesNFCe());
            } else {
                new PrintDanfce().printDanfce(this.currentNfce, null, StaticObjects.getOpcoes().getNrImpressoesNFCe());
            }
            return null;
        }
        catch (Exception ex) {
            TLogger.get(((Object)((Object)this)).getClass()).error((Throwable)ex);
            throw ex;
        }
    }
}

