/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.splash.impl;

import com.touchcomp.basementor.constants.enums.EnumConstAbertoFechado;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoMovimentoCaixa;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorexceptions.exceptions.impl.print.ExceptionPrint;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.caixa.AberturaCaixaController;
import com.touchcomp.touchnfce.controller.splash.SplashMain;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.model.NFCeEncerranteAbastecimento;
import com.touchcomp.touchnfce.model.NFCeMovimentoCaixa;
import com.touchcomp.touchnfce.modeltemp.AberturaCaixa;
import com.touchcomp.touchnfce.print.impl.PrintAberturaCaixa;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeControleCaixa;
import com.touchcomp.touchnfce.sinc.send.SincEnvFactory;
import com.touchcomp.touchnfce.utils.UtilNFCeControleCaixa;
import com.touchcomp.touchnfce.utils.UtilNFCeSerial;
import com.touchcomp.touchnfce.utils.abastecimentocompanytec.UtilCentralAbastecimento;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.Initializable;

public class SplashSaveAberturaNFCeEncerranteAbastecimento
extends SplashMain<NFCeControleCaixa>
implements Initializable {
    private short status;
    private Date dataAbertura;
    private Double valorSuprimento;

    public SplashSaveAberturaNFCeEncerranteAbastecimento(short status, Date dataAbertura, Double valorSuprimento) {
        this.status = status;
        this.dataAbertura = dataAbertura;
        this.valorSuprimento = valorSuprimento;
    }

    @Override
    protected void successTask() {
        Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Caixa Aberto com Sucesso", "");
        Main.get().mudaTela(Controllers.MENU_PRINCIPAL);
    }

    @Override
    protected void errorTask(WorkerStateEvent workerStateEvent) {
        Alerts.showAlertError("Erro ao salvar abertura de caixa:\n\n" + workerStateEvent.getSource().getException().getMessage());
    }

    @Override
    protected NFCeControleCaixa call() throws Exception {
        try {
            NFCeControleCaixa abertCaixa = StaticObjects.getControleCaixa();
            Object movCaixa = null;
            if (abertCaixa == null) {
                abertCaixa = UtilNFCeControleCaixa.getNewNFCeControleCaixa();
            }
            if (this.valorSuprimento > 0.0) {
                abertCaixa.setNFCeMovCaixaAbertura(this.criaMovimentacao(EnumConstNFCeTipoMovimentoCaixa.ENTRADA_SUPRIMENTO.getValue(), abertCaixa));
            }
            ServiceNFCeControleCaixa serviceContCaixa = Main.getBean(ServiceNFCeControleCaixa.class);
            serviceContCaixa.saveAndMovAbert(abertCaixa);
            StaticObjects.setControleCaixa(abertCaixa);
            if (ToolMethods.isEquals((Object)StaticObjects.getEmpresa().getEmpresaDados().getTipoEmpresa().getCodigo().shortValue(), (Object)6) && UtilCentralAbastecimento.get().isControlMaster()) {
                this.updateStatus("Gerando Encerrantes Bico Bomba Combust\u00edvel");
                UtilCentralAbastecimento.get().createAndSaveEncerranteAbastecimento(abertCaixa, EnumConstAbertoFechado.ABERTO.value);
            }
            this.sinronizaAberturaCaixa(abertCaixa);
            this.imprimeComprovante(abertCaixa);
            return null;
        }
        catch (Throwable ex) {
            TLogger.get(((Object)((Object)this)).getClass()).error(ex);
            throw new Exception(ex.getMessage(), ex);
        }
    }

    public void imprimeComprovante(NFCeControleCaixa abertCaixa) {
        try {
            AberturaCaixa abert = new AberturaCaixa();
            abert.setDataAbertura(abertCaixa.getDataAbertura());
            abert.setEmpresa(abertCaixa.getNFCeCaixa().getEmpresa());
            abert.setUsuario(abertCaixa.getUsuario());
            abert.setCaixa(abertCaixa.getNFCeCaixa().getDescricao());
            if (abertCaixa.getNFCeMovCaixaAbertura() != null) {
                abert.setSuprimento(abertCaixa.getNFCeMovCaixaAbertura().getValor());
            }
            if (ToolMethods.isEquals((Object)StaticObjects.getEmpresa().getEmpresaDados().getTipoEmpresa().getCodigo().shortValue(), (Object)6) && UtilCentralAbastecimento.get().isControlMaster()) {
                abert.setEncerrantes(this.getEncerrantesAberturaCaixa(abertCaixa));
            }
            new PrintAberturaCaixa().printResumoCompleto(abert);
        }
        catch (ExceptionJasperReports | ExceptionPrint ex) {
            Logger.getLogger(AberturaCaixaController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
    }

    private List<AberturaCaixa.AberturaCaixaEncerrantes> getEncerrantesAberturaCaixa(NFCeControleCaixa abertCaixa) {
        ArrayList<AberturaCaixa.AberturaCaixaEncerrantes> aux = new ArrayList<AberturaCaixa.AberturaCaixaEncerrantes>();
        List<NFCeEncerranteAbastecimento> encerrantes = UtilCentralAbastecimento.get().getEncerranteAbastecimentoByControleCaixa(abertCaixa, EnumConstAbertoFechado.ABERTO.value);
        if (encerrantes != null && !encerrantes.isEmpty()) {
            for (NFCeEncerranteAbastecimento e : encerrantes) {
                aux.add(new AberturaCaixa.AberturaCaixaEncerrantes(e.getBico().getDescricao(), e.getQuantidade()));
            }
        }
        return aux;
    }

    private NFCeMovimentoCaixa criaMovimentacao(Integer tipoMovimentacao, NFCeControleCaixa abertCaixa) {
        NFCeMovimentoCaixa entradaMov = new NFCeMovimentoCaixa();
        entradaMov.setDataMovimento(new Date());
        entradaMov.setValor(this.valorSuprimento);
        entradaMov.setTipoMovimento(tipoMovimentacao);
        entradaMov.setObservacao("Saldo Inicial de Caixa");
        entradaMov.setSerialForSinc(UtilNFCeSerial.getSerial(StaticObjects.getNFCeCaixa()));
        if (tipoMovimentacao.equals(EnumConstNFCeTipoMovimentoCaixa.ENTRADA_SUPRIMENTO.getValue())) {
            abertCaixa.setValorTotalEntradasMov(this.valorSuprimento + abertCaixa.getValorTotalEntradasMov());
            abertCaixa.setValorTotalSistema(this.valorSuprimento + abertCaixa.getValorTotalSistema());
        } else {
            abertCaixa.setValorTotalSaidasMov(this.valorSuprimento + abertCaixa.getValorTotalSaidasMov());
            abertCaixa.setValorTotalSistema(abertCaixa.getValorTotalSistema() - this.valorSuprimento);
        }
        entradaMov.setControleCaixa(abertCaixa);
        return entradaMov;
    }

    private void sinronizaAberturaCaixa(NFCeControleCaixa abertCaixa) {
        if (ToolMethods.isAffirmative((Number)StaticObjects.getOpcoes().getBloqueioPreVenda())) {
            try {
                SincEnvFactory.getInstance().startSincNFCeControleCaixa(abertCaixa);
            }
            catch (ExceptionReflection ex) {
                TLogger.get(((Object)((Object)this)).getClass()).error((Throwable)ex);
            }
            catch (ExceptionDecodeHexString64 | ExceptionWebService ex) {
                TLogger.get(((Object)((Object)this)).getClass()).error(ex);
            }
            catch (Exception ex) {
                TLogger.get(((Object)((Object)this)).getClass()).error((Throwable)ex);
            }
        }
    }
}

