/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.splash.impl;

import com.touchcomp.basementor.constants.enums.EnumConstAbertoFechado;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorexceptions.exceptions.impl.print.ExceptionPrint;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.caixa.FechamentoCaixaController;
import com.touchcomp.touchnfce.controller.splash.SplashMain;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.modeltemp.ResumoRecebimento;
import com.touchcomp.touchnfce.print.impl.PrintFechamentoCaixaComp;
import com.touchcomp.touchnfce.print.impl.PrintFechamentoCaixaRes;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeControleCaixa;
import com.touchcomp.touchnfce.utils.abastecimentocompanytec.UtilCentralAbastecimento;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;

public class SplashSaveFechamentoNFCeEncerranteAbastecimento
extends SplashMain<NFCeControleCaixa>
implements Initializable {
    private NFCeControleCaixa caixaAberto;

    public SplashSaveFechamentoNFCeEncerranteAbastecimento(NFCeControleCaixa controleCaixa) {
        this.caixaAberto = controleCaixa;
    }

    @Override
    protected void successTask() {
        this.showAlertOpcaoImpressao();
        StaticObjects.setControleCaixa(null);
        Alerts.showAlertInfo("Sucesso", "Fechamento do caixa realizado com sucesso", "");
        Main.get().mudaTela(Controllers.MENU_PRINCIPAL);
    }

    @Override
    protected void errorTask(WorkerStateEvent workerStateEvent) {
        Alerts.showAlertError("Erro ao salvar o Fechamento de caixa:\n\n" + workerStateEvent.getSource().getException().getMessage());
    }

    @Override
    protected NFCeControleCaixa call() throws Exception {
        try {
            ServiceNFCeControleCaixa serviceContCaixa = Main.getBean(ServiceNFCeControleCaixa.class);
            this.caixaAberto.setDataFechamento(new Date());
            this.caixaAberto.setStatus((short)1);
            serviceContCaixa.save(this.caixaAberto);
            if (ToolMethods.isEquals((Object)StaticObjects.getEmpresa().getEmpresaDados().getTipoEmpresa().getCodigo().shortValue(), (Object)6)) {
                this.updateStatus("Bloqueando bombas");
                this.bloquearBombasAoSair();
                this.updateStatus("Gerando Encerrantes Bico Bomba Combust\u00edvel");
                UtilCentralAbastecimento.get().createAndSaveEncerranteAbastecimento(this.caixaAberto, EnumConstAbertoFechado.FECHADO.value);
                StaticObjects.setCentralAbastecimentoController(null);
            }
            return null;
        }
        catch (Throwable ex) {
            TLogger.get(((Object)((Object)this)).getClass()).error(ex);
            throw new Exception(ex.getMessage(), ex);
        }
    }

    private void showAlertOpcaoImpressao() {
        Alert dialogoExe = new Alert(Alert.AlertType.CONFIRMATION);
        ButtonType btnCompleto = new ButtonType("Completo", ButtonBar.ButtonData.OK_DONE);
        ButtonType btnSimplificado = new ButtonType("Simplificado");
        ButtonType btnCancelar = new ButtonType("Cancelar");
        dialogoExe.setTitle("Fechamento do caixa");
        dialogoExe.setHeaderText("Deseja imprimir o resumo do caixa como?");
        dialogoExe.getButtonTypes().setAll((Object[])new ButtonType[]{btnCompleto, btnSimplificado, btnCancelar});
        List<ResumoRecebimento> resumo = ResumoRecebimento.convertListControleCaixaRes(this.caixaAberto.getResumoRecebimentos());
        dialogoExe.showAndWait().ifPresent(b -> {
            if (b == btnCompleto) {
                try {
                    new PrintFechamentoCaixaComp().printResumoCompleto(StaticObjects.getControleCaixa(), resumo);
                }
                catch (ExceptionJasperReports | ExceptionPrint ex) {
                    Logger.getLogger(FechamentoCaixaController.class.getName()).log(Level.SEVERE, null, ex);
                    Alerts.showAlertError(ex.getMessage());
                }
            } else if (b == btnSimplificado) {
                try {
                    new PrintFechamentoCaixaRes().printResumoCompleto(StaticObjects.getControleCaixa());
                }
                catch (ExceptionJasperReports | ExceptionPrint ex) {
                    Logger.getLogger(FechamentoCaixaController.class.getName()).log(Level.SEVERE, null, ex);
                    Alerts.showAlertError(ex.getMessage());
                }
            } else {
                dialogoExe.close();
            }
        });
    }

    public void bloquearBombasAoSair() {
        try {
            if (!UtilCentralAbastecimento.get().isControlMaster()) {
                return;
            }
            if (!ToolMethods.isAffirmative((Number)StaticObjects.getOpcoes().getLibBloquearBombasSaiEntrar())) {
                return;
            }
            UtilCentralAbastecimento.get().bloqueiaAllBombaAbastecimento();
        }
        catch (Exception ex) {
            TLogger.get(((Object)((Object)this)).getClass()).error((Throwable)ex);
            Alerts.showAlertErrorRunLater("Erro ao alterar o preco na automacao: " + ex.getMessage());
        }
    }
}

