/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.splash.impl;

import br.com.softwareexpress.sitef.JCliSiTefI;
import com.touchcomp.basementor.constants.enums.cartaocreditositef.EnumConstSitefStatRetorno;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.MainEvents;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.splash.SplashMain;
import com.touchcomp.touchnfce.controller.splash.impl.thread.ThreadTEFPagamento;
import com.touchcomp.touchnfce.listeners.ShortcutListener;
import com.touchcomp.touchnfce.model.BandeiraTEF;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCePagamento;
import com.touchcomp.touchnfce.model.NFCePagamentoCDC;
import com.touchcomp.touchnfce.service.impl.ServiceBandeiraTEF;
import com.touchcomp.touchnfce.utils.sitef.SitefInterativoListener;
import com.touchcomp.touchnfce.utils.sitef.UtilSitefPagamento;
import com.touchcomp.touchnfce.utils.sitef.model.AuxPagamentoNFCe;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.fxml.Initializable;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;

public class SplashTEFPagamento
extends SplashMain<AuxPagamentoNFCe>
implements Initializable,
SitefInterativoListener,
ShortcutListener {
    private AuxPagamentoNFCe auxPagamento;
    private ThreadTEFPagamento currentThread;

    public SplashTEFPagamento(AuxPagamentoNFCe auxPagamento) {
        this.auxPagamento = auxPagamento;
        MainEvents.getInstance().setListener(this);
        KeyCodeCombination keyShiftTab = new KeyCodeCombination(KeyCode.ESCAPE, new KeyCombination.Modifier[]{KeyCombination.SHIFT_ANY});
        this.scene.addEventFilter(KeyEvent.KEY_RELEASED, (EventHandler)new EventHandler<KeyEvent>(){
            final /* synthetic */ KeyCombination val$keyShiftTab;
            {
                this.val$keyShiftTab = keyCombination;
            }

            public void handle(KeyEvent e) {
                if (this.val$keyShiftTab.match(e) && SplashTEFPagamento.this.currentThread != null) {
                    SplashTEFPagamento.this.currentThread.cancelarTransacao(true);
                    e.consume();
                }
            }
        });
    }

    @Override
    protected void successTask() {
        this.updateStatus("Processando...");
    }

    @Override
    protected void errorTask(WorkerStateEvent workerStateEvent) {
        Alerts.showAlertError("Erro ao realizar a transa\u00e7\u00e3o com cart\u00e3o de cr\u00e9dito:\n\n" + workerStateEvent.getSource().getException().getMessage());
    }

    private Short getTipoCartao(String tipoCartao) {
        if (tipoCartao.equals("04") || tipoCartao.equals("10") || tipoCartao.equals("11")) {
            return (short)2;
        }
        if (tipoCartao.equals("03")) {
            return (short)3;
        }
        if (tipoCartao.equals("13")) {
            return (short)7;
        }
        if (tipoCartao.equals("17")) {
            return (short)122;
        }
        return (short)0;
    }

    public boolean abrirTransacaoSitef(AuxPagamentoNFCe aux) {
        Integer tipoCartao = this.getTipoCartao(aux.getFormaPagNFCe().getTipoPagamento().getCodigo()).intValue();
        Double valor = aux.getNfcePagamento().getValorLiquido();
        NFCe nfce = aux.getNfcePagamento().getNfce();
        HashMap hash = new UtilSitefPagamento().iniciarPagamentoSiTef(tipoCartao, valor, aux.getNfcePagamento().getSerialForSinc(), nfce.getDataEmissao(), nfce.getDataEmissao(), StaticObjects.getUsuario().getPessoa().getIdentificador().toString(), "", aux, StaticObjects.getNFCeCaixa().getRestricoesSitef(), this);
        if (hash == null) {
            Platform.runLater((Runnable)new Runnable(this){

                @Override
                public void run() {
                    Alerts.showAlertInfo(MessagesBaseMentor.getErrorMsg((String)"E.NFC._TEF.003", (Object[])new Object[0]));
                }
            });
            return false;
        }
        final Integer retorno = (Integer)hash.get("retorno");
        if (retorno != null && retorno == 0) {
            this.createCDC(aux.getNfcePagamento(), hash);
            return true;
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EnumConstSitefStatRetorno ret = EnumConstSitefStatRetorno.get((int)retorno);
                Alerts.showAlertInfo("Nao houve retorno do TEF." + String.valueOf(ret) != null ? ret.getDescricao() : "");
            }
        });
        return false;
    }

    private void createCDC(NFCePagamento nfcePagamento, HashMap hash) {
        NFCePagamentoCDC r = new NFCePagamentoCDC();
        nfcePagamento.setNfcePagamentoCDC(r);
        r.setNfcePagamento(nfcePagamento);
        r.setNrNFCe(nfcePagamento.getNfce().getNumero());
        r.setVia1((String)hash.get("1viaTEF"));
        r.setVia2((String)hash.get("2viaTEF"));
        r.setNsu((String)hash.get("NR_CCD"));
        r.setCodigoBandeiraCartao((String)hash.get("BANDEIRA"));
        nfcePagamento.setCodigoBandeiraTEF(r.getCodigoBandeiraCartao());
        nfcePagamento.setBandeiraTEF(this.getBandeiraTEF(nfcePagamento.getTipoPagamentoNFe().getCodigo(), r.getCodigoBandeiraCartao()));
        nfcePagamento.setPermitirTEF((short)1);
        nfcePagamento.setNrAutorizacao(r.getNsu());
        if (hash.get("VR_PAGAMENTO") != null) {
            r.setValorPagamento(new Double((String)hash.get("VR_PAGAMENTO")));
        }
        if (hash.get("VR_TROCO") != null) {
            String valorTroco = (String)hash.get("VR_TROCO");
            r.setValorSaque(new Double(valorTroco.replaceAll(",", ".")));
        }
    }

    @Override
    protected AuxPagamentoNFCe call() throws Exception {
        try {
            this.abrirTransacaoSitef(this.auxPagamento);
            return this.auxPagamento;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
    }

    @Override
    public HashMap interacaoTef(HashMap h, JCliSiTefI j, Short restricoesTEF) {
        this.currentThread = new ThreadTEFPagamento(h, j, restricoesTEF, this);
        Platform.runLater((Runnable)this.currentThread);
        while (!this.currentThread.isFinished()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SplashTEFPagamento.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.currentThread.getParametros();
    }

    @Override
    public void firstEscapeKey(KeyEvent evt) {
        this.defaultTrataEventos(evt);
    }

    @Override
    public void evtKey(KeyEvent evt) {
        this.defaultTrataEventos(evt);
    }

    private void defaultTrataEventos(KeyEvent evt) {
        switch (evt.getCode()) {
            case F10: {
                Alerts.showAlertError("pare aqui");
            }
        }
    }

    private BandeiraTEF getBandeiraTEF(String codigo, String codigoBandeiraCartao) {
        if (codigo.equalsIgnoreCase("04") || codigo.equalsIgnoreCase("10") || codigo.equalsIgnoreCase("11")) {
            ServiceBandeiraTEF service = Main.getBean(ServiceBandeiraTEF.class);
            return service.findByCodigoAndDebCred(codigoBandeiraCartao, (short)0);
        }
        ServiceBandeiraTEF service = Main.getBean(ServiceBandeiraTEF.class);
        return service.findByCodigoAndDebCred(codigoBandeiraCartao, (short)1);
    }

    @Override
    public void evtAltControl(KeyEvent event) {
    }
}

