/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.splash.impl.thread;

import br.com.softwareexpress.sitef.JCliSiTefI;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.dialogs.DialogComboBox;
import com.touchcomp.touchnfce.controller.dialogs.DialogFieldMaxLenght;
import com.touchcomp.touchnfce.controller.splash.impl.SplashTEFTransacaoGerencial;
import com.touchcomp.touchnfce.utils.sitef.model.AuxPagamentoNFCe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;

public class ThreadTEFTransacaoGerencial
implements Runnable {
    private boolean finished;
    private HashMap parametros;
    private JCliSiTefI jCliSiTefI;
    Short restricoesTEF;
    private String texto = "";
    private String CABECALHO = "";
    private static String textoVisor = "";
    private boolean cancelaTransacao;
    private SplashTEFTransacaoGerencial splashTEFTransacaoGerencial;
    private Boolean stop;

    public ThreadTEFTransacaoGerencial(HashMap parametros, JCliSiTefI jCliSiTefI, Short restricoesTEF, SplashTEFTransacaoGerencial splashTEFTransacaoGerencial) {
        this.parametros = parametros;
        this.jCliSiTefI = jCliSiTefI;
        this.restricoesTEF = restricoesTEF;
        this.splashTEFTransacaoGerencial = splashTEFTransacaoGerencial;
    }

    @Override
    public void run() {
        try {
            this.callRunInternal();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.setFinished(true);
    }

    public void callRunInternal() {
        Integer proximoComando = this.getjCliSiTefI().getProximoComando();
        System.out.println("Comando: " + proximoComando + "  Buffer: " + this.getjCliSiTefI().getBuffer());
        switch (proximoComando) {
            case 0: {
                this.setInformacoesTEF(this.getjCliSiTefI(), this.parametros);
                break;
            }
            case 1: {
                this.texto = this.getjCliSiTefI().getBuffer();
                break;
            }
            case 3: {
                this.texto = this.getjCliSiTefI().getBuffer();
                textoVisor = this.getjCliSiTefI().getBuffer();
                this.splashTEFTransacaoGerencial.updateStatus(textoVisor);
                break;
            }
            case 4: {
                this.CABECALHO = this.getjCliSiTefI().getBuffer();
                break;
            }
            case 11: {
                this.texto = "";
                break;
            }
            case 13: {
                this.texto = "";
                break;
            }
            case 20: {
                if (this.stop != null && this.stop.booleanValue()) {
                    this.cancelarTransacao(true);
                    this.stop = false;
                    break;
                }
                this.exibirAlertInputCancelaConfirma(this.getjCliSiTefI());
                break;
            }
            case 21: {
                if (this.stop != null && this.stop.booleanValue()) {
                    this.cancelarTransacao(true);
                    this.stop = false;
                    break;
                }
                this.exibirAlertInputComboBox(this.getjCliSiTefI().getBuffer(), this.getjCliSiTefI(), this.parametros);
                break;
            }
            case 22: {
                if (this.stop != null && this.stop.booleanValue()) {
                    this.cancelarTransacao(true);
                    break;
                }
                if (this.getjCliSiTefI().getBuffer().trim().length() <= 150) {
                    this.exibirAlertInfo(this.getjCliSiTefI().getBuffer());
                    break;
                }
                this.exibirAlertInfo(this.getjCliSiTefI().getBuffer());
                break;
            }
            case 23: {
                if (this.stop == null || !this.stop.booleanValue()) break;
                this.cancelarTransacao(true);
                this.stop = false;
                break;
            }
            case 30: {
                if (this.stop != null && this.stop.booleanValue()) {
                    this.cancelarTransacao(true);
                    this.stop = false;
                    break;
                }
                this.getComandoCampo30(this.getjCliSiTefI(), this.parametros, this.restricoesTEF);
                break;
            }
            case 34: {
                if (this.stop != null && this.stop.booleanValue()) {
                    this.cancelarTransacao(true);
                    this.stop = false;
                    break;
                }
                this.getComandoCampo34(this.getjCliSiTefI(), this.parametros, this.restricoesTEF);
            }
        }
    }

    private void cancelarTransacao(Boolean cancela) {
        this.cancelaTransacao = cancela;
    }

    private void setInformacoesTEF(JCliSiTefI j, HashMap h) {
        Integer tipoCampo = j.getTipoCampo();
        switch (tipoCampo) {
            case 121: {
                h.put("1viaTEF", j.getBuffer());
                break;
            }
            case 122: {
                h.put("2viaTEF", j.getBuffer());
                break;
            }
            case 134: {
                h.put("NR_CCD", j.getBuffer());
                break;
            }
            case 105: {
                h.put("DATA_CCD", j.getBuffer());
                break;
            }
            case 130: {
                h.put("VR_TROCO", j.getBuffer());
                break;
            }
            case 138: {
                h.put("VR_RECEBIDO", j.getBuffer());
                break;
            }
            case 139: {
                h.put("VR_ENTRADA", j.getBuffer());
                break;
            }
            case 145: {
                h.put("VR_PAGAMENTO", j.getBuffer());
                break;
            }
            case 4029: {
                h.put("VR_DESCONTO_CIELO_PREMIA", j.getBuffer());
            }
        }
    }

    private void getComandoCampo30(JCliSiTefI j, HashMap h, Short restricoesTEF) {
        if (restricoesTEF == 1) {
            this.verificarTipoCampoComando30Restrito(j, h);
        } else {
            this.verificarTipoCampoComando30NaoRestrito(j, h);
        }
    }

    private void verificarTipoCampoComando30Restrito(JCliSiTefI j, HashMap h) {
        int tipoCampo = j.getTipoCampo();
        AuxPagamentoNFCe auxPagamento = (AuxPagamentoNFCe)h.get("AUX_PAGAMENTO");
        switch (tipoCampo) {
            case 514: {
                if (auxPagamento != null && auxPagamento.getCodSegurancaCartao() != null && this.validarTamanho(auxPagamento.getCodSegurancaCartao(), j).booleanValue()) {
                    j.setBuffer(auxPagamento.getCodSegurancaCartao());
                    auxPagamento.setCodSegurancaCartao(null);
                } else {
                    this.exibirAlertInputMascarado(j.getBuffer(), j, h);
                }
                return;
            }
            case 513: {
                if (auxPagamento != null && auxPagamento.getDataValidadeCartao() != null && this.validarTamanho(auxPagamento.getDataValidadeCartao(), j).booleanValue()) {
                    j.setBuffer(auxPagamento.getDataValidadeCartao());
                    auxPagamento.setDataValidadeCartao(null);
                } else {
                    this.exibirAlertInputTextoValidado(j.getBuffer(), j, h);
                }
                return;
            }
            case 512: {
                if (auxPagamento != null && auxPagamento.getNrCartao() != null && this.validarTamanho(auxPagamento.getNrCartao(), j).booleanValue()) {
                    j.setBuffer(auxPagamento.getNrCartao());
                    auxPagamento.setNrCartao(null);
                } else {
                    this.exibirAlertInputTextoValidado(j.getBuffer(), j, h);
                }
                return;
            }
            case 515: {
                this.exibirAlertInputTextoValidado(j.getBuffer(), j, h);
                return;
            }
            case 516: {
                this.exibirAlertInputTextoValidado(j.getBuffer(), j, h);
                return;
            }
            case 500: {
                this.exibirAlertInputMascarado(j.getBuffer(), j, h);
                return;
            }
            case 505: {
                if (StaticObjects.getNFCeCaixa().getRestricoesSitef() == 1) {
                    j.setBuffer(auxPagamento.getFormaPagNFCe().getNumeroParcelas().toString());
                } else {
                    this.exibirAlertInputTextoValidado(j.getBuffer(), j, h);
                }
                return;
            }
        }
        this.exibirAlertInputTextoValidado(j.getBuffer(), j, h);
    }

    private void exibirAlertInputTextoValidado(String buffer, JCliSiTefI j, HashMap h) {
        Short tamMaximo = j.getTamanhoMaximo();
        this.exibirAlertInputTexto(buffer, j, h, tamMaximo);
    }

    private void setPropertyCCD(JCliSiTefI j, HashMap h) {
        Integer tipoCampo = j.getTipoCampo();
        switch (tipoCampo) {
            case 516: {
                h.put("NR_CCD", j.getBuffer());
            }
        }
    }

    private Boolean validarTamanho(String nrCartao, JCliSiTefI j) {
        Short tamMinimo = j.getTamanhoMinimo();
        Short tamMaximo = j.getTamanhoMaximo();
        return nrCartao.trim().length() >= tamMinimo && nrCartao.trim().length() <= tamMaximo;
    }

    private void verificarTipoCampoComando30NaoRestrito(JCliSiTefI j, HashMap h) {
        int tipoCampo = j.getTipoCampo();
        AuxPagamentoNFCe auxPagamento = (AuxPagamentoNFCe)h.get("AUX_PAGAMENTO");
        switch (tipoCampo) {
            case 514: {
                this.exibirAlertInputTextoValidado(j.getBuffer(), j, h);
                return;
            }
            case 513: {
                this.exibirAlertInputTextoValidado(j.getBuffer(), j, h);
                return;
            }
            case 512: {
                this.exibirAlertInputTextoValidado(j.getBuffer(), j, h);
                return;
            }
            case 515: {
                this.exibirAlertInputTextoValidado(j.getBuffer(), j, h);
                return;
            }
            case 516: {
                this.exibirAlertInputTextoValidado(j.getBuffer(), j, h);
                return;
            }
            case 500: {
                this.exibirAlertInputMascarado(j.getBuffer(), j, h);
                return;
            }
            case 505: {
                this.exibirAlertInputTextoValidado(j.getBuffer(), j, h);
                return;
            }
        }
        this.exibirAlertInputTextoValidado(j.getBuffer(), j, h);
    }

    private void getComandoCampo34(JCliSiTefI j, HashMap h, Short restricoesTEF) {
        if (restricoesTEF == 1) {
            this.verificarTipoCampoComando34Restrito(j, h);
        } else {
            this.verificarTipoCampoComando34NaoRestrito(j, h);
        }
    }

    private void verificarTipoCampoComando34Restrito(JCliSiTefI j, HashMap h) {
        int tipoCampo = j.getTipoCampo();
        AuxPagamentoNFCe auxPagamento = (AuxPagamentoNFCe)h.get("AUX_PAGAMENTO");
        switch (tipoCampo) {
            case 130: {
                j.setBuffer(ToolFormatter.formataNumero((Number)auxPagamento.getValorSaque(), (int)2));
                return;
            }
            case 504: {
                j.setBuffer(ToolFormatter.formataNumero((Number)auxPagamento.getValorTaxaServico(), (int)2));
                return;
            }
        }
        this.exibirAlertInputMonetario(j.getBuffer(), j, h);
    }

    private void verificarTipoCampoComando34NaoRestrito(JCliSiTefI j, HashMap h) {
        int tipoCampo = j.getTipoCampo();
        AuxPagamentoNFCe auxPagamento = (AuxPagamentoNFCe)h.get("AUX_PAGAMENTO");
        switch (tipoCampo) {
            case 130: {
                this.exibirAlertInputMonetario(j.getBuffer(), j, h);
                return;
            }
            case 504: {
                this.exibirAlertInputMonetario(j.getBuffer(), j, h);
                return;
            }
        }
        this.exibirAlertInputMonetario(j.getBuffer(), j, h);
    }

    private void exibirAlertInputCancelaConfirma(JCliSiTefI j) {
        String sim = "0-Sim";
        String nao = "1-Nao";
        ArrayList<String> dados = new ArrayList<String>();
        dados.add(sim);
        dados.add(nao);
        DialogComboBox dialog = Alerts.showDialogComboBox(j.getBuffer(), dados);
        switch (dialog.getStatus()) {
            case 0: {
                String valor = (String)dialog.getSelectedItem();
                j.setContinuaNavegacao(0);
                j.setBuffer(valor);
                break;
            }
            case 1: {
                j.setContinuaNavegacao(1);
                break;
            }
            case 2: {
                Alerts.showAlertError("Opera\u00e7\u00e3o cancelada!");
                j.setContinuaNavegacao(-1);
                break;
            }
        }
    }

    private void exibirAlertInfo(String buffer) {
        Alerts.showAlertInfo(buffer);
    }

    private void exibirAlertError(String buffer) {
        Alerts.showAlertError(buffer);
    }

    private void exibirAlertInputTexto(String buffer, JCliSiTefI j, HashMap h, Short tamanhoMaximo) {
        DialogFieldMaxLenght dialog = Alerts.showDialogInputTextMaxSize(buffer, tamanhoMaximo.intValue());
        switch (dialog.getStatus()) {
            case 0: {
                String valor = dialog.getValue();
                j.setContinuaNavegacao(0);
                j.setBuffer(valor);
                break;
            }
            case 1: {
                j.setContinuaNavegacao(1);
                break;
            }
            case 2: {
                Alerts.showAlertError("Opera\u00e7\u00e3o cancelada!");
                j.setContinuaNavegacao(-1);
                break;
            }
        }
    }

    private void exibirAlertInputMascarado(String buffer, JCliSiTefI j, HashMap h) {
        String valor = Alerts.showAlertInputMask(buffer);
        if (valor == null || valor.isEmpty()) {
            j.setContinuaNavegacao(1);
        } else {
            j.setContinuaNavegacao(0);
        }
        if (valor.equals("123")) {
            j.setBuffer(valor);
        } else {
            this.exibirAlertError("Senha do Supervisor incorreta!");
            h.put("PROXIMA_ITERACAO", false);
            this.cancelarTransacao(true);
        }
    }

    private void exibirAlertInputMonetario(String buffer, JCliSiTefI j, HashMap h) {
        String texto = Alerts.showAlertInput(buffer);
        if (texto == null || texto.isEmpty()) {
            j.setContinuaNavegacao(1);
        } else {
            Double valor = new Double(texto);
            j.setBuffer(ToolFormatter.formataNumero((Number)valor, (int)2));
            j.setContinuaNavegacao(0);
        }
        this.setPropertyCCD(j, h);
    }

    private void exibirAlertInputComboBox(String buffer, JCliSiTefI j, HashMap h) {
        String[] result = buffer.split(Pattern.quote(";"));
        ArrayList<String> dados = new ArrayList<String>();
        for (String s : result) {
            dados.add(s);
        }
        DialogComboBox dialog = Alerts.showDialogComboBox(this.CABECALHO, dados);
        switch (dialog.getStatus()) {
            case 0: {
                String valor = (String)dialog.getSelectedItem();
                j.setContinuaNavegacao(0);
                int i = valor.indexOf(":");
                j.setBuffer(valor.substring(0, i));
                break;
            }
            case 1: {
                j.setContinuaNavegacao(1);
                break;
            }
            case 2: {
                Alerts.showAlertError("Opera\u00e7\u00e3o cancelada!");
                j.setContinuaNavegacao(-1);
                break;
            }
        }
        this.sleeping(10000);
    }

    private void sleeping(int i) {
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public HashMap getParametros() {
        return this.parametros;
    }

    public JCliSiTefI getjCliSiTefI() {
        return this.jCliSiTefI;
    }

    public void setjCliSiTefI(JCliSiTefI jCliSiTefI) {
        this.jCliSiTefI = jCliSiTefI;
    }
}

