/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.venda;

import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoAutenticacao;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchDoubleField;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.components.autocomplete.AutoCompleteLazyLoad;
import com.touchcomp.touchnfce.components.autocomplete.impl.AutoCompleteLazyLoadProduto;
import com.touchcomp.touchnfce.components.listener.FocusListener;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.controller.dialogs.DialogOutrasOpcoesCliente;
import com.touchcomp.touchnfce.controller.dialogs.dialogconfirmasair.ActionsConfirmaSair;
import com.touchcomp.touchnfce.controller.endereco.EnderecoEntregaPedidoController;
import com.touchcomp.touchnfce.controller.item.ConsultaItemController;
import com.touchcomp.touchnfce.controller.login.LoginAutorizacaoController;
import com.touchcomp.touchnfce.controller.pessoa.PessoaIndicanteController;
import com.touchcomp.touchnfce.controller.venda.StyleChangingRowFactory;
import com.touchcomp.touchnfce.controller.venda.TempPesquisaProdutoConverter;
import com.touchcomp.touchnfce.controller.venda.VendaNFCeController;
import com.touchcomp.touchnfce.controller.venda.auxmodelofiscal.AuxModeloFiscal;
import com.touchcomp.touchnfce.controller.venda.balanca.ThreadBalanca;
import com.touchcomp.touchnfce.controller.venda.balanca.ThreadBalancaListener;
import com.touchcomp.touchnfce.controller.vendedor.VendedorController;
import com.touchcomp.touchnfce.exceptions.ExceptionTabelaPrecosDinamica;
import com.touchcomp.touchnfce.helpers.preco.HelperPrecos;
import com.touchcomp.touchnfce.model.GradeCor;
import com.touchcomp.touchnfce.model.ItemPedido;
import com.touchcomp.touchnfce.model.ModeloFiscal;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.model.Pessoa;
import com.touchcomp.touchnfce.model.Produto;
import com.touchcomp.touchnfce.model.Representante;
import com.touchcomp.touchnfce.modeltemp.TempPesquisaProduto;
import com.touchcomp.touchnfce.service.impl.ServiceGradeCor;
import com.touchcomp.touchnfce.service.impl.ServicePedidoRec;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.UtilConsultaSaldoEstoque;
import com.touchcomp.touchnfce.utils.UtilPermissaoUsuario;
import com.touchcomp.touchnfce.utils.UtilShowDialogTable;
import com.touchcomp.touchnfce.utils.pedido.UtilPedido;
import com.touchcomp.touchnfce.utils.pedido.UtilPedidoCalculos;
import com.touchcomp.touchvomodel.vo.saldoestoque.DTOSaldoEstoqueGeralBasico;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import javafx.util.Callback;

public class PreVendaController
extends BaseController
implements AutoCompleteLazyLoad.ItemSelLazyFilter,
AutoCompleteLazyLoad.ItemLazyFilter,
ActionsConfirmaSair,
ThreadBalancaListener {
    @FXML
    private Label lblQuantidade;
    @FXML
    private Label lblProduto;
    @FXML
    private Label lblVlrUnitario;
    @FXML
    private Label lblVlrDesc;
    @FXML
    private Label lblVendedor;
    @FXML
    private Label lblSubTotalNFCe;
    @FXML
    private Label lblCliente;
    @FXML
    private Label lblSaldo;
    @FXML
    private TableColumn<ItemPedido, String> columnNmrItem;
    @FXML
    private TableColumn<ItemPedido, String> columnProduto;
    @FXML
    private TableColumn<ItemPedido, String> columnUM;
    @FXML
    private TableColumn<ItemPedido, String> columnVlrDesconto;
    @FXML
    private TableColumn<ItemPedido, String> columnVlrTot;
    @FXML
    private TableColumn<ItemPedido, String> columnVlrUnitario;
    @FXML
    private TableColumn<ItemPedido, String> columnQuantidade;
    @FXML
    private TableColumn<ItemPedido, String> columIdCodAux;
    @FXML
    private TableColumn<ItemPedido, String> columnCodBarras;
    @FXML
    private TableView<ItemPedido> tableItens;
    @FXML
    private Button btnCliente;
    @FXML
    private Button btnCamposProduto;
    @FXML
    private Button btnVendedor;
    @FXML
    private Button btnCancItem;
    @FXML
    private Button btnConsultaItem;
    @FXML
    private Button btnFecharPreVenda;
    @FXML
    private Button btnSair;
    @FXML
    private Button btnEnderecoEntrega;
    @FXML
    private Button btnCancelaExcluiPedido;
    @FXML
    private Button btnPesquisarPreVenda;
    @FXML
    private Button btnMaisOpcoes;
    @FXML
    private Button btnDadosTransporte;
    @FXML
    private TouchDoubleField tfVlrUnitario;
    @FXML
    private TouchDoubleField tfVlrDesc;
    @FXML
    private TouchDoubleField tfSubTotalNFCe;
    @FXML
    private TouchDoubleField tfQuantidade;
    @FXML
    private TouchDoubleField tfSaldo;
    @FXML
    private TouchTextField tfVendedor;
    @FXML
    private TouchTextField tfCliente;
    @FXML
    private AutoCompleteLazyLoadProduto tfProduto;
    @FXML
    private AnchorPane body;
    @FXML
    private GridPane gridVenda;
    @FXML
    private GridPane gridCliente;
    private ImageView image = new ImageView();
    private Image logo = null;
    private TreeSet<TempPesquisaProdutoConverter> produtos = new TreeSet();
    private TempPesquisaProduto tempPesquisaProduto;
    private int exibirProduto = 0;
    StyleChangingRowFactory<ItemPedido> rowFactory = new StyleChangingRowFactory("table-row-cell-yellow");
    private ServicePedidoRec servicePedido = Main.getBean(ServicePedidoRec.class);
    private final ThreadBalanca threadBalanca = new ThreadBalanca(this);
    private TLogger logger = TLogger.get(PreVendaController.class);

    @Override
    protected void requestFocusOnOpen() {
        this.tfProduto.requestFocus();
    }

    @Override
    protected void initializeController(ResourceBundle rb) {
        this.exibirProduto = this.getOpcoes().getUsarCodAuxiliar().shortValue();
        Main.get().getFooterController().atualizaStatusPedido();
        if (this.exibirProduto == 1) {
            this.columIdCodAux.setText("Cod. Aux.");
        } else {
            this.columIdCodAux.setText("Id");
        }
        this.tableItens.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.configureTable();
        this.setPropriedadesTextFields();
        this.configureButtons();
        this.tfProduto.setItemSelListener(this);
        this.tfProduto.setLazyLoading(this);
        this.tableItens.setRowFactory(this.rowFactory);
        this.tfVlrDesc.setEditable(false);
        this.tfVlrUnitario.setEditable(false);
        this.tfSubTotalNFCe.setEditable(false);
        this.tfCliente.setEditable(false);
        this.tfQuantidade.setNumberDecimalCases(3);
        this.tfQuantidade.setDouble(1.0);
        this.tfVlrDesc.setEditable(false);
        this.tfVlrDesc.setEditable(false);
        this.tfSaldo.setEditable(false);
        this.tfSubTotalNFCe.setFocusTraversable(false);
        this.tfCliente.setFocusTraversable(false);
        this.tfVendedor.setFocusTraversable(false);
        this.tfVlrUnitario.setFocusTraversable(false);
        this.tfVlrDesc.setFocusTraversable(false);
        this.btnCancItem.setFocusTraversable(false);
        this.btnCliente.setFocusTraversable(false);
        this.btnCancelaExcluiPedido.setFocusTraversable(false);
        this.btnCamposProduto.setFocusTraversable(false);
        this.btnConsultaItem.setFocusTraversable(false);
        this.btnFecharPreVenda.setFocusTraversable(false);
        this.btnSair.setFocusTraversable(false);
        this.btnVendedor.setFocusTraversable(false);
        this.btnMaisOpcoes.setFocusTraversable(false);
        this.tableItens.setFocusTraversable(false);
        this.tfProduto.setLabel(this.lblProduto);
        this.tfQuantidade.setLabel(this.lblQuantidade);
        this.tfSaldo.setLabel(this.lblSaldo);
        this.setFieldClienteAndRepresentante();
        Main.get().getHeaderController().setVisible(true);
    }

    private void setFieldClienteAndRepresentante() {
        if (this.getPedido() != null && this.getPedido().getUnidadeFatCliente() != null) {
            this.gridCliente.setVisible(true);
            this.tfCliente.setText(this.getPedido().getUnidadeFatCliente().getPessoa().getNome());
            this.tfCliente.setEditable(false);
        } else {
            this.gridCliente.setVisible(false);
        }
        if (this.getPedido() != null && this.getPedido().getRepresentante() != null) {
            this.visibleRepresentante();
        } else {
            this.invisibleRepresentante();
        }
        Main.get().getFooterController().atualizaStatusPedido();
    }

    @Override
    public void paramsData(Class<? extends BaseController> aClass, Map data) {
        TempPesquisaProduto prod;
        if (ConsultaItemController.class.equals(aClass) && (prod = (TempPesquisaProduto)data.get("pesquisa_prod")) != null) {
            this.setTempPesquisaProduto((TempPesquisaProduto)data.get("pesquisa_prod"), true);
            this.criaItemPedido();
        }
        this.iniciaPedido();
    }

    private void iniciaPedido() {
        if ((this.getPedido() == null || this.getPedido().getUnidadeFatCliente() == null) && ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getAbrirTelaClienteVenda(), (Object)1)) {
            Main.get().showDialog(Controllers.PESQUISA_PESSOAS);
        }
        this.preencherDadosPedido();
    }

    private void preencherDadosPedido() {
        if (this.getPedido() != null) {
            this.setProdutosTable(this.getPedido());
            this.setaDadosCampos(this.getPedido());
            this.habilitaTable();
        } else {
            this.desabilitaTableHabilitaGIF();
        }
    }

    private void setPropriedadesTextFields() {
        if (this.getPedido() != null && this.getPedido().getRepresentante() != null) {
            this.tfVendedor.setText(this.getPedido().getRepresentante().getPessoa().getNome());
            this.tfVendedor.setEditable(false);
        } else {
            this.lblVendedor.setVisible(false);
            this.tfVendedor.setVisible(false);
        }
        this.tfProduto.setOnKeyReleased(evt -> {
            if (evt.getCode() != null) {
                switch (evt.getCode()) {
                    case ENTER: {
                        if (!this.tfProduto.isFocused() || this.tfProduto.getText() == null || this.tfProduto.getText().isEmpty() || !ToolString.isAIntegerNumber((String)this.tfProduto.getText()) || !this.produtos.isEmpty()) break;
                        this.findProduto();
                        break;
                    }
                }
            }
        });
        this.tfQuantidade.setOnKeyPressed(evt -> {
            if (evt.getCode() != null) {
                switch (evt.getCode()) {
                    case ENTER: {
                        this.criaItemPedido();
                        break;
                    }
                }
            }
        });
        this.tfSaldo.setOnKeyPressed(evt -> {
            if (evt.getCode() != null) {
                switch (evt.getCode()) {
                    case ENTER: {
                        this.criaItemPedido();
                        break;
                    }
                }
            }
        });
        this.tfQuantidade.addFocusListener(new FocusListener(){

            @Override
            public void onFocusGained() {
                if (!PreVendaController.this.threadBalanca.isStartBalanca()) {
                    PreVendaController.this.threadBalanca.setStartBalanca(true);
                }
            }

            @Override
            public void onFocusLost() {
                PreVendaController.this.threadBalanca.setStartBalanca(false);
            }
        });
    }

    private void fecharPedido() {
        if (this.getPedido() == null) {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "N\u00e3o foi encontrada nenhum pedido aberto para pagamento", "");
            return;
        }
        if (this.getPedido().getItemPedido().isEmpty()) {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Para concluir uma pr\u00e9-venda \u00e9 preciso adicionar itens ao pedido!", "");
            return;
        }
        if (this.getPedido().getUnidadeFatCliente() == null && StaticObjects.getOpcoes().getUnidadeFatCliente() != null) {
            this.getPedido().setUnidadeFatCliente(StaticObjects.getOpcoes().getUnidadeFatCliente());
            return;
        }
        if (this.getPedido().getUnidadeFatCliente() == null) {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Nenhum Cliente informado.", "");
            return;
        }
        try {
            UtilPedidoCalculos.calcularValores(this.getPedido());
            StaticObjects.setPedidoAberto(this.getPedido());
            this.clearDescricaoUltimoProduto();
            Main.get().mudaTela(Controllers.FECHAMENTO_PREVENDA);
        }
        catch (Exception e) {
            TLogger.get((Object)e).error((Throwable)e);
            Alerts.showAlertInfo(e.getMessage());
        }
    }

    private void findProduto() {
        try {
            this.criaPedido();
            List<TempPesquisaProduto> prod = this.getProdutosPrecos(null, null);
            if (prod == null || prod.isEmpty()) {
                Alerts.showAlertInfo("Produto n\u00e3o encontrado ou sem pre\u00e7o ou tabela expirada. Confira o per\u00edodo de vig\u00eancia da tabela e se o item est\u00e1 na mesma e ativo.");
            } else {
                this.setTempPesquisaProduto(prod.get(0), false);
                this.criaItemPedido();
            }
        }
        catch (ExceptionTabelaPrecosDinamica ex) {
            this.logger.error((Throwable)ex);
            Alerts.showAlertInfo("Erro ao carregar os produtos/pre\u00e7os: " + ex.getMessage());
        }
        catch (ExceptionAvaliadorExpressoes ex) {
            this.logger.error((Throwable)ex);
            Alerts.showAlertInfo("Erro ao carregar os produtos/pre\u00e7os: " + ex.getMessage());
        }
    }

    private List<TempPesquisaProduto> getProdutosPrecos(Integer nrRegistros, Integer page) throws ExceptionTabelaPrecosDinamica, ExceptionAvaliadorExpressoes {
        this.criaPedido();
        HelperPrecos helper = Main.getBean(HelperPrecos.class);
        List<TempPesquisaProduto> prod = null;
        prod = helper.getProdutos(this.tfProduto.getText(), StaticObjects.getEmpresa(), this.getPedido().getUnidadeFatCliente(), StaticObjects.getOpcoes(), this.getPedido().getRepresentante(), StaticObjects.getUsuario(), StaticObjects.getGrupo(), this.getPedido().getTipoFrete(), this.getPedido().getNaturezaOperacao(), this.getPedido().getCondicoesPagamento(), nrRegistros, page);
        return prod;
    }

    public TempPesquisaProduto getTempPesquisaProduto() {
        return this.tempPesquisaProduto;
    }

    public void setTempPesquisaProduto(TempPesquisaProduto tempPesquisaProduto, boolean showDesc) {
        this.tempPesquisaProduto = tempPesquisaProduto;
        if (tempPesquisaProduto != null && showDesc) {
            this.tfProduto.setText(tempPesquisaProduto.getNomeProduto());
            this.tempPesquisaProduto.setSaldoQuantitativo(this.getSaldoQuantitativoByProduto(tempPesquisaProduto.getIdProduto()));
            this.tfSaldo.setDouble(this.tempPesquisaProduto.getSaldoQuantitativo());
        }
    }

    private void clearDescricaoUltimoProduto() {
        Main.get().getHeaderController().setVisible(false);
        Main.get().getHeaderController().setTextHeader("");
    }

    private void setProdutosTable(Pedido pedido) {
        this.columnUM.setCellValueFactory(cellData -> new SimpleStringProperty(((ItemPedido)cellData.getValue()).getProduto().getUnidadeMedida().getSigla()));
        this.columnNmrItem.setCellValueFactory((Callback)new PropertyValueFactory("numeroItem"));
        this.columnCodBarras.setCellFactory((Callback)new Callback<TableColumn<ItemPedido, String>, TableCell<ItemPedido, String>>(){

            public TableCell<ItemPedido, String> call(TableColumn<ItemPedido, String> param) {
                TableCell<ItemPedido, String> cell = new TableCell<ItemPedido, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.text = !this.isEmpty() && item != null ? new Text(item.toString()) : new Text("");
                        this.text.setWrappingWidth(PreVendaController.this.columnCodBarras.getWidth());
                        this.setGraphic((Node)this.text);
                    }
                };
                return cell;
            }
        });
        this.columnProduto.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ItemPedido, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ItemPedido, String> param) {
                return new SimpleObjectProperty((Object)((ItemPedido)param.getValue()).getProduto().getNome());
            }
        });
        this.columnProduto.setCellFactory((Callback)new Callback<TableColumn<ItemPedido, String>, TableCell<ItemPedido, String>>(){

            public TableCell<ItemPedido, String> call(TableColumn<ItemPedido, String> param) {
                TableCell<ItemPedido, String> cell = new TableCell<ItemPedido, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item != null) {
                            this.text = new Text(item.toString());
                            this.text.setWrappingWidth(PreVendaController.this.columnProduto.getWidth());
                            this.setGraphic((Node)this.text);
                        }
                    }
                };
                return cell;
            }
        });
        this.columnQuantidade.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ItemPedido, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ItemPedido, String> param) {
                return new SimpleObjectProperty((Object)MaskField.double3Casas(((ItemPedido)param.getValue()).getQuantidadeTotal()));
            }
        });
        this.columnVlrDesconto.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ItemPedido, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ItemPedido, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((ItemPedido)param.getValue()).getValorDesconto()));
            }
        });
        this.columnVlrTot.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ItemPedido, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ItemPedido, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((ItemPedido)param.getValue()).getValorTotal()));
            }
        });
        this.columnVlrUnitario.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ItemPedido, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ItemPedido, String> param) {
                return new SimpleObjectProperty((Object)MaskField.double3Casas(((ItemPedido)param.getValue()).getValorUnitario()));
            }
        });
        this.columIdCodAux.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ItemPedido, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ItemPedido, String> param) {
                return new SimpleObjectProperty((Object)(PreVendaController.this.exibirProduto == 1 ? ((ItemPedido)param.getValue()).getProduto().getCodigoAuxiliar() : String.valueOf(((ItemPedido)param.getValue()).getProduto().getIdentificador())));
            }
        });
        this.columIdCodAux.setCellFactory((Callback)new Callback<TableColumn<ItemPedido, String>, TableCell<ItemPedido, String>>(){

            public TableCell<ItemPedido, String> call(TableColumn<ItemPedido, String> param) {
                TableCell<ItemPedido, String> cell = new TableCell<ItemPedido, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.text = !this.isEmpty() && item != null ? new Text(item.toString()) : new Text("");
                        this.text.setWrappingWidth(PreVendaController.this.columIdCodAux.getWidth());
                        this.setGraphic((Node)this.text);
                    }
                };
                return cell;
            }
        });
        this.tableItens.getItems().clear();
        this.tableItens.setItems(FXCollections.observableArrayList(pedido.getItemPedido()));
        this.tableItens.scrollTo(pedido.getItemPedido().size());
        this.tableItens.refresh();
    }

    private void criaPedido() {
        if (this.getPedido() == null) {
            StaticObjects.setPedidoAberto(UtilPedido.getNewPedido(null));
            Main.get().getFooterController().atualizaStatusPedido();
        }
    }

    private void setaDadosCampos(Pedido pedido) {
        try {
            UtilPedidoCalculos.calcularValores(pedido);
            this.tableItens.getItems().clear();
            this.tableItens.setItems(FXCollections.observableArrayList(this.getPedido().getItemPedido()));
            this.tableItens.refresh();
            this.setProdutosTable(pedido);
            this.tfSubTotalNFCe.setDouble(pedido.getValorTotal());
            this.tableItens.getSelectionModel().select(null);
            this.setFieldClienteAndRepresentante();
        }
        catch (Exception e) {
            TLogger.get((Object)e).error((Throwable)e);
            Alerts.showAlertInfo(e.getMessage());
        }
    }

    private Pedido getPedido() {
        return StaticObjects.getPedidoAberto();
    }

    private void configureTable() {
        Platform.runLater(() -> {
            double totalWidth = this.tableItens.getWidth();
            this.columnProduto.setMinWidth(totalWidth * 29.0 / 100.0);
            this.columnProduto.setMaxWidth(totalWidth * 29.0 / 100.0);
            this.columnVlrTot.setMinWidth(totalWidth * 13.0 / 100.0);
            this.columnVlrTot.setMaxWidth(totalWidth * 13.0 / 100.0);
            this.columnVlrUnitario.setMinWidth(totalWidth * 13.0 / 100.0);
            this.columnVlrUnitario.setMaxWidth(totalWidth * 13.0 / 100.0);
            this.columnCodBarras.setMinWidth(totalWidth * 10.0 / 100.0);
            this.columnCodBarras.setMaxWidth(totalWidth * 10.0 / 100.0);
            this.columnQuantidade.setMinWidth(totalWidth * 10.0 / 100.0);
            this.columnQuantidade.setMaxWidth(totalWidth * 10.0 / 100.0);
            this.columnVlrDesconto.setMinWidth(totalWidth * 8.0 / 100.0);
            this.columnVlrDesconto.setMaxWidth(totalWidth * 8.0 / 100.0);
            this.columnUM.setMinWidth(totalWidth * 7.0 / 100.0);
            this.columnUM.setMaxWidth(totalWidth * 7.0 / 100.0);
            this.columIdCodAux.setMinWidth(totalWidth * 4.0 / 100.0);
            this.columIdCodAux.setMaxWidth(totalWidth * 4.0 / 100.0);
            this.columnNmrItem.setMinWidth(totalWidth * 5.0 / 100.0);
            this.columnNmrItem.setMaxWidth(totalWidth * 5.0 / 100.0);
        });
        this.columnVlrDesconto.setStyle("-fx-alignment: TOP_RIGHT;");
        this.columnVlrTot.setStyle("-fx-alignment: TOP_RIGHT;");
        this.columnVlrUnitario.setStyle("-fx-alignment: TOP_RIGHT;");
        this.columnQuantidade.setStyle("-fx-alignment: TOP_RIGHT;");
        this.columIdCodAux.setStyle("-fx-alignment: TOP;");
        this.columnCodBarras.setStyle("-fx-alignment: TOP;");
        this.tableItens.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableItens.setStyle("-fx-table-cell-border-color: transparent;");
        this.tableItens.setRowFactory(this.rowFactory);
    }

    private void atualizaCampoSubTotal() {
        try {
            UtilPedidoCalculos.calcularValores(this.getPedido());
            this.tfSubTotalNFCe.setDouble(this.getPedido().getValorTotalBruto());
        }
        catch (Exception e) {
            TLogger.get((Object)e).error((Throwable)e);
            Alerts.showAlertInfo(e.getMessage());
        }
    }

    private void desabilitaTableHabilitaGIF() {
        Main.get().getFooterController().atualizaStatusPedido();
        Main.get().getHeaderController().setVisible(true);
        this.tableItens.setItems(FXCollections.observableArrayList(new LinkedList()));
        this.tableItens.setVisible(false);
        try {
            if (StaticObjects.getOpcoes() != null && StaticObjects.getOpcoes().getLogoNfce() != null) {
                this.logo = new Image((InputStream)new ByteArrayInputStream(StaticObjects.getOpcoes().getLogoNfce()));
            } else if (Main.class.getResource("/images/main_image.gif") != null) {
                this.logo = new Image(Main.class.getResource("/images/main_image.gif").toURI().toString());
            }
            Platform.runLater(() -> {
                this.image.setImage(this.logo);
                this.image.setFitWidth(this.tableItens.getWidth());
                this.image.setFitHeight(this.tableItens.getHeight());
                this.gridVenda.add((Node)this.image, 3, 0);
            });
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(VendaNFCeController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError("Erro", ex.getMessage());
        }
    }

    public void habilitaTable() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                PreVendaController.this.image.setVisible(false);
                PreVendaController.this.gridVenda.getChildren().remove((Object)PreVendaController.this.image);
                PreVendaController.this.configureTable();
                PreVendaController.this.tableItens.setVisible(true);
            }
        });
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent event) {
        if (event != null) {
            switch (event.getCode()) {
                case F1: {
                    if (this.tfQuantidade.isFocused()) {
                        this.tfProduto.requestFocus();
                        break;
                    }
                    if (this.tfProduto.isFocused()) {
                        this.tfQuantidade.requestFocus();
                        this.threadBalanca.setStartBalanca(true);
                        break;
                    }
                    this.tfProduto.requestFocus();
                    break;
                }
                case F2: {
                    this.informaVendedor();
                    break;
                }
                case F3: {
                    this.pesquisarCliente();
                    break;
                }
                case F4: {
                    this.informaEnderecoEntrega();
                    break;
                }
                case F5: {
                    this.cancelaItemNFCeFocusTabela();
                    break;
                }
                case F6: {
                    this.excluiPedido();
                    break;
                }
                case F7: {
                    this.consultaItem();
                    break;
                }
                case F8: {
                    this.pesquisaPreVendas();
                    break;
                }
                case F9: {
                    this.irTelaMaisOpcoes();
                    break;
                }
                case F10: {
                    this.informaDadosTransporte();
                    break;
                }
                case F11: {
                    this.informaPessoaIndicante();
                    break;
                }
                case F12: {
                    this.fecharPedido();
                    break;
                }
                case ESCAPE: {
                    this.sairVoltar();
                    break;
                }
                case DELETE: {
                    if (!this.tableItens.isFocused() || this.tableItens.getSelectionModel().getSelectedItem() == null) break;
                    this.cancelaItem();
                    break;
                }
                case ENTER: {
                    if (!this.tableItens.isFocused() || this.tableItens.getSelectionModel().getSelectedItem() == null) break;
                    this.descontoAcrescimoItem();
                    break;
                }
                case UP: {
                    if (!this.tfQuantidade.isFocused()) break;
                    this.tfProduto.requestFocus();
                    break;
                }
                case DOWN: {
                    break;
                }
                case RIGHT: {
                    if (!this.tfQuantidade.isFocused() && !this.tfProduto.isFocused()) break;
                    this.tableItens.requestFocus();
                    break;
                }
                case LEFT: {
                    if (!this.tableItens.isFocused()) break;
                    this.tfProduto.requestFocus();
                    break;
                }
            }
        }
    }

    private void pesquisarCliente() {
        this.criaPedido();
        this.clearDescricaoUltimoProduto();
        Main.get().showDialog(Controllers.PESQUISA_PESSOAS);
        this.setFieldClienteAndRepresentante();
    }

    private void confirmaCancelamentoItem() {
        Optional<ButtonType> type = Alerts.showQuestion("Deseja realmente cancelar esse item?");
        if (type.get() == ButtonType.OK) {
            ItemPedido toRemove = (ItemPedido)this.tableItens.getSelectionModel().getSelectedItem();
            this.getPedido().getItemPedido().remove(toRemove);
            this.tableItens.getItems().clear();
            this.tableItens.setItems(FXCollections.observableArrayList(this.getPedido().getItemPedido()));
            this.tableItens.refresh();
            UtilPedido.aplicarDescontoPromocionalPedido(toRemove, this.getPedido());
            this.atualizarPedido();
            this.atualizaCampoSubTotal();
            this.tableItens.getSelectionModel().select(null);
            this.resetFields();
        }
    }

    private void atualizarPedido() {
        StaticObjects.refreshPedido();
        this.tableItens.getItems().clear();
        this.tableItens.getItems().addAll(StaticObjects.getPedidoAberto().getItemPedido());
    }

    private void cancelaItem() {
        if (UtilPermissaoUsuario.isPermitidoCancelarNFCeItem()) {
            this.confirmaCancelamentoItem();
            return;
        }
        HashMap<String, EnumConstNFCeTipoAutenticacao> h = new HashMap<String, EnumConstNFCeTipoAutenticacao>();
        h.put("tipo_autenticacao", EnumConstNFCeTipoAutenticacao.AUTENTICACAO_CANCELAMENTO);
        LoginAutorizacaoController loginController = (LoginAutorizacaoController)Main.get().showDialog(Controllers.LOGIN_AUTORIZACAO, h);
        if (loginController.getUsuario() == null) {
            Alerts.showAlertError("Voc\u00ea n\u00e3o possui autoriza\u00e7\u00e3o para realizar essa opera\u00e7\u00e3o");
        } else {
            this.confirmaCancelamentoItem();
        }
    }

    private NFCeOpcoes getOpcoes() {
        return StaticObjects.getOpcoes();
    }

    private void informaVendedor() {
        this.criaPedido();
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("representante", this.getPedido().getRepresentante());
        h.put("lastPath", Controllers.PRE_VENDA);
        VendedorController consumidorController = (VendedorController)Main.get().showDialog(Controllers.VENDEDOR, h);
        this.getPedido().setRepresentante(consumidorController.getRepresentantePedido());
        if (this.getPedido().getRepresentante() != null) {
            this.visibleRepresentante();
        } else {
            this.invisibleRepresentante();
        }
        for (ItemPedido i : this.getPedido().getItemPedido()) {
            TempPesquisaProduto comissao = this.getTempPesquisaProdutoComissao(i.getGradeItemPedido().getFirst().getGradeCor());
            if (!ToolMethods.isNotNull((Object)comissao).booleanValue()) continue;
            i.setPercComissao(comissao.getPercComissao());
            i.setPercComissaoMin(comissao.getPercComissaoMin());
            i.setPercComissaoMax(comissao.getPercComissaoMax());
        }
        this.atualizarPedido();
    }

    private void informaPessoaIndicante() {
        this.criaPedido();
        HashMap<String, Pessoa> h = new HashMap<String, Pessoa>();
        h.put("current_pessoa_indicante", this.getPedido().getPessoaAutorizada());
        PessoaIndicanteController controller = (PessoaIndicanteController)Main.get().showDialog(Controllers.PESSOA_INDICANTE, h);
        if (controller.getPessoaIndicante() != null) {
            this.getPedido().setPessoaAutorizada(controller.getPessoaIndicante());
            this.atualizarPedido();
        }
    }

    private void invisibleRepresentante() {
        this.lblVendedor.setVisible(false);
        this.tfVendedor.setVisible(false);
    }

    private void visibleRepresentante() {
        this.lblVendedor.setVisible(true);
        this.tfVendedor.setVisible(true);
        this.tfVendedor.setEditable(false);
        this.tfVendedor.setText(this.getPedido().getRepresentante().toString());
    }

    private void cancelaItemNFCeFocusTabela() {
        this.tableItens.getSelectionModel().selectLast();
        this.tableItens.requestFocus();
    }

    private void informaEnderecoEntrega() {
        this.criaPedido();
        HashMap h = new HashMap();
        EnderecoEntregaPedidoController consumidorController = (EnderecoEntregaPedidoController)Main.get().showDialog(Controllers.ENDERECO_ENTREGA_PEDIDO, h);
    }

    private void configureButtons() {
        this.btnFecharPreVenda.setOnAction(event -> this.fecharPedido());
        this.btnEnderecoEntrega.setOnAction(event -> this.informaEnderecoEntrega());
        this.btnCamposProduto.setOnAction(event -> this.informaPessoaIndicante());
        this.btnCancItem.setOnAction(event -> this.cancelaItemNFCeFocusTabela());
        this.btnCliente.setOnAction(event -> {
            this.clearDescricaoUltimoProduto();
            Main.get().showDialog(Controllers.PESQUISA_PESSOAS);
            this.setFieldClienteAndRepresentante();
        });
        this.btnConsultaItem.setOnAction(event -> this.consultaItem());
        this.btnSair.setOnAction(event -> this.sairVoltar());
        this.btnVendedor.setOnAction(event -> this.informaVendedor());
        this.btnCancelaExcluiPedido.setOnAction(event -> this.excluiPedido());
        this.btnPesquisarPreVenda.setOnAction(event -> this.pesquisaPreVendas());
        this.btnMaisOpcoes.setOnAction(event -> this.irTelaMaisOpcoes());
        this.btnDadosTransporte.setOnAction(event -> this.informaDadosTransporte());
        this.tableItens.setOnMouseClicked(event -> {
            ItemPedido item = (ItemPedido)this.tableItens.getSelectionModel().getSelectedItem();
            if (item != null) {
                this.tfVlrUnitario.setDouble(item.getValorUnitario());
                this.tfVlrDesc.setDouble(item.getValorDesconto());
            }
        });
        this.tableItens.setOnKeyReleased(event -> {
            ItemPedido item = (ItemPedido)this.tableItens.getSelectionModel().getSelectedItem();
            if (item != null) {
                this.tfVlrUnitario.setDouble(item.getValorUnitario());
                this.tfVlrDesc.setDouble(item.getValorDesconto());
            }
        });
    }

    private Double getSaldoQuantitativoByProduto(Long idProduto) {
        Double aux = 0.0;
        if (!ToolMethods.isAffirmative((Number)StaticObjects.getOpcoes().getExibirEstoquePreVenda())) {
            return aux;
        }
        DTOSaldoEstoqueGeralBasico dto = UtilConsultaSaldoEstoque.findSaldoIdProdutoByCentroEstoquePadrao(idProduto, StaticObjects.getEmpresa().getIdentificador());
        if (dto != null) {
            aux = dto.getQuantidade();
        }
        return aux;
    }

    private void sairVoltar() {
        if (StaticObjects.getPedidoAberto() != null) {
            this.showDialogConfirmaSair();
        } else {
            this.confirma();
        }
    }

    private void resetFields() {
        this.tfVlrUnitario.clear();
        this.tfProduto.clear();
        this.tfQuantidade.setDouble(1.0);
        this.tfVlrDesc.clear();
        this.tfSaldo.clear();
        this.tfProduto.requestFocus();
    }

    public void onItemListener(Object data) {
        TempPesquisaProdutoConverter obj = (TempPesquisaProdutoConverter)data;
        this.setTempPesquisaProduto(obj.getTempPesqProd(), true);
        this.tfProduto.setText(obj.getTempPesqProd().getNomeProduto());
        this.criaItemPedido();
    }

    private void criaItemPedido() {
        ServiceGradeCor service;
        GradeCor gradeCor;
        if (this.getTempPesquisaProduto() == null) {
            return;
        }
        Main.get().getHeaderController().setTextHeader(this.getTempPesquisaProduto().getNomeProduto());
        if (this.getTempPesquisaProduto().getValorUnitario() <= 0.0) {
            this.tfProduto.requestFocus();
            Alerts.showAlertError("Produto sem pre\u00e7o ou tabela expirada. Confira o per\u00edodo de vig\u00eancia da tabela e se o item est\u00e1 na mesma e ativo.");
            return;
        }
        this.tfVlrUnitario.setDouble(this.getTempPesquisaProduto().getValorUnitario());
        this.tfSaldo.setDouble(this.getTempPesquisaProduto().getSaldoQuantitativo());
        if (ToolMethods.isEquals((Object)this.getTempPesquisaProduto().getQtdNaoFracionada(), (Object)0) && !this.threadBalanca.isStartBalanca() && !this.tfSaldo.isFocused() && !this.tfQuantidade.isFocused()) {
            this.tempPesquisaProduto.setSaldoQuantitativo(this.getSaldoQuantitativoByProduto(this.tempPesquisaProduto.getIdProduto()));
            this.tfQuantidade.requestFocus();
            this.threadBalanca.setStartBalanca(true);
            return;
        }
        if (ToolMethods.isAffirmative((Number)StaticObjects.getOpcoes().getExibirEstoquePreVenda()) && this.tfProduto.isFocused() && !this.tfQuantidade.isFocused() && !this.tfSaldo.isFocused()) {
            this.tfQuantidade.requestFocus();
            return;
        }
        if (ToolMethods.isAffirmative((Number)StaticObjects.getOpcoes().getExibirEstoquePreVenda()) && this.tfQuantidade.isFocused() && !this.tfSaldo.isFocused()) {
            this.tfSaldo.requestFocus();
            return;
        }
        this.criaPedido();
        if (this.tfQuantidade.getDouble() == 0.0) {
            this.tfQuantidade.setDouble(this.getTempPesquisaProduto().getQtdMinVenda());
        }
        if (this.tfQuantidade.getDouble() == 0.0) {
            this.tfQuantidade.setDouble(1.0);
        }
        this.tfSaldo.setDouble(this.getTempPesquisaProduto().getSaldoQuantitativo());
        this.threadBalanca.setStartBalanca(false);
        Double qtd = this.tfQuantidade.getDouble();
        if (qtd <= 0.0) {
            Alerts.showAlertInfo("Quantidade informada \u00e9 inv\u00e1lida. Quantidade deve ser maior que 0.");
            return;
        }
        if (this.getTempPesquisaProduto().getQtdMinVenda() != null && this.getTempPesquisaProduto().getQtdMinVenda() > 0.0 && qtd < this.getTempPesquisaProduto().getQtdMinVenda()) {
            Alerts.showAlertInfo("Quantidade informada \u00e9 menor que a quantidade minima comercializada. Quantidade m\u00ednima: " + MaskField.monetaryField(this.getTempPesquisaProduto().getQtdMinVenda()));
            return;
        }
        if (this.getTempPesquisaProduto().getQtdMaxVenda() != null && this.getTempPesquisaProduto().getQtdMaxVenda() > 0.0 && this.tfQuantidade.getDouble() > this.getTempPesquisaProduto().getQtdMaxVenda()) {
            Alerts.showAlertInfo("Quantidade informada \u00e9 maior que a quantidade m\u00e1xima comercializada. Quantidade m\u00e1xima: " + MaskField.monetaryField(this.getTempPesquisaProduto().getQtdMaxVenda()));
            return;
        }
        if (this.getTempPesquisaProduto().getQtdNaoFracionada() != null && this.getTempPesquisaProduto().getQtdNaoFracionada() == 1 && qtd % 1.0 != 0.0) {
            Alerts.showAlertInfo("Quantidade informada n\u00e3o pode ser fracionada. ");
            return;
        }
        if (this.getPedido().getNaturezaOperacao() == null) {
            Alerts.showAlertInfo("Primeiro informe a Natureza de Opera\u00e7\u00e3o do Pedido!");
            this.getPedido().setNaturezaOperacao(UtilShowDialogTable.getNaturezaOperacao(null));
        }
        if (ToolMethods.isEquals((Object)this.getPedido().getNaturezaOperacao().getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo()) && this.getPedido().getUnidadeFatCliente() == null) {
            Main.get().showDialog(Controllers.PESQUISA_PESSOAS);
            this.setFieldClienteAndRepresentante();
        }
        if (ToolMethods.isEquals((Object)(gradeCor = (GradeCor)(service = Main.getBean(ServiceGradeCor.class)).get(this.getTempPesquisaProduto().getIdGradeCor())).getProdutoGrade().getProduto().getPermitirVendaSomenteAutomacao(), (Object)1)) {
            Alerts.showAlertInfo("A venda deste produto esta liberada somente pela automa\u00e7\u00e3o!");
            return;
        }
        ModeloFiscal modeloFiscal = new AuxModeloFiscal().getModeloFiscalPedido(gradeCor.getProdutoGrade().getProduto(), this.getPedido().getUnidadeFatCliente(), this.getPedido().getEnderecoEntrega(), this.getPedido().getNaturezaOperacao(), this.getPedido().getEmpresa(), true);
        if (modeloFiscal == null) {
            this.tfProduto.requestFocus();
            return;
        }
        Representante old = this.getPedido().getRepresentante();
        if (this.obrigarInformarVendedor().booleanValue()) {
            ItemPedido item;
            boolean validar;
            TempPesquisaProduto comissao;
            this.habilitaTable();
            if (!ToolMethods.isEquals((Object)old, (Object)this.getPedido().getRepresentante()) && ToolMethods.isNotNull((Object)(comissao = this.getTempPesquisaProdutoComissao(gradeCor))).booleanValue()) {
                this.getTempPesquisaProduto().setPercComissao(comissao.getPercComissao());
                this.getTempPesquisaProduto().setPercComissaoMin(comissao.getPercComissaoMin());
                this.getTempPesquisaProduto().setPercComissaoMax(comissao.getPercComissaoMax());
                this.getTempPesquisaProduto().setAvaliadorExpressoesComissao(comissao.getAvaliadorExpressoesComissao());
            }
            if (!(validar = this.informarTipoMedicamento(item = UtilPedido.getNewItemPedido(this.getPedido(), gradeCor, modeloFiscal, this.tfQuantidade.getDouble(), this.getTempPesquisaProduto().getPercComissao(), this.tfVlrUnitario.getDouble(), this.getTempPesquisaProduto().getPercDescontoTrib(), this.getTempPesquisaProduto().getValorMinimo(), this.getTempPesquisaProduto().getValorMaximo())))) {
                Alerts.showAlertError("Item n\u00e3o registrado, pois n\u00e3o foi informado as informa\u00e7\u00f5es do lote de fabrica\u00e7\u00e3o para um produto de medicamento!");
                this.resetFields();
                this.tfProduto.requestFocus();
                this.tfQuantidade.setDouble(1.0);
                this.setTempPesquisaProduto(null, true);
                return;
            }
            this.getPedido().getItemPedido().add(item);
            UtilPedido.aplicarDescontoPromocionalPedido(item, this.getPedido());
            this.atualizaCampoSubTotal();
            this.setProdutosTable(this.getPedido());
            this.tableItens.refresh();
            if (this.tableItens.getItems() != null && !this.tableItens.getItems().isEmpty()) {
                this.tableItens.scrollTo(this.tableItens.getItems().size());
            }
            this.resetFields();
        }
        this.setTempPesquisaProduto(null, true);
        this.tfProduto.requestFocus();
    }

    private Boolean obrigarInformarVendedor() {
        if (this.getPedido().getRepresentante() != null) {
            this.visibleRepresentante();
            return true;
        }
        HashMap<String, EnumConstNFCeTipoAutenticacao> h = new HashMap<String, EnumConstNFCeTipoAutenticacao>();
        h.put("tipo_autenticacao", EnumConstNFCeTipoAutenticacao.AUTENTICACAO_REPRESENTANTE);
        LoginAutorizacaoController loginController = (LoginAutorizacaoController)Main.get().showDialog(Controllers.LOGIN_AUTORIZACAO, h);
        if (loginController.getRepresentante() == null) {
            Alerts.showAlertError("O Usuario n\u00e3o informado ou o mesmo n\u00e3o \u00e9 um representante. Informe um usu\u00e1rio valido para finalizar o processo!");
            return false;
        }
        this.getPedido().setRepresentante(loginController.getRepresentante());
        this.visibleRepresentante();
        return true;
    }

    private void excluiPedido() {
        if (this.getPedido() != null) {
            if (ToolMethods.isEquals((Object)this.getPedido().getStatusSincERP(), (Object)1)) {
                Optional<ButtonType> type = Alerts.showQuestion("O Pedido n\u00e3o pode ser cancelado/excluido pois o mesmo ja foi sincronizado. Este processo dever\u00e1 ser realizado pelo ERP. \nDeseja criar um novo Pedido?");
                if (type.get() == ButtonType.OK) {
                    StaticObjects.clearPedido();
                    Main.get().mudaTela(Controllers.PRE_VENDA);
                } else {
                    return;
                }
            }
            this.servicePedido.delete(this.getPedido());
            StaticObjects.clearPedido();
            this.clearDescricaoUltimoProduto();
            Main.get().mudaTela(Controllers.PRE_VENDA);
        }
    }

    private void pesquisaPreVendas() {
        if (StaticObjects.getPedidoAberto() != null) {
            this.atualizarPedido();
        }
        this.clearDescricaoUltimoProduto();
        Main.get().mudaTela(Controllers.PESQUISA_PRE_VENDA);
    }

    private void showDialogConfirmaSair() {
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("label", "Existe um pedido aberto, deseja realmente sair?");
        h.put("controller", this);
        Main.get().showDialog(Controllers.DIALOG_CONFIRMA_SAIR_VENDA, h);
    }

    @Override
    public void confirma() {
        StaticObjects.setPedidoAberto(null);
        this.clearDescricaoUltimoProduto();
        Main.get().mudaTela(Controllers.MENU_PRINCIPAL);
    }

    @Override
    public void cancela() {
    }

    private void descontoAcrescimoItem() {
        ItemPedido item = (ItemPedido)this.tableItens.getSelectionModel().getSelectedItem();
        HashMap<String, ItemPedido> h = new HashMap<String, ItemPedido>();
        h.put("item", item);
        Main.get().showDialog(Controllers.DIALOG_DESCONTO_ACRESC_ITEM_VENDA, h);
        this.tfSubTotalNFCe.setDouble(this.getPedido().getValorTotal());
        this.tableItens.refresh();
        this.tableItens.getSelectionModel().clearSelection();
        this.tfProduto.requestFocus();
    }

    private void irTelaMaisOpcoes() {
        if (StaticObjects.getPedidoAberto() == null) {
            Alerts.showAlertInfo("Primeiro, crie ou selecione um pedido!");
            return;
        }
        Main.get().showDialog(Controllers.DIALOG_OUTRAS_OPCOES_PEDIDO);
    }

    private void informaDadosTransporte() {
        this.criaPedido();
        HashMap<String, Boolean> h = new HashMap<String, Boolean>();
        h.put("PEDIDO", true);
        DialogOutrasOpcoesCliente consumidorController = (DialogOutrasOpcoesCliente)Main.get().showDialog(Controllers.DIALOG_OUTRAS_OPCOES_CLIENTE, h);
    }

    @Override
    public void pesoLido(Double peso) {
        this.tfQuantidade.setDouble(peso);
    }

    @Override
    public void error(Throwable t) {
        t.printStackTrace();
        this.tfQuantidade.setDouble(1.0);
    }

    @Override
    public SortedSet loadingMoreItems(String text, int page, int registrosPorCarregamento) {
        this.produtos = new TreeSet();
        if (!text.isEmpty() && text.length() >= 3 && !ToolString.isAIntegerNumber((String)text)) {
            try {
                List<TempPesquisaProduto> prod = this.getProdutosPrecos(registrosPorCarregamento, page);
                this.produtos = TempPesquisaProdutoConverter.converterList(prod);
            }
            catch (ExceptionTabelaPrecosDinamica ex) {
                this.logger.error((Throwable)ex);
                Alerts.showAlertInfo("Erro ao carregar os produtos/pre\u00e7os: " + ex.getMessage());
            }
            catch (ExceptionAvaliadorExpressoes ex) {
                this.logger.error((Throwable)ex);
                Alerts.showAlertInfo("Erro ao carregar os produtos/pre\u00e7os: " + ex.getMessage());
            }
            catch (Exception ex) {
                this.logger.error((Throwable)ex);
                Alerts.showAlertInfo("Erro ao carregar os produtos/pre\u00e7os: " + ex.getMessage());
            }
        }
        return this.produtos;
    }

    private boolean informarTipoMedicamento(ItemPedido item) {
        if (!ToolMethods.isStrWithData((String)item.getProduto().getCodAnvisa())) {
            return true;
        }
        if (this.getPedido() == null || ToolMethods.isEquals((Object)this.getPedido().getNaturezaOperacao().getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
            return true;
        }
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getTipoInformacaoRastreabilidade(), (Object)1)) {
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            Produto p = item.getProduto();
            params.put("produto", p);
            params.put("itemPedido", item);
            Main.get().showDialog(Controllers.DIALOG_INFORMA_LOTE_MEDICAMENTO, params);
            if (!ToolMethods.isStrWithData((String)item.getNrLoteFabricacao()) || ToolMethods.isNull((Object)item.getDataFabricacao()).booleanValue() || ToolMethods.isNull((Object)item.getDataValidade()).booleanValue()) {
                return false;
            }
        }
        return true;
    }

    private void consultaItem() {
        this.clearDescricaoUltimoProduto();
        HashMap<String, Serializable> h = new HashMap<String, Serializable>();
        h.put("qtd_pesquisa_prod", this.tfQuantidade.getDouble());
        if (StaticObjects.getPedidoAberto() != null) {
            h.put("unidade_fat_cliente_inf_nfce", StaticObjects.getPedidoAberto().getUnidadeFatCliente());
        }
        Main.get().mudaTela(Controllers.CONSULTA_ITEM, h);
    }

    private TempPesquisaProduto getTempPesquisaProdutoComissao(GradeCor gradeCor) {
        try {
            HelperPrecos helper = Main.getBean(HelperPrecos.class);
            TempPesquisaProduto comissao = helper.getComissao(gradeCor.getProdutoGrade().getProduto(), this.getPedido().getEmpresa(), this.getPedido().getUnidadeFatCliente(), StaticObjects.getOpcoes(), this.getPedido().getRepresentante(), StaticObjects.getUsuario(), StaticObjects.getGrupo(), this.getPedido().getTipoFrete(), this.getPedido().getNaturezaOperacao(), this.getPedido().getCondicoesPagamento());
            return comissao;
        }
        catch (ExceptionAvaliadorExpressoes | ExceptionTabelaPrecosDinamica ex) {
            Logger.getLogger(PreVendaController.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

