/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.venda;

import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.properties.ConfPropertiesLoader;
import java.util.List;
import java.util.TreeSet;
import lombok.Generated;

public class TempPesquisaClienteConverter
implements Comparable<TempPesquisaClienteConverter> {
    private Integer sequencia;
    private UnidadeFatCliente tempPesqProd;
    private ConfPropertiesLoader confProps;

    public TempPesquisaClienteConverter(int sequencia, UnidadeFatCliente tempPesqProd) {
        this.sequencia = sequencia;
        this.tempPesqProd = tempPesqProd;
        this.confProps = ConfPropertiesLoader.get();
    }

    public String toString() {
        Object text = "";
        text = this.tempPesqProd.getPessoa().getNome();
        if (ToolMethods.isStrWithData((String)this.tempPesqProd.getPessoa().getNomeFantasia())) {
            text = (String)text + "/" + this.tempPesqProd.getPessoa().getNomeFantasia();
        }
        text = (String)text + "(" + this.tempPesqProd.getCliente().getCodigoCliente() + ")";
        text = (String)text + " CPF/CNPJ: " + this.tempPesqProd.getPessoa().getComplemento().getCnpj();
        return text;
    }

    public static TreeSet<TempPesquisaClienteConverter> converterList(List<UnidadeFatCliente> prod) {
        TreeSet<TempPesquisaClienteConverter> ret = new TreeSet<TempPesquisaClienteConverter>();
        int index = 0;
        for (UnidadeFatCliente tp : prod) {
            ret.add(new TempPesquisaClienteConverter(index, tp));
            ++index;
        }
        return ret;
    }

    @Override
    public int compareTo(TempPesquisaClienteConverter o) {
        return this.getSequencia().compareTo(o.getSequencia());
    }

    @Generated
    public Integer getSequencia() {
        return this.sequencia;
    }

    @Generated
    public UnidadeFatCliente getTempPesqProd() {
        return this.tempPesqProd;
    }

    @Generated
    public ConfPropertiesLoader getConfProps() {
        return this.confProps;
    }

    @Generated
    public void setSequencia(Integer sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setTempPesqProd(UnidadeFatCliente tempPesqProd) {
        this.tempPesqProd = tempPesqProd;
    }

    @Generated
    public void setConfProps(ConfPropertiesLoader confProps) {
        this.confProps = confProps;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TempPesquisaClienteConverter)) {
            return false;
        }
        TempPesquisaClienteConverter other = (TempPesquisaClienteConverter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$sequencia = this.getSequencia();
        Integer other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        UnidadeFatCliente this$tempPesqProd = this.getTempPesqProd();
        UnidadeFatCliente other$tempPesqProd = other.getTempPesqProd();
        if (this$tempPesqProd == null ? other$tempPesqProd != null : !((Object)this$tempPesqProd).equals(other$tempPesqProd)) {
            return false;
        }
        ConfPropertiesLoader this$confProps = this.getConfProps();
        ConfPropertiesLoader other$confProps = other.getConfProps();
        return !(this$confProps == null ? other$confProps != null : !this$confProps.equals(other$confProps));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TempPesquisaClienteConverter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        UnidadeFatCliente $tempPesqProd = this.getTempPesqProd();
        result = result * 59 + ($tempPesqProd == null ? 43 : ((Object)$tempPesqProd).hashCode());
        ConfPropertiesLoader $confProps = this.getConfProps();
        result = result * 59 + ($confProps == null ? 43 : $confProps.hashCode());
        return result;
    }
}

