/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.venda.balanca;

import br.com.mzsw.BalancaListener;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.venda.balanca.ThreadBalancaListener;

public class ThreadBalanca
extends Thread
implements BalancaListener {
    private boolean startBalanca = false;
    private final ThreadBalancaListener listener;
    private boolean pesoLido = false;

    public ThreadBalanca(ThreadBalancaListener listener) {
        this.listener = listener;
        if (StaticObjects.getPesoLib() != null) {
            StaticObjects.getPesoLib().addEventListener((BalancaListener)this);
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                if (this.startBalanca) {
                    StaticObjects.getPesoLib().setPreco(2.5f);
                    Thread.sleep(100L);
                    continue;
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.listener.error(e);
        }
    }

    public void onConectado(Object o) {
        System.out.println("Balan\u00e7a Conectada com sucesso");
    }

    public void onPesoRecebido(Object o, int gramas) {
        Object str = String.format("%.3f", (double)gramas / 1000.0) + " kg";
        if (gramas < 1000) {
            str = String.format("%.3f", (double)gramas / 1000.0);
        }
        str = ((String)str).replaceAll(",", ".");
        this.listener.pesoLido(Double.valueOf((String)str));
        this.pesoLido = true;
    }

    public boolean isStartBalanca() {
        return this.startBalanca;
    }

    public void setStartBalanca(boolean startBalanca) {
        this.startBalanca = startBalanca;
        this.pesoLido = false;
    }

    public void onDesconectado(Object o) {
        System.out.println("Balan\u00e7a Desconectada com sucesso");
    }
}

