/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.nfcesefaz;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementorclientwebservices.nfe.model.env.cancelarnota.NFeCancelarNota;
import com.touchcomp.basementorclientwebservices.nfe.model.ret.NFeEnviaEventoRet;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.helpers.nfcesefaz.HelperNFCeSefazBase;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeCancelamento;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.model.Usuario;
import com.touchcomp.touchnfce.nfe.impl.versoes.ConfigCertificate;
import com.touchcomp.touchnfce.nfe.impl.versoes.ConstNFeVersoes;
import com.touchcomp.touchnfce.nfe.impl.versoes.UtilNfeSendWebServices;
import com.touchcomp.touchnfce.service.impl.ServiceNFCe;
import com.touchcomp.touchnfce.tasks.utils.UtilXMLFile;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class HelperNFCeSefazCanc
extends HelperNFCeSefazBase {
    private static final String DIR_CANCELAMENTO = "cancelamento";

    HelperNFCeSefazCanc() {
    }

    NFCe cancela(NFCe nfce, String justificativa, Usuario usuario) throws Exception {
        if (!this.isValidToCancel(nfce)) {
            return nfce;
        }
        NFCeCancelamento nfCeCancelamento = this.criarAndEnviarCancelamento(nfce, justificativa, false, usuario);
        nfCeCancelamento = this.atualizaDadosRetCanc(nfCeCancelamento);
        Main.get().getHeaderController().setTextHeader("");
        return nfce;
    }

    NFCe cancelaPorSubstituicao(NFCe nfce, String justificativa, Usuario usuario) throws Exception {
        if (!this.isValidToCancel(nfce)) {
            return nfce;
        }
        NFCeCancelamento nfCeCancelamento = this.criarAndEnviarCancelamento(nfce, justificativa, true, usuario);
        nfCeCancelamento = this.atualizaDadosRetCanc(nfCeCancelamento);
        Main.get().getHeaderController().setTextHeader("");
        return nfce;
    }

    private boolean isValidToCancel(NFCe nfce) {
        if (nfce.getStatus() == 101) {
            Alerts.showAlertError("NFCe j\u00e1 se encontra cancelada.");
            return false;
        }
        if (nfce.getStatus() == 205 || nfce.getStatus() == 302 || nfce.getStatus() == 303 || nfce.getStatus() == 301) {
            Alerts.showAlertError("NFCe denegada. N\u00e3o \u00e9 poss\u00edvel cancelar.");
            return false;
        }
        return EnumConstNFeStatus.isStatusAutorizada((Integer)nfce.getStatus());
    }

    private NFCeCancelamento criarAndEnviarCancelamento(NFCe nfce, String justificativa, Boolean cancelamentoPorSubstituicao, Usuario usuario) throws Exception {
        NFCeCancelamento canc = nfce.getNfCeCancelamento();
        if (canc == null) {
            canc = UtilNFCe.getCancelamento(nfce, justificativa, usuario);
        }
        canc.setJustificativa(justificativa);
        canc = this.enviaCancelamento(StaticObjects.getOpcoes(), canc, cancelamentoPorSubstituicao);
        return canc;
    }

    private NFCeCancelamento enviaCancelamento(NFCeOpcoes opcoes, NFCeCancelamento nfCeCancelamento, Boolean cancelamentoPorSubstituicao) throws Exception {
        try {
            Empresa empresa = StaticObjects.getEmpresa();
            ConfigCertificate config = new ConfigCertificate(empresa.getPessoa().getEndereco().getCidade().getUf(), opcoes, UtilNFCe.getTipoEmissaoNFe(nfCeCancelamento.getNfce()));
            NFeCancelarNota cancelarNota = new NFeCancelarNota();
            cancelarNota.setChave(nfCeCancelamento.getNfce().getChaveNFCe());
            cancelarNota.setMotivo(nfCeCancelamento.getJustificativa());
            cancelarNota.setNumeroProtocolo(nfCeCancelamento.getNfce().getNrProtocolo());
            if (nfCeCancelamento.getNfcePosterior() != null) {
                cancelarNota.setChaveSubstituta(nfCeCancelamento.getNfcePosterior().getChaveNFCe());
            }
            NFeEnviaEventoRet stat = UtilNfeSendWebServices.cancelarNota(config, ConstNFeVersoes.VERSAO_20180005_1_20, cancelarNota, cancelamentoPorSubstituicao);
            this.setXMLNFCe(stat.getDetEventos(), nfCeCancelamento);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        return nfCeCancelamento;
    }

    private void setXMLNFCe(List<NFeEnviaEventoRet.NFEEnviaEventoRetDet> eventos, NFCeCancelamento nfCeCancelamento) throws Exception {
        for (NFeEnviaEventoRet.NFEEnviaEventoRetDet nf : eventos) {
            Optional<NFeEnviaEventoRet.NFEEnviaEventoRetDet> found = eventos.stream().filter(i -> Objects.equals(nfCeCancelamento.getNfce().getChaveNFCe(), nf.getChave())).findFirst();
            if (found.isPresent()) {
                String data = found.get().toString();
                UtilXMLFile.saveOnFile(data, DIR_CANCELAMENTO, nf.getChave() + "-canc.xml");
                nfCeCancelamento.setXmlCancelamento(data.getBytes());
                nfCeCancelamento.setMotivo(nf.getMotivo());
                nfCeCancelamento.setStatus(nf.getCodigoStatus());
                nfCeCancelamento.setNrProtocoloCancelamento(nf.getNumeroProtocolo());
                continue;
            }
            throw new Exception("Ocorreu um erro ao comparar as notas enviadas com o retorno. Verifique a NF id " + nfCeCancelamento.getNfce().getNumero());
        }
    }

    private NFCeCancelamento atualizaDadosRetCanc(NFCeCancelamento nfCeCancelamento) {
        NFCe nfce = nfCeCancelamento.getNfce();
        if (ToolMethods.isEquals((Object)nfCeCancelamento.getStatus(), (Object)EnumConstNFeStatus.EVENTO_REG_VINC_NFE.getValue())) {
            nfce.setMotivo(nfCeCancelamento.getMotivo());
            nfce.setStatus(EnumConstNFeStatus.CANCELADA.getValue());
            this.atualizaDadosCancDenegInutNota(nfce);
        }
        ServiceNFCe serviceNFCe = Main.getBean(ServiceNFCe.class);
        nfce.setNfCeCancelamento(nfCeCancelamento);
        nfce = serviceNFCe.merge(nfce);
        return nfce.getNfCeCancelamento();
    }
}

