/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.nfcesefaz;

import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementorclientwebservices.nfe.model.env.inutilizarnota.NFeInutilizarNumeracao;
import com.touchcomp.basementorclientwebservices.nfe.model.ret.inutilizacao.NFeInutilizacaoRet;
import com.touchcomp.basementorrules.inutilizacaonumeracaonfe.CompInutilizacaoNumeracaoNFe;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.helpers.nfcesefaz.HelperNFCeSefazBase;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.InutilizacaoNumeracaoNFe;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.model.TipoEmissaoNFe;
import com.touchcomp.touchnfce.nfe.impl.versoes.ConfigCertificate;
import com.touchcomp.touchnfce.nfe.impl.versoes.ConstNFeVersoes;
import com.touchcomp.touchnfce.nfe.impl.versoes.UtilNfeSendWebServices;
import com.touchcomp.touchnfce.service.impl.ServiceInutilizacaoNumeracaoNFe;
import com.touchcomp.touchnfce.tasks.utils.UtilXMLFile;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import com.touchcomp.touchnfce.utils.UtilNFCeSerial;
import java.util.Date;
import java.util.Objects;

class HelperNFCeSefazInu
extends HelperNFCeSefazBase {
    private static String DIR_INUTILIZACAO = "inutilizacao";

    HelperNFCeSefazInu() {
    }

    NFCe inutiliza(NFCe nfce, String justificativa) throws Exception {
        InutilizacaoNumeracaoNFe inu = this.criarAndEnviarInutilizacao(StaticObjects.getOpcoes(), nfce, justificativa);
        inu = this.atualizaDadosRetInut(inu);
        return inu.getNfce();
    }

    private InutilizacaoNumeracaoNFe criarAndEnviarInutilizacao(NFCeOpcoes opcoes, NFCe nfce, String motivo) throws Exception {
        InutilizacaoNumeracaoNFe inutilizacaoNumeracaoNFe = HelperNFCeSefazInu.getInutilizacao(nfce, motivo);
        inutilizacaoNumeracaoNFe = HelperNFCeSefazInu.save(inutilizacaoNumeracaoNFe);
        try {
            Empresa empresa = StaticObjects.getEmpresa();
            ConfigCertificate config = new ConfigCertificate(empresa.getPessoa().getEndereco().getCidade().getUf(), opcoes, UtilNFCe.getTipoEmissaoNFe(nfce));
            NFeInutilizarNumeracao inu = new NFeInutilizarNumeracao();
            inu.setAnoInutilizacaoNumeracao(Integer.valueOf(ToolDate.dateToStr((Date)inutilizacaoNumeracaoNFe.getPeriodo(), (String)"yy")).intValue());
            inu.setCnpjEmitente(inutilizacaoNumeracaoNFe.getEmpresa().getPessoa().getComplemento().getCnpj());
            inu.setJustificativa(inutilizacaoNumeracaoNFe.getJustificativa());
            inu.setModelo(EnumConstantsModeloDocFiscal.valueOfCodigo((String)inutilizacaoNumeracaoNFe.getModeloDocFiscal().getCodigo()));
            inu.setNumeroInicial(ToolString.onlyNumbers((String)inutilizacaoNumeracaoNFe.getNumeroInicial().toString()));
            inu.setNumeroFinal(ToolString.onlyNumbers((String)inutilizacaoNumeracaoNFe.getNumeroFinal().toString()));
            inu.setSerie(Integer.valueOf(inutilizacaoNumeracaoNFe.getSerie()).toString());
            NFeInutilizacaoRet stat = UtilNfeSendWebServices.inutilizarNota(config, ConstNFeVersoes.VERSAO_20180005_1_20, inu);
            inutilizacaoNumeracaoNFe.setMotivo(stat.getMotivo());
            inutilizacaoNumeracaoNFe.setStatus(Integer.valueOf(stat.getStatus()));
            inutilizacaoNumeracaoNFe.setNumProtocolo(stat.getNumeroProtocolo());
            if (Objects.equals(inutilizacaoNumeracaoNFe.getStatus(), EnumConstNFeStatus.REJ_INUTILIZACAO_JA_EXISTENTE.getValue())) {
                inutilizacaoNumeracaoNFe.setMotivo("Inutiliza??o de n?mero homologado");
                inutilizacaoNumeracaoNFe.setStatus(EnumConstNFeStatus.INUTILIZADA.getValue());
            }
            String data = stat.getXmlRecebido();
            UtilXMLFile.saveOnFile(data, DIR_INUTILIZACAO, inutilizacaoNumeracaoNFe.getNumeroInicial() + "-inu.xml");
            inutilizacaoNumeracaoNFe.setConteudoInutilizacao(data.getBytes());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        return inutilizacaoNumeracaoNFe;
    }

    private static InutilizacaoNumeracaoNFe save(InutilizacaoNumeracaoNFe inutilizacaoNumeracaoNFe) {
        ServiceInutilizacaoNumeracaoNFe service = Main.getBean(ServiceInutilizacaoNumeracaoNFe.class);
        return service.merge(inutilizacaoNumeracaoNFe);
    }

    private static InutilizacaoNumeracaoNFe getInutilizacao(NFCe nfce, String motivo) {
        InutilizacaoNumeracaoNFe inu = nfce.getInutilizacaoNFe();
        if (inu == null) {
            inu = new InutilizacaoNumeracaoNFe();
        }
        TipoEmissaoNFe tipoEmissao = nfce.getPeriodoEmissaoNFCe() != null ? nfce.getPeriodoEmissaoNFCe().getTipoEmissaoNfe() : nfce.getPeriodoEmissaoNFe().getTipoEmissaoNfe();
        nfce.setInutilizacaoNFe(inu);
        inu.setNfce(nfce);
        inu.setDataCadastro(new Date());
        inu.setEmpresa(nfce.getEmpresa());
        inu.setJustificativa(ToolString.clearSpecialCharacXML((String)motivo));
        inu.setModeloDocFiscal(nfce.getModeloDocFiscal());
        inu.setNumeroFinal(nfce.getNumero());
        inu.setNumeroInicial(nfce.getNumero());
        inu.setPeriodo(nfce.getDataEmissao());
        inu.setSerialForSinc(UtilNFCeSerial.getSerial(nfce.getNfCeCaixa()));
        inu.setSerie(nfce.getSerie());
        inu.setTipoEmissaoNFe(tipoEmissao);
        inu.setChaveID(CompInutilizacaoNumeracaoNFe.getIDInutilizacao((EnumConstUF)EnumConstUF.valueOfCodigoIbge((String)nfce.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge()), (Date)inu.getPeriodo(), (String)inu.getEmpresa().getPessoa().getComplemento().getCnpj(), (String)inu.getModeloDocFiscal().getCodigo(), (String)inu.getSerie(), (Long)inu.getNumeroInicial(), (Long)inu.getNumeroFinal()));
        return inu;
    }

    private InutilizacaoNumeracaoNFe atualizaDadosRetInut(InutilizacaoNumeracaoNFe inutilizacaoNumeracaoNFe) throws Exception {
        if (Objects.equals(inutilizacaoNumeracaoNFe.getStatus(), EnumConstNFeStatus.INUTILIZADA.getValue())) {
            inutilizacaoNumeracaoNFe.getNfce().setStatus(inutilizacaoNumeracaoNFe.getStatus());
            inutilizacaoNumeracaoNFe.getNfce().setMotivo(inutilizacaoNumeracaoNFe.getMotivo());
            this.atualizaDadosCancDenegInutNota(inutilizacaoNumeracaoNFe.getNfce());
        }
        if (Objects.equals((inutilizacaoNumeracaoNFe = HelperNFCeSefazInu.save(inutilizacaoNumeracaoNFe)).getStatus(), EnumConstNFeStatus.INUTILIZADA.getValue())) {
            return inutilizacaoNumeracaoNFe;
        }
        throw new Exception("Ocorreu um problema ao inutilizar a nota fiscal " + String.valueOf(inutilizacaoNumeracaoNFe.getNfce()) + "\n" + inutilizacaoNumeracaoNFe.getMotivo());
    }
}

