/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.preco;

import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.naturezaoperacao.EnumConstNatOpSugVlrNFCe;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoTabelaPreco;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.constants.EnumTipoPesqProduto;
import com.touchcomp.touchnfce.exceptions.ExceptionTabelaPrecosDinamica;
import com.touchcomp.touchnfce.helpers.preco.tabbase.HelperPrecosTabBase;
import com.touchcomp.touchnfce.helpers.preco.tabdinamica.HelperPrecosTabDinamica;
import com.touchcomp.touchnfce.model.CondicoesPagamento;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.Grupo;
import com.touchcomp.touchnfce.model.InfoUltEntradaProduto;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.model.NaturezaOperacao;
import com.touchcomp.touchnfce.model.Produto;
import com.touchcomp.touchnfce.model.Representante;
import com.touchcomp.touchnfce.model.TipoFrete;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.model.Usuario;
import com.touchcomp.touchnfce.modeltemp.TempPesquisaProduto;
import com.touchcomp.touchnfce.service.impl.ServiceInfoUltEntradaProduto;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class HelperPrecos {
    public List<TempPesquisaProduto> getProdutos(String aux, Empresa empresa, UnidadeFatCliente unidade, NFCeOpcoes opcoes, Representante representante, Usuario usuario, Grupo grupo, TipoFrete tipoFrete, NaturezaOperacao natOP, CondicoesPagamento condicoesPagamento, Integer nrRegistros, Integer page) throws ExceptionTabelaPrecosDinamica, ExceptionAvaliadorExpressoes {
        EnumTipoPesqProduto tipoPesqProd = this.getTipoPesq(aux, opcoes);
        return this.getProdutos(aux, empresa, unidade, opcoes, representante, usuario, grupo, tipoFrete, natOP, condicoesPagamento, tipoPesqProd, nrRegistros, page);
    }

    public List<TempPesquisaProduto> getProdutos(Long idProduto, Empresa empresa, UnidadeFatCliente unidade, NFCeOpcoes opcoes, Representante representante, Usuario usuario, Grupo grupo, TipoFrete tipoFrete, NaturezaOperacao natOP, CondicoesPagamento condicoesPagamento, Integer nrRegistros, Integer page) throws ExceptionTabelaPrecosDinamica, ExceptionAvaliadorExpressoes {
        return this.getProdutos(String.valueOf(idProduto), empresa, unidade, opcoes, representante, usuario, grupo, tipoFrete, natOP, condicoesPagamento, EnumTipoPesqProduto.TIPO_PESQ_ID, nrRegistros, page);
    }

    public List<TempPesquisaProduto> getProdutos(String aux, Empresa empresa, UnidadeFatCliente unidade, NFCeOpcoes opcoes, Representante representante, Usuario usuario, Grupo grupo, TipoFrete tipoFrete, NaturezaOperacao natOP, CondicoesPagamento condicoesPagamento, Integer nrRegistros, Integer page, EnumTipoPesqProduto tipoPesqProd) throws ExceptionTabelaPrecosDinamica, ExceptionAvaliadorExpressoes {
        return this.getProdutos(aux, empresa, unidade, opcoes, representante, usuario, grupo, tipoFrete, natOP, condicoesPagamento, tipoPesqProd, nrRegistros, page);
    }

    public List<TempPesquisaProduto> getProdutosConfOpcoes(String aux, Empresa empresa, UnidadeFatCliente unidade, NFCeOpcoes opcoes, Representante representante, Usuario usuario, Grupo grupo, TipoFrete tipoFrete, NaturezaOperacao natOP, CondicoesPagamento condicoesPagamento, Integer nrRegistros, Integer page) throws ExceptionTabelaPrecosDinamica, ExceptionAvaliadorExpressoes {
        boolean useWildCard = false;
        if (!ToolMethods.isStrWithData((String)aux)) {
            return new LinkedList<TempPesquisaProduto>();
        }
        if (aux.startsWith("=")) {
            aux = aux.substring(1);
            useWildCard = true;
        }
        if (!ToolMethods.isStrWithData((String)aux)) {
            return new LinkedList<TempPesquisaProduto>();
        }
        if (!useWildCard) {
            return this.getProdutos(aux, empresa, unidade, opcoes, representante, usuario, grupo, tipoFrete, natOP, condicoesPagamento, nrRegistros, page);
        }
        EnumTipoPesqProduto tipoPesqProduto = EnumTipoPesqProduto.TIPO_PESQ_ID;
        if (ToolMethods.isAffirmative((Number)opcoes.getUsarCodAuxiliar())) {
            tipoPesqProduto = EnumTipoPesqProduto.TIPO_PESQ_COD_AUX;
        }
        return this.getProdutos(aux, empresa, unidade, opcoes, representante, usuario, grupo, tipoFrete, natOP, condicoesPagamento, tipoPesqProduto, nrRegistros, page);
    }

    public List<TempPesquisaProduto> getProdutos(String aux, Empresa empresa, UnidadeFatCliente unidade, NFCeOpcoes opcoes, Representante representante, Usuario usuario, Grupo grupo, TipoFrete tipoFrete, NaturezaOperacao natOP, CondicoesPagamento condicoesPagamento, EnumTipoPesqProduto tipoPesqProd, Integer nrRegistros, Integer page) throws ExceptionTabelaPrecosDinamica, ExceptionAvaliadorExpressoes {
        Short tipoTabPreco = opcoes.getTipoTabelaPrecoNFe();
        if (natOP != null && ToolMethods.isEquals((Object)natOP.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
            tipoTabPreco = EnumConstNFCeTipoTabelaPreco.TABELA_BASE.getValue();
        }
        if (unidade == null) {
            tipoTabPreco = EnumConstNFCeTipoTabelaPreco.TABELA_BASE.getValue();
        }
        EnumConstNatOpSugVlrNFCe sel = EnumConstNatOpSugVlrNFCe.VALOR_VENDA_TAB_PRECO;
        if (natOP != null && natOP.getSugValorUnitarioFatNFCe() != null) {
            sel = EnumConstNatOpSugVlrNFCe.valueOfCodigo((int)natOP.getSugValorUnitarioFatNFCe().shortValue());
        }
        if (ToolMethods.isEquals((Object)sel, (Object)EnumConstNatOpSugVlrNFCe.VALOR_TRANSF_FISCAL_PROD) || ToolMethods.isEquals((Object)sel, (Object)EnumConstNatOpSugVlrNFCe.VALOR_ULT_CUSTO_PROD) || ToolMethods.isEquals((Object)sel, (Object)EnumConstNatOpSugVlrNFCe.VALOR_ULT_COMPRA)) {
            return this.getValoresProdUltEntProd(sel, tipoTabPreco, aux, empresa, opcoes.getUsarCodAuxiliar(), unidade, representante, usuario, grupo, tipoFrete, natOP, condicoesPagamento, tipoPesqProd, opcoes, nrRegistros, page);
        }
        return this.getValoresProdTab(sel, tipoTabPreco, aux, empresa, opcoes.getUsarCodAuxiliar(), unidade, representante, usuario, grupo, tipoFrete, natOP, condicoesPagamento, tipoPesqProd, opcoes, nrRegistros, page);
    }

    private List<TempPesquisaProduto> getValoresProdUltEntProd(EnumConstNatOpSugVlrNFCe sel, Short tipoTabPreco, String aux, Empresa empresa, Short usarCodAuxiliar, UnidadeFatCliente unidade, Representante representante, Usuario usuario, Grupo grupo, TipoFrete tipoFrete, NaturezaOperacao natOP, CondicoesPagamento condicoesPagamento, EnumTipoPesqProduto tipoPesqProd, NFCeOpcoes opcoes, Integer nrRegistros, Integer page) throws ExceptionAvaliadorExpressoes, ExceptionTabelaPrecosDinamica {
        List<TempPesquisaProduto> ret = this.getValoresProdTab(sel, tipoTabPreco, aux, empresa, opcoes.getUsarCodAuxiliar(), unidade, representante, usuario, grupo, tipoFrete, natOP, condicoesPagamento, tipoPesqProd, opcoes, nrRegistros, page);
        ServiceInfoUltEntradaProduto service = Main.getBean(ServiceInfoUltEntradaProduto.class);
        for (TempPesquisaProduto t : ret) {
            InfoUltEntradaProduto inf = service.get(empresa, t.getIdProduto());
            if (inf != null && ToolMethods.isEquals((Object)EnumConstNatOpSugVlrNFCe.VALOR_TRANSF_FISCAL_PROD, (Object)sel)) {
                t.setValorUnitario(inf.getVrUltTransfFiscal());
                continue;
            }
            if (inf != null && ToolMethods.isEquals((Object)EnumConstNatOpSugVlrNFCe.VALOR_ULT_CUSTO_PROD, (Object)sel)) {
                t.setValorUnitario(inf.getVrUltCusto());
                continue;
            }
            if (inf != null && ToolMethods.isEquals((Object)EnumConstNatOpSugVlrNFCe.VALOR_ULT_COMPRA, (Object)sel)) {
                t.setValorUnitario(inf.getVrUltCompra());
                continue;
            }
            t.setValorUnitario(0.0);
            t.setPrecoCusto(0.0);
            t.setValorTotalFixo(0.0);
            t.setValorMinimo(0.0);
        }
        return ret;
    }

    private List<TempPesquisaProduto> getValoresProdTab(EnumConstNatOpSugVlrNFCe sel, Short tipoTabPreco, String aux, Empresa empresa, Short usarCodAuxiliar, UnidadeFatCliente unidade, Representante representante, Usuario usuario, Grupo grupo, TipoFrete tipoFrete, NaturezaOperacao natOP, CondicoesPagamento condicoesPagamento, EnumTipoPesqProduto tipoPesqProd, NFCeOpcoes opcoes, Integer nrRegistros, Integer page) throws ExceptionAvaliadorExpressoes, ExceptionTabelaPrecosDinamica {
        List<TempPesquisaProduto> ret = ToolMethods.isEquals((Object)tipoTabPreco, (Object)EnumConstNFCeTipoTabelaPreco.TABELA_BASE.getValue()) ? new HelperPrecosTabBase().getPesqTabBase(aux, tipoPesqProd, empresa, opcoes.getTabelaPrecoBase(), nrRegistros, page) : new HelperPrecosTabDinamica().getPrecosTabDinamica(aux, empresa, opcoes.getUsarCodAuxiliar(), unidade, representante, usuario, grupo, tipoFrete, natOP, condicoesPagamento, tipoPesqProd, opcoes);
        if (ToolMethods.isEquals((Object)EnumConstNatOpSugVlrNFCe.VALOR_CUSTO_TAB_PRECO, (Object)sel)) {
            ret.forEach(i -> i.setValorUnitario(i.getPrecoCusto()));
        }
        return ret;
    }

    public EnumTipoPesqProduto getTipoPesq(String aux, NFCeOpcoes opcoes) {
        Date in = new Date();
        LinkedList ret = new LinkedList();
        if (aux == null || aux.isEmpty()) {
            return EnumTipoPesqProduto.TIPO_PESQ_NENHUM;
        }
        if (ToolString.isAIntegerNumber((String)aux)) {
            if (aux.length() < 8 && !ToolMethods.isAffirmative((Number)opcoes.getUsarCodAuxiliar())) {
                return EnumTipoPesqProduto.TIPO_PESQ_ID;
            }
            if (aux.length() >= 8) {
                return EnumTipoPesqProduto.TIPO_PESQ_COD_BARRAS;
            }
        }
        return EnumTipoPesqProduto.TIPO_PESQ_COD_AUX;
    }

    public TempPesquisaProduto getComissao(Produto produto, Empresa empresa, UnidadeFatCliente unidade, NFCeOpcoes opcoes, Representante representante, Usuario usuario, Grupo grupo, TipoFrete tipoFrete, NaturezaOperacao natOP, CondicoesPagamento condicoesPagamento) throws ExceptionTabelaPrecosDinamica, ExceptionAvaliadorExpressoes {
        Short tipoTabPreco = opcoes.getTipoTabelaPrecoNFe();
        if (natOP != null && ToolMethods.isEquals((Object)natOP.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
            tipoTabPreco = EnumConstNFCeTipoTabelaPreco.TABELA_BASE.getValue();
        }
        if (unidade == null) {
            tipoTabPreco = EnumConstNFCeTipoTabelaPreco.TABELA_BASE.getValue();
        }
        return this.getValoresComissaoProdTab(tipoTabPreco, produto, empresa, unidade, representante, usuario, grupo, tipoFrete, natOP, condicoesPagamento, opcoes);
    }

    private TempPesquisaProduto getValoresComissaoProdTab(Short tipoTabPreco, Produto produto, Empresa empresa, UnidadeFatCliente unidade, Representante representante, Usuario usuario, Grupo grupo, TipoFrete tipoFrete, NaturezaOperacao natOP, CondicoesPagamento condicoesPagamento, NFCeOpcoes opcoes) throws ExceptionAvaliadorExpressoes, ExceptionTabelaPrecosDinamica {
        TempPesquisaProduto ret = ToolMethods.isEquals((Object)tipoTabPreco, (Object)EnumConstNFCeTipoTabelaPreco.TABELA_BASE.getValue()) ? new HelperPrecosTabBase().getComissaoTabBase(produto, empresa, opcoes.getTabelaPrecoBase()) : new HelperPrecosTabDinamica().getComissaoTabelaDinamica(empresa, produto, unidade, representante, usuario, grupo, tipoFrete, natOP, condicoesPagamento, opcoes);
        return ret;
    }
}

