/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.model;

import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.ModeloDocFiscal;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.TipoEmissaoNFe;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import lombok.Generated;

@Entity
@Table(name="INUTILIZACAO_NUMERACAO_NFE", uniqueConstraints={@UniqueConstraint(columnNames={"id_nfce"})})
public class InutilizacaoNumeracaoNFe
implements Serializable {
    @Id
    @Column(name="ID_INUTILIZACAO_NUMERACAO_NFE", nullable=false)
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_INUTILIZACAO_NUMERACAO_NFE")
    private Long identificador;
    @Temporal(value=TemporalType.DATE)
    @Column(name="data_cadastro")
    private Date dataCadastro;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_empresa", foreignKey=@ForeignKey(name="FK_INUTILIZACAO_NUM_NFE_EMP"))
    private Empresa empresa;
    @Column(name="chave_id")
    private String chaveID;
    @Temporal(value=TemporalType.DATE)
    @Column(name="periodo")
    private Date periodo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_modelo_doc_fiscal", foreignKey=@ForeignKey(name="FK_INUTILIZACAO_NUM_NFE_MOD"))
    private ModeloDocFiscal modeloDocFiscal;
    @Column(name="numero_inicial", nullable=false)
    private Long numeroInicial;
    @Column(name="numero_final", nullable=false)
    private Long numeroFinal;
    @Column(name="justificativa", length=1000)
    private String justificativa;
    @Column(name="serie", length=10)
    private String serie;
    @Column(name="status")
    private Integer status = 0;
    @Column(name="motivo", length=2000)
    private String motivo;
    @Column(name="num_protocolo", length=100)
    private String numProtocolo;
    @Column(name="enviado")
    private Short enviado = 1;
    @Column(name="conteudo_inutilizacao")
    private byte[] conteudoInutilizacao;
    @Column(name="conteudo_enviado")
    private byte[] conteudoEnviado;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_tipo_emissao_nfe", foreignKey=@ForeignKey(name="FK_INUTILIZACAO_NUM_NFE_TP_EMI"))
    private TipoEmissaoNFe tipoEmissaoNFe;
    @Column(name="serial_for_sinc", nullable=false, length=100)
    private String serialForSinc;
    @Version
    @Column(name="data_atualizacao")
    private Timestamp dataAtualizacao;
    @Column(name="identificador_erp")
    private Long identificadorERP;
    @Column(name="status_sinc_erp")
    private Short statusSincERP;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL, CascadeType.MERGE})
    @JoinColumn(name="id_nfce", foreignKey=@ForeignKey(name="FK_INUTILIZACAO_NUM_NFE_NFCE"))
    private NFCe nfce;

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public String getChaveID() {
        return this.chaveID;
    }

    @Generated
    public Date getPeriodo() {
        return this.periodo;
    }

    @Generated
    public ModeloDocFiscal getModeloDocFiscal() {
        return this.modeloDocFiscal;
    }

    @Generated
    public Long getNumeroInicial() {
        return this.numeroInicial;
    }

    @Generated
    public Long getNumeroFinal() {
        return this.numeroFinal;
    }

    @Generated
    public String getJustificativa() {
        return this.justificativa;
    }

    @Generated
    public String getSerie() {
        return this.serie;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public String getMotivo() {
        return this.motivo;
    }

    @Generated
    public String getNumProtocolo() {
        return this.numProtocolo;
    }

    @Generated
    public Short getEnviado() {
        return this.enviado;
    }

    @Generated
    public byte[] getConteudoInutilizacao() {
        return this.conteudoInutilizacao;
    }

    @Generated
    public byte[] getConteudoEnviado() {
        return this.conteudoEnviado;
    }

    @Generated
    public TipoEmissaoNFe getTipoEmissaoNFe() {
        return this.tipoEmissaoNFe;
    }

    @Generated
    public String getSerialForSinc() {
        return this.serialForSinc;
    }

    @Generated
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Long getIdentificadorERP() {
        return this.identificadorERP;
    }

    @Generated
    public Short getStatusSincERP() {
        return this.statusSincERP;
    }

    @Generated
    public NFCe getNfce() {
        return this.nfce;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setChaveID(String chaveID) {
        this.chaveID = chaveID;
    }

    @Generated
    public void setPeriodo(Date periodo) {
        this.periodo = periodo;
    }

    @Generated
    public void setModeloDocFiscal(ModeloDocFiscal modeloDocFiscal) {
        this.modeloDocFiscal = modeloDocFiscal;
    }

    @Generated
    public void setNumeroInicial(Long numeroInicial) {
        this.numeroInicial = numeroInicial;
    }

    @Generated
    public void setNumeroFinal(Long numeroFinal) {
        this.numeroFinal = numeroFinal;
    }

    @Generated
    public void setJustificativa(String justificativa) {
        this.justificativa = justificativa;
    }

    @Generated
    public void setSerie(String serie) {
        this.serie = serie;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @Generated
    public void setNumProtocolo(String numProtocolo) {
        this.numProtocolo = numProtocolo;
    }

    @Generated
    public void setEnviado(Short enviado) {
        this.enviado = enviado;
    }

    @Generated
    public void setConteudoInutilizacao(byte[] conteudoInutilizacao) {
        this.conteudoInutilizacao = conteudoInutilizacao;
    }

    @Generated
    public void setConteudoEnviado(byte[] conteudoEnviado) {
        this.conteudoEnviado = conteudoEnviado;
    }

    @Generated
    public void setTipoEmissaoNFe(TipoEmissaoNFe tipoEmissaoNFe) {
        this.tipoEmissaoNFe = tipoEmissaoNFe;
    }

    @Generated
    public void setSerialForSinc(String serialForSinc) {
        this.serialForSinc = serialForSinc;
    }

    @Generated
    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setIdentificadorERP(Long identificadorERP) {
        this.identificadorERP = identificadorERP;
    }

    @Generated
    public void setStatusSincERP(Short statusSincERP) {
        this.statusSincERP = statusSincERP;
    }

    @Generated
    public void setNfce(NFCe nfce) {
        this.nfce = nfce;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InutilizacaoNumeracaoNFe)) {
            return false;
        }
        InutilizacaoNumeracaoNFe other = (InutilizacaoNumeracaoNFe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$identificador = this.getIdentificador();
        Long other$identificador = other.getIdentificador();
        if (this$identificador == null ? other$identificador != null : !((Object)this$identificador).equals(other$identificador)) {
            return false;
        }
        Long this$numeroInicial = this.getNumeroInicial();
        Long other$numeroInicial = other.getNumeroInicial();
        if (this$numeroInicial == null ? other$numeroInicial != null : !((Object)this$numeroInicial).equals(other$numeroInicial)) {
            return false;
        }
        Long this$numeroFinal = this.getNumeroFinal();
        Long other$numeroFinal = other.getNumeroFinal();
        if (this$numeroFinal == null ? other$numeroFinal != null : !((Object)this$numeroFinal).equals(other$numeroFinal)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Short this$enviado = this.getEnviado();
        Short other$enviado = other.getEnviado();
        if (this$enviado == null ? other$enviado != null : !((Object)this$enviado).equals(other$enviado)) {
            return false;
        }
        Long this$identificadorERP = this.getIdentificadorERP();
        Long other$identificadorERP = other.getIdentificadorERP();
        if (this$identificadorERP == null ? other$identificadorERP != null : !((Object)this$identificadorERP).equals(other$identificadorERP)) {
            return false;
        }
        Short this$statusSincERP = this.getStatusSincERP();
        Short other$statusSincERP = other.getStatusSincERP();
        if (this$statusSincERP == null ? other$statusSincERP != null : !((Object)this$statusSincERP).equals(other$statusSincERP)) {
            return false;
        }
        Date this$dataCadastro = this.getDataCadastro();
        Date other$dataCadastro = other.getDataCadastro();
        if (this$dataCadastro == null ? other$dataCadastro != null : !((Object)this$dataCadastro).equals(other$dataCadastro)) {
            return false;
        }
        Empresa this$empresa = this.getEmpresa();
        Empresa other$empresa = other.getEmpresa();
        if (this$empresa == null ? other$empresa != null : !((Object)this$empresa).equals(other$empresa)) {
            return false;
        }
        String this$chaveID = this.getChaveID();
        String other$chaveID = other.getChaveID();
        if (this$chaveID == null ? other$chaveID != null : !this$chaveID.equals(other$chaveID)) {
            return false;
        }
        Date this$periodo = this.getPeriodo();
        Date other$periodo = other.getPeriodo();
        if (this$periodo == null ? other$periodo != null : !((Object)this$periodo).equals(other$periodo)) {
            return false;
        }
        ModeloDocFiscal this$modeloDocFiscal = this.getModeloDocFiscal();
        ModeloDocFiscal other$modeloDocFiscal = other.getModeloDocFiscal();
        if (this$modeloDocFiscal == null ? other$modeloDocFiscal != null : !((Object)this$modeloDocFiscal).equals(other$modeloDocFiscal)) {
            return false;
        }
        String this$justificativa = this.getJustificativa();
        String other$justificativa = other.getJustificativa();
        if (this$justificativa == null ? other$justificativa != null : !this$justificativa.equals(other$justificativa)) {
            return false;
        }
        String this$serie = this.getSerie();
        String other$serie = other.getSerie();
        if (this$serie == null ? other$serie != null : !this$serie.equals(other$serie)) {
            return false;
        }
        String this$motivo = this.getMotivo();
        String other$motivo = other.getMotivo();
        if (this$motivo == null ? other$motivo != null : !this$motivo.equals(other$motivo)) {
            return false;
        }
        String this$numProtocolo = this.getNumProtocolo();
        String other$numProtocolo = other.getNumProtocolo();
        if (this$numProtocolo == null ? other$numProtocolo != null : !this$numProtocolo.equals(other$numProtocolo)) {
            return false;
        }
        if (!Arrays.equals(this.getConteudoInutilizacao(), other.getConteudoInutilizacao())) {
            return false;
        }
        if (!Arrays.equals(this.getConteudoEnviado(), other.getConteudoEnviado())) {
            return false;
        }
        TipoEmissaoNFe this$tipoEmissaoNFe = this.getTipoEmissaoNFe();
        TipoEmissaoNFe other$tipoEmissaoNFe = other.getTipoEmissaoNFe();
        if (this$tipoEmissaoNFe == null ? other$tipoEmissaoNFe != null : !((Object)this$tipoEmissaoNFe).equals(other$tipoEmissaoNFe)) {
            return false;
        }
        String this$serialForSinc = this.getSerialForSinc();
        String other$serialForSinc = other.getSerialForSinc();
        if (this$serialForSinc == null ? other$serialForSinc != null : !this$serialForSinc.equals(other$serialForSinc)) {
            return false;
        }
        Timestamp this$dataAtualizacao = this.getDataAtualizacao();
        Timestamp other$dataAtualizacao = other.getDataAtualizacao();
        if (this$dataAtualizacao == null ? other$dataAtualizacao != null : !((Object)this$dataAtualizacao).equals(other$dataAtualizacao)) {
            return false;
        }
        NFCe this$nfce = this.getNfce();
        NFCe other$nfce = other.getNfce();
        return !(this$nfce == null ? other$nfce != null : !((Object)this$nfce).equals(other$nfce));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InutilizacaoNumeracaoNFe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $identificador = this.getIdentificador();
        result = result * 59 + ($identificador == null ? 43 : ((Object)$identificador).hashCode());
        Long $numeroInicial = this.getNumeroInicial();
        result = result * 59 + ($numeroInicial == null ? 43 : ((Object)$numeroInicial).hashCode());
        Long $numeroFinal = this.getNumeroFinal();
        result = result * 59 + ($numeroFinal == null ? 43 : ((Object)$numeroFinal).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Short $enviado = this.getEnviado();
        result = result * 59 + ($enviado == null ? 43 : ((Object)$enviado).hashCode());
        Long $identificadorERP = this.getIdentificadorERP();
        result = result * 59 + ($identificadorERP == null ? 43 : ((Object)$identificadorERP).hashCode());
        Short $statusSincERP = this.getStatusSincERP();
        result = result * 59 + ($statusSincERP == null ? 43 : ((Object)$statusSincERP).hashCode());
        Date $dataCadastro = this.getDataCadastro();
        result = result * 59 + ($dataCadastro == null ? 43 : ((Object)$dataCadastro).hashCode());
        Empresa $empresa = this.getEmpresa();
        result = result * 59 + ($empresa == null ? 43 : ((Object)$empresa).hashCode());
        String $chaveID = this.getChaveID();
        result = result * 59 + ($chaveID == null ? 43 : $chaveID.hashCode());
        Date $periodo = this.getPeriodo();
        result = result * 59 + ($periodo == null ? 43 : ((Object)$periodo).hashCode());
        ModeloDocFiscal $modeloDocFiscal = this.getModeloDocFiscal();
        result = result * 59 + ($modeloDocFiscal == null ? 43 : ((Object)$modeloDocFiscal).hashCode());
        String $justificativa = this.getJustificativa();
        result = result * 59 + ($justificativa == null ? 43 : $justificativa.hashCode());
        String $serie = this.getSerie();
        result = result * 59 + ($serie == null ? 43 : $serie.hashCode());
        String $motivo = this.getMotivo();
        result = result * 59 + ($motivo == null ? 43 : $motivo.hashCode());
        String $numProtocolo = this.getNumProtocolo();
        result = result * 59 + ($numProtocolo == null ? 43 : $numProtocolo.hashCode());
        result = result * 59 + Arrays.hashCode(this.getConteudoInutilizacao());
        result = result * 59 + Arrays.hashCode(this.getConteudoEnviado());
        TipoEmissaoNFe $tipoEmissaoNFe = this.getTipoEmissaoNFe();
        result = result * 59 + ($tipoEmissaoNFe == null ? 43 : ((Object)$tipoEmissaoNFe).hashCode());
        String $serialForSinc = this.getSerialForSinc();
        result = result * 59 + ($serialForSinc == null ? 43 : $serialForSinc.hashCode());
        Timestamp $dataAtualizacao = this.getDataAtualizacao();
        result = result * 59 + ($dataAtualizacao == null ? 43 : ((Object)$dataAtualizacao).hashCode());
        NFCe $nfce = this.getNfce();
        result = result * 59 + ($nfce == null ? 43 : ((Object)$nfce).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InutilizacaoNumeracaoNFe(identificador=" + this.getIdentificador() + ", dataCadastro=" + String.valueOf(this.getDataCadastro()) + ", empresa=" + String.valueOf(this.getEmpresa()) + ", chaveID=" + this.getChaveID() + ", periodo=" + String.valueOf(this.getPeriodo()) + ", modeloDocFiscal=" + String.valueOf(this.getModeloDocFiscal()) + ", numeroInicial=" + this.getNumeroInicial() + ", numeroFinal=" + this.getNumeroFinal() + ", justificativa=" + this.getJustificativa() + ", serie=" + this.getSerie() + ", status=" + this.getStatus() + ", motivo=" + this.getMotivo() + ", numProtocolo=" + this.getNumProtocolo() + ", enviado=" + this.getEnviado() + ", conteudoInutilizacao=" + Arrays.toString(this.getConteudoInutilizacao()) + ", conteudoEnviado=" + Arrays.toString(this.getConteudoEnviado()) + ", tipoEmissaoNFe=" + String.valueOf(this.getTipoEmissaoNFe()) + ", serialForSinc=" + this.getSerialForSinc() + ", dataAtualizacao=" + String.valueOf(this.getDataAtualizacao()) + ", identificadorERP=" + this.getIdentificadorERP() + ", statusSincERP=" + this.getStatusSincERP() + ", nfce=" + String.valueOf(this.getNfce()) + ")";
    }
}

