/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.model;

import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.Usuario;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import lombok.Generated;

@Entity
@Table(name="NFCE_CANCELAMENTO", uniqueConstraints={@UniqueConstraint(name="UK_NFCE_CANCELAMENTO_NFCE", columnNames={"ID_NFCE"})})
public class NFCeCancelamento
implements Serializable {
    @Id
    @Column(name="ID_NFCE_CANCELAMENTO", nullable=false)
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_NFCE_CANCELAMENTO")
    private Long identificador;
    @Column(name="MOTIVO", length=1000)
    private String motivo;
    @Column(name="JUSTIFICATIVA", nullable=false, length=1000)
    private String justificativa;
    @Column(name="NR_PROTOCOLO_CANCELAMENTO", length=100)
    private String nrProtocoloCancelamento;
    @Column(name="STATUS", nullable=false, length=100)
    private Integer status = 0;
    @ManyToOne
    @JoinColumn(name="ID_NFCE", nullable=false, foreignKey=@ForeignKey(name="FK_NFCE_CANCELAMENTO_NFCE"))
    private NFCe nfce;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_CANCELAMENTO", nullable=false)
    private Date dataCancelamento = new Date();
    @Column(name="XML_CANCELAMENTO")
    private byte[] xmlCancelamento;
    @OneToOne(mappedBy="nfceCancelamentoAnterior")
    private NFCe nfcePosterior;
    @ManyToOne
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_NFCE_CANCELAMENTO_USUARIO"))
    private Usuario usuario;

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Cancelamento: {0} : {1}  NR NFCe: {2}", (Object[])new Object[]{this.getIdentificador(), this.getMotivo(), this.getNfce() != null ? this.getNfce().getNumero() : ""});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public String getMotivo() {
        return this.motivo;
    }

    @Generated
    public String getJustificativa() {
        return this.justificativa;
    }

    @Generated
    public String getNrProtocoloCancelamento() {
        return this.nrProtocoloCancelamento;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public NFCe getNfce() {
        return this.nfce;
    }

    @Generated
    public Date getDataCancelamento() {
        return this.dataCancelamento;
    }

    @Generated
    public byte[] getXmlCancelamento() {
        return this.xmlCancelamento;
    }

    @Generated
    public NFCe getNfcePosterior() {
        return this.nfcePosterior;
    }

    @Generated
    public Usuario getUsuario() {
        return this.usuario;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @Generated
    public void setJustificativa(String justificativa) {
        this.justificativa = justificativa;
    }

    @Generated
    public void setNrProtocoloCancelamento(String nrProtocoloCancelamento) {
        this.nrProtocoloCancelamento = nrProtocoloCancelamento;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setNfce(NFCe nfce) {
        this.nfce = nfce;
    }

    @Generated
    public void setDataCancelamento(Date dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @Generated
    public void setXmlCancelamento(byte[] xmlCancelamento) {
        this.xmlCancelamento = xmlCancelamento;
    }

    @Generated
    public void setNfcePosterior(NFCe nfcePosterior) {
        this.nfcePosterior = nfcePosterior;
    }

    @Generated
    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }
}

