/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.model;

import com.touchcomp.basementor.constants.enums.EnumConstPercentualValor;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoDesconto;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import com.touchcomp.touchnfce.model.CentroEstoque;
import com.touchcomp.touchnfce.model.Cfop;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.GradeCor;
import com.touchcomp.touchnfce.model.ModeloFiscal;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeItemCofins;
import com.touchcomp.touchnfce.model.NFCeItemICMS;
import com.touchcomp.touchnfce.model.NFCeItemIpi;
import com.touchcomp.touchnfce.model.NFCeItemPis;
import com.touchcomp.touchnfce.model.NFCePreAbastecimento;
import com.touchcomp.touchnfce.model.Produto;
import com.touchcomp.touchnfce.model.Representante;
import com.touchcomp.touchnfce.model.UnidadeMedida;
import com.touchcomp.touchnfce.model.Usuario;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import lombok.Generated;

@Entity
@Table(name="NFCE_ITEM", uniqueConstraints={@UniqueConstraint(name="UK_NFCE_ITEM_ICMS", columnNames={"id_icms"}), @UniqueConstraint(name="UK_NFCE_ITEM_PIS", columnNames={"id_pis"}), @UniqueConstraint(name="UK_NFCE_ITEM_COFINS", columnNames={"id_cofins"})})
public class NFCeItem
implements Serializable {
    @Id
    @Column(name="ID_NFCE_ITEM", nullable=false)
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_NFCE_ITEM")
    private Long identificador;
    @ManyToOne
    @JoinColumn(name="id_nfce", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_NFCE"))
    private NFCe nfce;
    @ManyToOne
    @JoinColumn(name="id_grade_cor", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_GRADE_COR"))
    private GradeCor gradeCor;
    @ManyToOne
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_PRODUTO"))
    private Produto produto;
    @ManyToOne
    @JoinColumn(name="ID_CFOP", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_CFOP"))
    private Cfop cfop;
    @Column(name="QUANTIDADE_COMERCIAL", nullable=false, precision=6, scale=15)
    private Double quantidadeComercial = 0.0;
    @Column(name="QUANTIDADE_TRIBURARIA", nullable=false, precision=6, scale=15)
    private Double quantidadeTributaria = 0.0;
    @Column(name="VALOR_UNITARIO_COMERCIAL", nullable=false, precision=6, scale=15)
    private Double valorUnitarioComercial = 0.0;
    @Column(name="VALOR_CUSTO", precision=6, scale=15)
    private Double valorCusto = 0.0;
    @Column(name="VALOR_UNITARIO_TRIBUTADO", nullable=false, precision=6, scale=15)
    private Double valorUnitarioTributario = 0.0;
    @Column(name="VALOR_TOTAL", nullable=false, precision=2, scale=15)
    private Double valorTotal = 0.0;
    @Column(name="VALOR_TOTAL_BRUTO", nullable=false, precision=2, scale=15)
    private Double valorTotalBruto = 0.0;
    @Column(name="COMPOE_TOTAL", nullable=false)
    private Short compoeTotal = 1;
    @Column(name="NUMERO_ITEM", nullable=false)
    private Integer numeroItem = 1;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="ID_ICMS", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_ICMS"))
    private NFCeItemICMS icms;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="ID_PIS", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_PIS"))
    private NFCeItemPis pis;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="ID_COFINS", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_COFINS"))
    private NFCeItemCofins cofins;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="ID_IPI", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_IPI"))
    private NFCeItemIpi ipi;
    @Column(name="inf_adicional_prod", length=500)
    private String infAdicionalProd;
    @Column(name="PERCENTUAL_FRETE", nullable=false)
    private Double percentualFrete;
    @Column(name="VALOR_FRETE", nullable=false, precision=2, scale=15)
    private Double valorFrete = 0.0;
    @Column(name="PERCENTUAL_SEGURO", nullable=false)
    private Double percentualSeguro;
    @Column(name="VALOR_SEGURO", nullable=false, precision=2, scale=15)
    private Double valorSeguro = 0.0;
    @Column(name="PERCENTUAL_DESCONTO", nullable=false)
    private Double percentualDesconto;
    @Column(name="VALOR_DESCONTO", nullable=false, precision=2, scale=15)
    private Double valorDesconto = 0.0;
    @Column(name="PERC_DESCONTO_PROMOCAO", nullable=true)
    private Double percentualDescontoPromocional;
    @Column(name="VALOR_DESCONTO_PROMOCAO", nullable=true, precision=2, scale=15)
    private Double valorDescontoPromocional;
    @Column(name="PERCENTUAL_DESP_ACESS", nullable=false)
    private Double percentualDespAcess;
    @Column(name="VALOR_DESP_ACESSORIAS", nullable=false, precision=2, scale=15)
    private Double valorDespesasAcessorias = 0.0;
    @Column(name="perc_valor_frete", nullable=false)
    private Short percValorFrete;
    @Column(name="PERCENTUAL_FRETE_INF", nullable=false)
    private Double percentualFreteInf;
    @Column(name="VALOR_FRETE_INF", nullable=false, precision=2, scale=15)
    private Double valorFreteInf;
    @Column(name="perc_valor_seguro", nullable=false)
    private Short percValorSeguro;
    @Column(name="PERCENTUAL_SEGURO_INF", nullable=false)
    private Double percentualSeguroInf;
    @Column(name="VALOR_SEGURO_INF", nullable=false, precision=2, scale=15)
    private Double valorSeguroInf;
    @Column(name="perc_valor_desconto", nullable=false)
    private Short percValorDesconto;
    @Column(name="PERCENTUAL_DESCONTO_INF", nullable=false)
    private Double percentualDescontoInf;
    @Column(name="VALOR_DESCONTO_INF", nullable=false, precision=2, scale=15)
    private Double valorDescontoInf;
    @Column(name="perc_valor_desp_acess", nullable=false)
    private Short percValorDespAcess;
    @Column(name="PERCENTUAL_DESP_ACESS_INF", nullable=false)
    private Double percentualDespAcessInf;
    @Column(name="VALOR_DESP_ACESSORIAS_INF", nullable=false, precision=2, scale=15)
    private Double valorDespesasAcessoriasInf;
    @Column(name="PERCENTUAL_FRETE_RAT", nullable=false)
    private Double percentualFreteRat;
    @Column(name="VALOR_FRETE_RAT", nullable=false, precision=2, scale=15)
    private Double valorFreteRat;
    @Column(name="PERCENTUAL_SEGURO_RAT", nullable=false)
    private Double percentualSeguroRat;
    @Column(name="VALOR_SEGURO_RAT", nullable=false, precision=2, scale=15)
    private Double valorSeguroRat;
    @Column(name="PERCENTUAL_DESCONTO_RAT", nullable=false)
    private Double percentualDescontoRat;
    @Column(name="VALOR_DESCONTO_RAT", nullable=false, precision=2, scale=15)
    private Double valorDescontoRat;
    @Column(name="PERCENTUAL_DESP_ACESS_RAT", nullable=false)
    private Double percentualDespAcessRat;
    @Column(name="VALOR_DESP_ACESSORIAS_RAT", nullable=false, precision=2, scale=15)
    private Double valorDespesasAcessoriasRat;
    @Column(name="NUMERO_PEDIDO_CLIENTE", length=15)
    private String numeroPedidoCliente;
    @Column(name="STATUS", nullable=false)
    private Short status = 1;
    @Column(name="STATUS_ORIGINAL")
    private Short statusOriginal = 1;
    @Column(name="NUMERO_PED_ITEM_CLIENTE")
    private Integer numeroPedidoItemCliente;
    @Column(name="VALOR_TOTAL_TRIBUTOS", nullable=false, precision=2, scale=15)
    private Double valorTotalTributos = 0.0;
    @Column(name="VR_TRIBUTOS_PREV_EST", precision=2, scale=15)
    private Double valorTributosPrevistosEst;
    @Column(name="VR_TRIBUTOS_PREV_FED", precision=2, scale=15)
    private Double valorTributosPrevistosFed;
    @Column(name="VR_TRIBUTOS_PREV_MUN", precision=2, scale=15)
    private Double valorTributosPrevistosMun;
    @ManyToOne
    @JoinColumn(name="ID_MODELO_FISCAL", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_MOD_FISCAL"))
    private ModeloFiscal modeloFiscal;
    @Column(name="CODIGO_BARRAS", length=30)
    private String codigoBarras;
    @Column(name="CODIGO_BARRAS_TRIBUTAVEL", length=30)
    private String codigoBarrasTributavel;
    @Column(name="PERCENTUAL_COMISSAO", precision=2, scale=15)
    private Double percentualComissao;
    @ManyToOne
    @JoinColumn(name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_REPRESENTANTE"))
    private Representante representante;
    @Column(name="PERC_TRIBUTOS_PREVISTOS", precision=2, scale=15)
    private Double percTributosPrevistos;
    @Column(name="PERC_TRIBUTOS_PREV_EST", precision=2, scale=15)
    private Double percTributosPrevistosEst;
    @Column(name="PERC_TRIBUTOS_PREV_FED", precision=2, scale=15)
    private Double percTributosPrevistosFed;
    @Column(name="PERC_TRIBUTOS_PREV_MUN", precision=2, scale=15)
    private Double percTributosPrevistosMun;
    @ManyToOne
    @JoinColumn(name="id_usuario_cancelamento", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_USUARIO_CANC"))
    private Usuario usuarioCancelamento;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.REFRESH})
    @JoinColumn(name="id_pre_Abastecimento", unique=true, foreignKey=@ForeignKey(name="FK_NFCE_ITEM_PRE_ABAST"))
    private NFCePreAbastecimento preAbastecimento;
    @ManyToOne
    @JoinColumn(name="id_centro_Estoque", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_CENTRO_ESTOQUE"))
    private CentroEstoque centroEstoque;
    @Column(name="valor_Partida", precision=2, scale=15)
    private Double valorPartida = 0.0;
    @ManyToOne
    @JoinColumn(name="id_unidade_Medida_Trib", foreignKey=@ForeignKey(name="FK_NFCE_ITEM_UNID_MED"))
    private UnidadeMedida unidadeMedidaTrib;
    @Column(name="fator_Conversao", precision=4, scale=15)
    private Double fatorConversao = 1.0;
    @Column(name="tipo_Desconto")
    private Short tipoDesconto;
    @Column(name="movimentacao_Fisica")
    private Short movimentacaoFisica = 0;
    @ManyToOne
    @JoinColumn(name="id_empresa")
    private Empresa empresa;
    @Column(name="SERIAL_FOR_SINC")
    private String serialForSinc;
    @Column(name="CODIGO_BARRAS_PESAVEL")
    private Short codigoBarrasPesavel = 0;
    @Column(name="NR_LOTE_FABRICACAO", length=100)
    private String nrLoteFabricacao;
    @Column(name="DATA_FABRICACAO")
    private Date dataFabricacao;
    @Column(name="DATA_VALIDADE")
    private Date dataValidade;

    public NFCeItem() {
        this.setPercentualComissao(0.0);
        this.valorDescontoRat = 0.0;
        this.valorFreteRat = 0.0;
        this.valorDespesasAcessoriasRat = 0.0;
        this.valorSeguroRat = 0.0;
        this.percentualDesconto = 0.0;
        this.percentualDespAcess = 0.0;
        this.percentualFrete = 0.0;
        this.percentualSeguro = 0.0;
        this.percentualDescontoRat = 0.0;
        this.percentualDespAcessRat = 0.0;
        this.percentualFreteRat = 0.0;
        this.percentualSeguroRat = 0.0;
        this.valorDescontoInf = 0.0;
        this.valorDespesasAcessoriasInf = 0.0;
        this.valorFreteInf = 0.0;
        this.valorSeguroInf = 0.0;
        this.percentualDescontoInf = 0.0;
        this.percentualDespAcessInf = 0.0;
        this.percentualFreteInf = 0.0;
        this.percentualSeguroInf = 0.0;
        this.percTributosPrevistos = 0.0;
        this.percTributosPrevistosEst = 0.0;
        this.percTributosPrevistosFed = 0.0;
        this.percTributosPrevistosMun = 0.0;
        this.percValorDesconto = EnumConstPercentualValor.PERCENTUAL.getValue();
        this.percValorDespAcess = EnumConstPercentualValor.PERCENTUAL.getValue();
        this.percValorFrete = EnumConstPercentualValor.PERCENTUAL.getValue();
        this.percValorSeguro = EnumConstPercentualValor.PERCENTUAL.getValue();
        this.tipoDesconto = EnumConstNFCeTipoDesconto.SEM_DESCONTO_ACRESCIMO.getValue();
    }

    public void setPercentualComissao(Double percentualComissao) {
        this.percentualComissao = percentualComissao;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public void setValorCusto(Double valorCusto) {
        this.valorCusto = valorCusto;
    }

    public void setValorUnitarioComercial(Double valorUnitarioComercial) {
        this.valorUnitarioComercial = valorUnitarioComercial;
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public NFCe getNfce() {
        return this.nfce;
    }

    @Generated
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    @Generated
    public Produto getProduto() {
        return this.produto;
    }

    @Generated
    public Cfop getCfop() {
        return this.cfop;
    }

    @Generated
    public Double getQuantidadeComercial() {
        return this.quantidadeComercial;
    }

    @Generated
    public Double getQuantidadeTributaria() {
        return this.quantidadeTributaria;
    }

    @Generated
    public Double getValorUnitarioComercial() {
        return this.valorUnitarioComercial;
    }

    @Generated
    public Double getValorCusto() {
        return this.valorCusto;
    }

    @Generated
    public Double getValorUnitarioTributario() {
        return this.valorUnitarioTributario;
    }

    @Generated
    public Double getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public Double getValorTotalBruto() {
        return this.valorTotalBruto;
    }

    @Generated
    public Short getCompoeTotal() {
        return this.compoeTotal;
    }

    @Generated
    public Integer getNumeroItem() {
        return this.numeroItem;
    }

    @Generated
    public NFCeItemICMS getIcms() {
        return this.icms;
    }

    @Generated
    public NFCeItemPis getPis() {
        return this.pis;
    }

    @Generated
    public NFCeItemCofins getCofins() {
        return this.cofins;
    }

    @Generated
    public NFCeItemIpi getIpi() {
        return this.ipi;
    }

    @Generated
    public String getInfAdicionalProd() {
        return this.infAdicionalProd;
    }

    @Generated
    public Double getPercentualFrete() {
        return this.percentualFrete;
    }

    @Generated
    public Double getValorFrete() {
        return this.valorFrete;
    }

    @Generated
    public Double getPercentualSeguro() {
        return this.percentualSeguro;
    }

    @Generated
    public Double getValorSeguro() {
        return this.valorSeguro;
    }

    @Generated
    public Double getPercentualDesconto() {
        return this.percentualDesconto;
    }

    @Generated
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    @Generated
    public Double getPercentualDescontoPromocional() {
        return this.percentualDescontoPromocional;
    }

    @Generated
    public Double getValorDescontoPromocional() {
        return this.valorDescontoPromocional;
    }

    @Generated
    public Double getPercentualDespAcess() {
        return this.percentualDespAcess;
    }

    @Generated
    public Double getValorDespesasAcessorias() {
        return this.valorDespesasAcessorias;
    }

    @Generated
    public Short getPercValorFrete() {
        return this.percValorFrete;
    }

    @Generated
    public Double getPercentualFreteInf() {
        return this.percentualFreteInf;
    }

    @Generated
    public Double getValorFreteInf() {
        return this.valorFreteInf;
    }

    @Generated
    public Short getPercValorSeguro() {
        return this.percValorSeguro;
    }

    @Generated
    public Double getPercentualSeguroInf() {
        return this.percentualSeguroInf;
    }

    @Generated
    public Double getValorSeguroInf() {
        return this.valorSeguroInf;
    }

    @Generated
    public Short getPercValorDesconto() {
        return this.percValorDesconto;
    }

    @Generated
    public Double getPercentualDescontoInf() {
        return this.percentualDescontoInf;
    }

    @Generated
    public Double getValorDescontoInf() {
        return this.valorDescontoInf;
    }

    @Generated
    public Short getPercValorDespAcess() {
        return this.percValorDespAcess;
    }

    @Generated
    public Double getPercentualDespAcessInf() {
        return this.percentualDespAcessInf;
    }

    @Generated
    public Double getValorDespesasAcessoriasInf() {
        return this.valorDespesasAcessoriasInf;
    }

    @Generated
    public Double getPercentualFreteRat() {
        return this.percentualFreteRat;
    }

    @Generated
    public Double getValorFreteRat() {
        return this.valorFreteRat;
    }

    @Generated
    public Double getPercentualSeguroRat() {
        return this.percentualSeguroRat;
    }

    @Generated
    public Double getValorSeguroRat() {
        return this.valorSeguroRat;
    }

    @Generated
    public Double getPercentualDescontoRat() {
        return this.percentualDescontoRat;
    }

    @Generated
    public Double getValorDescontoRat() {
        return this.valorDescontoRat;
    }

    @Generated
    public Double getPercentualDespAcessRat() {
        return this.percentualDespAcessRat;
    }

    @Generated
    public Double getValorDespesasAcessoriasRat() {
        return this.valorDespesasAcessoriasRat;
    }

    @Generated
    public String getNumeroPedidoCliente() {
        return this.numeroPedidoCliente;
    }

    @Generated
    public Short getStatus() {
        return this.status;
    }

    @Generated
    public Short getStatusOriginal() {
        return this.statusOriginal;
    }

    @Generated
    public Integer getNumeroPedidoItemCliente() {
        return this.numeroPedidoItemCliente;
    }

    @Generated
    public Double getValorTotalTributos() {
        return this.valorTotalTributos;
    }

    @Generated
    public Double getValorTributosPrevistosEst() {
        return this.valorTributosPrevistosEst;
    }

    @Generated
    public Double getValorTributosPrevistosFed() {
        return this.valorTributosPrevistosFed;
    }

    @Generated
    public Double getValorTributosPrevistosMun() {
        return this.valorTributosPrevistosMun;
    }

    @Generated
    public ModeloFiscal getModeloFiscal() {
        return this.modeloFiscal;
    }

    @Generated
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    @Generated
    public String getCodigoBarrasTributavel() {
        return this.codigoBarrasTributavel;
    }

    @Generated
    public Double getPercentualComissao() {
        return this.percentualComissao;
    }

    @Generated
    public Representante getRepresentante() {
        return this.representante;
    }

    @Generated
    public Double getPercTributosPrevistos() {
        return this.percTributosPrevistos;
    }

    @Generated
    public Double getPercTributosPrevistosEst() {
        return this.percTributosPrevistosEst;
    }

    @Generated
    public Double getPercTributosPrevistosFed() {
        return this.percTributosPrevistosFed;
    }

    @Generated
    public Double getPercTributosPrevistosMun() {
        return this.percTributosPrevistosMun;
    }

    @Generated
    public Usuario getUsuarioCancelamento() {
        return this.usuarioCancelamento;
    }

    @Generated
    public NFCePreAbastecimento getPreAbastecimento() {
        return this.preAbastecimento;
    }

    @Generated
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    @Generated
    public Double getValorPartida() {
        return this.valorPartida;
    }

    @Generated
    public UnidadeMedida getUnidadeMedidaTrib() {
        return this.unidadeMedidaTrib;
    }

    @Generated
    public Double getFatorConversao() {
        return this.fatorConversao;
    }

    @Generated
    public Short getTipoDesconto() {
        return this.tipoDesconto;
    }

    @Generated
    public Short getMovimentacaoFisica() {
        return this.movimentacaoFisica;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public String getSerialForSinc() {
        return this.serialForSinc;
    }

    @Generated
    public Short getCodigoBarrasPesavel() {
        return this.codigoBarrasPesavel;
    }

    @Generated
    public String getNrLoteFabricacao() {
        return this.nrLoteFabricacao;
    }

    @Generated
    public Date getDataFabricacao() {
        return this.dataFabricacao;
    }

    @Generated
    public Date getDataValidade() {
        return this.dataValidade;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setNfce(NFCe nfce) {
        this.nfce = nfce;
    }

    @Generated
    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    @Generated
    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @Generated
    public void setCfop(Cfop cfop) {
        this.cfop = cfop;
    }

    @Generated
    public void setQuantidadeComercial(Double quantidadeComercial) {
        this.quantidadeComercial = quantidadeComercial;
    }

    @Generated
    public void setQuantidadeTributaria(Double quantidadeTributaria) {
        this.quantidadeTributaria = quantidadeTributaria;
    }

    @Generated
    public void setValorUnitarioTributario(Double valorUnitarioTributario) {
        this.valorUnitarioTributario = valorUnitarioTributario;
    }

    @Generated
    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setValorTotalBruto(Double valorTotalBruto) {
        this.valorTotalBruto = valorTotalBruto;
    }

    @Generated
    public void setCompoeTotal(Short compoeTotal) {
        this.compoeTotal = compoeTotal;
    }

    @Generated
    public void setNumeroItem(Integer numeroItem) {
        this.numeroItem = numeroItem;
    }

    @Generated
    public void setIcms(NFCeItemICMS icms) {
        this.icms = icms;
    }

    @Generated
    public void setPis(NFCeItemPis pis) {
        this.pis = pis;
    }

    @Generated
    public void setCofins(NFCeItemCofins cofins) {
        this.cofins = cofins;
    }

    @Generated
    public void setIpi(NFCeItemIpi ipi) {
        this.ipi = ipi;
    }

    @Generated
    public void setInfAdicionalProd(String infAdicionalProd) {
        this.infAdicionalProd = infAdicionalProd;
    }

    @Generated
    public void setPercentualFrete(Double percentualFrete) {
        this.percentualFrete = percentualFrete;
    }

    @Generated
    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
    }

    @Generated
    public void setPercentualSeguro(Double percentualSeguro) {
        this.percentualSeguro = percentualSeguro;
    }

    @Generated
    public void setValorSeguro(Double valorSeguro) {
        this.valorSeguro = valorSeguro;
    }

    @Generated
    public void setPercentualDesconto(Double percentualDesconto) {
        this.percentualDesconto = percentualDesconto;
    }

    @Generated
    public void setPercentualDescontoPromocional(Double percentualDescontoPromocional) {
        this.percentualDescontoPromocional = percentualDescontoPromocional;
    }

    @Generated
    public void setValorDescontoPromocional(Double valorDescontoPromocional) {
        this.valorDescontoPromocional = valorDescontoPromocional;
    }

    @Generated
    public void setPercentualDespAcess(Double percentualDespAcess) {
        this.percentualDespAcess = percentualDespAcess;
    }

    @Generated
    public void setValorDespesasAcessorias(Double valorDespesasAcessorias) {
        this.valorDespesasAcessorias = valorDespesasAcessorias;
    }

    @Generated
    public void setPercValorFrete(Short percValorFrete) {
        this.percValorFrete = percValorFrete;
    }

    @Generated
    public void setPercentualFreteInf(Double percentualFreteInf) {
        this.percentualFreteInf = percentualFreteInf;
    }

    @Generated
    public void setValorFreteInf(Double valorFreteInf) {
        this.valorFreteInf = valorFreteInf;
    }

    @Generated
    public void setPercValorSeguro(Short percValorSeguro) {
        this.percValorSeguro = percValorSeguro;
    }

    @Generated
    public void setPercentualSeguroInf(Double percentualSeguroInf) {
        this.percentualSeguroInf = percentualSeguroInf;
    }

    @Generated
    public void setValorSeguroInf(Double valorSeguroInf) {
        this.valorSeguroInf = valorSeguroInf;
    }

    @Generated
    public void setPercValorDesconto(Short percValorDesconto) {
        this.percValorDesconto = percValorDesconto;
    }

    @Generated
    public void setPercentualDescontoInf(Double percentualDescontoInf) {
        this.percentualDescontoInf = percentualDescontoInf;
    }

    @Generated
    public void setValorDescontoInf(Double valorDescontoInf) {
        this.valorDescontoInf = valorDescontoInf;
    }

    @Generated
    public void setPercValorDespAcess(Short percValorDespAcess) {
        this.percValorDespAcess = percValorDespAcess;
    }

    @Generated
    public void setPercentualDespAcessInf(Double percentualDespAcessInf) {
        this.percentualDespAcessInf = percentualDespAcessInf;
    }

    @Generated
    public void setValorDespesasAcessoriasInf(Double valorDespesasAcessoriasInf) {
        this.valorDespesasAcessoriasInf = valorDespesasAcessoriasInf;
    }

    @Generated
    public void setPercentualFreteRat(Double percentualFreteRat) {
        this.percentualFreteRat = percentualFreteRat;
    }

    @Generated
    public void setValorFreteRat(Double valorFreteRat) {
        this.valorFreteRat = valorFreteRat;
    }

    @Generated
    public void setPercentualSeguroRat(Double percentualSeguroRat) {
        this.percentualSeguroRat = percentualSeguroRat;
    }

    @Generated
    public void setValorSeguroRat(Double valorSeguroRat) {
        this.valorSeguroRat = valorSeguroRat;
    }

    @Generated
    public void setPercentualDescontoRat(Double percentualDescontoRat) {
        this.percentualDescontoRat = percentualDescontoRat;
    }

    @Generated
    public void setValorDescontoRat(Double valorDescontoRat) {
        this.valorDescontoRat = valorDescontoRat;
    }

    @Generated
    public void setPercentualDespAcessRat(Double percentualDespAcessRat) {
        this.percentualDespAcessRat = percentualDespAcessRat;
    }

    @Generated
    public void setValorDespesasAcessoriasRat(Double valorDespesasAcessoriasRat) {
        this.valorDespesasAcessoriasRat = valorDespesasAcessoriasRat;
    }

    @Generated
    public void setNumeroPedidoCliente(String numeroPedidoCliente) {
        this.numeroPedidoCliente = numeroPedidoCliente;
    }

    @Generated
    public void setStatusOriginal(Short statusOriginal) {
        this.statusOriginal = statusOriginal;
    }

    @Generated
    public void setNumeroPedidoItemCliente(Integer numeroPedidoItemCliente) {
        this.numeroPedidoItemCliente = numeroPedidoItemCliente;
    }

    @Generated
    public void setValorTotalTributos(Double valorTotalTributos) {
        this.valorTotalTributos = valorTotalTributos;
    }

    @Generated
    public void setValorTributosPrevistosEst(Double valorTributosPrevistosEst) {
        this.valorTributosPrevistosEst = valorTributosPrevistosEst;
    }

    @Generated
    public void setValorTributosPrevistosFed(Double valorTributosPrevistosFed) {
        this.valorTributosPrevistosFed = valorTributosPrevistosFed;
    }

    @Generated
    public void setValorTributosPrevistosMun(Double valorTributosPrevistosMun) {
        this.valorTributosPrevistosMun = valorTributosPrevistosMun;
    }

    @Generated
    public void setModeloFiscal(ModeloFiscal modeloFiscal) {
        this.modeloFiscal = modeloFiscal;
    }

    @Generated
    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @Generated
    public void setCodigoBarrasTributavel(String codigoBarrasTributavel) {
        this.codigoBarrasTributavel = codigoBarrasTributavel;
    }

    @Generated
    public void setRepresentante(Representante representante) {
        this.representante = representante;
    }

    @Generated
    public void setPercTributosPrevistos(Double percTributosPrevistos) {
        this.percTributosPrevistos = percTributosPrevistos;
    }

    @Generated
    public void setPercTributosPrevistosEst(Double percTributosPrevistosEst) {
        this.percTributosPrevistosEst = percTributosPrevistosEst;
    }

    @Generated
    public void setPercTributosPrevistosFed(Double percTributosPrevistosFed) {
        this.percTributosPrevistosFed = percTributosPrevistosFed;
    }

    @Generated
    public void setPercTributosPrevistosMun(Double percTributosPrevistosMun) {
        this.percTributosPrevistosMun = percTributosPrevistosMun;
    }

    @Generated
    public void setUsuarioCancelamento(Usuario usuarioCancelamento) {
        this.usuarioCancelamento = usuarioCancelamento;
    }

    @Generated
    public void setPreAbastecimento(NFCePreAbastecimento preAbastecimento) {
        this.preAbastecimento = preAbastecimento;
    }

    @Generated
    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @Generated
    public void setValorPartida(Double valorPartida) {
        this.valorPartida = valorPartida;
    }

    @Generated
    public void setUnidadeMedidaTrib(UnidadeMedida unidadeMedidaTrib) {
        this.unidadeMedidaTrib = unidadeMedidaTrib;
    }

    @Generated
    public void setFatorConversao(Double fatorConversao) {
        this.fatorConversao = fatorConversao;
    }

    @Generated
    public void setTipoDesconto(Short tipoDesconto) {
        this.tipoDesconto = tipoDesconto;
    }

    @Generated
    public void setMovimentacaoFisica(Short movimentacaoFisica) {
        this.movimentacaoFisica = movimentacaoFisica;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setSerialForSinc(String serialForSinc) {
        this.serialForSinc = serialForSinc;
    }

    @Generated
    public void setCodigoBarrasPesavel(Short codigoBarrasPesavel) {
        this.codigoBarrasPesavel = codigoBarrasPesavel;
    }

    @Generated
    public void setNrLoteFabricacao(String nrLoteFabricacao) {
        this.nrLoteFabricacao = nrLoteFabricacao;
    }

    @Generated
    public void setDataFabricacao(Date dataFabricacao) {
        this.dataFabricacao = dataFabricacao;
    }

    @Generated
    public void setDataValidade(Date dataValidade) {
        this.dataValidade = dataValidade;
    }
}

