/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.model;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndIntermediador;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.touchnfce.model.CondicoesPagamento;
import com.touchcomp.touchnfce.model.DadosRecAgrPedido;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.EnderecoEntregaPedido;
import com.touchcomp.touchnfce.model.InfPagamentoPedido;
import com.touchcomp.touchnfce.model.IntermediadorComercial;
import com.touchcomp.touchnfce.model.ItemPedido;
import com.touchcomp.touchnfce.model.MeioPagamento;
import com.touchcomp.touchnfce.model.NFCeConsumidor;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.model.NaturezaOperacao;
import com.touchcomp.touchnfce.model.Pessoa;
import com.touchcomp.touchnfce.model.Representante;
import com.touchcomp.touchnfce.model.SituacaoPedidos;
import com.touchcomp.touchnfce.model.TipoFrete;
import com.touchcomp.touchnfce.model.Transportador;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.model.Usuario;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import lombok.Generated;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="PEDIDO")
public class Pedido
implements Serializable {
    @Id
    @Column(name="ID_PEDIDO", nullable=false)
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PEDIDO")
    private Long identificador;
    @Column(name="nr_pedido_cliente", nullable=true)
    private String nrPedidoCliente = "";
    @Column(name="observacao", length=5000)
    private String observacao = "";
    @Column(name="observacao_uso_interno", length=5000)
    private String observacaoUsoInterno = "";
    @Column(name="perc_frete", nullable=false, precision=15, scale=2)
    private Double percFrete = 0.0;
    @Column(name="valor_frete", nullable=false, precision=15, scale=2)
    private Double valorFrete = 0.0;
    @Column(name="perc_desconto", nullable=false, precision=15, scale=2)
    private Double percDesconto = 0.0;
    @Column(name="valor_desconto", nullable=false, precision=15, scale=2)
    private Double valorDesconto = 0.0;
    @Column(name="valor_total_bruto", nullable=false, precision=15, scale=2)
    private Double valorTotalBruto = 0.0;
    @Column(name="valor_total", nullable=false, precision=15, scale=2)
    private Double valorTotal = 0.0;
    @Column(name="valor_total_bruto_desc_trib", precision=15, scale=2)
    private Double valorTotalBrutoDescTrib = 0.0;
    @Column(name="valor_total_desc_trib", precision=15, scale=2)
    private Double valorTotalDescTrib = 0.0;
    @Column(name="perc_seguro", nullable=false, precision=15, scale=2)
    private Double percSeguro = 0.0;
    @Column(name="valor_seguro", nullable=false, precision=15, scale=2)
    private Double valorSeguro = 0.0;
    @Column(name="perc_desp_acessoria", nullable=false, precision=15, scale=2)
    private Double percDespAcessoria = 0.0;
    @Column(name="valor_desp_acessoria", nullable=false, precision=15, scale=2)
    private Double valorDespAcessoria = 0.0;
    @Column(name="cond_pag_mut", length=500)
    private String condPagMut;
    @Column(name="perc_desc_financeiro", nullable=false, precision=15, scale=6)
    private Double percDescFinanceiro = 0.0;
    @Column(name="perc_comissao", nullable=false, precision=15, scale=6)
    private Double percComissao = 0.0;
    @ManyToOne
    @JoinColumn(name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_PEDIDO_REPRESENTANTE"))
    private Representante representante;
    @ManyToOne
    @JoinColumn(name="ID_CONDICOES_PAGAMENTO", foreignKey=@ForeignKey(name="FK_PEDIDO_COND_PAGAMENTO"))
    private CondicoesPagamento condicoesPagamento;
    @ManyToOne
    @JoinColumn(name="id_tipo_frete", foreignKey=@ForeignKey(name="FK_PEDIDO_TIPO_FRETE"))
    private TipoFrete tipoFrete;
    @ManyToOne
    @JoinColumn(name="id_transportador", foreignKey=@ForeignKey(name="FK_PEDIDO_TRASNPORTADOR"))
    private Transportador transportador;
    @Temporal(value=TemporalType.DATE)
    @Column(name="data_previsao_saida", nullable=false)
    private Date dataPrevisaoSaida;
    @Temporal(value=TemporalType.DATE)
    @Column(name="data_previsao_fat", nullable=false)
    private Date dataPrevisaoFat;
    @ManyToOne
    @JoinColumn(name="id_natureza_operacao", foreignKey=@ForeignKey(name="FK_PEDIDO_NAT_OPERACAO"))
    private NaturezaOperacao naturezaOperacao;
    @ManyToOne
    @JoinColumn(name="id_unidade_fat_cliente", foreignKey=@ForeignKey(name="FK_PEDIDO_UNID_FAT_CLIENTE"))
    private UnidadeFatCliente unidadeFatCliente;
    @Temporal(value=TemporalType.DATE)
    @Column(name="data_emissao", nullable=false)
    private Date dataEmissao;
    @Temporal(value=TemporalType.DATE)
    @Column(name="data_cadastro", nullable=false)
    private Date dataCadastro;
    @ManyToOne
    @JoinColumn(name="id_empresa", foreignKey=@ForeignKey(name="FK_PEDIDO_EMPRESA"))
    private Empresa empresa;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="pedido", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Fetch(value=FetchMode.SUBSELECT)
    private List<ItemPedido> itemPedido = new ArrayList<ItemPedido>();
    @Column(name="tipo_desconto", nullable=false)
    private Short tipoDesconto = 1;
    @Column(name="observacao_sistema", length=5000)
    private String observacaoSistema = "";
    @Column(name="tipo_frete_inf", nullable=false)
    private Short tipoFreteInf = 1;
    @Column(name="tipo_seguro_inf", nullable=false)
    private Short tipoSeguroInf = 1;
    @Column(name="tipo_desp_acess_inf", nullable=false)
    private Short tipoDespAcessInf = 1;
    @Column(name="destacar_frete", nullable=false)
    private Short destacarFrete = 1;
    @Column(name="destacar_seguro", nullable=false)
    private Short destacarSeguro = 1;
    @Column(name="destacar_desconto", nullable=false)
    private Short destacarDesconto = 1;
    @Column(name="destacar_desp_acessoria", nullable=false)
    private Short destacarDespAcessoria = 1;
    @Column(name="informar_local_entrega", nullable=false)
    private Short informarLocalEntrega = 0;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="ID_ENDERECO_ENT_PEDIDO", foreignKey=@ForeignKey(name="FK_PEDIDO_END_ENTREGA"))
    private EnderecoEntregaPedido enderecoEntrega;
    @Column(name="prec_frete_inf", nullable=false, precision=15, scale=2)
    private Double percFreteInf = 0.0;
    @Column(name="valor_frete_inf", nullable=false, precision=15, scale=2)
    private Double valorFreteInf = 0.0;
    @Column(name="perc_desconto_inf", nullable=false, precision=15, scale=2)
    private Double percDescontoInf = 0.0;
    @Column(name="valor_desconto_inf", nullable=false, precision=15, scale=2)
    private Double valorDescontoInf = 0.0;
    @Column(name="perc_seguro_inf", nullable=false, precision=15, scale=2)
    private Double percSeguroInf = 0.0;
    @Column(name="valor_seguro_inf", nullable=false, precision=15, scale=2)
    private Double valorSeguroInf = 0.0;
    @Column(name="perc_desp_acessoria_inf", nullable=false, precision=15, scale=2)
    private Double percDespAcessoriaInf = 0.0;
    @Column(name="valor_desp_acessoria_inf", nullable=false, precision=15, scale=2)
    private Double valorDespAcessoriaInf = 0.0;
    @ManyToOne
    @JoinColumn(name="id_usuario", foreignKey=@ForeignKey(name="FK_PEDIDO_USUARIO"))
    private Usuario usuario;
    @Column(name="tipo_consumidor", nullable=false)
    private Short tipoConsumidor = 0;
    @Column(name="dias_medios_cond_pag", nullable=false)
    private Short diasMediosCondPag = 0;
    @OneToMany(mappedBy="pedido", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.SUBSELECT)
    private List<InfPagamentoPedido> infPagamentoPedido = new ArrayList<InfPagamentoPedido>();
    @Column(name="serial_for_sinc", nullable=false, length=500)
    private String serialForSync;
    @Column(name="nr_total_itens", nullable=false)
    private Integer nrTotalItens = 0;
    @Column(name="qtde_total_itens", nullable=false, precision=15, scale=6)
    private Double qtdeTotalItens = 0.0;
    @Column(name="vlr_total_custo", nullable=false, precision=15, scale=6)
    private Double vlrTotalCusto = 0.0;
    @Column(name="identificador_erp")
    private Long identificadorERP;
    @Version
    @Column(name="data_atualizacao")
    private Timestamp dataAtualizacao;
    @Column(name="status_sinc_erp")
    private Short statusSincERP = 0;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="id_nfce_consumidor", foreignKey=@ForeignKey(name="FK_PEDIDO_NFCE_CONSUMIDOR"))
    private NFCeConsumidor nfCeConsumidor;
    @ManyToOne
    @JoinColumn(name="id_situacao_pedido", foreignKey=@ForeignKey(name="FK_PEDIDO_SITUACAO_PED"))
    private SituacaoPedidos situacaoPedidos;
    @ManyToOne
    @JoinColumn(name="id_meio_pagamento", foreignKey=@ForeignKey(name="FK_PEDIDO_MEIO_PAGAMENTO"))
    private MeioPagamento meioPagamento;
    @ManyToOne
    @JoinColumn(name="id_pessoa_autorizada", foreignKey=@ForeignKey(name="FK_PEDIDO_PESSOA_AUTORIZADA"))
    private Pessoa pessoaAutorizada;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INDICANTE", foreignKey=@ForeignKey(name="FK_PEDIDO_INDICANTE"))
    private Pessoa indicante;
    @Column(name="TIPO_INTERMEDIADOR")
    private Short tipoIntermediador = EnumConstNFeIndIntermediador.NAO_SE_APLICA.getValue();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INTERMEDIADOR_COMERCIAL")
    private IntermediadorComercial intermediadorComercial;
    @Column(name="IND_PRESENCA_CONSUMIDOR")
    private Short indicadorPresencaConsumidor = EnumConstNFeIndicadorPresConsumidor.OPERACAO_PRESENCIAL.getValue();
    @ManyToOne
    @JoinColumn(name="id_controle_caixa", foreignKey=@ForeignKey(name="FK_PEDIDO_NFCE_CONTR_CAIXA"))
    private NFCeControleCaixa nfceControleCaixa;
    @OneToMany(mappedBy="pedido", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.SUBSELECT)
    private List<DadosRecAgrPedido> receitasAgronomicas;

    public Pedido() {
        this.dataCadastro = new Date();
        this.dataEmissao = new Date();
        this.dataPrevisaoSaida = new Date();
        this.receitasAgronomicas = new ArrayList<DadosRecAgrPedido>();
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public String getNrPedidoCliente() {
        return this.nrPedidoCliente;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getObservacaoUsoInterno() {
        return this.observacaoUsoInterno;
    }

    @Generated
    public Double getPercFrete() {
        return this.percFrete;
    }

    @Generated
    public Double getValorFrete() {
        return this.valorFrete;
    }

    @Generated
    public Double getPercDesconto() {
        return this.percDesconto;
    }

    @Generated
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    @Generated
    public Double getValorTotalBruto() {
        return this.valorTotalBruto;
    }

    @Generated
    public Double getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public Double getValorTotalBrutoDescTrib() {
        return this.valorTotalBrutoDescTrib;
    }

    @Generated
    public Double getValorTotalDescTrib() {
        return this.valorTotalDescTrib;
    }

    @Generated
    public Double getPercSeguro() {
        return this.percSeguro;
    }

    @Generated
    public Double getValorSeguro() {
        return this.valorSeguro;
    }

    @Generated
    public Double getPercDespAcessoria() {
        return this.percDespAcessoria;
    }

    @Generated
    public Double getValorDespAcessoria() {
        return this.valorDespAcessoria;
    }

    @Generated
    public String getCondPagMut() {
        return this.condPagMut;
    }

    @Generated
    public Double getPercDescFinanceiro() {
        return this.percDescFinanceiro;
    }

    @Generated
    public Double getPercComissao() {
        return this.percComissao;
    }

    @Generated
    public Representante getRepresentante() {
        return this.representante;
    }

    @Generated
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    @Generated
    public TipoFrete getTipoFrete() {
        return this.tipoFrete;
    }

    @Generated
    public Transportador getTransportador() {
        return this.transportador;
    }

    @Generated
    public Date getDataPrevisaoSaida() {
        return this.dataPrevisaoSaida;
    }

    @Generated
    public Date getDataPrevisaoFat() {
        return this.dataPrevisaoFat;
    }

    @Generated
    public NaturezaOperacao getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    @Generated
    public UnidadeFatCliente getUnidadeFatCliente() {
        return this.unidadeFatCliente;
    }

    @Generated
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public List<ItemPedido> getItemPedido() {
        return this.itemPedido;
    }

    @Generated
    public Short getTipoDesconto() {
        return this.tipoDesconto;
    }

    @Generated
    public String getObservacaoSistema() {
        return this.observacaoSistema;
    }

    @Generated
    public Short getTipoFreteInf() {
        return this.tipoFreteInf;
    }

    @Generated
    public Short getTipoSeguroInf() {
        return this.tipoSeguroInf;
    }

    @Generated
    public Short getTipoDespAcessInf() {
        return this.tipoDespAcessInf;
    }

    @Generated
    public Short getDestacarFrete() {
        return this.destacarFrete;
    }

    @Generated
    public Short getDestacarSeguro() {
        return this.destacarSeguro;
    }

    @Generated
    public Short getDestacarDesconto() {
        return this.destacarDesconto;
    }

    @Generated
    public Short getDestacarDespAcessoria() {
        return this.destacarDespAcessoria;
    }

    @Generated
    public Short getInformarLocalEntrega() {
        return this.informarLocalEntrega;
    }

    @Generated
    public EnderecoEntregaPedido getEnderecoEntrega() {
        return this.enderecoEntrega;
    }

    @Generated
    public Double getPercFreteInf() {
        return this.percFreteInf;
    }

    @Generated
    public Double getValorFreteInf() {
        return this.valorFreteInf;
    }

    @Generated
    public Double getPercDescontoInf() {
        return this.percDescontoInf;
    }

    @Generated
    public Double getValorDescontoInf() {
        return this.valorDescontoInf;
    }

    @Generated
    public Double getPercSeguroInf() {
        return this.percSeguroInf;
    }

    @Generated
    public Double getValorSeguroInf() {
        return this.valorSeguroInf;
    }

    @Generated
    public Double getPercDespAcessoriaInf() {
        return this.percDespAcessoriaInf;
    }

    @Generated
    public Double getValorDespAcessoriaInf() {
        return this.valorDespAcessoriaInf;
    }

    @Generated
    public Usuario getUsuario() {
        return this.usuario;
    }

    @Generated
    public Short getTipoConsumidor() {
        return this.tipoConsumidor;
    }

    @Generated
    public Short getDiasMediosCondPag() {
        return this.diasMediosCondPag;
    }

    @Generated
    public List<InfPagamentoPedido> getInfPagamentoPedido() {
        return this.infPagamentoPedido;
    }

    @Generated
    public String getSerialForSync() {
        return this.serialForSync;
    }

    @Generated
    public Integer getNrTotalItens() {
        return this.nrTotalItens;
    }

    @Generated
    public Double getQtdeTotalItens() {
        return this.qtdeTotalItens;
    }

    @Generated
    public Double getVlrTotalCusto() {
        return this.vlrTotalCusto;
    }

    @Generated
    public Long getIdentificadorERP() {
        return this.identificadorERP;
    }

    @Generated
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Short getStatusSincERP() {
        return this.statusSincERP;
    }

    @Generated
    public NFCeConsumidor getNfCeConsumidor() {
        return this.nfCeConsumidor;
    }

    @Generated
    public SituacaoPedidos getSituacaoPedidos() {
        return this.situacaoPedidos;
    }

    @Generated
    public MeioPagamento getMeioPagamento() {
        return this.meioPagamento;
    }

    @Generated
    public Pessoa getPessoaAutorizada() {
        return this.pessoaAutorizada;
    }

    @Generated
    public Pessoa getIndicante() {
        return this.indicante;
    }

    @Generated
    public Short getTipoIntermediador() {
        return this.tipoIntermediador;
    }

    @Generated
    public IntermediadorComercial getIntermediadorComercial() {
        return this.intermediadorComercial;
    }

    @Generated
    public Short getIndicadorPresencaConsumidor() {
        return this.indicadorPresencaConsumidor;
    }

    @Generated
    public NFCeControleCaixa getNfceControleCaixa() {
        return this.nfceControleCaixa;
    }

    @Generated
    public List<DadosRecAgrPedido> getReceitasAgronomicas() {
        return this.receitasAgronomicas;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setNrPedidoCliente(String nrPedidoCliente) {
        this.nrPedidoCliente = nrPedidoCliente;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setObservacaoUsoInterno(String observacaoUsoInterno) {
        this.observacaoUsoInterno = observacaoUsoInterno;
    }

    @Generated
    public void setPercFrete(Double percFrete) {
        this.percFrete = percFrete;
    }

    @Generated
    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
    }

    @Generated
    public void setPercDesconto(Double percDesconto) {
        this.percDesconto = percDesconto;
    }

    @Generated
    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Generated
    public void setValorTotalBruto(Double valorTotalBruto) {
        this.valorTotalBruto = valorTotalBruto;
    }

    @Generated
    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setValorTotalBrutoDescTrib(Double valorTotalBrutoDescTrib) {
        this.valorTotalBrutoDescTrib = valorTotalBrutoDescTrib;
    }

    @Generated
    public void setValorTotalDescTrib(Double valorTotalDescTrib) {
        this.valorTotalDescTrib = valorTotalDescTrib;
    }

    @Generated
    public void setPercSeguro(Double percSeguro) {
        this.percSeguro = percSeguro;
    }

    @Generated
    public void setValorSeguro(Double valorSeguro) {
        this.valorSeguro = valorSeguro;
    }

    @Generated
    public void setPercDespAcessoria(Double percDespAcessoria) {
        this.percDespAcessoria = percDespAcessoria;
    }

    @Generated
    public void setValorDespAcessoria(Double valorDespAcessoria) {
        this.valorDespAcessoria = valorDespAcessoria;
    }

    @Generated
    public void setCondPagMut(String condPagMut) {
        this.condPagMut = condPagMut;
    }

    @Generated
    public void setPercDescFinanceiro(Double percDescFinanceiro) {
        this.percDescFinanceiro = percDescFinanceiro;
    }

    @Generated
    public void setPercComissao(Double percComissao) {
        this.percComissao = percComissao;
    }

    @Generated
    public void setRepresentante(Representante representante) {
        this.representante = representante;
    }

    @Generated
    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    @Generated
    public void setTipoFrete(TipoFrete tipoFrete) {
        this.tipoFrete = tipoFrete;
    }

    @Generated
    public void setTransportador(Transportador transportador) {
        this.transportador = transportador;
    }

    @Generated
    public void setDataPrevisaoSaida(Date dataPrevisaoSaida) {
        this.dataPrevisaoSaida = dataPrevisaoSaida;
    }

    @Generated
    public void setDataPrevisaoFat(Date dataPrevisaoFat) {
        this.dataPrevisaoFat = dataPrevisaoFat;
    }

    @Generated
    public void setNaturezaOperacao(NaturezaOperacao naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    @Generated
    public void setUnidadeFatCliente(UnidadeFatCliente unidadeFatCliente) {
        this.unidadeFatCliente = unidadeFatCliente;
    }

    @Generated
    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Generated
    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setItemPedido(List<ItemPedido> itemPedido) {
        this.itemPedido = itemPedido;
    }

    @Generated
    public void setTipoDesconto(Short tipoDesconto) {
        this.tipoDesconto = tipoDesconto;
    }

    @Generated
    public void setObservacaoSistema(String observacaoSistema) {
        this.observacaoSistema = observacaoSistema;
    }

    @Generated
    public void setTipoFreteInf(Short tipoFreteInf) {
        this.tipoFreteInf = tipoFreteInf;
    }

    @Generated
    public void setTipoSeguroInf(Short tipoSeguroInf) {
        this.tipoSeguroInf = tipoSeguroInf;
    }

    @Generated
    public void setTipoDespAcessInf(Short tipoDespAcessInf) {
        this.tipoDespAcessInf = tipoDespAcessInf;
    }

    @Generated
    public void setDestacarFrete(Short destacarFrete) {
        this.destacarFrete = destacarFrete;
    }

    @Generated
    public void setDestacarSeguro(Short destacarSeguro) {
        this.destacarSeguro = destacarSeguro;
    }

    @Generated
    public void setDestacarDesconto(Short destacarDesconto) {
        this.destacarDesconto = destacarDesconto;
    }

    @Generated
    public void setDestacarDespAcessoria(Short destacarDespAcessoria) {
        this.destacarDespAcessoria = destacarDespAcessoria;
    }

    @Generated
    public void setInformarLocalEntrega(Short informarLocalEntrega) {
        this.informarLocalEntrega = informarLocalEntrega;
    }

    @Generated
    public void setEnderecoEntrega(EnderecoEntregaPedido enderecoEntrega) {
        this.enderecoEntrega = enderecoEntrega;
    }

    @Generated
    public void setPercFreteInf(Double percFreteInf) {
        this.percFreteInf = percFreteInf;
    }

    @Generated
    public void setValorFreteInf(Double valorFreteInf) {
        this.valorFreteInf = valorFreteInf;
    }

    @Generated
    public void setPercDescontoInf(Double percDescontoInf) {
        this.percDescontoInf = percDescontoInf;
    }

    @Generated
    public void setValorDescontoInf(Double valorDescontoInf) {
        this.valorDescontoInf = valorDescontoInf;
    }

    @Generated
    public void setPercSeguroInf(Double percSeguroInf) {
        this.percSeguroInf = percSeguroInf;
    }

    @Generated
    public void setValorSeguroInf(Double valorSeguroInf) {
        this.valorSeguroInf = valorSeguroInf;
    }

    @Generated
    public void setPercDespAcessoriaInf(Double percDespAcessoriaInf) {
        this.percDespAcessoriaInf = percDespAcessoriaInf;
    }

    @Generated
    public void setValorDespAcessoriaInf(Double valorDespAcessoriaInf) {
        this.valorDespAcessoriaInf = valorDespAcessoriaInf;
    }

    @Generated
    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setTipoConsumidor(Short tipoConsumidor) {
        this.tipoConsumidor = tipoConsumidor;
    }

    @Generated
    public void setDiasMediosCondPag(Short diasMediosCondPag) {
        this.diasMediosCondPag = diasMediosCondPag;
    }

    @Generated
    public void setInfPagamentoPedido(List<InfPagamentoPedido> infPagamentoPedido) {
        this.infPagamentoPedido = infPagamentoPedido;
    }

    @Generated
    public void setSerialForSync(String serialForSync) {
        this.serialForSync = serialForSync;
    }

    @Generated
    public void setNrTotalItens(Integer nrTotalItens) {
        this.nrTotalItens = nrTotalItens;
    }

    @Generated
    public void setQtdeTotalItens(Double qtdeTotalItens) {
        this.qtdeTotalItens = qtdeTotalItens;
    }

    @Generated
    public void setVlrTotalCusto(Double vlrTotalCusto) {
        this.vlrTotalCusto = vlrTotalCusto;
    }

    @Generated
    public void setIdentificadorERP(Long identificadorERP) {
        this.identificadorERP = identificadorERP;
    }

    @Generated
    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setStatusSincERP(Short statusSincERP) {
        this.statusSincERP = statusSincERP;
    }

    @Generated
    public void setNfCeConsumidor(NFCeConsumidor nfCeConsumidor) {
        this.nfCeConsumidor = nfCeConsumidor;
    }

    @Generated
    public void setSituacaoPedidos(SituacaoPedidos situacaoPedidos) {
        this.situacaoPedidos = situacaoPedidos;
    }

    @Generated
    public void setMeioPagamento(MeioPagamento meioPagamento) {
        this.meioPagamento = meioPagamento;
    }

    @Generated
    public void setPessoaAutorizada(Pessoa pessoaAutorizada) {
        this.pessoaAutorizada = pessoaAutorizada;
    }

    @Generated
    public void setIndicante(Pessoa indicante) {
        this.indicante = indicante;
    }

    @Generated
    public void setTipoIntermediador(Short tipoIntermediador) {
        this.tipoIntermediador = tipoIntermediador;
    }

    @Generated
    public void setIntermediadorComercial(IntermediadorComercial intermediadorComercial) {
        this.intermediadorComercial = intermediadorComercial;
    }

    @Generated
    public void setIndicadorPresencaConsumidor(Short indicadorPresencaConsumidor) {
        this.indicadorPresencaConsumidor = indicadorPresencaConsumidor;
    }

    @Generated
    public void setNfceControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        this.nfceControleCaixa = nfceControleCaixa;
    }

    @Generated
    public void setReceitasAgronomicas(List<DadosRecAgrPedido> receitasAgronomicas) {
        this.receitasAgronomicas = receitasAgronomicas;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pedido)) {
            return false;
        }
        Pedido other = (Pedido)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$identificador = this.getIdentificador();
        Long other$identificador = other.getIdentificador();
        if (this$identificador == null ? other$identificador != null : !((Object)this$identificador).equals(other$identificador)) {
            return false;
        }
        Double this$percFrete = this.getPercFrete();
        Double other$percFrete = other.getPercFrete();
        if (this$percFrete == null ? other$percFrete != null : !((Object)this$percFrete).equals(other$percFrete)) {
            return false;
        }
        Double this$valorFrete = this.getValorFrete();
        Double other$valorFrete = other.getValorFrete();
        if (this$valorFrete == null ? other$valorFrete != null : !((Object)this$valorFrete).equals(other$valorFrete)) {
            return false;
        }
        Double this$percDesconto = this.getPercDesconto();
        Double other$percDesconto = other.getPercDesconto();
        if (this$percDesconto == null ? other$percDesconto != null : !((Object)this$percDesconto).equals(other$percDesconto)) {
            return false;
        }
        Double this$valorDesconto = this.getValorDesconto();
        Double other$valorDesconto = other.getValorDesconto();
        if (this$valorDesconto == null ? other$valorDesconto != null : !((Object)this$valorDesconto).equals(other$valorDesconto)) {
            return false;
        }
        Double this$valorTotalBruto = this.getValorTotalBruto();
        Double other$valorTotalBruto = other.getValorTotalBruto();
        if (this$valorTotalBruto == null ? other$valorTotalBruto != null : !((Object)this$valorTotalBruto).equals(other$valorTotalBruto)) {
            return false;
        }
        Double this$valorTotal = this.getValorTotal();
        Double other$valorTotal = other.getValorTotal();
        if (this$valorTotal == null ? other$valorTotal != null : !((Object)this$valorTotal).equals(other$valorTotal)) {
            return false;
        }
        Double this$valorTotalBrutoDescTrib = this.getValorTotalBrutoDescTrib();
        Double other$valorTotalBrutoDescTrib = other.getValorTotalBrutoDescTrib();
        if (this$valorTotalBrutoDescTrib == null ? other$valorTotalBrutoDescTrib != null : !((Object)this$valorTotalBrutoDescTrib).equals(other$valorTotalBrutoDescTrib)) {
            return false;
        }
        Double this$valorTotalDescTrib = this.getValorTotalDescTrib();
        Double other$valorTotalDescTrib = other.getValorTotalDescTrib();
        if (this$valorTotalDescTrib == null ? other$valorTotalDescTrib != null : !((Object)this$valorTotalDescTrib).equals(other$valorTotalDescTrib)) {
            return false;
        }
        Double this$percSeguro = this.getPercSeguro();
        Double other$percSeguro = other.getPercSeguro();
        if (this$percSeguro == null ? other$percSeguro != null : !((Object)this$percSeguro).equals(other$percSeguro)) {
            return false;
        }
        Double this$valorSeguro = this.getValorSeguro();
        Double other$valorSeguro = other.getValorSeguro();
        if (this$valorSeguro == null ? other$valorSeguro != null : !((Object)this$valorSeguro).equals(other$valorSeguro)) {
            return false;
        }
        Double this$percDespAcessoria = this.getPercDespAcessoria();
        Double other$percDespAcessoria = other.getPercDespAcessoria();
        if (this$percDespAcessoria == null ? other$percDespAcessoria != null : !((Object)this$percDespAcessoria).equals(other$percDespAcessoria)) {
            return false;
        }
        Double this$valorDespAcessoria = this.getValorDespAcessoria();
        Double other$valorDespAcessoria = other.getValorDespAcessoria();
        if (this$valorDespAcessoria == null ? other$valorDespAcessoria != null : !((Object)this$valorDespAcessoria).equals(other$valorDespAcessoria)) {
            return false;
        }
        Double this$percDescFinanceiro = this.getPercDescFinanceiro();
        Double other$percDescFinanceiro = other.getPercDescFinanceiro();
        if (this$percDescFinanceiro == null ? other$percDescFinanceiro != null : !((Object)this$percDescFinanceiro).equals(other$percDescFinanceiro)) {
            return false;
        }
        Double this$percComissao = this.getPercComissao();
        Double other$percComissao = other.getPercComissao();
        if (this$percComissao == null ? other$percComissao != null : !((Object)this$percComissao).equals(other$percComissao)) {
            return false;
        }
        Short this$tipoDesconto = this.getTipoDesconto();
        Short other$tipoDesconto = other.getTipoDesconto();
        if (this$tipoDesconto == null ? other$tipoDesconto != null : !((Object)this$tipoDesconto).equals(other$tipoDesconto)) {
            return false;
        }
        Short this$tipoFreteInf = this.getTipoFreteInf();
        Short other$tipoFreteInf = other.getTipoFreteInf();
        if (this$tipoFreteInf == null ? other$tipoFreteInf != null : !((Object)this$tipoFreteInf).equals(other$tipoFreteInf)) {
            return false;
        }
        Short this$tipoSeguroInf = this.getTipoSeguroInf();
        Short other$tipoSeguroInf = other.getTipoSeguroInf();
        if (this$tipoSeguroInf == null ? other$tipoSeguroInf != null : !((Object)this$tipoSeguroInf).equals(other$tipoSeguroInf)) {
            return false;
        }
        Short this$tipoDespAcessInf = this.getTipoDespAcessInf();
        Short other$tipoDespAcessInf = other.getTipoDespAcessInf();
        if (this$tipoDespAcessInf == null ? other$tipoDespAcessInf != null : !((Object)this$tipoDespAcessInf).equals(other$tipoDespAcessInf)) {
            return false;
        }
        Short this$destacarFrete = this.getDestacarFrete();
        Short other$destacarFrete = other.getDestacarFrete();
        if (this$destacarFrete == null ? other$destacarFrete != null : !((Object)this$destacarFrete).equals(other$destacarFrete)) {
            return false;
        }
        Short this$destacarSeguro = this.getDestacarSeguro();
        Short other$destacarSeguro = other.getDestacarSeguro();
        if (this$destacarSeguro == null ? other$destacarSeguro != null : !((Object)this$destacarSeguro).equals(other$destacarSeguro)) {
            return false;
        }
        Short this$destacarDesconto = this.getDestacarDesconto();
        Short other$destacarDesconto = other.getDestacarDesconto();
        if (this$destacarDesconto == null ? other$destacarDesconto != null : !((Object)this$destacarDesconto).equals(other$destacarDesconto)) {
            return false;
        }
        Short this$destacarDespAcessoria = this.getDestacarDespAcessoria();
        Short other$destacarDespAcessoria = other.getDestacarDespAcessoria();
        if (this$destacarDespAcessoria == null ? other$destacarDespAcessoria != null : !((Object)this$destacarDespAcessoria).equals(other$destacarDespAcessoria)) {
            return false;
        }
        Short this$informarLocalEntrega = this.getInformarLocalEntrega();
        Short other$informarLocalEntrega = other.getInformarLocalEntrega();
        if (this$informarLocalEntrega == null ? other$informarLocalEntrega != null : !((Object)this$informarLocalEntrega).equals(other$informarLocalEntrega)) {
            return false;
        }
        Double this$percFreteInf = this.getPercFreteInf();
        Double other$percFreteInf = other.getPercFreteInf();
        if (this$percFreteInf == null ? other$percFreteInf != null : !((Object)this$percFreteInf).equals(other$percFreteInf)) {
            return false;
        }
        Double this$valorFreteInf = this.getValorFreteInf();
        Double other$valorFreteInf = other.getValorFreteInf();
        if (this$valorFreteInf == null ? other$valorFreteInf != null : !((Object)this$valorFreteInf).equals(other$valorFreteInf)) {
            return false;
        }
        Double this$percDescontoInf = this.getPercDescontoInf();
        Double other$percDescontoInf = other.getPercDescontoInf();
        if (this$percDescontoInf == null ? other$percDescontoInf != null : !((Object)this$percDescontoInf).equals(other$percDescontoInf)) {
            return false;
        }
        Double this$valorDescontoInf = this.getValorDescontoInf();
        Double other$valorDescontoInf = other.getValorDescontoInf();
        if (this$valorDescontoInf == null ? other$valorDescontoInf != null : !((Object)this$valorDescontoInf).equals(other$valorDescontoInf)) {
            return false;
        }
        Double this$percSeguroInf = this.getPercSeguroInf();
        Double other$percSeguroInf = other.getPercSeguroInf();
        if (this$percSeguroInf == null ? other$percSeguroInf != null : !((Object)this$percSeguroInf).equals(other$percSeguroInf)) {
            return false;
        }
        Double this$valorSeguroInf = this.getValorSeguroInf();
        Double other$valorSeguroInf = other.getValorSeguroInf();
        if (this$valorSeguroInf == null ? other$valorSeguroInf != null : !((Object)this$valorSeguroInf).equals(other$valorSeguroInf)) {
            return false;
        }
        Double this$percDespAcessoriaInf = this.getPercDespAcessoriaInf();
        Double other$percDespAcessoriaInf = other.getPercDespAcessoriaInf();
        if (this$percDespAcessoriaInf == null ? other$percDespAcessoriaInf != null : !((Object)this$percDespAcessoriaInf).equals(other$percDespAcessoriaInf)) {
            return false;
        }
        Double this$valorDespAcessoriaInf = this.getValorDespAcessoriaInf();
        Double other$valorDespAcessoriaInf = other.getValorDespAcessoriaInf();
        if (this$valorDespAcessoriaInf == null ? other$valorDespAcessoriaInf != null : !((Object)this$valorDespAcessoriaInf).equals(other$valorDespAcessoriaInf)) {
            return false;
        }
        Short this$tipoConsumidor = this.getTipoConsumidor();
        Short other$tipoConsumidor = other.getTipoConsumidor();
        if (this$tipoConsumidor == null ? other$tipoConsumidor != null : !((Object)this$tipoConsumidor).equals(other$tipoConsumidor)) {
            return false;
        }
        Short this$diasMediosCondPag = this.getDiasMediosCondPag();
        Short other$diasMediosCondPag = other.getDiasMediosCondPag();
        if (this$diasMediosCondPag == null ? other$diasMediosCondPag != null : !((Object)this$diasMediosCondPag).equals(other$diasMediosCondPag)) {
            return false;
        }
        Integer this$nrTotalItens = this.getNrTotalItens();
        Integer other$nrTotalItens = other.getNrTotalItens();
        if (this$nrTotalItens == null ? other$nrTotalItens != null : !((Object)this$nrTotalItens).equals(other$nrTotalItens)) {
            return false;
        }
        Double this$qtdeTotalItens = this.getQtdeTotalItens();
        Double other$qtdeTotalItens = other.getQtdeTotalItens();
        if (this$qtdeTotalItens == null ? other$qtdeTotalItens != null : !((Object)this$qtdeTotalItens).equals(other$qtdeTotalItens)) {
            return false;
        }
        Double this$vlrTotalCusto = this.getVlrTotalCusto();
        Double other$vlrTotalCusto = other.getVlrTotalCusto();
        if (this$vlrTotalCusto == null ? other$vlrTotalCusto != null : !((Object)this$vlrTotalCusto).equals(other$vlrTotalCusto)) {
            return false;
        }
        Long this$identificadorERP = this.getIdentificadorERP();
        Long other$identificadorERP = other.getIdentificadorERP();
        if (this$identificadorERP == null ? other$identificadorERP != null : !((Object)this$identificadorERP).equals(other$identificadorERP)) {
            return false;
        }
        Short this$statusSincERP = this.getStatusSincERP();
        Short other$statusSincERP = other.getStatusSincERP();
        if (this$statusSincERP == null ? other$statusSincERP != null : !((Object)this$statusSincERP).equals(other$statusSincERP)) {
            return false;
        }
        Short this$tipoIntermediador = this.getTipoIntermediador();
        Short other$tipoIntermediador = other.getTipoIntermediador();
        if (this$tipoIntermediador == null ? other$tipoIntermediador != null : !((Object)this$tipoIntermediador).equals(other$tipoIntermediador)) {
            return false;
        }
        Short this$indicadorPresencaConsumidor = this.getIndicadorPresencaConsumidor();
        Short other$indicadorPresencaConsumidor = other.getIndicadorPresencaConsumidor();
        if (this$indicadorPresencaConsumidor == null ? other$indicadorPresencaConsumidor != null : !((Object)this$indicadorPresencaConsumidor).equals(other$indicadorPresencaConsumidor)) {
            return false;
        }
        String this$nrPedidoCliente = this.getNrPedidoCliente();
        String other$nrPedidoCliente = other.getNrPedidoCliente();
        if (this$nrPedidoCliente == null ? other$nrPedidoCliente != null : !this$nrPedidoCliente.equals(other$nrPedidoCliente)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        String this$observacaoUsoInterno = this.getObservacaoUsoInterno();
        String other$observacaoUsoInterno = other.getObservacaoUsoInterno();
        if (this$observacaoUsoInterno == null ? other$observacaoUsoInterno != null : !this$observacaoUsoInterno.equals(other$observacaoUsoInterno)) {
            return false;
        }
        String this$condPagMut = this.getCondPagMut();
        String other$condPagMut = other.getCondPagMut();
        if (this$condPagMut == null ? other$condPagMut != null : !this$condPagMut.equals(other$condPagMut)) {
            return false;
        }
        Representante this$representante = this.getRepresentante();
        Representante other$representante = other.getRepresentante();
        if (this$representante == null ? other$representante != null : !((Object)this$representante).equals(other$representante)) {
            return false;
        }
        CondicoesPagamento this$condicoesPagamento = this.getCondicoesPagamento();
        CondicoesPagamento other$condicoesPagamento = other.getCondicoesPagamento();
        if (this$condicoesPagamento == null ? other$condicoesPagamento != null : !((Object)this$condicoesPagamento).equals(other$condicoesPagamento)) {
            return false;
        }
        TipoFrete this$tipoFrete = this.getTipoFrete();
        TipoFrete other$tipoFrete = other.getTipoFrete();
        if (this$tipoFrete == null ? other$tipoFrete != null : !((Object)this$tipoFrete).equals(other$tipoFrete)) {
            return false;
        }
        Transportador this$transportador = this.getTransportador();
        Transportador other$transportador = other.getTransportador();
        if (this$transportador == null ? other$transportador != null : !((Object)this$transportador).equals(other$transportador)) {
            return false;
        }
        Date this$dataPrevisaoSaida = this.getDataPrevisaoSaida();
        Date other$dataPrevisaoSaida = other.getDataPrevisaoSaida();
        if (this$dataPrevisaoSaida == null ? other$dataPrevisaoSaida != null : !((Object)this$dataPrevisaoSaida).equals(other$dataPrevisaoSaida)) {
            return false;
        }
        Date this$dataPrevisaoFat = this.getDataPrevisaoFat();
        Date other$dataPrevisaoFat = other.getDataPrevisaoFat();
        if (this$dataPrevisaoFat == null ? other$dataPrevisaoFat != null : !((Object)this$dataPrevisaoFat).equals(other$dataPrevisaoFat)) {
            return false;
        }
        NaturezaOperacao this$naturezaOperacao = this.getNaturezaOperacao();
        NaturezaOperacao other$naturezaOperacao = other.getNaturezaOperacao();
        if (this$naturezaOperacao == null ? other$naturezaOperacao != null : !((Object)this$naturezaOperacao).equals(other$naturezaOperacao)) {
            return false;
        }
        UnidadeFatCliente this$unidadeFatCliente = this.getUnidadeFatCliente();
        UnidadeFatCliente other$unidadeFatCliente = other.getUnidadeFatCliente();
        if (this$unidadeFatCliente == null ? other$unidadeFatCliente != null : !((Object)this$unidadeFatCliente).equals(other$unidadeFatCliente)) {
            return false;
        }
        Date this$dataEmissao = this.getDataEmissao();
        Date other$dataEmissao = other.getDataEmissao();
        if (this$dataEmissao == null ? other$dataEmissao != null : !((Object)this$dataEmissao).equals(other$dataEmissao)) {
            return false;
        }
        Date this$dataCadastro = this.getDataCadastro();
        Date other$dataCadastro = other.getDataCadastro();
        if (this$dataCadastro == null ? other$dataCadastro != null : !((Object)this$dataCadastro).equals(other$dataCadastro)) {
            return false;
        }
        Empresa this$empresa = this.getEmpresa();
        Empresa other$empresa = other.getEmpresa();
        if (this$empresa == null ? other$empresa != null : !((Object)this$empresa).equals(other$empresa)) {
            return false;
        }
        List<ItemPedido> this$itemPedido = this.getItemPedido();
        List<ItemPedido> other$itemPedido = other.getItemPedido();
        if (this$itemPedido == null ? other$itemPedido != null : !((Object)this$itemPedido).equals(other$itemPedido)) {
            return false;
        }
        String this$observacaoSistema = this.getObservacaoSistema();
        String other$observacaoSistema = other.getObservacaoSistema();
        if (this$observacaoSistema == null ? other$observacaoSistema != null : !this$observacaoSistema.equals(other$observacaoSistema)) {
            return false;
        }
        EnderecoEntregaPedido this$enderecoEntrega = this.getEnderecoEntrega();
        EnderecoEntregaPedido other$enderecoEntrega = other.getEnderecoEntrega();
        if (this$enderecoEntrega == null ? other$enderecoEntrega != null : !((Object)this$enderecoEntrega).equals(other$enderecoEntrega)) {
            return false;
        }
        Usuario this$usuario = this.getUsuario();
        Usuario other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !((Object)this$usuario).equals(other$usuario)) {
            return false;
        }
        List<InfPagamentoPedido> this$infPagamentoPedido = this.getInfPagamentoPedido();
        List<InfPagamentoPedido> other$infPagamentoPedido = other.getInfPagamentoPedido();
        if (this$infPagamentoPedido == null ? other$infPagamentoPedido != null : !((Object)this$infPagamentoPedido).equals(other$infPagamentoPedido)) {
            return false;
        }
        String this$serialForSync = this.getSerialForSync();
        String other$serialForSync = other.getSerialForSync();
        if (this$serialForSync == null ? other$serialForSync != null : !this$serialForSync.equals(other$serialForSync)) {
            return false;
        }
        Timestamp this$dataAtualizacao = this.getDataAtualizacao();
        Timestamp other$dataAtualizacao = other.getDataAtualizacao();
        if (this$dataAtualizacao == null ? other$dataAtualizacao != null : !((Object)this$dataAtualizacao).equals(other$dataAtualizacao)) {
            return false;
        }
        NFCeConsumidor this$nfCeConsumidor = this.getNfCeConsumidor();
        NFCeConsumidor other$nfCeConsumidor = other.getNfCeConsumidor();
        if (this$nfCeConsumidor == null ? other$nfCeConsumidor != null : !((Object)this$nfCeConsumidor).equals(other$nfCeConsumidor)) {
            return false;
        }
        SituacaoPedidos this$situacaoPedidos = this.getSituacaoPedidos();
        SituacaoPedidos other$situacaoPedidos = other.getSituacaoPedidos();
        if (this$situacaoPedidos == null ? other$situacaoPedidos != null : !((Object)this$situacaoPedidos).equals(other$situacaoPedidos)) {
            return false;
        }
        MeioPagamento this$meioPagamento = this.getMeioPagamento();
        MeioPagamento other$meioPagamento = other.getMeioPagamento();
        if (this$meioPagamento == null ? other$meioPagamento != null : !((Object)this$meioPagamento).equals(other$meioPagamento)) {
            return false;
        }
        Pessoa this$pessoaAutorizada = this.getPessoaAutorizada();
        Pessoa other$pessoaAutorizada = other.getPessoaAutorizada();
        if (this$pessoaAutorizada == null ? other$pessoaAutorizada != null : !((Object)this$pessoaAutorizada).equals(other$pessoaAutorizada)) {
            return false;
        }
        Pessoa this$indicante = this.getIndicante();
        Pessoa other$indicante = other.getIndicante();
        if (this$indicante == null ? other$indicante != null : !((Object)this$indicante).equals(other$indicante)) {
            return false;
        }
        IntermediadorComercial this$intermediadorComercial = this.getIntermediadorComercial();
        IntermediadorComercial other$intermediadorComercial = other.getIntermediadorComercial();
        if (this$intermediadorComercial == null ? other$intermediadorComercial != null : !((Object)this$intermediadorComercial).equals(other$intermediadorComercial)) {
            return false;
        }
        NFCeControleCaixa this$nfceControleCaixa = this.getNfceControleCaixa();
        NFCeControleCaixa other$nfceControleCaixa = other.getNfceControleCaixa();
        if (this$nfceControleCaixa == null ? other$nfceControleCaixa != null : !((Object)this$nfceControleCaixa).equals(other$nfceControleCaixa)) {
            return false;
        }
        List<DadosRecAgrPedido> this$receitasAgronomicas = this.getReceitasAgronomicas();
        List<DadosRecAgrPedido> other$receitasAgronomicas = other.getReceitasAgronomicas();
        return !(this$receitasAgronomicas == null ? other$receitasAgronomicas != null : !((Object)this$receitasAgronomicas).equals(other$receitasAgronomicas));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Pedido;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $identificador = this.getIdentificador();
        result = result * 59 + ($identificador == null ? 43 : ((Object)$identificador).hashCode());
        Double $percFrete = this.getPercFrete();
        result = result * 59 + ($percFrete == null ? 43 : ((Object)$percFrete).hashCode());
        Double $valorFrete = this.getValorFrete();
        result = result * 59 + ($valorFrete == null ? 43 : ((Object)$valorFrete).hashCode());
        Double $percDesconto = this.getPercDesconto();
        result = result * 59 + ($percDesconto == null ? 43 : ((Object)$percDesconto).hashCode());
        Double $valorDesconto = this.getValorDesconto();
        result = result * 59 + ($valorDesconto == null ? 43 : ((Object)$valorDesconto).hashCode());
        Double $valorTotalBruto = this.getValorTotalBruto();
        result = result * 59 + ($valorTotalBruto == null ? 43 : ((Object)$valorTotalBruto).hashCode());
        Double $valorTotal = this.getValorTotal();
        result = result * 59 + ($valorTotal == null ? 43 : ((Object)$valorTotal).hashCode());
        Double $valorTotalBrutoDescTrib = this.getValorTotalBrutoDescTrib();
        result = result * 59 + ($valorTotalBrutoDescTrib == null ? 43 : ((Object)$valorTotalBrutoDescTrib).hashCode());
        Double $valorTotalDescTrib = this.getValorTotalDescTrib();
        result = result * 59 + ($valorTotalDescTrib == null ? 43 : ((Object)$valorTotalDescTrib).hashCode());
        Double $percSeguro = this.getPercSeguro();
        result = result * 59 + ($percSeguro == null ? 43 : ((Object)$percSeguro).hashCode());
        Double $valorSeguro = this.getValorSeguro();
        result = result * 59 + ($valorSeguro == null ? 43 : ((Object)$valorSeguro).hashCode());
        Double $percDespAcessoria = this.getPercDespAcessoria();
        result = result * 59 + ($percDespAcessoria == null ? 43 : ((Object)$percDespAcessoria).hashCode());
        Double $valorDespAcessoria = this.getValorDespAcessoria();
        result = result * 59 + ($valorDespAcessoria == null ? 43 : ((Object)$valorDespAcessoria).hashCode());
        Double $percDescFinanceiro = this.getPercDescFinanceiro();
        result = result * 59 + ($percDescFinanceiro == null ? 43 : ((Object)$percDescFinanceiro).hashCode());
        Double $percComissao = this.getPercComissao();
        result = result * 59 + ($percComissao == null ? 43 : ((Object)$percComissao).hashCode());
        Short $tipoDesconto = this.getTipoDesconto();
        result = result * 59 + ($tipoDesconto == null ? 43 : ((Object)$tipoDesconto).hashCode());
        Short $tipoFreteInf = this.getTipoFreteInf();
        result = result * 59 + ($tipoFreteInf == null ? 43 : ((Object)$tipoFreteInf).hashCode());
        Short $tipoSeguroInf = this.getTipoSeguroInf();
        result = result * 59 + ($tipoSeguroInf == null ? 43 : ((Object)$tipoSeguroInf).hashCode());
        Short $tipoDespAcessInf = this.getTipoDespAcessInf();
        result = result * 59 + ($tipoDespAcessInf == null ? 43 : ((Object)$tipoDespAcessInf).hashCode());
        Short $destacarFrete = this.getDestacarFrete();
        result = result * 59 + ($destacarFrete == null ? 43 : ((Object)$destacarFrete).hashCode());
        Short $destacarSeguro = this.getDestacarSeguro();
        result = result * 59 + ($destacarSeguro == null ? 43 : ((Object)$destacarSeguro).hashCode());
        Short $destacarDesconto = this.getDestacarDesconto();
        result = result * 59 + ($destacarDesconto == null ? 43 : ((Object)$destacarDesconto).hashCode());
        Short $destacarDespAcessoria = this.getDestacarDespAcessoria();
        result = result * 59 + ($destacarDespAcessoria == null ? 43 : ((Object)$destacarDespAcessoria).hashCode());
        Short $informarLocalEntrega = this.getInformarLocalEntrega();
        result = result * 59 + ($informarLocalEntrega == null ? 43 : ((Object)$informarLocalEntrega).hashCode());
        Double $percFreteInf = this.getPercFreteInf();
        result = result * 59 + ($percFreteInf == null ? 43 : ((Object)$percFreteInf).hashCode());
        Double $valorFreteInf = this.getValorFreteInf();
        result = result * 59 + ($valorFreteInf == null ? 43 : ((Object)$valorFreteInf).hashCode());
        Double $percDescontoInf = this.getPercDescontoInf();
        result = result * 59 + ($percDescontoInf == null ? 43 : ((Object)$percDescontoInf).hashCode());
        Double $valorDescontoInf = this.getValorDescontoInf();
        result = result * 59 + ($valorDescontoInf == null ? 43 : ((Object)$valorDescontoInf).hashCode());
        Double $percSeguroInf = this.getPercSeguroInf();
        result = result * 59 + ($percSeguroInf == null ? 43 : ((Object)$percSeguroInf).hashCode());
        Double $valorSeguroInf = this.getValorSeguroInf();
        result = result * 59 + ($valorSeguroInf == null ? 43 : ((Object)$valorSeguroInf).hashCode());
        Double $percDespAcessoriaInf = this.getPercDespAcessoriaInf();
        result = result * 59 + ($percDespAcessoriaInf == null ? 43 : ((Object)$percDespAcessoriaInf).hashCode());
        Double $valorDespAcessoriaInf = this.getValorDespAcessoriaInf();
        result = result * 59 + ($valorDespAcessoriaInf == null ? 43 : ((Object)$valorDespAcessoriaInf).hashCode());
        Short $tipoConsumidor = this.getTipoConsumidor();
        result = result * 59 + ($tipoConsumidor == null ? 43 : ((Object)$tipoConsumidor).hashCode());
        Short $diasMediosCondPag = this.getDiasMediosCondPag();
        result = result * 59 + ($diasMediosCondPag == null ? 43 : ((Object)$diasMediosCondPag).hashCode());
        Integer $nrTotalItens = this.getNrTotalItens();
        result = result * 59 + ($nrTotalItens == null ? 43 : ((Object)$nrTotalItens).hashCode());
        Double $qtdeTotalItens = this.getQtdeTotalItens();
        result = result * 59 + ($qtdeTotalItens == null ? 43 : ((Object)$qtdeTotalItens).hashCode());
        Double $vlrTotalCusto = this.getVlrTotalCusto();
        result = result * 59 + ($vlrTotalCusto == null ? 43 : ((Object)$vlrTotalCusto).hashCode());
        Long $identificadorERP = this.getIdentificadorERP();
        result = result * 59 + ($identificadorERP == null ? 43 : ((Object)$identificadorERP).hashCode());
        Short $statusSincERP = this.getStatusSincERP();
        result = result * 59 + ($statusSincERP == null ? 43 : ((Object)$statusSincERP).hashCode());
        Short $tipoIntermediador = this.getTipoIntermediador();
        result = result * 59 + ($tipoIntermediador == null ? 43 : ((Object)$tipoIntermediador).hashCode());
        Short $indicadorPresencaConsumidor = this.getIndicadorPresencaConsumidor();
        result = result * 59 + ($indicadorPresencaConsumidor == null ? 43 : ((Object)$indicadorPresencaConsumidor).hashCode());
        String $nrPedidoCliente = this.getNrPedidoCliente();
        result = result * 59 + ($nrPedidoCliente == null ? 43 : $nrPedidoCliente.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        String $observacaoUsoInterno = this.getObservacaoUsoInterno();
        result = result * 59 + ($observacaoUsoInterno == null ? 43 : $observacaoUsoInterno.hashCode());
        String $condPagMut = this.getCondPagMut();
        result = result * 59 + ($condPagMut == null ? 43 : $condPagMut.hashCode());
        Representante $representante = this.getRepresentante();
        result = result * 59 + ($representante == null ? 43 : ((Object)$representante).hashCode());
        CondicoesPagamento $condicoesPagamento = this.getCondicoesPagamento();
        result = result * 59 + ($condicoesPagamento == null ? 43 : ((Object)$condicoesPagamento).hashCode());
        TipoFrete $tipoFrete = this.getTipoFrete();
        result = result * 59 + ($tipoFrete == null ? 43 : ((Object)$tipoFrete).hashCode());
        Transportador $transportador = this.getTransportador();
        result = result * 59 + ($transportador == null ? 43 : ((Object)$transportador).hashCode());
        Date $dataPrevisaoSaida = this.getDataPrevisaoSaida();
        result = result * 59 + ($dataPrevisaoSaida == null ? 43 : ((Object)$dataPrevisaoSaida).hashCode());
        Date $dataPrevisaoFat = this.getDataPrevisaoFat();
        result = result * 59 + ($dataPrevisaoFat == null ? 43 : ((Object)$dataPrevisaoFat).hashCode());
        NaturezaOperacao $naturezaOperacao = this.getNaturezaOperacao();
        result = result * 59 + ($naturezaOperacao == null ? 43 : ((Object)$naturezaOperacao).hashCode());
        UnidadeFatCliente $unidadeFatCliente = this.getUnidadeFatCliente();
        result = result * 59 + ($unidadeFatCliente == null ? 43 : ((Object)$unidadeFatCliente).hashCode());
        Date $dataEmissao = this.getDataEmissao();
        result = result * 59 + ($dataEmissao == null ? 43 : ((Object)$dataEmissao).hashCode());
        Date $dataCadastro = this.getDataCadastro();
        result = result * 59 + ($dataCadastro == null ? 43 : ((Object)$dataCadastro).hashCode());
        Empresa $empresa = this.getEmpresa();
        result = result * 59 + ($empresa == null ? 43 : ((Object)$empresa).hashCode());
        List<ItemPedido> $itemPedido = this.getItemPedido();
        result = result * 59 + ($itemPedido == null ? 43 : ((Object)$itemPedido).hashCode());
        String $observacaoSistema = this.getObservacaoSistema();
        result = result * 59 + ($observacaoSistema == null ? 43 : $observacaoSistema.hashCode());
        EnderecoEntregaPedido $enderecoEntrega = this.getEnderecoEntrega();
        result = result * 59 + ($enderecoEntrega == null ? 43 : ((Object)$enderecoEntrega).hashCode());
        Usuario $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : ((Object)$usuario).hashCode());
        List<InfPagamentoPedido> $infPagamentoPedido = this.getInfPagamentoPedido();
        result = result * 59 + ($infPagamentoPedido == null ? 43 : ((Object)$infPagamentoPedido).hashCode());
        String $serialForSync = this.getSerialForSync();
        result = result * 59 + ($serialForSync == null ? 43 : $serialForSync.hashCode());
        Timestamp $dataAtualizacao = this.getDataAtualizacao();
        result = result * 59 + ($dataAtualizacao == null ? 43 : ((Object)$dataAtualizacao).hashCode());
        NFCeConsumidor $nfCeConsumidor = this.getNfCeConsumidor();
        result = result * 59 + ($nfCeConsumidor == null ? 43 : ((Object)$nfCeConsumidor).hashCode());
        SituacaoPedidos $situacaoPedidos = this.getSituacaoPedidos();
        result = result * 59 + ($situacaoPedidos == null ? 43 : ((Object)$situacaoPedidos).hashCode());
        MeioPagamento $meioPagamento = this.getMeioPagamento();
        result = result * 59 + ($meioPagamento == null ? 43 : ((Object)$meioPagamento).hashCode());
        Pessoa $pessoaAutorizada = this.getPessoaAutorizada();
        result = result * 59 + ($pessoaAutorizada == null ? 43 : ((Object)$pessoaAutorizada).hashCode());
        Pessoa $indicante = this.getIndicante();
        result = result * 59 + ($indicante == null ? 43 : ((Object)$indicante).hashCode());
        IntermediadorComercial $intermediadorComercial = this.getIntermediadorComercial();
        result = result * 59 + ($intermediadorComercial == null ? 43 : ((Object)$intermediadorComercial).hashCode());
        NFCeControleCaixa $nfceControleCaixa = this.getNfceControleCaixa();
        result = result * 59 + ($nfceControleCaixa == null ? 43 : ((Object)$nfceControleCaixa).hashCode());
        List<DadosRecAgrPedido> $receitasAgronomicas = this.getReceitasAgronomicas();
        result = result * 59 + ($receitasAgronomicas == null ? 43 : ((Object)$receitasAgronomicas).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Pedido(identificador=" + this.getIdentificador() + ", nrPedidoCliente=" + this.getNrPedidoCliente() + ", observacao=" + this.getObservacao() + ", observacaoUsoInterno=" + this.getObservacaoUsoInterno() + ", percFrete=" + this.getPercFrete() + ", valorFrete=" + this.getValorFrete() + ", percDesconto=" + this.getPercDesconto() + ", valorDesconto=" + this.getValorDesconto() + ", valorTotalBruto=" + this.getValorTotalBruto() + ", valorTotal=" + this.getValorTotal() + ", valorTotalBrutoDescTrib=" + this.getValorTotalBrutoDescTrib() + ", valorTotalDescTrib=" + this.getValorTotalDescTrib() + ", percSeguro=" + this.getPercSeguro() + ", valorSeguro=" + this.getValorSeguro() + ", percDespAcessoria=" + this.getPercDespAcessoria() + ", valorDespAcessoria=" + this.getValorDespAcessoria() + ", condPagMut=" + this.getCondPagMut() + ", percDescFinanceiro=" + this.getPercDescFinanceiro() + ", percComissao=" + this.getPercComissao() + ", representante=" + String.valueOf(this.getRepresentante()) + ", condicoesPagamento=" + String.valueOf(this.getCondicoesPagamento()) + ", tipoFrete=" + String.valueOf(this.getTipoFrete()) + ", transportador=" + String.valueOf(this.getTransportador()) + ", dataPrevisaoSaida=" + String.valueOf(this.getDataPrevisaoSaida()) + ", dataPrevisaoFat=" + String.valueOf(this.getDataPrevisaoFat()) + ", naturezaOperacao=" + String.valueOf(this.getNaturezaOperacao()) + ", unidadeFatCliente=" + String.valueOf(this.getUnidadeFatCliente()) + ", dataEmissao=" + String.valueOf(this.getDataEmissao()) + ", dataCadastro=" + String.valueOf(this.getDataCadastro()) + ", empresa=" + String.valueOf(this.getEmpresa()) + ", itemPedido=" + String.valueOf(this.getItemPedido()) + ", tipoDesconto=" + this.getTipoDesconto() + ", observacaoSistema=" + this.getObservacaoSistema() + ", tipoFreteInf=" + this.getTipoFreteInf() + ", tipoSeguroInf=" + this.getTipoSeguroInf() + ", tipoDespAcessInf=" + this.getTipoDespAcessInf() + ", destacarFrete=" + this.getDestacarFrete() + ", destacarSeguro=" + this.getDestacarSeguro() + ", destacarDesconto=" + this.getDestacarDesconto() + ", destacarDespAcessoria=" + this.getDestacarDespAcessoria() + ", informarLocalEntrega=" + this.getInformarLocalEntrega() + ", enderecoEntrega=" + String.valueOf(this.getEnderecoEntrega()) + ", percFreteInf=" + this.getPercFreteInf() + ", valorFreteInf=" + this.getValorFreteInf() + ", percDescontoInf=" + this.getPercDescontoInf() + ", valorDescontoInf=" + this.getValorDescontoInf() + ", percSeguroInf=" + this.getPercSeguroInf() + ", valorSeguroInf=" + this.getValorSeguroInf() + ", percDespAcessoriaInf=" + this.getPercDespAcessoriaInf() + ", valorDespAcessoriaInf=" + this.getValorDespAcessoriaInf() + ", usuario=" + String.valueOf(this.getUsuario()) + ", tipoConsumidor=" + this.getTipoConsumidor() + ", diasMediosCondPag=" + this.getDiasMediosCondPag() + ", infPagamentoPedido=" + String.valueOf(this.getInfPagamentoPedido()) + ", serialForSync=" + this.getSerialForSync() + ", nrTotalItens=" + this.getNrTotalItens() + ", qtdeTotalItens=" + this.getQtdeTotalItens() + ", vlrTotalCusto=" + this.getVlrTotalCusto() + ", identificadorERP=" + this.getIdentificadorERP() + ", dataAtualizacao=" + String.valueOf(this.getDataAtualizacao()) + ", statusSincERP=" + this.getStatusSincERP() + ", nfCeConsumidor=" + String.valueOf(this.getNfCeConsumidor()) + ", situacaoPedidos=" + String.valueOf(this.getSituacaoPedidos()) + ", meioPagamento=" + String.valueOf(this.getMeioPagamento()) + ", pessoaAutorizada=" + String.valueOf(this.getPessoaAutorizada()) + ", indicante=" + String.valueOf(this.getIndicante()) + ", tipoIntermediador=" + this.getTipoIntermediador() + ", intermediadorComercial=" + String.valueOf(this.getIntermediadorComercial()) + ", indicadorPresencaConsumidor=" + this.getIndicadorPresencaConsumidor() + ", nfceControleCaixa=" + String.valueOf(this.getNfceControleCaixa()) + ", receitasAgronomicas=" + String.valueOf(this.getReceitasAgronomicas()) + ")";
    }
}

