/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.nfe.impl.versoes;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.model.ConfiguracaoCertificado;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.model.TipoEmissaoNFe;
import com.touchcomp.touchnfce.model.UnidadeFederativa;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class ConfigCertificate
extends NFeConfig {
    private NFCeOpcoes opcoes;
    private KeyStore keyStoreCertificado = null;
    private KeyStore keyStoreCadeia = null;
    private UnidadeFederativa unidadeFederativa;
    private ConfiguracaoCertificado configuracaoCertificado;
    private TipoEmissaoNFe tipoEmissaoNFe;

    public ConfigCertificate(UnidadeFederativa unidadeFederativa, NFCeOpcoes opcoes, TipoEmissaoNFe tipoEmissaoNFe) {
        this.unidadeFederativa = unidadeFederativa;
        this.configuracaoCertificado = opcoes.getConfiguracaoCertificado();
        this.opcoes = opcoes;
        this.tipoEmissaoNFe = tipoEmissaoNFe;
    }

    public Integer getCodigoSegurancaContribuinteID() {
        return new Integer(ToolString.onlyNumbers((String)this.opcoes.getIdentificadorCSCContrib()));
    }

    public String getCodigoSegurancaContribuinte() {
        return this.opcoes.getCodigoCSCContrib();
    }

    public String getCertificadoSenha() {
        return this.configuracaoCertificado.getSenha();
    }

    public String getCadeiaCertificadosSenha() {
        return "touchcompKeyStore";
    }

    public DFUnidadeFederativa getCUF() {
        return DFUnidadeFederativa.valueOfCodigo((String)this.unidadeFederativa.getCodIbge());
    }

    public KeyStore getCertificadoKeyStore() throws KeyStoreException {
        if (this.keyStoreCertificado == null) {
            this.keyStoreCertificado = KeyStore.getInstance("PKCS12");
            try (ByteArrayInputStream certificadoStream = new ByteArrayInputStream(this.configuracaoCertificado.getArquivoPFX());){
                this.keyStoreCertificado.load(certificadoStream, this.getCertificadoSenha().toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                this.keyStoreCadeia = null;
                throw new KeyStoreException("Nao foi possibel montar o KeyStore com a cadeia de certificados", e);
            }
        }
        return this.keyStoreCertificado;
    }

    public KeyStore getCadeiaCertificadosKeyStore() throws KeyStoreException {
        if (this.keyStoreCadeia == null) {
            this.keyStoreCadeia = KeyStore.getInstance("JKS");
            try (ByteArrayInputStream cadeia = new ByteArrayInputStream(this.configuracaoCertificado.getArquivoJKS());){
                this.keyStoreCadeia.load(cadeia, this.getCadeiaCertificadosSenha().toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                this.keyStoreCadeia = null;
                throw new KeyStoreException("Nao foi possivel montar o KeyStore com o certificado", e);
            }
        }
        return this.keyStoreCadeia;
    }

    public DFAmbiente getAmbiente() {
        if (ToolMethods.isEquals((Object)String.valueOf(this.opcoes.getTipoAmbiente()), (Object)ConstAmbiente.HOMOLOGACAO.getCodigo())) {
            return DFAmbiente.HOMOLOGACAO;
        }
        if (ToolMethods.isEquals((Object)String.valueOf(this.opcoes.getTipoAmbiente()), (Object)ConstAmbiente.PRODUCAO.getCodigo())) {
            return DFAmbiente.PRODUCAO;
        }
        throw new RuntimeException("Primeiro cadastre o Tipo de Ambiente em Op\u00e7\u00f5es NFCe");
    }

    public NFTipoEmissao getTipoEmissao() {
        if (ToolMethods.isEquals((Object)this.tipoEmissaoNFe.getCodigo(), (Object)3)) {
            return NFTipoEmissao.CONTINGENCIA_SCAN;
        }
        if (ToolMethods.isEquals((Object)this.tipoEmissaoNFe.getCodigo(), (Object)4)) {
            return NFTipoEmissao.CONTINGENCIA_EPEC;
        }
        if (ToolMethods.isEquals((Object)this.tipoEmissaoNFe.getCodigo(), (Object)6)) {
            return NFTipoEmissao.CONTINGENCIA_SVCAN;
        }
        if (ToolMethods.isEquals((Object)this.tipoEmissaoNFe.getCodigo(), (Object)7)) {
            return NFTipoEmissao.CONTINGENCIA_SVCRS;
        }
        if (ToolMethods.isEquals((Object)this.tipoEmissaoNFe.getCodigo(), (Object)5)) {
            return NFTipoEmissao.CONTINGENCIA_FSDA;
        }
        return NFTipoEmissao.EMISSAO_NORMAL;
    }

    public int getSoTimeoutEmMillis() {
        if (this.opcoes.getTimeoutConexao() != null && this.opcoes.getTimeoutConexao() > 0) {
            return this.opcoes.getTimeoutConexao() * 1000;
        }
        return super.getTimeoutRequisicaoEmMillis();
    }

    public Short getVersaoQrCodeNFCe() {
        return this.opcoes.getVersaoQrCodeNfce();
    }
}

