/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.nfe.impl.versoes.base;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFPais;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe400.classes.NFEndereco;
import com.fincatto.documentofiscal.nfe400.classes.NFFinalidade;
import com.fincatto.documentofiscal.nfe400.classes.NFIndicadorFormaPagamento;
import com.fincatto.documentofiscal.nfe400.classes.NFModalidadeFrete;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigemProcesso;
import com.fincatto.documentofiscal.nfe400.classes.NFProcessoEmissor;
import com.fincatto.documentofiscal.nfe400.classes.NFRegimeTributario;
import com.fincatto.documentofiscal.nfe400.classes.NFTipo;
import com.fincatto.documentofiscal.nfe400.classes.NFTipoImpressao;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvio;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteIndicadorProcessamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIdentificadorLocalDestinoOperacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIndicadorIEDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIndicadorIntermediador;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIndicadorPresencaComprador;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInfoCupomFiscalReferenciado;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInfoModelo1Por1AReferenciada;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInfoProdutorRuralReferenciada;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInfoReferenciada;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInformacaoIntermediador;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFMeioPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoAgropecuario;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoAgropecuarioDefensivo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoAvulsa;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoCana;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoCartao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoCobranca;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoCompra;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoEmitente;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoExportacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoFatura;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoFormaPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoICMSTotal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoISSQNTotal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoIdentificacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoInformacoesAdicionais;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoLacre;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoLocal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoObservacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoParcela;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoProcessoReferenciado;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoReboque;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoRegimeEspecialTributacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoResponsavelTecnico;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoRetencaoICMSTransporte;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoRetencoesTributos;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoSuplementar;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoTotal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoTransportador;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoTransporte;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoVeiculo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoVolume;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFOperacaoConsumidorFinal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFOperadoraCartao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFPessoaAutorizadaDownloadNFe;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFTipoIntegracaoPagamento;
import com.touchcomp.basementor.constants.enums.modelodocfiscal.EnumConstModDocFiscal;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIndicadorIEDest;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIntermediadorComerical;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeTipoEmissao;
import com.touchcomp.basementorclientwebservices.nfe.model.env.lotefat.NFeLoteFaturamento;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropria;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.nfe.impl.versoes.base.WritterNFeItemDef;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public abstract class WritterNFeDef {
    private static String VERSAO_MENTOR = "MENTOR_ERP_NFE_400";
    private NFeLoteFaturamento nfeLote;

    public WritterNFeDef(NFeLoteFaturamento nfeLote) {
        this.nfeLote = nfeLote;
    }

    public abstract WritterNFeItemDef getWriterNFeItem();

    public NFLoteEnvio getLoteEnvio() {
        NFLoteEnvio lote = new NFLoteEnvio();
        lote.setIdLote(Objects.toString(this.nfeLote.getIdentificador()));
        lote.setVersao(this.nfeLote.getVersao());
        lote.setNotas(this.getNotas());
        lote.setIndicadorProcessamento(NFLoteIndicadorProcessamento.valueOfCodigo((String)this.nfeLote.getTipoProcessamento().getCodigo()));
        return lote;
    }

    private List<NFNota> getNotas() {
        LinkedList<NFNota> notas = new LinkedList<NFNota>();
        this.nfeLote.getNotas().forEach(nf -> notas.add(this.getNota((NFeNotaFiscalPropria)nf)));
        return notas;
    }

    private NFNota getNota(NFeNotaFiscalPropria nf) {
        NFNota nfNota = new NFNota();
        nfNota.setIdentificadorLocal(nf.getIdentificador().longValue());
        nfNota.setInfo(this.getInfo(nf));
        nfNota.setInfoSuplementar(this.getInfoSuplementar(nf));
        return nfNota;
    }

    private NFNotaInfoSuplementar getInfoSuplementar(NFeNotaFiscalPropria nf) {
        if (nf.getInfoSuplementar() == null) {
            return null;
        }
        NFNotaInfoSuplementar info = new NFNotaInfoSuplementar();
        info.setQrCode(nf.getInfoSuplementar().getQrCode());
        info.setUrlConsultaChaveAcesso(nf.getInfoSuplementar().getUrlConsultaChaveAcesso());
        return info;
    }

    private NFNotaInfo getInfo(NFeNotaFiscalPropria nf) {
        NFNotaInfo info = new NFNotaInfo();
        info.setAvulsa(this.getAvulsa());
        info.setCana(this.getCana());
        info.setCobranca(this.getCobranca(nf));
        info.setCompra(this.getCompra(nf));
        info.setDestinatario(this.getDestinatario(nf));
        info.setEmitente(this.getEmitente(nf));
        info.setEntrega(this.getEntrega(nf));
        info.setExportacao(this.getExportacao(nf));
        info.setIdentificacao(this.getIdentificacacao(nf));
        info.setInformacoesAdicionais(this.getInfoAdicionais(nf));
        info.setItens(this.getWriterNFeItem().getItens(nf));
        info.setPagamento(this.getPagamentos(nf));
        info.setPessoasAutorizadasDownloadNFe(this.getPessoasAutXML(nf));
        info.setRetirada(this.getRetirada(nf));
        info.setTotal(this.getTotal(nf));
        info.setTransporte(this.getTransporte(nf));
        info.setIdentificador(ToolString.completaEspacos((String)nf.getChaveNFe(), (int)44));
        info.setVersao(new BigDecimal(nf.getVersaoNFe()));
        info.setInformacaoResposavelTecnico(this.getRespTecnico(nf));
        info.setAgropecuario(this.getAgropecuario(nf));
        info.setInfIntermed(this.getInfIntermediador(nf));
        return info;
    }

    private NFInformacaoIntermediador getInfIntermediador(NFeNotaFiscalPropria nf) {
        if (nf.getIntermediadorComercial() == null) {
            return null;
        }
        if (nf.getIdentificacao().getTipoIntermediador() == null) {
            return null;
        }
        if (nf.getIdentificacao().getTipoIntermediador().equals((Object)ConstNFeIntermediadorComerical.NAO_SE_APLICA)) {
            return null;
        }
        NFInformacaoIntermediador i = new NFInformacaoIntermediador();
        i.setCnpj(nf.getIntermediadorComercial().getCnpj());
        i.setIdCadIntTran(nf.getIntermediadorComercial().getIdentificadorIntermediador());
        return i;
    }

    private NFNotaInfoResponsavelTecnico getRespTecnico(NFeNotaFiscalPropria nf) {
        if (nf.getRespTecnico() == null) {
            return null;
        }
        NFNotaInfoResponsavelTecnico resp = new NFNotaInfoResponsavelTecnico();
        resp.setCnpj(nf.getRespTecnico().getCnpj());
        resp.setContatoNome(this.clearStringXml(nf.getRespTecnico().getContatoNome()));
        resp.setEmail(this.clearStringXml(nf.getRespTecnico().getEmail()));
        resp.setTelefone(this.clearStringXml(nf.getRespTecnico().getTelefone()));
        resp.setIdCSRT(nf.getRespTecnico().getIdCSRT());
        if (nf.getRespTecnico().getHashCSRT() != null) {
            resp.setHashCSRT(nf.getRespTecnico().getHashCSRT());
        }
        return resp;
    }

    private String clearStringXml(String str) {
        if (str == null) {
            return null;
        }
        return ToolString.clearSpecialCharacXML((String)str);
    }

    private NFNotaInfoPagamento getPagamentos(NFeNotaFiscalPropria nf) {
        NFNotaInfoPagamento info = new NFNotaInfoPagamento();
        info.setDetalhamentoFormasPagamento(this.getDetalhamentoFormasPagamento(nf, info));
        return info;
    }

    private List<NFNotaInfoFormaPagamento> getDetalhamentoFormasPagamento(NFeNotaFiscalPropria nf, NFNotaInfoPagamento info) {
        Double valorTroco = nf.getInfoPagamento().getValorTroco();
        LinkedList<NFNotaInfoFormaPagamento> ret = new LinkedList<NFNotaInfoFormaPagamento>();
        nf.getInfoPagamento().getDetalhamentoFormasPagamento().forEach(i -> {
            NFNotaInfoFormaPagamento inf = new NFNotaInfoFormaPagamento();
            inf.setCartao(this.getInfoCartao(i.getCartao()));
            inf.setIndicadorFormaPagamento(NFIndicadorFormaPagamento.valueOfCodigo((String)i.getIndicadorFormaPagamento().getCodigo()));
            inf.setMeioPagamento(NFMeioPagamento.valueOfCodigo((String)i.getMeioPagamento().getCodigo()));
            inf.setValorPagamento(this.toBig(i.getValorPagamento()));
            ret.add(inf);
        });
        if (valorTroco != null) {
            info.setValorTroco(this.toBig(valorTroco));
        }
        return ret;
    }

    private NFNotaInfoCartao getInfoCartao(NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento.NFeNotaInfoCartao cartao) {
        if (cartao == null) {
            return null;
        }
        NFNotaInfoCartao infoCartao = new NFNotaInfoCartao();
        if (cartao.getCnpj() != null && !cartao.getCnpj().isEmpty()) {
            infoCartao.setCnpj(cartao.getCnpj());
        }
        if (cartao.getNumeroAutorizacaoOperacaoCartao() != null && cartao.getNumeroAutorizacaoOperacaoCartao().isEmpty()) {
            infoCartao.setNumeroAutorizacaoOperacaoCartao(cartao.getNumeroAutorizacaoOperacaoCartao());
        }
        if (cartao.getOperadoraCartao() != null) {
            infoCartao.setOperadoraCartao(NFOperadoraCartao.valueOfCodigo((String)cartao.getOperadoraCartao().getCodigo()));
        }
        if (cartao.getTipoIntegracao() != null) {
            infoCartao.setTipoIntegracao(NFTipoIntegracaoPagamento.valueOf((String)cartao.getTipoIntegracao().getCodigo()));
        } else {
            infoCartao.setTipoIntegracao(NFTipoIntegracaoPagamento.SEPARADO);
        }
        return infoCartao;
    }

    private NFNotaInfoTotal getTotal(NFeNotaFiscalPropria nf) {
        NFNotaInfoTotal tot = new NFNotaInfoTotal();
        tot.setIcmsTotal(this.getIcmsTot(nf.getTotal().getIcmsTotal()));
        if (nf.getTotal().getIssqnTotal() != null) {
            tot.setIssqnTotal(this.getIssqnTotal(nf.getTotal().getIssqnTotal()));
        }
        if (nf.getTotal().getRetencoesTributos() != null) {
            tot.setRetencoesTributos(this.getRetencoesTributos(nf.getTotal().getRetencoesTributos()));
        }
        return tot;
    }

    private NFNotaInfoRetencoesTributos getRetencoesTributos(NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoRetencoesTributos retencoesTributos) {
        NFNotaInfoRetencoesTributos ret = new NFNotaInfoRetencoesTributos();
        ret.setValorRetidoPIS(this.toBig(retencoesTributos.getValorRetidoPIS()));
        ret.setValorRetidoCOFINS(this.toBig(retencoesTributos.getValorRetidoCOFINS()));
        ret.setValorRetidoCSLL(this.toBig(retencoesTributos.getValorRetidoCSLL()));
        ret.setBaseCalculoIRRF(this.toBig(retencoesTributos.getBaseCalculoIRRF()));
        ret.setValorRetidoIRRF(this.toBig(retencoesTributos.getValorRetidoIRRF()));
        ret.setBaseCalculoRetencaoPrevidenciaSocial(this.toBig(retencoesTributos.getBaseCalculoRetencaoPrevidenciaSocial()));
        ret.setValorRetencaoPrevidenciaSocial(this.toBig(retencoesTributos.getValorRetencaoPrevidenciaSocial()));
        return ret;
    }

    private NFNotaInfoISSQNTotal getIssqnTotal(NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoISSQNTotal issqnTotal) {
        NFNotaInfoISSQNTotal iss = new NFNotaInfoISSQNTotal();
        iss.setValorTotalServicosSobNaoIncidenciaNaoTributadosICMS(this.toBig(issqnTotal.getValorTotalServicosSobNaoIncidenciaNaoTributadosICMS()));
        iss.setBaseCalculoISS(this.toBig(issqnTotal.getBaseCalculoISS()));
        iss.setValorTotalISS(this.toBig(issqnTotal.getValorTotalISS()));
        iss.setValorPISsobreServicos(this.toBig(issqnTotal.getValorPISsobreServicos()));
        iss.setValorCOFINSsobreServicos(this.toBig(issqnTotal.getValorCOFINSsobreServicos()));
        iss.setDataPrestacaoServico(issqnTotal.getDataPrestacaoServico());
        iss.setValorDeducao(this.toBig(issqnTotal.getValorDeducao()));
        iss.setValorOutros(this.toBig(issqnTotal.getValorOutros()));
        iss.setValorTotalDescontoIncondicionado(this.toBig(issqnTotal.getValorTotalDescontoIncondicionado()));
        iss.setValorTotalDescontoCondicionado(this.toBig(issqnTotal.getValorTotalDescontoCondicionado()));
        iss.setValorTotalRetencaoISS(this.toBig(issqnTotal.getValorTotalRetencaoISS()));
        iss.setTributacao(NFNotaInfoRegimeEspecialTributacao.valueOfCodigo((String)issqnTotal.getTributacao().getCodigo()));
        return iss;
    }

    private NFNotaInfoICMSTotal getIcmsTot(NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoICMSTotal icmsTotal) {
        NFNotaInfoICMSTotal tot = new NFNotaInfoICMSTotal();
        tot.setBaseCalculoICMS(this.toBig(icmsTotal.getBaseCalculoICMS()));
        tot.setBaseCalculoICMS(this.toBig(icmsTotal.getBaseCalculoICMS()));
        tot.setValorTotalICMS(this.toBig(icmsTotal.getValorTotalICMS()));
        tot.setValorICMSDesonerado(this.toBig(icmsTotal.getValorICMSDesonerado()));
        tot.setValorICMSFundoCombatePobreza(this.toBig(icmsTotal.getValorICMSFundoCombatePobreza()));
        tot.setValorICMSPartilhaDestinatario(this.toBig(icmsTotal.getValorICMSPartilhaDestinatario()));
        tot.setValorICMSPartilhaRementente(this.toBig(icmsTotal.getValorICMSPartilhaRementente()));
        tot.setValorTotalFundoCombatePobreza(this.toBig(icmsTotal.getValorTotalFundoCombatePobreza()));
        tot.setBaseCalculoICMSST(this.toBig(icmsTotal.getBaseCalculoICMSST()));
        tot.setValorTotalICMSST(this.toBig(icmsTotal.getValorTotalICMSST()));
        tot.setValorTotalFundoCombatePobrezaST(this.toBig(icmsTotal.getValorTotalFundoCombatePobrezaST()));
        tot.setValorTotalFundoCombatePobrezaSTRetido(this.toBig(icmsTotal.getValorTotalFundoCombatePobrezaSTRetido()));
        tot.setValorTotalDosProdutosServicos(this.toBig(icmsTotal.getValorTotalDosProdutosServicos()));
        tot.setValorTotalFrete(this.toBig(icmsTotal.getValorTotalFrete()));
        tot.setValorTotalSeguro(this.toBig(icmsTotal.getValorTotalSeguro()));
        tot.setValorTotalDesconto(this.toBig(icmsTotal.getValorTotalDesconto()));
        tot.setValorTotalII(this.toBig(icmsTotal.getValorTotalII()));
        tot.setValorTotalIPI(this.toBig(icmsTotal.getValorTotalIPI()));
        tot.setValorTotalIPIDevolvido(this.toBig(icmsTotal.getValorTotalIPIDevolvido()));
        tot.setValorPIS(this.toBig(icmsTotal.getValorPIS()));
        tot.setValorCOFINS(this.toBig(icmsTotal.getValorCOFINS()));
        tot.setOutrasDespesasAcessorias(this.toBig(icmsTotal.getOutrasDespesasAcessorias()));
        tot.setValorTotalNFe(this.toBig(icmsTotal.getValorTotalNFe()));
        tot.setValorTotalTributos(this.toBig(icmsTotal.getValorTotalTributos()));
        if (icmsTotal.getQtdeTribRetidoAnteriormente() != null && icmsTotal.getQtdeTribRetidoAnteriormente() > 0.0 && icmsTotal.getValorICMSRetidoAnteriormente() != null && icmsTotal.getValorICMSRetidoAnteriormente() > 0.0) {
            tot.setQuantidadeTributadaIcmsMonofasico(this.toBig(0.0));
            tot.setValorTotalIcmsMonofasico(this.toBig(0.0));
            tot.setQuantidadeTributadaMonofasicoSujeitoRetencao(this.toBig(0.0));
            tot.setValorTotalIcmsSujeitoRetencao(this.toBig(0.0));
            tot.setQuantidadeTributadaMonofasicoRetiroAnteriormente(this.toBig(icmsTotal.getQtdeTribRetidoAnteriormente()));
            tot.setValorTotalIcmsMonofasicoRetidoAnteriormente(this.toBig(icmsTotal.getValorICMSRetidoAnteriormente()));
        }
        return tot;
    }

    private BigDecimal toBig(Double vlr, int casasDec) {
        BigDecimal big = BigDecimal.valueOf(vlr);
        big = big.setScale(casasDec, 6);
        return big;
    }

    private BigDecimal toBig(Double vlr) {
        BigDecimal big = BigDecimal.valueOf(vlr);
        big = big.setScale(2, 6);
        return big;
    }

    private NFNotaInfoTransporte getTransporte(NFeNotaFiscalPropria nf) {
        if (nf.getInfoTransporte() == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeNotaInfoTransporte info = nf.getInfoTransporte();
        NFNotaInfoTransporte tr = new NFNotaInfoTransporte();
        tr.setBalsa(info.getBalsa());
        tr.setIcmsTransporte(this.getIcmsTransporte(info));
        if (info.getModalidadeFrete() != null) {
            tr.setModalidadeFrete(NFModalidadeFrete.valueOfCodigo((String)info.getModalidadeFrete().getCodigo()));
        }
        tr.setReboques(this.getReboques(info));
        tr.setTransportador(this.getTransportador(info, nf));
        tr.setVagao(info.getVagao());
        tr.setVeiculo(this.getVeiculos(nf, info));
        tr.setVolumes(this.getVolumes(info));
        return tr;
    }

    private List<NFNotaInfoVolume> getVolumes(NFeNotaFiscalPropria.NFeNotaInfoTransporte info) {
        LinkedList<NFNotaInfoVolume> ret = new LinkedList<NFNotaInfoVolume>();
        info.getVolumes().forEach(i -> {
            NFNotaInfoVolume vol = new NFNotaInfoVolume();
            vol.setEspecieVolumesTransportados(this.clearStringXml(i.getEspecieVolumesTransportados()));
            vol.setLacres(this.getLacres(i.getLacres()));
            vol.setMarca(i.getMarca());
            vol.setNumeracaoVolumesTransportados(i.getNumeracaoVolumesTransportados());
            vol.setPesoBruto(this.toBig(i.getPesoBruto()));
            vol.setPesoLiquido(this.toBig(i.getPesoLiquido()));
            vol.setQuantidadeVolumesTransportados(BigInteger.valueOf(i.getQuantidadeVolumesTransportados()));
            ret.add(vol);
        });
        return ret;
    }

    private List<NFNotaInfoLacre> getLacres(List<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume.NFeNotaInfoLacre> lacres) {
        LinkedList<NFNotaInfoLacre> ret = new LinkedList<NFNotaInfoLacre>();
        lacres.forEach(i -> {
            NFNotaInfoLacre lacre = new NFNotaInfoLacre();
            lacre.setNumeroLacre(i.getNumeroLacres());
            ret.add(lacre);
        });
        return ret;
    }

    private NFNotaInfoVeiculo getVeiculos(NFeNotaFiscalPropria nf, NFeNotaFiscalPropria.NFeNotaInfoTransporte info) {
        if (info.getVeiculo() == null) {
            return null;
        }
        if (!nf.getIdentificacao().getModelo().equals((Object)EnumConstModDocFiscal.NFE)) {
            return null;
        }
        NFNotaInfoVeiculo vei = new NFNotaInfoVeiculo();
        vei.setPlacaVeiculo(this.clearStringXml(info.getVeiculo().getPlacaVeiculo()));
        vei.setRegistroNacionalTransportadorCarga(this.clearStringXml(info.getVeiculo().getRegistroNacionalTransportadorCarga()));
        if (info.getVeiculo() != null) {
            vei.setUf(DFUnidadeFederativa.valueOfCodigo((String)info.getVeiculo().getUf()));
        }
        return vei;
    }

    private NFNotaInfoTransportador getTransportador(NFeNotaFiscalPropria.NFeNotaInfoTransporte info, NFeNotaFiscalPropria n) {
        if (info.getTransportador() == null) {
            return null;
        }
        NFNotaInfoTransportador tr = new NFNotaInfoTransportador();
        if (info.getTransportador().getCnpjCpf().length() > 11) {
            tr.setCnpj(info.getTransportador().getCnpjCpf());
        } else {
            tr.setCpf(info.getTransportador().getCnpjCpf());
        }
        tr.setEnderecoComplemento(this.clearStringXml(info.getTransportador().getEnderecoComplemento()));
        tr.setInscricaoEstadual(info.getTransportador().getInscricaoEstadual());
        tr.setNomeMunicipio(this.clearStringXml(info.getTransportador().getNomeMunicipio()));
        tr.setRazaoSocial(this.clearStringXml(info.getTransportador().getRazaoSocial()));
        tr.setUf(DFUnidadeFederativa.valueOfCodigo((String)info.getTransportador().getUf()));
        return tr;
    }

    private List<NFNotaInfoReboque> getReboques(NFeNotaFiscalPropria.NFeNotaInfoTransporte info) {
        LinkedList<NFNotaInfoReboque> ret = new LinkedList<NFNotaInfoReboque>();
        info.getReboques().forEach(i -> {
            NFNotaInfoReboque reb = new NFNotaInfoReboque();
            reb.setPlacaVeiculo(this.clearStringXml(i.getPlacaVeiculo()));
            reb.setRegistroNacionalTransportadorCarga(this.clearStringXml(i.getRegistroNacionalTransportadorCarga()));
            reb.setUf(DFUnidadeFederativa.valueOfCodigo((String)i.getCodigoUf()));
            ret.add(reb);
        });
        return ret;
    }

    private NFNotaInfoRetencaoICMSTransporte getIcmsTransporte(NFeNotaFiscalPropria.NFeNotaInfoTransporte info) {
        if (info.getIcmsTransporte() == null) {
            return null;
        }
        NFNotaInfoRetencaoICMSTransporte ret = new NFNotaInfoRetencaoICMSTransporte();
        ret.setAliquotaRetencao(this.toBig(info.getIcmsTransporte().getAliquotaRetencao()));
        ret.setBcRetencaoICMS(this.toBig(info.getIcmsTransporte().getBcRetencaoICMS()));
        ret.setCfop(info.getIcmsTransporte().getCfop());
        ret.setCodigoMunicipioOcorrenciaFatoGeradorICMSTransporte(info.getIcmsTransporte().getCodigoMunicipio());
        ret.setValorICMSRetido(this.toBig(info.getIcmsTransporte().getValorICMSRetido()));
        ret.setValorServico(this.toBig(info.getIcmsTransporte().getValorServico()));
        return ret;
    }

    private List<NFPessoaAutorizadaDownloadNFe> getPessoasAutXML(NFeNotaFiscalPropria nf) {
        LinkedList<NFPessoaAutorizadaDownloadNFe> ret = new LinkedList<NFPessoaAutorizadaDownloadNFe>();
        nf.getPessoasAutorizadasDowXML().forEach(i -> {
            NFPessoaAutorizadaDownloadNFe aut = new NFPessoaAutorizadaDownloadNFe();
            if (i.getCnpjCpf().length() > 11) {
                aut.setCnpj(i.getCnpjCpf());
            } else {
                aut.setCpf(i.getCnpjCpf());
            }
            ret.add(aut);
        });
        return ret;
    }

    private NFNotaInfoLocal getRetirada(NFeNotaFiscalPropria nf) {
        if (nf.getLocalRetirada() == null) {
            return null;
        }
        NFNotaInfoLocal ret = new NFNotaInfoLocal();
        ret.setLogradouro(this.clearStringXml(nf.getLocalRetirada().getLogradouro()));
        ret.setNomeMunicipio(this.clearStringXml(nf.getLocalRetirada().getNomeMunicipio()));
        ret.setComplemento(this.clearStringXml(nf.getLocalRetirada().getComplemento()));
        ret.setCodigoMunicipio(nf.getLocalRetirada().getCodigoMunicipio());
        ret.setBairro(this.clearStringXml(nf.getLocalRetirada().getBairro()));
        ret.setUf(DFUnidadeFederativa.valueOfCodigo((String)nf.getLocalRetirada().getUf()));
        if (nf.getLocalRetirada().getCnpjCpf().length() > 11) {
            ret.setCnpj(nf.getLocalRetirada().getCnpjCpf());
        } else {
            ret.setCpf(nf.getLocalRetirada().getCnpjCpf());
        }
        return ret;
    }

    private NFNotaInfoInformacoesAdicionais getInfoAdicionais(NFeNotaFiscalPropria nf) {
        if (nf.getInformacoesAdicionais() == null) {
            return null;
        }
        NFNotaInfoInformacoesAdicionais info = new NFNotaInfoInformacoesAdicionais();
        if (ToolMethods.isStrWithData((String)nf.getInformacoesAdicionais().getInformacoesAdicionaisInteresseFisco())) {
            info.setInformacoesAdicionaisInteresseFisco(this.clearStringXml(nf.getInformacoesAdicionais().getInformacoesAdicionaisInteresseFisco()));
        }
        if (ToolMethods.isStrWithData((String)nf.getInformacoesAdicionais().getInformacoesComplementaresInteresseContribuinte())) {
            info.setInformacoesComplementaresInteresseContribuinte(this.clearStringXml(nf.getInformacoesAdicionais().getInformacoesComplementaresInteresseContribuinte()));
        }
        nf.getInformacoesAdicionais().getObservacoesContribuinte().forEach(i -> {
            if (ToolMethods.isStrWithData((String)i.getIdentificacaoCampo()) && ToolMethods.isStrWithData((String)i.getConteudoCampo())) {
                NFNotaInfoObservacao obs = new NFNotaInfoObservacao();
                obs.setIdentificacaoCampo(this.clearStringXml(i.getIdentificacaoCampo()));
                obs.setConteudoCampo(this.clearStringXml(i.getConteudoCampo()));
                info.getObservacoesContribuinte().add(obs);
            }
        });
        nf.getInformacoesAdicionais().getObservacoesFisco().forEach(i -> {
            if (ToolMethods.isStrWithData((String)i.getIdentificacaoCampo()) && ToolMethods.isStrWithData((String)i.getConteudoCampo())) {
                NFNotaInfoObservacao obs = new NFNotaInfoObservacao();
                obs.setIdentificacaoCampo(this.clearStringXml(i.getIdentificacaoCampo()));
                obs.setConteudoCampo(this.clearStringXml(i.getConteudoCampo()));
                info.getObservacoesFisco().add(obs);
            }
        });
        nf.getInformacoesAdicionais().getProcessosRefenciado().forEach(i -> {
            NFNotaInfoProcessoReferenciado proc = new NFNotaInfoProcessoReferenciado();
            proc.setIdentificadorProcessoOuAtoConcessorio(i.getIdentificadorProcessoOuAtoConcessorio());
            proc.setIndicadorOrigemProcesso(NFOrigemProcesso.valueOfCodigo((String)i.getIndicadorOrigemProcesso().getCodigo()));
            info.getProcessosRefenciado().add(proc);
        });
        return info;
    }

    private NFNotaInfoIdentificacao getIdentificacacao(NFeNotaFiscalPropria nf) {
        NFeNotaFiscalPropria.NFeIdentificacao iden = nf.getIdentificacao();
        NFNotaInfoIdentificacao identificacao = new NFNotaInfoIdentificacao();
        identificacao.setAmbiente(DFAmbiente.valueOfCodigo((String)iden.getAmbiente().getCodigo()));
        identificacao.setCodigoMunicipio(iden.getCodigoMunicipio());
        identificacao.setCodigoRandomico(iden.getCodigoRandomico());
        identificacao.setDataHoraEmissao(iden.getDataHoraEmissao());
        identificacao.setDataHoraSaidaOuEntrada(iden.getDataHoraSaidaOuEntrada());
        identificacao.setDigitoVerificador(iden.getDigitoVerificador());
        identificacao.setFinalidade(NFFinalidade.valueOfCodigo((String)iden.getFinalidade().getCodigo()));
        identificacao.setIdentificadorLocalDestinoOperacao(NFIdentificadorLocalDestinoOperacao.valueOfCodigo((String)iden.getIdentificadorLocalDestinoOperacao().getCodigo()));
        identificacao.setIndicadorPresencaComprador(NFIndicadorPresencaComprador.valueOfCodigo((String)iden.getIndicadorPresencaComprador().getCodigo()));
        identificacao.setModelo(DFModelo.valueOfCodigo((String)iden.getModelo().getCodigo()));
        identificacao.setNaturezaOperacao(this.clearStringXml(iden.getNaturezaOperacao()));
        identificacao.setNumeroNota(String.valueOf(iden.getNumeroNota()));
        identificacao.setOperacaoConsumidorFinal(NFOperacaoConsumidorFinal.valueOfCodigo((String)iden.getOperacaoConsumidorFinal().getCodigo()));
        identificacao.setProgramaEmissor(NFProcessoEmissor.CONTRIBUINTE);
        identificacao.setReferenciadas(this.getNFeReferenciadas(iden.getReferenciadas()));
        identificacao.setSerie(new Integer(ToolString.onlyNumbers((String)iden.getSerie())).toString());
        identificacao.setTipo(NFTipo.valueOfCodigo((String)iden.getTipo().getCodigo()));
        identificacao.setTipoEmissao(NFTipoEmissao.valueOfCodigo((String)iden.getTipoEmissao().getCodigo()));
        identificacao.setTipoImpressao(NFTipoImpressao.valueOfCodigo((String)iden.getTipoImpressao().getCodigo()));
        identificacao.setUf(DFUnidadeFederativa.valueOfCodigo((String)iden.getCodigoUf()));
        identificacao.setVersaoEmissor(this.getVersaoProcessoEmissor());
        if (iden.getTipoEmissao() != ConstNFeTipoEmissao.EMISSAO_NORMAL) {
            identificacao.setDataHoraContigencia(iden.getDataHoraContigencia());
            identificacao.setJustificativaEntradaContingencia(iden.getJustificativaEntradaContingencia());
        }
        if (iden.getTipoIntermediador() != null && !ToolMethods.isEquals((Object)iden.getTipoIntermediador(), (Object)ConstNFeIntermediadorComerical.NAO_SE_APLICA)) {
            identificacao.setIndIntermed(NFIndicadorIntermediador.valueOfCodigo((String)iden.getTipoIntermediador().getCodigo()));
        }
        return identificacao;
    }

    private List<NFInfoReferenciada> getNFeReferenciadas(List<NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada> referenciadas) {
        LinkedList<NFInfoReferenciada> ret = new LinkedList<NFInfoReferenciada>();
        for (NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada aux : referenciadas) {
            NFInfoReferenciada ref = new NFInfoReferenciada();
            ref.setChaveAcesso(aux.getChaveAcesso());
            ref.setChaveAcessoCTReferenciada(aux.getChaveAcessoCTReferenciada());
            if (aux.getCupomFiscalReferenciado() != null) {
                NFInfoCupomFiscalReferenciado cf = new NFInfoCupomFiscalReferenciado();
                cf.setModeloDocumentoFiscal(aux.getCupomFiscalReferenciado().getModeloDocumentoFiscal());
                cf.setNumeroContadorOrdemOperacao(aux.getCupomFiscalReferenciado().getNumeroContadorOrdemOperacao());
                cf.setNumeroOrdemSequencialECF(aux.getCupomFiscalReferenciado().getNumeroOrdemSequencialECF());
                ref.setCupomFiscalReferenciado(cf);
            }
            if (aux.getInfoNFProdutorRuralReferenciada() != null) {
                NFInfoProdutorRuralReferenciada prod = new NFInfoProdutorRuralReferenciada();
                prod.setAnoMesEmissao(aux.getInfoNFProdutorRuralReferenciada().getAnoMesEmissao());
                if (aux.getInfoNFProdutorRuralReferenciada().getCnpjCpfEmitente().length() > 11) {
                    prod.setCnpjEmitente(aux.getInfoNFProdutorRuralReferenciada().getCnpjCpfEmitente());
                } else {
                    prod.setCpfEmitente(aux.getInfoNFProdutorRuralReferenciada().getCnpjCpfEmitente());
                }
                prod.setIeEmitente(aux.getInfoNFProdutorRuralReferenciada().getIeEmitente());
                prod.setModeloDocumentoFiscal(aux.getInfoNFProdutorRuralReferenciada().getModeloDocumentoFiscal());
                prod.setNumeroDocumentoFiscal(aux.getInfoNFProdutorRuralReferenciada().getNumeroDocumentoFiscal());
                prod.setSerieDocumentoFiscal(aux.getInfoNFProdutorRuralReferenciada().getSerieDocumentoFiscal());
                prod.setUfEmitente(DFUnidadeFederativa.valueOfCodigo((String)aux.getInfoNFProdutorRuralReferenciada().getCodigoUfEmitente()));
                ref.setInfoNFProdutorRuralReferenciada(prod);
            }
            if (aux.getModelo1por1Referenciada() != null) {
                NFInfoModelo1Por1AReferenciada nf = new NFInfoModelo1Por1AReferenciada();
                nf.setAnoMesEmissaoNFe(aux.getModelo1por1Referenciada().getAnoMesEmissaoNFe());
                nf.setCnpj(aux.getModelo1por1Referenciada().getCnpj());
                nf.setModeloDocumentoFiscal(aux.getModelo1por1Referenciada().getModeloDocumentoFiscal());
                nf.setNumeroDocumentoFiscal(aux.getModelo1por1Referenciada().getNumeroDocumentoFiscal());
                nf.setUf(DFUnidadeFederativa.valueOfCodigo((String)aux.getModelo1por1Referenciada().getCodigoUf()));
                ref.setModelo1por1Referenciada(nf);
            }
            ret.add(ref);
        }
        return ret;
    }

    private String getVersaoProcessoEmissor() {
        return VERSAO_MENTOR;
    }

    private NFNotaInfoExportacao getExportacao(NFeNotaFiscalPropria nf) {
        if (nf.getInfoExportacao() == null) {
            return null;
        }
        NFNotaInfoExportacao exp = new NFNotaInfoExportacao();
        exp.setLocalDespachoProdutos(this.clearStringXml(nf.getInfoExportacao().getLocalDespachoProdutos()));
        exp.setLocalEmbarqueProdutos(this.clearStringXml(nf.getInfoExportacao().getLocalEmbarqueProdutos()));
        exp.setUfEmbarqueProduto(DFUnidadeFederativa.valueOfCodigo((String)nf.getInfoExportacao().getCodigoUfEmbarqueProduto()));
        return exp;
    }

    private NFEndereco getEndereco(NFeNotaFiscalPropria.NFeEnderecoEntrega end) {
        NFEndereco endereco = new NFEndereco();
        endereco.setLogradouro(this.getStringNullIfEmpty(end.getLogradouro()));
        endereco.setNumero(this.getStringNullIfEmpty(end.getNumero()));
        endereco.setComplemento(this.getStringNullIfEmpty(end.getComplemento()));
        endereco.setBairro(this.getStringNullIfEmpty(end.getBairro()));
        endereco.setCodigoMunicipio(end.getCodigoMunicipio());
        endereco.setDescricaoMunicipio(this.clearStringXml(end.getNomeMunicipio()));
        endereco.setUf(DFUnidadeFederativa.valueOfCodigo((String)end.getUf()));
        endereco.setCep(end.getCep());
        DFPais pais = DFPais.valueOfCodigo((String)end.getCodigoPais());
        endereco.setCodigoPais(pais);
        endereco.setDescricaoPais(this.clearStringXml(pais.getDescricao()));
        return endereco;
    }

    private NFNotaInfoLocal getEntrega(NFeNotaFiscalPropria nf) {
        if (nf.getEnderecoEntrega() == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeEnderecoEntrega entrega = nf.getEnderecoEntrega();
        NFNotaInfoLocal infoLocal = new NFNotaInfoLocal();
        infoLocal.setBairro(entrega.getBairro());
        if (ToolMethods.isStrWithData((String)entrega.getCnpjCpf())) {
            if (entrega.getCnpjCpf().length() > 11) {
                infoLocal.setCnpj(entrega.getCnpjCpf());
            } else {
                infoLocal.setCpf(entrega.getCnpjCpf());
            }
        }
        infoLocal.setCodigoMunicipio(entrega.getCodigoMunicipio());
        infoLocal.setComplemento(null);
        infoLocal.setLogradouro(this.getStringNullIfEmpty(entrega.getLogradouro()));
        infoLocal.setNomeMunicipio(this.clearStringXml(entrega.getNomeMunicipio()));
        infoLocal.setNumero(this.getStringNullIfEmpty(entrega.getNumero()));
        infoLocal.setUf(DFUnidadeFederativa.valueOfCodigo((String)entrega.getUf()));
        return infoLocal;
    }

    private NFNotaInfoEmitente getEmitente(NFeNotaFiscalPropria nf) {
        NFNotaInfoEmitente emit = new NFNotaInfoEmitente();
        NFeNotaFiscalPropria.NFeEmitente emitente = nf.getEmitente();
        if (emitente.getCnpjCpf().length() > 11) {
            emit.setCnpj(emitente.getCnpjCpf());
        } else {
            emit.setCpf(emitente.getCnpjCpf());
        }
        emit.setEndereco(this.getEndereco(emitente.getEndereco()));
        emit.setInscricaoEstadual(emitente.getInscricaoEstadual());
        emit.setInscricaoEstadualSubstituicaoTributaria(this.getStringNullIfEmpty(emitente.getInscricaoEstadualSubstituicaoTributaria()));
        if (this.getStringNullIfEmpty(emitente.getInscricaoMunicipal()) != null && this.getStringNullIfEmpty(emitente.getClassificacaoNacionalAtividadesEconomicas()) != null) {
            emit.setInscricaoMunicipal(this.getStringNullIfEmpty(emitente.getInscricaoMunicipal()));
            emit.setClassificacaoNacionalAtividadesEconomicas(emitente.getClassificacaoNacionalAtividadesEconomicas());
        }
        emit.setNomeFantasia(this.getStringNullIfEmpty(emitente.getNomeFantasia()));
        emit.setRazaoSocial(this.clearStringXml(emitente.getRazaoSocial()));
        emit.setRegimeTributario(NFRegimeTributario.valueOfCodigo((String)emitente.getCodRegimeTributario()));
        return emit;
    }

    private NFNotaInfoDestinatario getDestinatario(NFeNotaFiscalPropria nf) {
        NFNotaInfoDestinatario destinatario = new NFNotaInfoDestinatario();
        NFeNotaFiscalPropria.NFeDestinatario dest = nf.getInfoDestinatario();
        if (dest == null) {
            return null;
        }
        if (dest.getCnpjCpf() != null && dest.getCnpjCpf().length() > 0) {
            if (dest.getCnpjCpf().length() > 11) {
                destinatario.setCnpj(dest.getCnpjCpf());
            } else {
                destinatario.setCpf(dest.getCnpjCpf());
            }
        }
        destinatario.setEmail(this.clearStringXml(dest.getEmail()));
        if (nf.getInfoDestinatario() != null && nf.getInfoDestinatario().getEndereco() != null) {
            destinatario.setEndereco(this.getEndereco(nf.getInfoDestinatario().getEndereco()));
        } else if (nf.getInfoDestinatario() != null && nf.getInfoDestinatario().getEndereco() == null && nf.getEnderecoEntrega() != null) {
            destinatario.setEndereco(this.getEndereco(nf.getEnderecoEntrega()));
        }
        destinatario.setIdEstrangeiro(this.getStringNullIfEmpty(dest.getIdEstrangeiro()));
        if (dest.getIndicadorIEDestinatario() != null) {
            destinatario.setIndicadorIEDestinatario(NFIndicadorIEDestinatario.valueOfCodigo((String)dest.getIndicadorIEDestinatario().getCodigo()));
        } else {
            destinatario.setIndicadorIEDestinatario(NFIndicadorIEDestinatario.valueOfCodigo((String)ConstNFeIndicadorIEDest.NAO_CONTRIBUINTE.getCodigo()));
        }
        destinatario.setInscricaoEstadual(this.getStringNullIfEmpty(dest.getInscricaoEstadual()));
        destinatario.setInscricaoMunicipal(this.getStringNullIfEmpty(dest.getInscricaoMunicipal()));
        destinatario.setInscricaoSuframa(this.getStringNullIfEmpty(dest.getInscricaoSuframa()));
        destinatario.setRazaoSocial(this.clearStringXml(dest.getRazaoSocial()));
        return destinatario;
    }

    private NFEndereco getEndereco(NFeNotaFiscalPropria.NFeEndereco end) {
        NFEndereco endereco = new NFEndereco();
        endereco.setLogradouro(this.getStringNullIfEmpty(end.getLogradouro()));
        endereco.setNumero(this.getStringNullIfEmpty(end.getNumero()));
        endereco.setComplemento(this.getStringNullIfEmpty(end.getComplemento()));
        endereco.setBairro(this.getStringNullIfEmpty(end.getBairro()));
        endereco.setCodigoMunicipio(end.getCodigoMunicipio());
        endereco.setDescricaoMunicipio(this.clearStringXml(end.getDescricaoMunicipio()));
        endereco.setUf(DFUnidadeFederativa.valueOfCodigo((String)end.getCodigoUF()));
        endereco.setCep(end.getCep());
        DFPais pais = DFPais.valueOfCodigo((String)end.getCodigoPais());
        endereco.setCodigoPais(pais);
        endereco.setDescricaoPais(this.clearStringXml(pais.getDescricao()));
        endereco.setTelefone(this.getStringNullIfEmpty(end.getTelefone()));
        return endereco;
    }

    private String getStringNullIfEmpty(String str) {
        return str != null && str.trim().length() > 0 ? this.clearStringXml(str) : null;
    }

    private String getStringVaziaIfEmpty(String str) {
        return str != null && str.trim().length() > 0 ? str : "";
    }

    private NFNotaInfoCompra getCompra(NFeNotaFiscalPropria nf) {
        if (nf.getInfoCompra() == null) {
            return null;
        }
        NFNotaInfoCompra compra = new NFNotaInfoCompra();
        compra.setContrato(this.clearStringXml(nf.getInfoCompra().getContrato()));
        compra.setNotaDeEmpenho(nf.getInfoCompra().getNotaDeEmpenho());
        compra.setPedido(this.clearStringXml(nf.getInfoCompra().getPedido()));
        return compra;
    }

    private NFNotaInfoCobranca getCobranca(NFeNotaFiscalPropria nf) {
        if (nf.getInfoCobranca() == null) {
            return null;
        }
        NFNotaInfoCobranca c = new NFNotaInfoCobranca();
        ArrayList<NFNotaInfoParcela> listParcelas = new ArrayList<NFNotaInfoParcela>();
        for (NFeNotaFiscalPropria.NFNotaInfoParcela p : nf.getInfoCobranca().getParcelas()) {
            NFNotaInfoParcela infParc = new NFNotaInfoParcela();
            infParc.setDataVencimento(p.getDataVencimento());
            infParc.setNumeroParcela(p.getNumeroParcela());
            infParc.setValorParcela(this.toBig(p.getValorParcela()));
            listParcelas.add(infParc);
        }
        if (nf.getInfoCobranca().getInfoFatura() != null) {
            c.setFatura(this.getInfoFatura(nf));
        }
        c.setParcelas(listParcelas);
        return c;
    }

    private NFNotaInfoFatura getInfoFatura(NFeNotaFiscalPropria nf) {
        if (nf.getInfoCobranca() == null || nf.getInfoCobranca().getInfoFatura() == null) {
            return null;
        }
        NFNotaInfoFatura f = new NFNotaInfoFatura();
        f.setValorLiquidoFatura(this.toBig(nf.getInfoCobranca().getInfoFatura().getValorLiquidoFatura(), 2));
        f.setValorDesconto(this.toBig(nf.getInfoCobranca().getInfoFatura().getValorDesconto(), 2));
        f.setValorOriginalFatura(this.toBig(nf.getInfoCobranca().getInfoFatura().getValorOriginalFatura(), 2));
        f.setNumeroFatura(nf.getInfoCobranca().getInfoFatura().getNumeroFatura());
        return f;
    }

    private NFNotaInfoCana getCana() {
        return null;
    }

    private NFNotaInfoAvulsa getAvulsa() {
        return null;
    }

    private NFNotaInfoAgropecuario getAgropecuario(NFeNotaFiscalPropria nf) {
        if (nf.getAgropecuario() == null) {
            return null;
        }
        NFNotaInfoAgropecuario ag = new NFNotaInfoAgropecuario();
        ArrayList<NFNotaInfoAgropecuarioDefensivo> defensivos = new ArrayList<NFNotaInfoAgropecuarioDefensivo>();
        for (NFeNotaFiscalPropria.NFeNotaAgropecuario.NFeNotaAgropecuarioDefensivo d : nf.getAgropecuario().getDefensivo()) {
            NFNotaInfoAgropecuarioDefensivo defensivo = new NFNotaInfoAgropecuarioDefensivo();
            defensivo.setCPFRespTec(d.getCpfRespTec());
            defensivo.setNrReceituario(d.getNrReceituario());
            defensivos.add(defensivo);
        }
        ag.setDefensivo(defensivos);
        return ag;
    }
}

