/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.print.impl;

import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeFonteImpressao;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorexceptions.exceptions.impl.print.ExceptionPrint;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.model.NFCeAfericaoPreAbastecimento;
import com.touchcomp.touchnfce.print.PrintReport;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.sf.jasperreports.engine.JasperPrint;
import org.jetbrains.annotations.NotNull;

public class PrintAfericaoAbastecimento
extends PrintReport {
    public void printComprovanteAfericao(@NotNull List<NFCeAfericaoPreAbastecimento> list) throws ExceptionJasperReports, ExceptionPrint {
        LinkedList data = new LinkedList();
        if (list != null && !list.isEmpty()) {
            this.getParams().put("DATA_AFERICAO", ToolDate.dateToStr((Date)new Date(), (String)"dd/MM/yyyy hh:mm"));
            this.getParams().put("CNPJ", StaticObjects.getEmpresa().getPessoa().getComplemento().getCnpj());
            this.getParams().put("NOME", StaticObjects.getEmpresa().getPessoa().getNomeFantasia());
            this.getParams().put("LOGRADOURO", StaticObjects.getEmpresa().getPessoa().getEndereco().getLogradouro());
            this.getParams().put("NUMERO", StaticObjects.getEmpresa().getPessoa().getEndereco().getNumero());
            this.getParams().put("BAIRRO", StaticObjects.getEmpresa().getPessoa().getEndereco().getBairro());
            this.getParams().put("CIDADE", StaticObjects.getEmpresa().getPessoa().getEndereco().getCidade().getDescricao());
            this.getParams().put("UF", StaticObjects.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla());
            this.getParams().put("CEP", StaticObjects.getEmpresa().getPessoa().getEndereco().getCep());
            if (ToolMethods.isEquals((Object)StaticObjects.getNFCeCaixa().getFonteImpressao(), (Object)EnumConstNFCeFonteImpressao.ABEL.getValue())) {
                this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.ABEL.getValue());
            } else if (ToolMethods.isEquals((Object)StaticObjects.getNFCeCaixa().getFonteImpressao(), (Object)EnumConstNFCeFonteImpressao.BARLOW.getValue())) {
                this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.BARLOW.getValue());
            } else if (ToolMethods.isEquals((Object)StaticObjects.getNFCeCaixa().getFonteImpressao(), (Object)EnumConstNFCeFonteImpressao.BARLOW_CONDENSED.getValue())) {
                this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.BARLOW_CONDENSED.getValue());
            } else {
                this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.SANS_SERIF_PADRAO.getValue());
            }
            for (NFCeAfericaoPreAbastecimento vo : list) {
                HashMap<String, Object> h = new HashMap<String, Object>();
                h.put("ID_TANQUE", vo.getPreAbastecimento().getBico().getTanqueCombustivel().getIdentificador());
                h.put("DESCRICAO_TANQUE", vo.getPreAbastecimento().getBico().getTanqueCombustivel());
                h.put("ID_BOMBA", vo.getPreAbastecimento().getBico().getBombaCombustivel().getIdentificador());
                h.put("DESCRICAO_BOMBA", vo.getPreAbastecimento().getBico().getBombaCombustivel().getDescricao());
                h.put("ID_BICO", vo.getPreAbastecimento().getBico().getIdentificador());
                h.put("DESCRICAO_BICO", vo.getPreAbastecimento().getBico().getDescricao());
                h.put("PRODUTO", vo.getPreAbastecimento().getBico().getGradeCor().getProdutoGrade().getProduto().getNome());
                h.put("ENCERRANTE_INICIAL", ToolFormatter.arrredondarNumero((Double)vo.getVlrEncerranteInicial(), (int)2));
                h.put("ENCERRANTE_FINAL", ToolFormatter.arrredondarNumero((Double)vo.getVlrEncerranteFinal(), (int)2));
                h.put("VALOR_UNITARIO", vo.getPreAbastecimento().getValorUnitario());
                h.put("VOLUME", ToolFormatter.arrredondarNumero((Double)vo.getPreAbastecimento().getQuantidade(), (int)2));
                h.put("VALOR_TOTAL", ToolFormatter.arrredondarNumero((Double)vo.getPreAbastecimento().getValorTotal(), (int)2));
                data.add(h);
            }
            JasperPrint jasperPrint = this.generateReportListDataSource(data);
            this.printOnParamTermicaPrinter(jasperPrint);
        }
    }

    @Override
    public String getPath() {
        return "reports/abastecimento/preabastecimento/comprovanteafericao/COMPROVANTE_AFERICAO_PRE_ABASTECIMENTO.jasper";
    }
}

