/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.print.impl;

import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeFonteImpressao;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorexceptions.exceptions.impl.print.ExceptionPrint;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.model.NFCePagamento;
import com.touchcomp.touchnfce.model.NFCeTitulo;
import com.touchcomp.touchnfce.print.PrintReport;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.sf.jasperreports.engine.JasperPrint;
import org.jetbrains.annotations.NotNull;

public class PrintDuplicataDuasVias
extends PrintReport {
    private short tipoVia;
    private short tipoImpressao;

    public void printDuplicataDuasVias(@NotNull List<NFCePagamento> list, Short tipoImpr) throws ExceptionJasperReports, ExceptionPrint {
        this.setTipoImpressao(tipoImpr);
        if (list != null && !list.isEmpty()) {
            if (ToolMethods.isEquals((Object)this.getTipoImpressao(), (Object)1)) {
                this.printDuplicata(list);
            } else {
                this.setTipoVia((short)0);
                this.printDuplicata(list);
                this.setTipoVia((short)1);
                this.printDuplicata(list);
            }
        }
    }

    @Override
    public String getPath() {
        if (ToolMethods.isEquals((Object)this.getTipoImpressao(), (Object)1)) {
            return "reports/duplicata/modeloduasvias/MODELO_DUPLICATA_DUAS_VIAS.jasper";
        }
        if (this.getTipoVia() == 0) {
            return "reports/duplicata/modeloduasviasresumido/MODELO_DUPLICATA_DUAS_VIAS_RESUMIDO_EMPRESA.jasper";
        }
        return "reports/duplicata/modeloduasviasresumido/MODELO_DUPLICATA_DUAS_VIAS_RESUMIDO_CONSUMIDOR.jasper";
    }

    private String getNomeClienteOrConsumidor(NFCePagamento vo) {
        Object str = "";
        if (vo.getNfce().getNfCeConsumidor() != null) {
            str = (String)str + vo.getNfce().getNfCeConsumidor().getNome();
        } else if (vo.getNfce().getUnidadeFatCliente() != null) {
            str = vo.getNfce().getUnidadeFatCliente().getPessoa().getNome();
        }
        return str;
    }

    private String getCodigoClienteOrConsumidor(NFCePagamento vo) {
        if (vo.getNfce().getNfCeConsumidor() != null) {
            return "";
        }
        if (vo.getNfce().getUnidadeFatCliente() != null) {
            Object codCliente = vo.getNfce().getUnidadeFatCliente().getCliente().getCodigoCliente();
            if (ToolMethods.isStrWithData((String)codCliente) && ((String)codCliente).length() > 2) {
                try {
                    codCliente = ((String)codCliente).substring(0, ((String)codCliente).length() - 1) + "-" + ((String)codCliente).substring(((String)codCliente).length() - 1);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return codCliente;
        }
        return "";
    }

    private String getCpfCnpjClienteConsumidor(NFCePagamento vo) {
        Object str = "";
        if (vo.getNfce().getNfCeConsumidor() != null) {
            str = (String)str + vo.getNfce().getNfCeConsumidor().getCpfCnpj();
        } else if (vo.getNfce().getUnidadeFatCliente() != null) {
            str = (String)str + vo.getNfce().getUnidadeFatCliente().getPessoa().getComplemento().getCnpj();
        }
        return str;
    }

    private String getCepCliente(NFCePagamento vo) {
        Object str = "";
        if (vo.getNfce().getUnidadeFatCliente() != null) {
            str = (String)str + vo.getNfce().getUnidadeFatCliente().getPessoa().getEndereco().getCep();
        }
        return str;
    }

    private String getCidadeCliente(NFCePagamento vo) {
        Object str = "";
        if (vo.getNfce().getUnidadeFatCliente() != null) {
            str = (String)str + vo.getNfce().getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getDescricao();
        }
        return str;
    }

    private List<HashMap> getTitulos(NFCePagamento vo) {
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        for (NFCeTitulo t : vo.getTitulos()) {
            HashMap<String, Comparable<Date>> h = new HashMap<String, Comparable<Date>>();
            h.put("DATA_VENCIMENTO", t.getDataVencimento());
            h.put("VALOR", t.getValor());
            h.put("PARCELA", t.getNumeroParcela());
            list.add(h);
        }
        return list;
    }

    private String getPessoaAutorizada(NFCePagamento vo) {
        Object str = "";
        if (vo.getNfce().getPessoaAutorizada() != null) {
            str = (String)str + vo.getNfce().getPessoaAutorizada().getNome();
        }
        return str;
    }

    private String getDadosVendedor(NFCePagamento vo) {
        Object str = "";
        if (vo.getNfce().getRepresentante() != null) {
            str = (String)str + vo.getNfce().getRepresentante().getIdentificador() + " - " + vo.getNfce().getRepresentante().getPessoa().getNome();
        }
        return str;
    }

    private void printDuplicata(List<NFCePagamento> list) throws ExceptionJasperReports {
        LinkedList data = new LinkedList();
        this.getParams().put("TELEFONE", StaticObjects.getEmpresa().getPessoa().getComplemento().getFone1());
        this.getParams().put("CNPJ", StaticObjects.getEmpresa().getPessoa().getComplemento().getCnpj());
        this.getParams().put("NOME", StaticObjects.getEmpresa().getPessoa().getNome());
        this.getParams().put("NOME_FANTASIA", StaticObjects.getEmpresa().getPessoa().getNomeFantasia());
        this.getParams().put("LOGRADOURO", StaticObjects.getEmpresa().getPessoa().getEndereco().getLogradouro());
        this.getParams().put("NUMERO", StaticObjects.getEmpresa().getPessoa().getEndereco().getNumero());
        this.getParams().put("BAIRRO", StaticObjects.getEmpresa().getPessoa().getEndereco().getBairro());
        this.getParams().put("CIDADE", StaticObjects.getEmpresa().getPessoa().getEndereco().getCidade().getDescricao());
        this.getParams().put("UF", StaticObjects.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla());
        this.getParams().put("CEP", StaticObjects.getEmpresa().getPessoa().getEndereco().getCep());
        if (ToolMethods.isEquals((Object)StaticObjects.getNFCeCaixa().getFonteImpressao(), (Object)EnumConstNFCeFonteImpressao.ABEL.getValue())) {
            this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.ABEL.getValue());
        } else if (ToolMethods.isEquals((Object)StaticObjects.getNFCeCaixa().getFonteImpressao(), (Object)EnumConstNFCeFonteImpressao.BARLOW.getValue())) {
            this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.BARLOW.getValue());
        } else if (ToolMethods.isEquals((Object)StaticObjects.getNFCeCaixa().getFonteImpressao(), (Object)EnumConstNFCeFonteImpressao.BARLOW_CONDENSED.getValue())) {
            this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.BARLOW_CONDENSED.getValue());
        } else {
            this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.SANS_SERIF_PADRAO.getValue());
        }
        for (NFCePagamento vo : list) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("DATA", vo.getNfce().getDataEmissao());
            h.put("NOTA_FISCAL", vo.getNfce().getNumero());
            h.put("SERIE_NOTA_FISCAL", vo.getNfce().getSerie());
            h.put("VENDEDOR", this.getDadosVendedor(vo));
            h.put("VALOR_TOTAL", vo.getValor());
            h.put("MEIO_PAGAMENTO", vo.getMeioPagamento().getDescricao());
            h.put("AUTORIZADO", this.getPessoaAutorizada(vo));
            h.put("NOME_CLIENTE_CONSUMIDOR", this.getNomeClienteOrConsumidor(vo));
            h.put("COD_CLIENTE_CONSUMIDOR", this.getCodigoClienteOrConsumidor(vo));
            h.put("CPF_CNPJ", this.getCpfCnpjClienteConsumidor(vo));
            h.put("CEP_CLIENTE", this.getCepCliente(vo));
            h.put("CIDADE_CLIENTE", this.getCidadeCliente(vo));
            h.put("LIST_TITULOS", this.getTitulos(vo));
            data.add(h);
        }
        JasperPrint jasperPrint = this.generateReportListDataSource(data);
        if (ToolMethods.isEquals((Object)this.getTipoImpressao(), (Object)1)) {
            this.printOnParamLaserPrinter(jasperPrint);
        } else {
            this.printOnParamTermicaPrinter(jasperPrint);
        }
    }

    public short getTipoVia() {
        return this.tipoVia;
    }

    public void setTipoVia(short tipoVia) {
        this.tipoVia = tipoVia;
    }

    public short getTipoImpressao() {
        return this.tipoImpressao;
    }

    public void setTipoImpressao(short tipoImpressao) {
        this.tipoImpressao = tipoImpressao;
    }
}

