/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.print.impl;

import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeFonteImpressao;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.constants.EnumTipoViaPedido;
import com.touchcomp.touchnfce.model.InfPagamentoPedido;
import com.touchcomp.touchnfce.model.ItemPedido;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.model.PedidoTitulo;
import com.touchcomp.touchnfce.print.PrintReport;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import org.jetbrains.annotations.NotNull;

public class PrintPreVendaTermica
extends PrintReport {
    public void PrintPreVenda(@NotNull Pedido aux, EnumTipoViaPedido enumTipoViaPedido) throws ExceptionJasperReports {
        LinkedList data = new LinkedList();
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("F_ID_PEDIDO", aux.getSerialForSync());
        h.put("F_ID_PEDIDO_ERP", aux.getIdentificadorERP());
        h.put("F_TIPO_PEDIDO", this.getTipoPedido(aux));
        h.put("LIST_PRE_PEDIDO_SUB", this.getDadosPedidoSub(aux));
        h.put("TIPO_VIA_PEDIDO", enumTipoViaPedido.getValue());
        data.add(h);
        if (ToolMethods.isEquals((Object)StaticObjects.getNFCeCaixa().getFonteImpressao(), (Object)EnumConstNFCeFonteImpressao.ABEL.getValue())) {
            this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.ABEL.getValue());
        } else if (ToolMethods.isEquals((Object)StaticObjects.getNFCeCaixa().getFonteImpressao(), (Object)EnumConstNFCeFonteImpressao.BARLOW.getValue())) {
            this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.BARLOW.getValue());
        } else if (ToolMethods.isEquals((Object)StaticObjects.getNFCeCaixa().getFonteImpressao(), (Object)EnumConstNFCeFonteImpressao.BARLOW_CONDENSED.getValue())) {
            this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.BARLOW_CONDENSED.getValue());
        } else {
            this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.SANS_SERIF_PADRAO.getValue());
        }
        JasperPrint jasperPrint = this.generateReportListDataSource(data);
        this.printOnParamTermicaPrinter(jasperPrint);
    }

    @Override
    public String getPath() {
        return "reports/prevenda/termica/PEDIDO_PRE_VENDA_TERMICO.jasper";
    }

    private List getDadosPedidoSub(Pedido aux) {
        ArrayList list = new ArrayList();
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("F_DATA_EMISSAO", aux.getDataEmissao());
        h.put("F_ID_PEDIDO", aux.getSerialForSync());
        h.put("F_ID_PEDIDO_ERP", aux.getIdentificadorERP());
        h.put("F_NOME_CLIENTE", aux.getUnidadeFatCliente().getCliente().getPessoa().getNome());
        h.put("F_ID_PESSOA", aux.getUnidadeFatCliente().getCliente().getPessoa().getIdentificador());
        h.put("F_LOGRADOURO_CLIENTE", aux.getUnidadeFatCliente().getCliente().getPessoa().getEndereco().getLogradouro());
        h.put("F_NUMERO_CLIENTE", aux.getUnidadeFatCliente().getCliente().getPessoa().getEndereco().getNumero());
        h.put("F_BAIRRO_CLIENTE", aux.getUnidadeFatCliente().getCliente().getPessoa().getEndereco().getBairro());
        h.put("F_COMPLEMENTO_CLIENTE", aux.getUnidadeFatCliente().getCliente().getPessoa().getEndereco().getComplemento());
        h.put("F_CIDADE_CLIENTE", aux.getUnidadeFatCliente().getCliente().getPessoa().getEndereco().getCidade().getDescricao());
        h.put("F_UF_CLIENTE", aux.getUnidadeFatCliente().getCliente().getPessoa().getEndereco().getCidade().getUf().getSigla());
        h.put("F_VALOR_PEDIDO", aux.getValorTotal());
        h.put("F_VALOR_PEDIDO_DESC_TRIB", aux.getValorTotalDescTrib());
        h.put("F_OBSERVACAO", aux.getObservacao());
        if (aux.getRepresentante() != null) {
            h.put("F_USUARIO", aux.getRepresentante().getPessoa().getNome());
        } else {
            h.put("F_USUARIO", aux.getUsuario().getPessoa().getNome());
        }
        h.put("F_TIPO_PEDIDO", this.getTipoPedido(aux));
        h.put("ITEM_PEDIDO", this.getItemPedido(aux));
        h.put("INF_PAG_PEDIDO", this.getInfPagamentoPedido(aux));
        h.put("INF_PAG_PEDIDO_TITULOS", this.getInfPagamentoPedidoTitulos(aux));
        h.put("F_CNPJ_CIENTE", this.getFormattedCNPJ(aux.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getCnpj()));
        h.put("F_FONE_CLIENTE", aux.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getFone1());
        h.put("F_FONE_EMPRESA", StaticObjects.getEmpresa().getPessoa().getComplemento().getFone1());
        h.put("F_CNPJ", this.getFormattedCNPJ(StaticObjects.getEmpresa().getPessoa().getComplemento().getCnpj()));
        h.put("F_INSCRICAO_ESTADUAL", this.getInscricaoEstadual());
        h.put("F_NOME_EMPRESA", StaticObjects.getEmpresa().getPessoa().getNome());
        h.put("F_NOME_FANTASIA", StaticObjects.getEmpresa().getPessoa().getNomeFantasia());
        h.put("LOGO_RELATORIO", JRImageRenderer.getInstance((byte[])this.getBytesImage()));
        list.add(h);
        return list;
    }

    private List getItemPedido(Pedido aux) {
        ArrayList list = new ArrayList();
        for (ItemPedido i : aux.getItemPedido()) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("F_ID_PRODUTO", i.getProduto().getIdentificador());
            h.put("F_NOME_PRODUTO", i.getProduto().getNome());
            h.put("F_QUANTIDADE_ITEM", i.getQuantidadeTotal());
            h.put("F_VALOR_UNITARIO", i.getValorUnitario());
            h.put("F_VALOR_TOTAL", i.getValorTotal());
            h.put("F_VALOR_PEDIDO_DESC_TRIB", i.getValorTotalDescTrib());
            h.put("F_UNIDADE_MEDIDA", i.getProduto().getUnidadeMedida().getSigla());
            h.put("F_REPRESENTANTE", i.getPedido().getRepresentante().getPessoa().getNome());
            h.put("F_CODIGO_AUXILIAR", i.getProduto().getCodigoAuxiliar());
            list.add(h);
        }
        return list;
    }

    private List getInfPagamentoPedido(Pedido aux) {
        ArrayList list = new ArrayList();
        for (InfPagamentoPedido i : aux.getInfPagamentoPedido()) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("F_FORMA_PAGAMENTO", i.getCondicoesPagamento().getNome());
            h.put("F_VALOR", i.getValorLiquido());
            list.add(h);
        }
        return list;
    }

    private List getInfPagamentoPedidoTitulos(Pedido aux) {
        ArrayList list = new ArrayList();
        for (InfPagamentoPedido i : aux.getInfPagamentoPedido()) {
            for (PedidoTitulo t : i.getTitulos()) {
                HashMap<String, Serializable> h = new HashMap<String, Serializable>();
                h.put("F_ID_TITULO", t.getIdentificador());
                h.put("F_VALOR", t.getValor());
                h.put("F_DATA_VENCIMENTO", t.getDataVencimento());
                list.add(h);
            }
        }
        return list;
    }

    private Short getTipoPedido(Pedido pedido) {
        if (ToolMethods.isEquals((Object)pedido.getSituacaoPedidos().getGerarFinanceiroNFCe(), (Object)1) && ToolMethods.isEquals((Object)pedido.getSituacaoPedidos().getBloqueioReservaEstoque(), (Object)0)) {
            return (short)0;
        }
        if (ToolMethods.isEquals((Object)pedido.getSituacaoPedidos().getGerarFinanceiroNFCe(), (Object)1) && ToolMethods.isEquals((Object)pedido.getSituacaoPedidos().getBloqueioReservaEstoque(), (Object)1)) {
            return (short)2;
        }
        return (short)1;
    }

    private byte[] getBytesImage() {
        byte[] img = null;
        img = StaticObjects.getOpcoes().getLogoNfce() == null ? PrintPreVendaTermica.criarImagem() : StaticObjects.getOpcoes().getLogoNfce();
        return img;
    }

    private static byte[] criarImagem() {
        try {
            File f = new File("/imagens/icone_touch_nfce.ico");
            if (!f.exists()) {
                f = new File("img.png");
            }
            if (!f.exists()) {
                int width = 200;
                int height = 200;
                BufferedImage buffer = new BufferedImage(width, height, 1);
                Graphics2D g = buffer.createGraphics();
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, width, height);
                g.setColor(Color.BLACK);
                ImageIO.write((RenderedImage)buffer, "png", new File("img.png"));
            }
            return ToolFile.getBytesFromFile((File)f);
        }
        catch (ExceptionIO | IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private String getInscricaoEstadual() {
        if (StaticObjects.getEmpresa().getPessoa().getComplemento() == null) {
            return "";
        }
        if (StaticObjects.getEmpresa().getPessoa().getComplemento().getInscEst() != null && !StaticObjects.getEmpresa().getPessoa().getComplemento().getInscEst().equalsIgnoreCase("ISENTO")) {
            return ToolFormatter.formatIE((String)StaticObjects.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla(), (String)StaticObjects.getEmpresa().getPessoa().getComplemento().getInscEst());
        }
        return StaticObjects.getEmpresa().getPessoa().getComplemento().getInscEst();
    }

    private String getFormattedCNPJ(String cnpj) {
        if (cnpj == null) {
            return "";
        }
        return ToolFormatter.formatCNPJCPF((String)cnpj);
    }
}

