/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.properties;

import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.touchnfce.properties.PropertiesLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ConfPropertiesLoader {
    private static final String ULTIMA_OTIMIZACAO_BANCO = "ultima.otimizacao.banco";
    private static String VERSAO_APP = "versao.app";
    private Properties props;
    public static String LAST_LOGIN = "last.login";
    public static String FILE_NAME = "configuration.properties";
    public static String FULL_SCREEN = "fullScreen";
    private String HEIGTH_MENU = "height.menu";
    private String WIDTH_MENU = "width.menu";
    private String X_MENU = "x.menu";
    private String Y_MENU = "y.menu";
    private String HEIGTH_ABASTECIMENTO = "height.abastecimento";
    private String WIDTH_ABASTECIMENTO = "width.abastecimento";
    private String X_ABASTECIMENTO = "x.abastecimento";
    private String Y_ABASTECIMENTO = "y.abastecimento";
    private String INF_TIPO_MEDICAMENTO = "inf.tipo.medicamento";
    private String PINPAD_NAO_SUPORTA_QRCODE = "pinpad.nao.suporta.qrcode";
    private String PORTA_CONSULTA_PRECO = "porta.consulta.preco";
    private String POSSUI_CONSULTA_PRECO = "possui.consulta.preco";
    private String TEMPO_DURACAO_CONSULTA_PRECO = "tempo.duracao.consulta.preco";
    private String TAMANHO_CARACTER_MSG_LINHA_CONSULTA_PRECO = "tamanho.caracter.msg.linha.consulta.preco";
    private static ConfPropertiesLoader instance;
    private static TLogger logger;

    private ConfPropertiesLoader() {
        try {
            this.props = new Properties();
            File f = new File(FILE_NAME);
            if (!f.exists()) {
                FileOutputStream fout = new FileOutputStream(f);
                fout.flush();
                fout.close();
            }
            FileInputStream in = new FileInputStream(f);
            this.props.load(in);
            ((InputStream)in).close();
        }
        catch (IOException ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static synchronized ConfPropertiesLoader get() {
        if (instance == null) {
            instance = new ConfPropertiesLoader();
        }
        return instance;
    }

    public void adicionaProperties(String chave, String valor) {
        try {
            FileOutputStream out = new FileOutputStream(FILE_NAME);
            this.props.setProperty(chave, valor);
            this.props.store(out, null);
            out.close();
        }
        catch (IOException ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public String getLastLogin() {
        if (this.props.getProperty(LAST_LOGIN) == null || this.props.getProperty(LAST_LOGIN).equals("")) {
            this.adicionaProperties(LAST_LOGIN, "admin");
        }
        return this.props.getProperty(LAST_LOGIN);
    }

    public String getVersaoApp() {
        if (this.props.getProperty(VERSAO_APP) == null || this.props.getProperty(VERSAO_APP).equals("")) {
            this.adicionaProperties(VERSAO_APP, "1.0");
        }
        return this.props.getProperty(VERSAO_APP);
    }

    public boolean getIsFullScreen() {
        if (this.props.getProperty(FULL_SCREEN) == null || this.props.getProperty(FULL_SCREEN).equals("")) {
            this.adicionaProperties(FULL_SCREEN, "true");
        }
        return Boolean.valueOf(this.props.getProperty(FULL_SCREEN));
    }

    public Double getHeigthMenuScreen() {
        if (this.props.getProperty(this.HEIGTH_MENU) == null || this.props.getProperty(this.HEIGTH_MENU).equals("")) {
            return 700.0;
        }
        return new Double(this.props.getProperty(this.HEIGTH_MENU));
    }

    public Double getHeigthAbastecimentoScreen() {
        if (this.props.getProperty(this.HEIGTH_ABASTECIMENTO) == null || this.props.getProperty(this.HEIGTH_ABASTECIMENTO).equals("")) {
            return 700.0;
        }
        return new Double(this.props.getProperty(this.HEIGTH_ABASTECIMENTO));
    }

    public Double getWidthMenuScreen() {
        if (this.props.getProperty(this.WIDTH_MENU) == null || this.props.getProperty(this.WIDTH_MENU).equals("")) {
            return 700.0;
        }
        return new Double(this.props.getProperty(this.WIDTH_MENU));
    }

    public Double getWidthAbastecimentoScreen() {
        if (this.props.getProperty(this.WIDTH_ABASTECIMENTO) == null || this.props.getProperty(this.WIDTH_ABASTECIMENTO).equals("")) {
            return 300.0;
        }
        return new Double(this.props.getProperty(this.WIDTH_ABASTECIMENTO));
    }

    public Double getXAbastecimentoScreen() {
        block3: {
            block2: {
                if (this.props.getProperty(this.X_ABASTECIMENTO) == null || this.props.getProperty(this.X_ABASTECIMENTO).equals("")) break block2;
                Double d = new Double(this.props.getProperty(this.X_ABASTECIMENTO));
                if (!(d < 0.0)) break block3;
            }
            return 0.0;
        }
        return new Double(this.props.getProperty(this.X_ABASTECIMENTO));
    }

    public Double getYAbastecimentoScreen() {
        block3: {
            block2: {
                if (this.props.getProperty(this.Y_ABASTECIMENTO) == null || this.props.getProperty(this.Y_ABASTECIMENTO).equals("")) break block2;
                Double d = new Double(this.props.getProperty(this.Y_ABASTECIMENTO));
                if (!(d < 0.0)) break block3;
            }
            return 0.0;
        }
        return new Double(this.props.getProperty(this.Y_ABASTECIMENTO));
    }

    public Double getXMenuScreen() {
        block3: {
            block2: {
                if (this.props.getProperty(this.X_MENU) == null || this.props.getProperty(this.X_MENU).equals("")) break block2;
                Double d = new Double(this.props.getProperty(this.X_MENU));
                if (!(d < 0.0)) break block3;
            }
            return 0.0;
        }
        return new Double(this.props.getProperty(this.X_MENU));
    }

    public Double getYMenuScreen() {
        block3: {
            block2: {
                if (this.props.getProperty(this.Y_MENU) == null || this.props.getProperty(this.Y_MENU).equals("")) break block2;
                Double d = new Double(this.props.getProperty(this.Y_MENU));
                if (!(d < 0.0)) break block3;
            }
            return 0.0;
        }
        return new Double(this.props.getProperty(this.Y_MENU));
    }

    public void setHeigthMenuScreen(double value) {
        this.adicionaProperties(this.HEIGTH_MENU, String.valueOf(value));
    }

    public void setHeigthAbastecimentoScreen(double value) {
        this.adicionaProperties(this.HEIGTH_ABASTECIMENTO, String.valueOf(value));
    }

    public void setWidthMenuScreen(double value) {
        this.adicionaProperties(this.WIDTH_MENU, String.valueOf(value));
    }

    public void setWidthAbastecimentoScreen(double value) {
        this.adicionaProperties(this.WIDTH_ABASTECIMENTO, String.valueOf(value));
    }

    public void setXAbastecimentoScreen(double value) {
        this.adicionaProperties(this.X_ABASTECIMENTO, String.valueOf(value));
    }

    public void setYAbastecimentoScreen(double value) {
        this.adicionaProperties(this.Y_ABASTECIMENTO, String.valueOf(value));
    }

    public void setXMenuScreen(double value) {
        this.adicionaProperties(this.X_MENU, String.valueOf(value));
    }

    public void setYMenuScreen(double value) {
        this.adicionaProperties(this.Y_MENU, String.valueOf(value));
    }

    public String getLastOtimizacaoBanco() {
        return this.props.getProperty(ULTIMA_OTIMIZACAO_BANCO);
    }

    public void setLastOtimizacaoBanco(String dateToStr) {
        this.adicionaProperties(ULTIMA_OTIMIZACAO_BANCO, dateToStr);
    }

    public String getInfTipoMedicamento() {
        return this.props.getProperty(this.INF_TIPO_MEDICAMENTO);
    }

    public void setInfTipoMedicamento(String infTipoMedicamento) {
        this.adicionaProperties(this.INF_TIPO_MEDICAMENTO, infTipoMedicamento);
    }

    public String getPinpadNaoSuportaQrcode() {
        return this.props.getProperty(this.PINPAD_NAO_SUPORTA_QRCODE);
    }

    public void setPinpadNaoSuportaQrcode(String pinpadNaoSuportaQrcode) {
        this.adicionaProperties(this.PINPAD_NAO_SUPORTA_QRCODE, pinpadNaoSuportaQrcode);
    }

    public String getPortaConsultaPreco() {
        return this.props.getProperty(this.PORTA_CONSULTA_PRECO);
    }

    public void setPortaConsultaPreco(String portaConsultaPreco) {
        this.adicionaProperties(this.PORTA_CONSULTA_PRECO, portaConsultaPreco);
    }

    public String getPossuiConsultaPreco() {
        return this.props.getProperty(this.POSSUI_CONSULTA_PRECO);
    }

    public void setPossuiConsultaPreco(String possuiConsultaPreco) {
        this.adicionaProperties(this.POSSUI_CONSULTA_PRECO, possuiConsultaPreco);
    }

    public int getTempoDuracaoConsultaPreco() {
        String str = this.props.getProperty(this.TEMPO_DURACAO_CONSULTA_PRECO);
        if (TString.isAIntNumber((String)str)) {
            return Integer.parseInt(str);
        }
        return 0;
    }

    public void setTempoDuracaoConsultaPreco(int tempoDuracaoConsultaPreco) {
        this.adicionaProperties(this.TEMPO_DURACAO_CONSULTA_PRECO, String.valueOf(tempoDuracaoConsultaPreco));
    }

    public int getTamanhoCaracterMsgLinhaConsultaPreco() {
        String str = this.props.getProperty(this.TAMANHO_CARACTER_MSG_LINHA_CONSULTA_PRECO);
        if (TString.isAIntNumber((String)str)) {
            return Integer.parseInt(str);
        }
        return 0;
    }

    public void setTamanhoCaracterMsgLinhaConsultaPreco(int tamanhoCaracterMsgLinhaConsultaPreco) {
        this.adicionaProperties(this.TAMANHO_CARACTER_MSG_LINHA_CONSULTA_PRECO, String.valueOf(tamanhoCaracterMsgLinhaConsultaPreco));
    }

    static {
        logger = TLogger.get(PropertiesLoader.class);
    }
}

