/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.properties;

import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class PropertiesBD {
    private String FILE_NAME = "update_properties.xml";
    private static PropertiesBD instance;
    private static TLogger logger;
    private String SHOW_SQL = "show.sql";
    private String URL_DATABASE = "url.database";
    private String FORMAT_SQL = "format.sql";
    private String SINC_DATA = "sinc.data";
    private static final String DEFAULT_URL = "jdbc:firebirdsql://HOST:PORTA/ALIAS?lc_ctype=ISO8859_1";
    private String HOST = "servidor";
    private String PORTA = "porta";
    private String NFCE_BD_ALIAS = "nfce";

    private void addProperties(String key, String value) {
        Element root = this.getRootElement();
        Element e = root.getChild(key);
        if (e == null) {
            e = new Element(key);
            root.addContent((Content)e);
        }
        e.setText(value);
        this.gravarArquivo(root);
    }

    private String getProperty(String name) {
        Element root = this.getRootElement();
        Element child = root.getChild(name);
        String value = null;
        if (child != null) {
            value = child.getText();
        }
        return value;
    }

    private Element getRootElement() {
        Element r = new Element("properties");
        try {
            File f = new File(this.FILE_NAME);
            if (f.exists()) {
                SAXBuilder sb = new SAXBuilder();
                Document d = sb.build(f);
                r = d.getRootElement();
            } else {
                FileOutputStream out = new FileOutputStream(f);
                Document d = new Document();
                Element root = new Element("properties");
                d.setRootElement(root);
                XMLOutputter xout = new XMLOutputter();
                xout.output(d, (OutputStream)out);
            }
        }
        catch (JDOMException ex) {
            logger.error((Throwable)ex);
        }
        catch (IOException ex) {
            logger.error((Throwable)ex);
        }
        if (r == null) {
            r = new Element("properties");
        }
        return r;
    }

    private void gravarArquivo(Element root) {
        try {
            XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
            root = root.detach();
            Document d = new Document(root);
            xout.output(d, (OutputStream)new FileOutputStream(new File(this.FILE_NAME)));
        }
        catch (IOException ex) {
            logger.error((Throwable)ex);
        }
    }

    public static synchronized PropertiesBD get() {
        if (instance == null) {
            instance = new PropertiesBD();
        }
        return instance;
    }

    public String getShowSql() {
        return this.getProperty(this.SHOW_SQL);
    }

    public String getFormatSql() {
        return this.getProperty(this.FORMAT_SQL);
    }

    public String getSincData() {
        return this.getProperty(this.SINC_DATA);
    }

    public String getURLDatabase() {
        String host = this.getProperty(this.HOST);
        String porta = this.getProperty(this.PORTA);
        if (!ToolMethods.isStrWithData((String)host)) {
            host = "localhost";
        }
        if (!ToolMethods.isStrWithData((String)porta)) {
            porta = "3052";
        }
        return this.build(host, Integer.valueOf(porta), this.NFCE_BD_ALIAS);
    }

    public String getPort() {
        return this.getProperty(this.PORTA);
    }

    public String getHost() {
        return this.getProperty(this.HOST);
    }

    public String getUser() {
        return "SYSDBA";
    }

    public String getPass() {
        return "masterkey";
    }

    public void setPort(String porta) {
        this.addProperties(this.PORTA, porta);
    }

    public void setHost(String host) {
        this.addProperties(this.HOST, host);
    }

    private String build(String host, Integer port, String alias) {
        if (!TMethods.isStrWithData((String)alias)) {
            return DEFAULT_URL;
        }
        return DEFAULT_URL.replaceAll("HOST", host).replaceAll("PORTA", String.valueOf(port)).replaceAll("ALIAS", alias);
    }

    static {
        logger = TLogger.get(PropertiesBD.class);
    }
}

