/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.repo.impl.nfce;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeCaixa;
import com.touchcomp.touchnfce.model.NFCeCancelamento;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.repo.impl.nfce.RepoCustomNFCe;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

public class RepoCustomNFCeImpl
implements RepoCustomNFCe {
    @PersistenceContext
    private EntityManager em;

    @Override
    public List<? extends NFCe> getNotasComInconsistencias(NFCeCaixa nfCeCaixa) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery crit = builder.createQuery(NFCe.class);
        Root itemRoot = crit.from(NFCe.class);
        Join jCont = itemRoot.join("nfCeControleCaixa");
        EnumConstNFeStatus[] finalStatus = EnumConstNFeStatus.getStatusFinal();
        ArrayList<Predicate> aux = new ArrayList<Predicate>();
        for (EnumConstNFeStatus st : finalStatus) {
            aux.add(builder.and(new Predicate[]{builder.notEqual((Expression)itemRoot.get("status"), (Object)st.getValue())}));
        }
        aux.add(builder.and(new Predicate[]{builder.equal((Expression)jCont.get("nFCeCaixa"), (Object)nfCeCaixa)}));
        crit.where(aux.toArray(new Predicate[0]));
        return this.em.createQuery(crit).getResultList();
    }

    @Override
    public List<? extends NFCe> getNotas(NFCeControleCaixa nfceControleCaixa) {
        Query query = this.em.createQuery("SELECT nf FROM " + NFCe.class.getCanonicalName() + " nf WHERE nf.nfCeControleCaixa = :nfceControleCaixa ORDER BY nf.numero");
        query.setParameter("nfceControleCaixa", (Object)nfceControleCaixa);
        return query.getResultList();
    }

    @Override
    public NFCe getUltimaNFCeAbertaSemEnvio(NFCeCaixa nfCeCaixa) {
        EnumConstNFeStatus[] finalStatus = EnumConstNFeStatus.getStatusFinal();
        String hql = "select nf from " + NFCe.class.getCanonicalName() + " nf inner join nf.nfCeCaixa caixa left join nf.nfCeCancelamento canc  where canc.identificador is null and caixa=:nfeCaixa and (";
        int tamanho = finalStatus.length;
        int cont = 1;
        for (EnumConstNFeStatus st : finalStatus) {
            hql = cont != tamanho ? hql + "nf.status <> " + st.getValue() + " and " : hql + "nf.status <> " + st.getValue() + ") ";
            ++cont;
        }
        hql = hql + " and (nf.status = " + EnumConstNFeStatus.NFCE_CRIADA_NAO_ENV.getValue() + ")";
        hql = hql + " order by  nf.identificador desc";
        Query query = this.em.createQuery(hql);
        query.setParameter("nfeCaixa", (Object)nfCeCaixa);
        query.setMaxResults(1);
        List lista = query.getResultList();
        if (lista != null && !lista.isEmpty()) {
            return (NFCe)lista.get(0);
        }
        return null;
    }

    @Override
    public List<? extends NFCe> getNotasByStatus(String aux, Empresa e, NFCeCaixa nfCeCaixa) {
        Query query = this.em.createQuery("select nf from " + NFCe.class.getCanonicalName() + " nf inner join nf.nfCeCaixa caixa left join nf.empresa emp where nf.status=:STATUS and emp.identificador=:ID_EMPRESA and caixa=:nfeCaixa order by nf.numero");
        query.setParameter("STATUS", (Object)new Integer(aux));
        query.setParameter("ID_EMPRESA", (Object)e.getIdentificador());
        query.setParameter("nfeCaixa", (Object)nfCeCaixa);
        return query.getResultList();
    }

    @Override
    public List<? extends NFCe> getNotasByValor(String aux, Empresa e, NFCeCaixa nfCeCaixa) {
        Query query = this.em.createQuery("select nf from " + NFCe.class.getCanonicalName() + " nf inner join nf.nfCeCaixa caixa left join nf.empresa emp left join nf.totalizadores tot where tot.valorTotalNFe=:VALOR_TOT and  emp.identificador=:ID_EMPRESA caixa.identificador=:ID_NFCE_CAIXA order by nf.numero");
        query.setParameter("VALOR_TOT", (Object)new Double(aux));
        query.setParameter("ID_EMPRESA", (Object)e.getIdentificador());
        query.setParameter("ID_NFCE_CAIXA", (Object)nfCeCaixa.getIdentificador());
        return query.getResultList();
    }

    @Override
    public List<? extends NFCe> getNotasByMotivo(String aux, Empresa e, NFCeCaixa nfCeCaixa) {
        String text = "select nf from " + NFCeCancelamento.class.getCanonicalName() + " nfCanc left join nfCanc.nfce nf inner join nf.nfCeCaixa caixa left join nf.empresa emp where lower(nfCanc.justificativa) LIKE lower('%" + aux + "%') and emp.identificador=" + e.getIdentificador() + " and caixa=:nfeCaixa order by nf.numero";
        Query query = this.em.createQuery(text);
        query.setParameter("nfeCaixa", (Object)nfCeCaixa);
        return query.getResultList();
    }

    @Override
    public List<? extends NFCe> getNotasByCliente(String aux, Empresa e, NFCeCaixa nfCeCaixa) {
        String text = "select nf from " + NFCe.class.getCanonicalName() + " nf inner join nf.nfCeCaixa caixa left join nf.empresa emp left join nf.unidadeFatCliente uniFat left join nf.nfCeConsumidor nfCon left join uniFat.cliente cli left join cli.pessoa pes where lower(pes.nome) LIKE lower('%" + aux + "%') or lower(nfCon.nome) LIKE lower('%" + aux + "%') and emp.identificador=" + e.getIdentificador() + " and caixa=:nfeCaixa order by nf.numero";
        Query query = this.em.createQuery(text);
        query.setParameter("nfeCaixa", (Object)nfCeCaixa);
        return query.getResultList();
    }

    @Override
    public List<? extends NFCe> getNotasByDate(Date aux, Empresa e, NFCeCaixa nfCeCaixa) {
        Query query = this.em.createQuery("select nf from " + NFCe.class.getCanonicalName() + " nf inner join nf.nfCeCaixa caixa left join nf.empresa emp where cast(nf.dataEmissao as date)= :DATA and emp.identificador=:EMPRESA and caixa=:nfeCaixa order by nf.numero");
        query.setParameter("DATA", (Object)aux);
        query.setParameter("EMPRESA", (Object)e.getIdentificador());
        query.setParameter("nfeCaixa", (Object)nfCeCaixa);
        return query.getResultList();
    }
}

