/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.repo.impl.nfcecontrolecaixa;

import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoMovimentoCaixa;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoPagNFe;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.model.NFCeControleCaixaRes;
import com.touchcomp.touchnfce.model.TipoPagamentoNFe;
import com.touchcomp.touchnfce.repo.impl.RepoTipoPagamentoNFe;
import com.touchcomp.touchnfce.repo.impl.nfce.RepoNFCe;
import com.touchcomp.touchnfce.repo.impl.nfcecontrolecaixa.RepoCustomNFCeControleCaixa;
import com.touchcomp.touchnfce.repo.impl.nfcemovimentocaixa.RepoNFCeMovimentoCaixa;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;

public class RepoCustomNFCeControleCaixaImpl
implements RepoCustomNFCeControleCaixa {
    @Autowired
    private RepoNFCe repoNFCe;
    @Autowired
    private RepoNFCeMovimentoCaixa repoNFCeMovimentoCaixa;
    @Autowired
    private RepoTipoPagamentoNFe tipoPagamentoNFe;
    @PersistenceContext
    private EntityManager em;

    @Override
    public NFCeControleCaixa fecharValoresControleCaixa(NFCeControleCaixa controleCaixa) {
        List<Object[]> data = this.repoNFCe.getResumoPagamentosCaixa(controleCaixa);
        double valorTotalRec = 0.0;
        double valorTotalRecDin = 0.0;
        for (Object[] ob : data) {
            Long idTpPag = (Long)ob[0];
            Double valor = (Double)ob[1];
            Double valorTroco = (Double)ob[2];
            Double valorLiquido = (Double)ob[3];
            NFCeControleCaixaRes res = new NFCeControleCaixaRes();
            res.setNfCeControleCaixa(controleCaixa);
            res.setTipoPagamentoNFe((TipoPagamentoNFe)this.tipoPagamentoNFe.getOne(idTpPag));
            res.setValorRecebido(valor);
            res.setValorLiquido(valorLiquido);
            res.setValorLiquidoInf(valorLiquido);
            res.setValorTroco(valorTroco);
            controleCaixa.getResumoRecebimentos().add(res);
            if (res.getTipoPagamentoNFe().getCodigo().equalsIgnoreCase(EnumConstNFeTipoPagNFe.DINHEIRO.getCodigo())) {
                valorTotalRecDin += res.getValorLiquido().doubleValue();
            }
            if (res.getTipoPagamentoNFe().getCodigo().equalsIgnoreCase(EnumConstNFeTipoPagNFe.SEM_PAGAMENTO.getCodigo())) continue;
            valorTotalRec += res.getValorLiquido().doubleValue();
        }
        Double totalEntradas = this.repoNFCeMovimentoCaixa.getTotal(controleCaixa, EnumConstNFCeTipoMovimentoCaixa.ENTRADA_SUPRIMENTO.getValue());
        Double totalSaidas = this.repoNFCeMovimentoCaixa.getTotal(controleCaixa, EnumConstNFCeTipoMovimentoCaixa.SAIDA_SANGRIA.getValue());
        controleCaixa.setValorTotalSistema(valorTotalRec);
        controleCaixa.setValorTotalSaidasMov(totalSaidas);
        controleCaixa.setValorTotalEntradasMov(totalEntradas);
        controleCaixa.setValorTotalSistema(controleCaixa.getValorRemanescenteCaixaAnterior() + valorTotalRec + totalEntradas - totalSaidas);
        controleCaixa.setValorTotalSistemaDinh(controleCaixa.getValorRemanescenteCaixaAnterior() + valorTotalRecDin + totalEntradas - totalSaidas);
        controleCaixa.setValorSaidaCaixaFechamento(controleCaixa.getValorTotalSistemaDinh());
        return controleCaixa;
    }

    @Override
    public List<NFCeControleCaixa> getUltimosMovimentos() {
        String q = "select p from " + NFCeControleCaixa.class.getCanonicalName() + " p where p.dataFechamento is not null order by p.identificador desc";
        Query query = this.em.createQuery(q);
        return query.setMaxResults(50).getResultList();
    }
}

