/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.repo.impl.tabelaprecobaseproduto;

import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.Produto;
import com.touchcomp.touchnfce.model.TabelaPrecoBase;
import com.touchcomp.touchnfce.model.TabelaPrecoBaseProduto;
import com.touchcomp.touchnfce.modeltemp.TempPesquisaProduto;
import com.touchcomp.touchnfce.repo.impl.tabelaprecobaseproduto.RepoCustomTabelaPrecoBaseProduto;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

public class RepoCustomTabelaPrecoBaseProdutoImpl
implements RepoCustomTabelaPrecoBaseProduto {
    @PersistenceContext
    private EntityManager em;

    public List<Long> getIDTabelaPrecoAndTabPrecoVinculada(Empresa empresa, TabelaPrecoBase taBase) {
        String str = "select distinct tbp.identificador as ID_TAB_PRECO,  v.identificador as ID_TAB_PRECO_VINC from " + TabelaPrecoBase.class.getCanonicalName() + " tbp inner join tbp.empresa e left join tbp.tabelaPrecoVinculada v where e = :empresa and :dataConsulta between tbp.dataInicial and tbp.dataFinal";
        if (taBase != null) {
            str = str + " and tbp = :tabBase";
        }
        Query query = this.em.createQuery(str);
        query.setParameter("empresa", (Object)empresa);
        query.setParameter("dataConsulta", (Object)new Date());
        if (taBase != null) {
            query.setParameter("tabBase", (Object)taBase);
        }
        List data = query.getResultList();
        LinkedList<Long> aux = new LinkedList<Long>();
        for (Object[] obj : data) {
            Long idTab = (Long)obj[0];
            Long idTabVinc = (Long)obj[1];
            if (idTab != null) {
                aux.add(idTab);
            }
            if (idTabVinc == null) continue;
            aux.add(idTabVinc);
        }
        return aux;
    }

    @Override
    public List<? extends TempPesquisaProduto> getTabelaPrecoBaseId(Long idProd, Empresa empresa, TabelaPrecoBase taBase) {
        List<Long> idTabelas = this.getIDTabelaPrecoAndTabPrecoVinculada(empresa, taBase);
        LinkedList<TempPesquisaProduto> aux = new LinkedList<TempPesquisaProduto>();
        for (Long idTabela : idTabelas) {
            Query query = this.em.createQuery("select tbp.valorVenda as VALOR_VENDA, tbp.percComissaoPadrao as PERC_COMISSAO, gc.identificador as ID_GRADE_COR, cr.nome as GRADE, p.codigoAuxiliar as CODIGO_AUXILIAR, p.identificador as ID_PRODUTO, p.nome as NOME, um.sigla as UNIDADE_MEDIDA, p.qtdeNaoFracionada as QTD_NAO_FRACIONADA, p.qtdMinVenda as QTD_MIN_VENDA, p.qtdMaxVenda as QTD_MAX_VENDA, tbp.valorCusto as VALOR_CUSTO,  cb.codigoBarras as CODIGO_BARRAS,  tbp.percentualDescTrib as PERC_DESC_TRIB,  tbp.valorMinimo as VALOR_MINIMO, tbp.valorMaximo as VALOR_MAXIMO from " + TabelaPrecoBaseProduto.class.getCanonicalName() + " tbp left join tbp.produto p left join p.unidadeMedida um left join tbp.tabelaPrecoBase tb left join tb.empresa e left join p.codigoBarras cb left join p.produtoGrade pg left join pg.gradesCores gc left join gc.cor cr where p.identificador=:idProduto and tb.identificador =:idTabela and p.ativo=:sim and tbp.ativo=:sim and (cb.identificador is null or (cb.identificador is not null and cb.ativo = :sim)) and :dataConsulta between tb.dataInicial and tb.dataFinal");
            query.setParameter("idProduto", (Object)idProd);
            query.setParameter("idTabela", (Object)idTabela);
            query.setParameter("sim", (Object)1);
            query.setParameter("dataConsulta", (Object)new Date());
            List data = query.getResultList();
            if (data.size() <= 0) continue;
            return this.convert(data, aux);
        }
        return new LinkedList();
    }

    @Override
    public List<? extends TempPesquisaProduto> getTabelaPrecoBaseCodBarras(String codBarras, Empresa empresa, TabelaPrecoBase taBase) {
        List<Long> idTabelas = this.getIDTabelaPrecoAndTabPrecoVinculada(empresa, taBase);
        LinkedList<TempPesquisaProduto> aux = new LinkedList<TempPesquisaProduto>();
        for (Long idTabela : idTabelas) {
            Query query = this.em.createQuery("select distinct tbp.valorVenda as VALOR_VENDA, tbp.percComissaoPadrao as PERC_COMISSAO, gc.identificador as ID_GRADE_COR, cr.nome as GRADE, p.codigoAuxiliar as CODIGO_AUXILIAR, p.identificador as ID_PRODUTO, p.nome as NOME, um.sigla as UNIDADE_MEDIDA, p.qtdeNaoFracionada as QTD_NAO_FRACIONADA, p.qtdMinVenda as QTD_MIN_VENDA, p.qtdMaxVenda as QTD_MAX_VENDA, tbp.valorCusto as VALOR_CUSTO,  cb.codigoBarras as CODIGO_BARRAS,  tbp.percentualDescTrib as PERC_DESC_TRIB,  tbp.valorMinimo as VALOR_MINIMO, tbp.valorMaximo as VALOR_MAXIMO from " + TabelaPrecoBaseProduto.class.getCanonicalName() + " tbp inner join tbp.produto p inner join p.unidadeMedida um inner join p.codigoBarras cb inner join tbp.tabelaPrecoBase tb inner join p.produtoGrade pg inner join pg.gradesCores gc inner join gc.cor cr where  :dataConsulta between tb.dataInicial and tb.dataFinal and cb.codigoBarras=:codBarras and tb.identificador =:idTabela and cb.ativo=:sim and p.ativo=:sim and tbp.ativo=:sim");
            query.setParameter("codBarras", (Object)codBarras);
            query.setParameter("idTabela", (Object)idTabela);
            query.setParameter("sim", (Object)1);
            query.setParameter("dataConsulta", (Object)new Date());
            List data = query.getResultList();
            this.convert(data, aux);
        }
        return aux;
    }

    @Override
    public List<? extends TempPesquisaProduto> getProdutoByTabelaPreco(Empresa empresa, TabelaPrecoBase taBase) {
        List<Long> idTabelas = this.getIDTabelaPrecoAndTabPrecoVinculada(empresa, taBase);
        LinkedList<TempPesquisaProduto> aux = new LinkedList<TempPesquisaProduto>();
        for (Long idTabela : idTabelas) {
            Query query = this.em.createQuery("select distinct tbp.valorVenda as VALOR_VENDA, tbp.percComissaoPadrao as PERC_COMISSAO, gc.identificador as ID_GRADE_COR, cr.nome as GRADE, p.codigoAuxiliar as CODIGO_AUXILIAR, p.identificador as ID_PRODUTO, p.nome as NOME, um.sigla as UNIDADE_MEDIDA, p.qtdeNaoFracionada as QTD_NAO_FRACIONADA, p.qtdMinVenda as QTD_MIN_VENDA, p.qtdMaxVenda as QTD_MAX_VENDA, tbp.valorCusto as VALOR_CUSTO,  cb.codigoBarras as CODIGO_BARRAS,  tbp.percentualDescTrib as PERC_DESC_TRIB,  tbp.valorMinimo as VALOR_MINIMO, tbp.valorMaximo as VALOR_MAXIMO from " + TabelaPrecoBaseProduto.class.getCanonicalName() + " tbp inner join tbp.produto p inner join p.unidadeMedida um inner join p.codigoBarras cb inner join tbp.tabelaPrecoBase tb inner join p.produtoGrade pg inner join pg.gradesCores gc inner join gc.cor cr where :dataConsulta between tb.dataInicial and tb.dataFinal and tb.identificador = :idTabelaPreco and p.ativo=:sim and (cb.identificador is null or (cb.identificador is not null and cb.ativo = :sim)) and tbp.ativo=:sim");
            query.setParameter("idTabelaPreco", (Object)idTabela);
            query.setParameter("sim", (Object)1);
            query.setParameter("dataConsulta", (Object)new Date());
            List data = query.getResultList();
            this.convert(data, aux);
        }
        return aux;
    }

    @Override
    public List<? extends TempPesquisaProduto> getTabelaPrecoBaseDescCodAux(String descricao, Empresa empresa, TabelaPrecoBase taBase, Integer nrRegistros, Integer page) {
        List<Long> idTabelas = this.getIDTabelaPrecoAndTabPrecoVinculada(empresa, taBase);
        LinkedList<TempPesquisaProduto> aux = new LinkedList<TempPesquisaProduto>();
        for (Long idTabela : idTabelas) {
            Query query = this.em.createQuery("select distinct tbp.valorVenda as VALOR_VENDA, tbp.percComissaoPadrao as PERC_COMISSAO, gc.identificador as ID_GRADE_COR, cr.nome as GRADE, p.codigoAuxiliar as CODIGO_AUXILIAR, p.identificador as ID_PRODUTO, p.nome as NOME, um.sigla as UNIDADE_MEDIDA, p.qtdeNaoFracionada as QTD_NAO_FRACIONADA, p.qtdMinVenda as QTD_MIN_VENDA, p.qtdMaxVenda as QTD_MAX_VENDA, tbp.valorCusto as VALOR_CUSTO,  cb.codigoBarras as CODIGO_BARRAS,  tbp.percentualDescTrib as PERC_DESC_TRIB,  tbp.valorMinimo as VALOR_MINIMO, tbp.valorMaximo as VALOR_MAXIMO from " + TabelaPrecoBaseProduto.class.getCanonicalName() + " tbp inner join tbp.produto p inner join p.unidadeMedida um inner join tbp.tabelaPrecoBase tb inner join p.produtoGrade pg left join pg.gradesCores gc left join gc.cor cr left join p.codigoBarras cb where (upper(p.nome) like :descricao or upper(p.codigoAuxiliar) = :codigoAuxiliar) and (:data_atual between tb.dataInicial and tb.dataFinal or tb.dataFinal is null) and tb.identificador =:idTabela  and (cb.identificador is null or (cb.identificador is not null and cb.ativo = :sim)) and p.ativo = :sim and tbp.ativo = :sim");
            Object temp = descricao;
            if (descricao.startsWith(" ")) {
                temp = descricao.substring(1);
                temp = "%" + (String)temp;
            }
            temp = (String)temp + "%";
            query.setParameter("descricao", (Object)((String)temp).toUpperCase());
            query.setParameter("codigoAuxiliar", (Object)descricao.toUpperCase());
            query.setParameter("idTabela", (Object)idTabela);
            query.setParameter("data_atual", (Object)new Date());
            query.setParameter("sim", (Object)1);
            if (ToolMethods.isWithData((Number)nrRegistros)) {
                query.setMaxResults(nrRegistros.intValue());
                if (ToolMethods.isWithData((Number)page)) {
                    query.setFirstResult((page - 1) * nrRegistros);
                }
            }
            List data = query.getResultList();
            this.convert(data, aux);
        }
        return aux;
    }

    private List<? extends TempPesquisaProduto> convert(List<Object[]> data, List<TempPesquisaProduto> temp) {
        for (Object[] ob : data) {
            Double valorVenda = (Double)ob[0];
            Double comissao = (Double)ob[1];
            Long idGradeCor = (Long)ob[2];
            String grade = (String)ob[3];
            String codAux = (String)ob[4];
            Long idProduto = (Long)ob[5];
            String nome = (String)ob[6];
            String unidade = (String)ob[7];
            Short qtdNaoFracionada = (Short)ob[8];
            Double qtdMin = (Double)ob[9];
            Double qtdMax = (Double)ob[10];
            Double precoCusto = (Double)ob[11];
            String codigoBarras = (String)ob[12];
            Double percentualDescTrib = (Double)ob[13];
            Double valorMinimo = (Double)ob[14];
            Double valorMaximo = (Double)ob[15];
            Optional<TempPesquisaProduto> found = temp.stream().filter(i -> ToolMethods.isEquals((Object)i.getIdGradeCor(), (Object)idGradeCor)).findFirst();
            if (found.isPresent()) continue;
            TempPesquisaProduto t = new TempPesquisaProduto();
            t.setIdGradeCor(idGradeCor);
            t.setGrade(grade);
            t.setCodAuxiliar(codAux);
            t.setIdProduto(idProduto);
            t.setNomeProduto(nome);
            t.setUnidadeMedida(unidade);
            t.setValorUnitario(valorVenda);
            t.setValorUnitarioTabPreco(valorVenda);
            t.setPrecoCusto(precoCusto);
            t.setPercComissao(comissao);
            t.setQtdNaoFracionada(qtdNaoFracionada);
            t.setQtdMinVenda(qtdMin);
            t.setQtdMaxVenda(qtdMax);
            t.setCodigoBarras(codigoBarras);
            t.setValorMinimo(valorMinimo);
            t.setValorMaximo(valorMaximo);
            t.setPercDescontoTrib(percentualDescTrib);
            if (ToolMethods.isWithData((Number)t.getPercDescontoTrib())) {
                t.setVlrUnitarioDescTrib(t.getValorUnitario() - t.getValorUnitario() * percentualDescTrib / 100.0);
            } else {
                t.setVlrUnitarioDescTrib(t.getValorUnitario());
            }
            temp.add(t);
        }
        return temp;
    }

    @Override
    public TabelaPrecoBaseProduto getTabelaPrecoBaseProd(TabelaPrecoBase tabelaPrecoBase, Produto produto) {
        TabelaPrecoBaseProduto t2;
        Object hql = "select b.identificador as ID_TAB_PRECO_BASE, tpv.identificador as ID_TAB_PRECO_BASE_VINC from TabelaPrecoBaseProduto t left join t.tabelaPrecoBase b left join b.tabelaPrecoVinculada tpv where b = :tabelaPrecoBase";
        hql = (String)hql + " order by b.identificador desc";
        Query q = this.em.createQuery((String)hql).setMaxResults(1).setParameter("tabelaPrecoBase", (Object)tabelaPrecoBase);
        q.setMaxResults(1);
        Object[] found = (Object[])q.getSingleResult();
        if (found == null) {
            return null;
        }
        Long idTab = (Long)found[0];
        Long idTabVinc = (Long)found[1];
        hql = "select t from TabelaPrecoBaseProduto t inner join t.tabelaPrecoBase b where t.produto=:produto  and t.ativo = :ativo and b.identificador=:idTab";
        q = this.em.createQuery((String)hql).setMaxResults(1).setParameter("produto", (Object)produto).setParameter("idTab", (Object)idTab).setParameter("ativo", (Object)1);
        try {
            t2 = (TabelaPrecoBaseProduto)q.getSingleResult();
            if (t2 != null) {
                return t2;
            }
        }
        catch (NoResultException t2) {
            // empty catch block
        }
        if (idTabVinc == null) {
            return null;
        }
        q.setParameter("idTab", (Object)idTabVinc);
        try {
            t2 = (TabelaPrecoBaseProduto)q.getSingleResult();
            if (t2 != null) {
                return t2;
            }
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return null;
    }
}

