/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.repo.impl.tabelaprecopromocoes;

import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.modeltemp.TempPesquisaProduto;
import com.touchcomp.touchnfce.repo.impl.tabelaprecopromocoes.RepoCustomTabelaPrecoPromocoes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

public class RepoCustomTabelaPrecoPromocoesImpl
implements RepoCustomTabelaPrecoPromocoes {
    @PersistenceContext
    private EntityManager em;

    @Override
    public List<? extends TempPesquisaProduto> getPesqTabPromocao(List<Long> produtos, Empresa empresa, Date dataAtual) {
        Query query = this.em.createQuery("select tbp.valorVenda as VALOR_VENDA, tbp.percComissao as PERC_COMISSAO, p.identificador as ID_PRODUTO, tbp.valorMinimo as VALOR_MINIMO, tbp.valorMaximo as VALOR_MAXIMO  from TabelaPrecoPromocoes tb  inner join tb.produtos tbp  inner join tbp.produto p inner join tb.empresas tbe inner join tbe.empresa e where  tb.dataInicial <=:dataAtual and tb.dataFinal >= :dataAtual and e.identificador = :idEmpresa and p.ativo=:sim and tbp.ativo=:sim and tbe.ativo=:sim and p.identificador in (:produtos)");
        query.setParameter("produtos", produtos);
        query.setParameter("idEmpresa", (Object)empresa.getIdentificador());
        query.setParameter("sim", (Object)1);
        query.setParameter("dataAtual", (Object)dataAtual);
        List data = query.getResultList();
        if (!data.isEmpty()) {
            return this.convert(data);
        }
        return new LinkedList();
    }

    private List<? extends TempPesquisaProduto> convert(List<Object[]> data) {
        ArrayList<TempPesquisaProduto> temp = new ArrayList<TempPesquisaProduto>();
        for (Object[] ob : data) {
            TempPesquisaProduto t = this.convert(ob);
            temp.add(t);
        }
        return temp;
    }

    private TempPesquisaProduto convert(Object[] ob) {
        Double valorVenda = (Double)ob[0];
        Double comissao = (Double)ob[1];
        Long idProduto = (Long)ob[2];
        Double valorMinimo = (Double)ob[3];
        Double valorMaximo = (Double)ob[4];
        TempPesquisaProduto t = new TempPesquisaProduto();
        t.setIdProduto(idProduto);
        t.setValorUnitario(valorVenda);
        t.setValorUnitarioTabPreco(valorVenda);
        t.setPercComissao(comissao);
        t.setValorMinimo(valorMinimo);
        t.setValorMaximo(valorMaximo);
        return t;
    }

    @Override
    public TempPesquisaProduto getPesqTabPromocao(Long produto, Empresa empresa, Date dataAtual, Double quantidade) {
        Query query = this.em.createQuery("select tbpq.valor as VALOR_VENDA, tbp.percComissao as PERC_COMISSAO, p.identificador as ID_PRODUTO, tbp.valorMinimo as VALOR_MINIMO, tbp.valorMaximo as VALOR_MAXIMO  from TabelaPrecoPromocoesProdQtd tbpq  inner join tbpq.tabelaPrecoPromocoesProd tbp  inner join tbp.tabelaPrecoPromocoes tb  inner join tbp.produto p inner join tb.empresas tbe inner join tbe.empresa e where  tb.dataInicial <=:dataAtual and tb.dataFinal >= :dataAtual and e.identificador = :idEmpresa and p.ativo=:sim and tbp.ativo=:sim and tbe.ativo=:sim and p.identificador=:produto and (:quantidade>=tbpq.quantidadeInicial and :quantidade<=tbpq.quantidadeFinal)");
        query.setParameter("produto", (Object)produto);
        query.setParameter("idEmpresa", (Object)empresa.getIdentificador());
        query.setParameter("sim", (Object)1);
        query.setParameter("dataAtual", (Object)dataAtual);
        query.setParameter("quantidade", (Object)quantidade);
        List data = query.getResultList();
        if (!data.isEmpty()) {
            return this.convert((Object[])data.getFirst());
        }
        return null;
    }

    @Override
    public TempPesquisaProduto getPesqTabPromocao(Long produto, Empresa empresa, Date dataAtual) {
        List<? extends TempPesquisaProduto> produtosPromocao = this.getPesqTabPromocao(Arrays.asList(produto), empresa, dataAtual);
        if (ToolMethods.isWithData(produtosPromocao)) {
            return produtosPromocao.getFirst();
        }
        return null;
    }
}

