/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.repo.impl.tabelaprecosdinamica;

import com.touchcomp.basementor.constants.enums.tabelaprecosdinamica.EnumTabelaPrecosDinamicaTipo;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.TabelaPrecosDinamica;
import com.touchcomp.touchnfce.model.TabelaPrecosDinamicaCond;
import com.touchcomp.touchnfce.repo.impl.tabelaprecosdinamica.RepoCustomTabelaPrecosDinamica;
import java.util.HashMap;
import java.util.LinkedList;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.hibernate.SessionFactory;

public class RepoCustomTabelaPrecosDinamicaImpl
implements RepoCustomTabelaPrecosDinamica {
    @PersistenceContext
    private EntityManager em;

    public SessionFactory getSessionFactory() {
        return Main.getBean(SessionFactory.class);
    }

    @Override
    public TabelaPrecosDinamicaCond getTabela(HashMap<EnumTabelaPrecosDinamicaTipo, Object> data, Empresa empresa, String parte, TabelaPrecosDinamica tabDin) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(TabelaPrecosDinamicaCond.class);
        Root root = cq.from(TabelaPrecosDinamicaCond.class);
        Join jTab = root.join("tabelaPrecoDinamica");
        Join jEmp = jTab.join("empresas");
        String[] aux = ToolString.splitString((String)parte, (char[])new char[0]);
        LinkedList<EnumTabelaPrecosDinamicaTipo> added = new LinkedList<EnumTabelaPrecosDinamicaTipo>();
        LinkedList<Predicate> predicates = new LinkedList<Predicate>();
        block21: for (String string : aux) {
            EnumTabelaPrecosDinamicaTipo temp = EnumTabelaPrecosDinamicaTipo.get((Object)string);
            Object entity = data.get(temp);
            added.add(temp);
            switch (temp) {
                case PESSOA_CLIENTE_1: {
                    predicates.add(cb.equal((Expression)root.get("pessoa"), entity));
                    continue block21;
                }
                case GRUPO_PESSOAS_CLIENTE_2: {
                    predicates.add(cb.equal((Expression)root.get("grupoPessoas"), entity));
                    continue block21;
                }
                case PESSOA_REPRESENTANTE_3: {
                    predicates.add(cb.equal((Expression)root.get("pessoa"), entity));
                    continue block21;
                }
                case GRUPO_PESSOAS_REPRESENTANTE_4: {
                    predicates.add(cb.equal((Expression)root.get("grupoPessoas"), entity));
                    continue block21;
                }
                case CLASSIFICACAO_CLIENTE_5: {
                    predicates.add(cb.equal((Expression)root.get("classificacaoClientes"), entity));
                    continue block21;
                }
                case CATEGORIA_CLIENTE_6: {
                    predicates.add(cb.equal((Expression)root.get("categoriaPessoa"), entity));
                    continue block21;
                }
                case REGIAO_TAB_PRECO_CLIENTE_7: {
                    predicates.add(cb.equal((Expression)root.get("regiaoTabPrecoDinamica"), entity));
                    continue block21;
                }
                case PRODUTO_8: {
                    Join jTabBase = root.join("tabelaPrecoBase");
                    Join jProds = jTabBase.join("produtos");
                    Join jTabBaseVinc = jTabBase.join("tabelaPrecoVinculada", JoinType.LEFT);
                    Join jTabBaseVincProds = jTabBaseVinc.join("produtos", JoinType.LEFT);
                    predicates.add(cb.or((Expression)cb.and((Expression)cb.equal((Expression)jProds.get("produto"), entity), (Expression)cb.equal((Expression)jProds.get("ativo"), (Object)1)), (Expression)cb.and((Expression)cb.equal((Expression)jTabBaseVincProds.get("produto"), entity), (Expression)cb.equal((Expression)jTabBaseVincProds.get("ativo"), (Object)1))));
                }
            }
        }
        block22: for (String string : EnumTabelaPrecosDinamicaTipo.values()) {
            if (added.contains(string)) continue;
            switch (1.$SwitchMap$com$touchcomp$basementor$constants$enums$tabelaprecosdinamica$EnumTabelaPrecosDinamicaTipo[string.ordinal()]) {
                case 1: {
                    if (added.contains(EnumTabelaPrecosDinamicaTipo.PESSOA_REPRESENTANTE_3)) continue block22;
                    predicates.add(cb.isNull((Expression)root.get("pessoa")));
                    continue block22;
                }
                case 2: {
                    if (added.contains(EnumTabelaPrecosDinamicaTipo.GRUPO_PESSOAS_CLIENTE_2)) continue block22;
                    predicates.add(cb.isNull((Expression)root.get("grupoPessoas")));
                    continue block22;
                }
                case 3: {
                    if (added.contains(EnumTabelaPrecosDinamicaTipo.PESSOA_CLIENTE_1)) continue block22;
                    predicates.add(cb.isNull((Expression)root.get("pessoa")));
                    continue block22;
                }
                case 4: {
                    if (added.contains(EnumTabelaPrecosDinamicaTipo.GRUPO_PESSOAS_REPRESENTANTE_4)) continue block22;
                    predicates.add(cb.isNull((Expression)root.get("grupoPessoas")));
                    continue block22;
                }
                case 5: {
                    predicates.add(cb.isNull((Expression)root.get("classificacaoClientes")));
                    continue block22;
                }
                case 6: {
                    predicates.add(cb.isNull((Expression)root.get("categoriaPessoa")));
                    continue block22;
                }
                case 7: {
                    predicates.add(cb.isNull((Expression)root.get("regiaoTabPrecoDinamica")));
                }
            }
        }
        predicates.add(cb.equal((Expression)root.get("ativo"), (Object)1));
        predicates.add(cb.equal((Expression)jEmp.get("empresa"), (Object)empresa));
        if (tabDin != null) {
            predicates.add(cb.equal((Expression)jTab, (Object)tabDin));
        }
        Predicate finalPredicate = cb.and(predicates.toArray(new Predicate[0]));
        cq.where((Expression)finalPredicate);
        cq.orderBy(new Order[]{cb.desc((Expression)root.get("identificador"))});
        try {
            return (TabelaPrecosDinamicaCond)this.em.createQuery(cq).setMaxResults(1).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }
}

