/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.scheduler;

import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.scheduler.SincEnvTask;
import com.touchcomp.touchnfce.scheduler.SincIncTask;
import com.touchcomp.touchnfce.scheduler.SincMsgCommandsNFCeRec;
import com.touchcomp.touchnfce.scheduler.SincRecTask;
import com.touchcomp.touchnfce.scheduler.TaskMsgCommandsNFCe;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class SchedulerUtil {
    private static final String GROUP_TASK = "main_group";
    private static SchedulerUtil instance;
    SchedulerFactory schedulerFactory = new StdSchedulerFactory();
    Scheduler scheduler;

    private SchedulerUtil() {
    }

    public static SchedulerUtil getInstance() {
        if (instance == null) {
            instance = new SchedulerUtil();
        }
        return instance;
    }

    public void buildAndStart() throws SchedulerException {
        this.scheduler = this.schedulerFactory.getScheduler();
        if (this.scheduler.isStarted()) {
            return;
        }
        this.scheduler.start();
        this.addTaskReceive();
        this.addTaskReceiveMsg();
        this.addTaskEnv();
        this.addTaskMsgNFCeCommands();
        this.addTaskInconsitencias();
    }

    private void addTaskReceive() throws SchedulerException {
        Integer time = null;
        if (StaticObjects.getDadosSincronizacao() == null || !ToolMethods.isEquals((Object)StaticObjects.getDadosSincronizacao().getSincronizadoCompeletamente(), (Object)1)) {
            return;
        }
        if ((time == null || time <= 0) && StaticObjects.getOpcoes() != null) {
            time = StaticObjects.getOpcoes().getTempoSegSincRec();
        }
        if (time == null || time <= 0) {
            time = 300;
        }
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("triggerreceive", GROUP_TASK).startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(time.intValue()).repeatForever()).build();
        JobDetail job = JobBuilder.newJob(SincRecTask.class).withIdentity(SincRecTask.TASK_NAME, GROUP_TASK).build();
        this.scheduler.scheduleJob(job, trigger);
    }

    private void addTaskReceiveMsg() throws SchedulerException {
        Integer time = null;
        if (StaticObjects.getDadosSincronizacao() == null || !ToolMethods.isEquals((Object)StaticObjects.getDadosSincronizacao().getSincronizadoCompeletamente(), (Object)1)) {
            return;
        }
        time = 180;
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("triggerreceivemsg", GROUP_TASK).startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(time.intValue()).repeatForever()).build();
        JobDetail job = JobBuilder.newJob(SincMsgCommandsNFCeRec.class).withIdentity(SincMsgCommandsNFCeRec.TASK_NAME, GROUP_TASK).build();
        this.scheduler.scheduleJob(job, trigger);
    }

    private void addTaskMsgNFCeCommands() throws SchedulerException {
        Integer time = null;
        if ((time == null || time <= 0) && StaticObjects.getOpcoes() != null) {
            time = StaticObjects.getOpcoes().getTempoSegSincRec();
        }
        if (time == null || time <= 0) {
            time = 300;
        }
        time = time / 2;
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("triggermsg", GROUP_TASK).startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(time.intValue()).repeatForever()).build();
        JobDetail job = JobBuilder.newJob(TaskMsgCommandsNFCe.class).withIdentity(TaskMsgCommandsNFCe.TASK_NAME, GROUP_TASK).build();
        this.scheduler.scheduleJob(job, trigger);
    }

    private void addTaskEnv() throws SchedulerException {
        Integer time = null;
        if ((time == null || time <= 0) && StaticObjects.getOpcoes() != null) {
            time = StaticObjects.getOpcoes().getTempoSegSincEnvio();
        }
        if (time == null || time <= 0) {
            time = 300;
        }
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("triggerenv", GROUP_TASK).startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(time.intValue()).repeatForever()).build();
        JobDetail job = JobBuilder.newJob(SincEnvTask.class).withIdentity(SincEnvTask.TASK_NAME, GROUP_TASK).build();
        this.scheduler.scheduleJob(job, trigger);
    }

    private void addTaskInconsitencias() throws SchedulerException {
        Integer time = null;
        if ((time == null || time <= 0) && StaticObjects.getOpcoes() != null) {
            time = StaticObjects.getOpcoes().getTempoSegSincInc();
        }
        if (time == null || time <= 0) {
            return;
        }
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("triggerinc", GROUP_TASK).startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(time.intValue()).repeatForever()).build();
        JobDetail job = JobBuilder.newJob(SincIncTask.class).withIdentity(SincIncTask.TASK_NAME, GROUP_TASK).build();
        this.scheduler.scheduleJob(job, trigger);
    }
}

