/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.scheduler;

import com.touchcomp.basementor.constants.enums.msgcomandosnfce.EnumConstMsgComandoNFCe;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.MsgComandosNFCe;
import com.touchcomp.touchnfce.model.NFCePeriodoEmissao;
import com.touchcomp.touchnfce.model.PeriodoEmissaoNFe;
import com.touchcomp.touchnfce.model.TipoEmissaoNFe;
import com.touchcomp.touchnfce.service.impl.ServiceMsgComandosNFCe;
import com.touchcomp.touchnfce.service.impl.ServiceTipoEmissaoNFe;
import com.touchcomp.touchnfce.utils.UtilDataSincCheck;
import com.touchcomp.touchnfce.utils.UtilNFCeSerial;
import com.touchcomp.touchnfce.utils.UtilPeriodoEmissao;
import com.touchcomp.touchvomodel.vo.msgcommandsnfce.nfce.impl.DTOMsgComForcarSaidaSistema;
import com.touchcomp.touchvomodel.vo.msgcommandsnfce.nfce.impl.DTOMsgComNFCePerEmissao;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

@DisallowConcurrentExecution
public class TaskMsgCommandsNFCe
implements StatefulJob {
    public static String TASK_NAME = "task_msg";
    private ServiceMsgComandosNFCe service = Main.getBean(ServiceMsgComandosNFCe.class);

    public synchronized void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        if (StaticObjects.getDadosSincronizacao().getAppConfigurado() != 1 || StaticObjects.getDadosSincronizacao().getSincronizadoCompeletamente() != 1) {
            return;
        }
        if (StaticObjects.getEmpresa() == null) {
            return;
        }
        this.checaDataPC();
        Date dataLimite = new Date();
        this.executarComandosMsgInformativa(dataLimite);
        this.mudarPeriodoNFCe(dataLimite);
        this.mudarPeriodoNFe(dataLimite);
        this.forcarSaidaSistema(dataLimite);
    }

    private void checaDataPC() {
        UtilDataSincCheck.checaDataPCVsUltSinc();
    }

    private void executarComandosMsgInformativa(Date dataLimite) {
        List<MsgComandosNFCe> commands = this.service.getCommandsToExecuteAsc(dataLimite, EnumConstMsgComandoNFCe.MENSAGEM_INFORMATIVA, StaticObjects.getEmpresa());
        for (MsgComandosNFCe msg : commands) {
            this.exibirMensagem(msg);
            this.salvarComandoExec(msg);
        }
    }

    private void mudarPeriodoNFCe(Date dataLimite) {
        List<MsgComandosNFCe> commands = this.service.getCommandsToExecuteDesc(dataLimite, EnumConstMsgComandoNFCe.MUDAR_PERIODO_NFCE, StaticObjects.getEmpresa());
        int i = 0;
        for (MsgComandosNFCe msg : commands) {
            if (i <= 0) {
                this.alterarPeriodoNFCe(msg);
            }
            this.salvarComandoExec(msg);
            ++i;
        }
    }

    private void mudarPeriodoNFe(Date dataLimite) {
        List<MsgComandosNFCe> commands = this.service.getCommandsToExecuteDesc(dataLimite, EnumConstMsgComandoNFCe.MUDAR_PERIODO_NFE, StaticObjects.getEmpresa());
        int i = 0;
        for (MsgComandosNFCe msg : commands) {
            if (i <= 0) {
                this.alterarPeriodoNFe(msg);
            }
            this.salvarComandoExec(msg);
            ++i;
        }
    }

    private void forcarSaidaSistema(Date dataLimite) {
        List<MsgComandosNFCe> commands = this.service.getCommandsToExecuteDesc(dataLimite, EnumConstMsgComandoNFCe.FORCAR_SAIDA_SISTEMA, StaticObjects.getEmpresa());
        int i = 0;
        for (MsgComandosNFCe msg : commands) {
            if (i <= 0) {
                this.forcarSaidaSistema(msg);
            }
            this.salvarComandoExec(msg);
            ++i;
        }
    }

    private void exibirMensagem(final MsgComandosNFCe command) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ToolMethods.isEquals((Object)command.getExibirUsuario(), (Object)1)) {
                    Alerts.showAlertInfo(command.getMensagem());
                }
            }
        });
    }

    private void exibirMensagem(final String msg, final Boolean exibirUsuario) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (exibirUsuario != null && exibirUsuario.booleanValue()) {
                    Alerts.showAlertInfo(msg);
                }
            }
        });
    }

    private void alterarPeriodoNFCe(MsgComandosNFCe command) {
        if (StaticObjects.getNFCeCaixa() == null) {
            return;
        }
        try {
            DTOMsgComNFCePerEmissao data = (DTOMsgComNFCePerEmissao)ToolJson.readJson((String)command.getInfoComando(), DTOMsgComNFCePerEmissao.class);
            ServiceTipoEmissaoNFe service = Main.getBean(ServiceTipoEmissaoNFe.class);
            TipoEmissaoNFe tipo = (TipoEmissaoNFe)service.get(data.getIdTipoEmissao());
            if (tipo != null) {
                NFCePeriodoEmissao per = new NFCePeriodoEmissao();
                per.setDataCadastro(new Date());
                per.setDataInicial(new Date());
                per.setDescricao(data.getMotivo());
                per.setNfCeCaixa(StaticObjects.getNFCeCaixa());
                per.setTipoEmissaoNfe(tipo);
                per.setSerialForSinc(UtilNFCeSerial.getSerial(StaticObjects.getNFCeCaixa()));
                StaticObjects.setPeriodoEmissaoNFCe(UtilPeriodoEmissao.savePeriodoEmissaoNFCe(per));
                Platform.runLater((Runnable)new Runnable(this){

                    @Override
                    public void run() {
                        Main.get().getFooterController().atualizaPeriodoEmissaoNFCe();
                    }
                });
            } else {
                this.exibirMensagem("N\u00e3o foi encontado Tipo Emiss\u00e3o com os dados informados, conforme comando enviado. Consulte o departamento de TI.", true);
            }
            this.exibirMensagem(command);
        }
        catch (ExceptionIO ex) {
            Logger.getLogger(TaskMsgCommandsNFCe.class.getName()).log(Level.SEVERE, null, ex);
            this.salvarComandoExec(command);
            this.exibirMensagem("Erro ao decifrar o comando: " + ex.getMessage(), true);
        }
    }

    private void salvarComandoExec(MsgComandosNFCe command) {
        command = (MsgComandosNFCe)Main.getBean(ServiceMsgComandosNFCe.class).get(command.getIdentificador());
        command.setExecutado((short)1);
        command.setDataVisualizacao(new Date());
        command.setUsuarioVisutalizacao(StaticObjects.getUsuario());
        Main.getBean(ServiceMsgComandosNFCe.class).merge(command);
    }

    private void alterarPeriodoNFe(MsgComandosNFCe command) {
        try {
            DTOMsgComNFCePerEmissao data = (DTOMsgComNFCePerEmissao)ToolJson.readJson((String)command.getInfoComando(), DTOMsgComNFCePerEmissao.class);
            ServiceTipoEmissaoNFe service = Main.getBean(ServiceTipoEmissaoNFe.class);
            TipoEmissaoNFe tipo = (TipoEmissaoNFe)service.get(data.getIdTipoEmissao());
            if (tipo != null) {
                PeriodoEmissaoNFe per = new PeriodoEmissaoNFe();
                per.setDataCadastro(new Date());
                per.setDataInicial(new Date());
                per.setDescricao(data.getMotivo());
                per.setNfceCaixa(StaticObjects.getNFCeCaixa());
                per.setTipoEmissaoNfe(tipo);
                per.setSerialForSinc(UtilNFCeSerial.getSerial(StaticObjects.getNFCeCaixa()));
                StaticObjects.setPeriodoEmissaoNFe(UtilPeriodoEmissao.savePeriodoEmissaoNFe(per));
                Platform.runLater((Runnable)new Runnable(this){

                    @Override
                    public void run() {
                        Main.get().getFooterController().atualizaPeriodoEmissaoNFe();
                    }
                });
            } else {
                this.exibirMensagem("N\u00e3o foi encontado Tipo Emiss\u00e3o com os dados informados, conforme comando enviado. Consulte o departamento de TI.", true);
            }
            this.exibirMensagem(command);
            this.salvarComandoExec(command);
        }
        catch (ExceptionIO ex) {
            Logger.getLogger(TaskMsgCommandsNFCe.class.getName()).log(Level.SEVERE, null, ex);
            this.salvarComandoExec(command);
            this.exibirMensagem("Erro ao decifrar o comando: " + ex.getMessage(), true);
        }
    }

    private void forcarSaidaSistema(final MsgComandosNFCe command) {
        try {
            DTOMsgComForcarSaidaSistema data = (DTOMsgComForcarSaidaSistema)ToolJson.readJson((String)command.getInfoComando(), DTOMsgComForcarSaidaSistema.class);
            int delay = data.getTempoEspera() / data.getNrAvisos();
            int i = 1;
            do {
                if (ToolMethods.isEquals((Object)command.getExibirUsuario(), (Object)1)) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Alerts.showAlertInfo(command.getMensagem());
                        }
                    });
                }
                try {
                    Thread.sleep(delay * 1000);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(TaskMsgCommandsNFCe.class.getName()).log(Level.SEVERE, null, ex);
                }
            } while (++i <= data.getNrAvisos());
            this.salvarComandoExec(command);
            System.exit(0);
            Platform.runLater((Runnable)new Runnable(this){

                @Override
                public void run() {
                    Alerts.showAlertInfo("ATEN\u00c7\u00c3O! Conforme programado, o sistema ser\u00e1 encerrado agora.");
                }
            });
        }
        catch (ExceptionIO ex) {
            Logger.getLogger(TaskMsgCommandsNFCe.class.getName()).log(Level.SEVERE, null, ex);
            this.salvarComandoExec(command);
            this.exibirMensagem("Erro ao decifrar o comando: " + ex.getMessage(), true);
        }
    }
}

