/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.service;

import com.touchcomp.touchnfce.repo.RepoBaseJPA;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public abstract class ServiceEntityAPI<T extends Serializable, ID extends Serializable> {
    protected final RepoBaseJPA<T, ID> repository;

    public <S extends RepoBaseJPA<T, ID>> S getRepository() {
        return (S)this.repository;
    }

    public ServiceEntityAPI(RepoBaseJPA<T, ID> repository) {
        this.repository = repository;
    }

    @Transactional
    public List<T> getAll() {
        return this.getRepository().findAll();
    }

    @Transactional
    public T get(ID id) {
        if (id == null) {
            return null;
        }
        Optional found = this.getRepository().findById(id);
        if (found.isPresent()) {
            return (T)((Serializable)found.get());
        }
        return null;
    }

    @Transactional
    public T merge(T entity) {
        return (T)((Serializable)this.getRepository().mergeOnDB(entity));
    }

    @Transactional
    public List<T> merge(List<T> entities) {
        LinkedList<Serializable> ret = new LinkedList<Serializable>();
        for (Serializable r : entities) {
            ret.add(this.getRepository().mergeOnDB((Serializable)r));
        }
        return ret;
    }

    @Transactional
    public T saveOrUdate(T entity) {
        return (T)((Serializable)this.getRepository().saveOrUpdateOnDB(entity));
    }

    @Transactional
    public T save(T entity) {
        return (T)((Serializable)this.getRepository().save(entity));
    }

    @Transactional
    public Iterable<T> saveAll(Iterable<T> entity) {
        return this.getRepository().saveAll(entity);
    }

    @Transactional
    public Long countOf() {
        return this.getRepository().count();
    }

    @Transactional
    public void deleteById(ID id) {
        this.getRepository().deleteById(id);
    }

    @Transactional
    public void delete(T entity) {
        this.getRepository().delete(entity);
    }

    @Transactional
    public void deleteAll(Iterable<T> entities) {
        this.getRepository().deleteAll(entities);
    }

    @Transactional
    public void deleteAll() {
        this.getRepository().deleteAll();
    }
}

