/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.service.impl;

import com.touchcomp.basementor.constants.enums.msgcomandosnfce.EnumConstMsgComandoNFCe;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.MsgComandosNFCe;
import com.touchcomp.touchnfce.repo.RepoBaseJPA;
import com.touchcomp.touchnfce.repo.impl.RepoMsgComandosNFCe;
import com.touchcomp.touchnfce.service.ServiceEntityAPI;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class ServiceMsgComandosNFCe
extends ServiceEntityAPI<MsgComandosNFCe, Long> {
    public ServiceMsgComandosNFCe(RepoBaseJPA<MsgComandosNFCe, Long> repository) {
        super(repository);
    }

    public List<MsgComandosNFCe> getCommandsToExecuteAsc(Date dataExpiracao, EnumConstMsgComandoNFCe comando, Empresa emp) {
        RepoMsgComandosNFCe repo = (RepoMsgComandosNFCe)this.getRepository();
        return repo.getCommandsToExecuteAsc((short)0, dataExpiracao, comando.getValue(), emp);
    }

    public List<MsgComandosNFCe> getCommandsToExecuteDesc(Date dataExpiracao, EnumConstMsgComandoNFCe comando, Empresa emp) {
        RepoMsgComandosNFCe repo = (RepoMsgComandosNFCe)this.getRepository();
        return repo.getCommandsToExecuteDesc((short)0, dataExpiracao, comando.getValue(), emp);
    }

    public Integer encerrarComandosPendentes() {
        RepoMsgComandosNFCe repo = (RepoMsgComandosNFCe)this.getRepository();
        return repo.encerrarComandosPendentes(EnumConstMsgComandoNFCe.FORCAR_SAIDA_SISTEMA.getValue(), (short)1);
    }

    private List<MsgComandosNFCe> filterLastComands(List<MsgComandosNFCe> commands) {
        LinkedList<MsgComandosNFCe> temp = new LinkedList<MsgComandosNFCe>();
        LinkedList<MsgComandosNFCe> updateExecutado = new LinkedList<MsgComandosNFCe>();
        for (MsgComandosNFCe aux : commands) {
            EnumConstMsgComandoNFCe codCom = EnumConstMsgComandoNFCe.valueOfCodigo((int)aux.getComando());
            Optional<MsgComandosNFCe> found = temp.stream().filter(i -> ToolMethods.isEquals((Object)i.getComando(), (Object)aux.getComando())).findFirst();
            if (!found.isPresent()) {
                temp.add(aux);
                continue;
            }
            if (!codCom.isExcecutarSomenteUltComando()) {
                temp.add(aux);
                continue;
            }
            updateExecutado.add(aux);
        }
        return temp;
    }
}

