/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.service.impl;

import com.touchcomp.basementor.constants.enums.EnumConstAbertoFechado;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoMovimentoCaixa;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoPagNFe;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.model.NFCeCaixa;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.model.NFCeControleCaixaRes;
import com.touchcomp.touchnfce.model.TipoPagamentoNFe;
import com.touchcomp.touchnfce.repo.RepoBaseJPA;
import com.touchcomp.touchnfce.repo.impl.nfcecontrolecaixa.RepoNFCeControleCaixa;
import com.touchcomp.touchnfce.service.ServiceSincEntityAPI;
import com.touchcomp.touchnfce.service.impl.ServiceNFCe;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeMovimentoCaixa;
import com.touchcomp.touchnfce.service.impl.ServiceTipoPagamentoNFe;
import com.touchcomp.touchvomodel.webservices.PackObjectsSinc;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ServiceNFCeControleCaixa
extends ServiceSincEntityAPI<NFCeControleCaixa, Long> {
    @Autowired
    private ServiceNFCe serviceNFCe;
    @Autowired
    private ServiceTipoPagamentoNFe serviceTipoPagamentoNFe;
    @Autowired
    private ServiceNFCeMovimentoCaixa serviceNFCeMovimentoCaixa;

    public ServiceNFCeControleCaixa(RepoBaseJPA<NFCeControleCaixa, Long> repository) {
        super(repository);
    }

    @Override
    public RepoNFCeControleCaixa getRepository() {
        return (RepoNFCeControleCaixa)super.getRepository();
    }

    public NFCeControleCaixa getControleCaixaAberto(NFCeCaixa nfCeCaixa) {
        NFCeControleCaixa found = this.getRepository().findByStatus(EnumConstAbertoFechado.ABERTO.value, nfCeCaixa);
        return found;
    }

    public NFCeControleCaixa recalcularValores(NFCeControleCaixa controleCaixa) {
        List data = this.serviceNFCe.getResumoPagamentosCaixa(controleCaixa);
        double valorTotalRec = 0.0;
        double valorTotalRecDin = 0.0;
        List<NFCeControleCaixaRes> lista = controleCaixa.getResumoRecebimentos();
        ArrayList<NFCeControleCaixaRes> listaNovo = new ArrayList<NFCeControleCaixaRes>();
        for (Object[] ob : data) {
            Long idTpPag = (Long)ob[0];
            Double valor = (Double)ob[1];
            Double valorTroco = (Double)ob[2];
            Double valorLiquido = (Double)ob[3];
            NFCeControleCaixaRes res = new NFCeControleCaixaRes();
            Boolean b = true;
            for (NFCeControleCaixaRes resAntigo : lista) {
                if (!ToolMethods.isEquals((Object)idTpPag, (Object)resAntigo.getTipoPagamentoNFe().getIdentificador())) continue;
                resAntigo.setValorLiquidoInf(valorLiquido);
                res = resAntigo;
                b = false;
            }
            if (b.booleanValue()) {
                res.setNfCeControleCaixa(controleCaixa);
                res.setTipoPagamentoNFe((TipoPagamentoNFe)this.serviceTipoPagamentoNFe.get(idTpPag));
                res.setValorRecebido(valor);
                res.setValorLiquido(valorLiquido);
                res.setValorLiquidoInf(valorLiquido);
                res.setValorTroco(valorTroco);
            }
            listaNovo.add(res);
            if (res.getTipoPagamentoNFe().getCodigo().equalsIgnoreCase(EnumConstNFeTipoPagNFe.DINHEIRO.getCodigo())) {
                valorTotalRecDin += res.getValorLiquido().doubleValue();
            }
            if (res.getTipoPagamentoNFe().getCodigo().equalsIgnoreCase(EnumConstNFeTipoPagNFe.SEM_PAGAMENTO.getCodigo())) continue;
            valorTotalRec += res.getValorLiquido().doubleValue();
        }
        return this.verificarNaoExisteControleCaixaResNovo(lista, listaNovo, valorTotalRecDin, valorTotalRec, controleCaixa);
    }

    private NFCeControleCaixa verificarNaoExisteControleCaixaResNovo(List<NFCeControleCaixaRes> lista, List<NFCeControleCaixaRes> listaNovo, double valorTotalRecDin, double valorTotalRec, NFCeControleCaixa controleCaixa) {
        for (NFCeControleCaixaRes antigo : lista) {
            Boolean b = true;
            for (NFCeControleCaixaRes novo : listaNovo) {
                if (!ToolMethods.isEquals((Object)antigo.getTipoPagamentoNFe().getIdentificador(), (Object)novo.getTipoPagamentoNFe().getIdentificador())) continue;
                b = false;
            }
            if (!b.booleanValue()) continue;
            antigo.setValorLiquidoInf(0.0);
            listaNovo.add(antigo);
            if (antigo.getTipoPagamentoNFe().getCodigo().equalsIgnoreCase(EnumConstNFeTipoPagNFe.DINHEIRO.getCodigo())) {
                valorTotalRecDin += antigo.getValorLiquido().doubleValue();
            }
            if (antigo.getTipoPagamentoNFe().getCodigo().equalsIgnoreCase(EnumConstNFeTipoPagNFe.SEM_PAGAMENTO.getCodigo())) continue;
            valorTotalRec += antigo.getValorLiquido().doubleValue();
        }
        controleCaixa.setResumoRecebimentos(listaNovo);
        this.calcularValoresControleCaixa(controleCaixa, valorTotalRec, valorTotalRecDin);
        return controleCaixa;
    }

    public NFCeControleCaixa calcularValores(NFCeControleCaixa controleCaixa) {
        List data = this.serviceNFCe.getResumoPagamentosCaixa(controleCaixa);
        double valorTotalRec = 0.0;
        double valorTotalRecDin = 0.0;
        controleCaixa.getResumoRecebimentos().clear();
        controleCaixa.setResumoRecebimentos(new ArrayList<NFCeControleCaixaRes>());
        for (Object[] ob : data) {
            Long idTpPag = (Long)ob[0];
            Double valor = (Double)ob[1];
            Double valorTroco = (Double)ob[2];
            Double valorLiquido = (Double)ob[3];
            NFCeControleCaixaRes res = new NFCeControleCaixaRes();
            res.setNfCeControleCaixa(controleCaixa);
            res.setTipoPagamentoNFe((TipoPagamentoNFe)this.serviceTipoPagamentoNFe.get(idTpPag));
            res.setValorRecebido(valor);
            res.setValorLiquido(valorLiquido);
            res.setValorLiquidoInf(valorLiquido);
            res.setValorTroco(valorTroco);
            controleCaixa.getResumoRecebimentos().add(res);
            if (res.getTipoPagamentoNFe().getCodigo().equalsIgnoreCase(EnumConstNFeTipoPagNFe.DINHEIRO.getCodigo())) {
                valorTotalRecDin += res.getValorLiquido().doubleValue();
            }
            if (res.getTipoPagamentoNFe().getCodigo().equalsIgnoreCase(EnumConstNFeTipoPagNFe.SEM_PAGAMENTO.getCodigo())) continue;
            valorTotalRec += res.getValorLiquido().doubleValue();
        }
        this.calcularValoresControleCaixa(controleCaixa, valorTotalRec, valorTotalRecDin);
        return controleCaixa;
    }

    private void calcularValoresControleCaixa(NFCeControleCaixa controleCaixa, double valorTotalRec, double valorTotalRecDin) {
        Double totalEntradas = this.serviceNFCeMovimentoCaixa.getTotal(controleCaixa, EnumConstNFCeTipoMovimentoCaixa.ENTRADA_SUPRIMENTO);
        Double totalSaidas = this.serviceNFCeMovimentoCaixa.getTotal(controleCaixa, EnumConstNFCeTipoMovimentoCaixa.SAIDA_SANGRIA);
        controleCaixa.setValorTotalSistema(valorTotalRec);
        controleCaixa.setValorTotalSaidasMov(totalSaidas);
        controleCaixa.setValorTotalEntradasMov(totalEntradas);
        controleCaixa.setValorTotalSistema(controleCaixa.getValorRemanescenteCaixaAnterior() + valorTotalRec + totalEntradas - totalSaidas);
        controleCaixa.setValorTotalSistemaDinh(controleCaixa.getValorRemanescenteCaixaAnterior() + valorTotalRecDin + totalEntradas - totalSaidas);
        controleCaixa.setValorSaidaCaixaFechamento(controleCaixa.getValorTotalSistemaDinh());
    }

    @Override
    public List<NFCeControleCaixa> getAllForSincZip(Date lastSinc, int atualPage, int regPerTime) {
        return this.getRepository().getForSinc(lastSinc, (Pageable)PageRequest.of((int)atualPage, (int)regPerTime));
    }

    @Override
    public Long getCountForSinc(Date dataUltSinc) {
        return this.getRepository().getCountForSinc(dataUltSinc);
    }

    @Override
    public void saveSinc(List<NFCeControleCaixa> data, List<PackObjectsSinc> res) {
        for (PackObjectsSinc p : res) {
            this.getRepository().updateSinc(p.getIdObjectMentor(), p.getStatus(), p.getSerialObjetoOrigem());
        }
    }

    public NFCeControleCaixa saveAndMovAbert(NFCeControleCaixa abertCaixa) {
        NFCeControleCaixa controleCaixa = (NFCeControleCaixa)this.getRepository().save(abertCaixa);
        return controleCaixa;
    }

    public List<NFCeControleCaixa> getUltimosMovimentos() {
        return this.getRepository().getUltimosMovimentos();
    }

    public void updateStatus(Timestamp dataAtualizacao, Long idNFCeControleCaixa) {
        this.getRepository().updateStatus(dataAtualizacao, idNFCeControleCaixa);
    }
}

