/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.service.impl;

import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoMovimentoCaixa;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.model.NFCeMovimentoCaixa;
import com.touchcomp.touchnfce.repo.impl.nfcemovimentocaixa.RepoNFCeMovimentoCaixa;
import com.touchcomp.touchnfce.service.ServiceSincEntityAPI;
import com.touchcomp.touchvomodel.webservices.PackObjectsSinc;
import java.util.Date;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ServiceNFCeMovimentoCaixa
extends ServiceSincEntityAPI<NFCeMovimentoCaixa, Long> {
    public ServiceNFCeMovimentoCaixa(RepoNFCeMovimentoCaixa repository) {
        super(repository);
    }

    public Double getTotal(NFCeControleCaixa controleCaixa, EnumConstNFCeTipoMovimentoCaixa tipoMovimentoCaixa) {
        if (controleCaixa == null || tipoMovimentoCaixa == null) {
            return 0.0;
        }
        Double ret = this.getRepository().getTotal(controleCaixa, tipoMovimentoCaixa.getValue());
        return ret != null ? ret : 0.0;
    }

    @Override
    public RepoNFCeMovimentoCaixa getRepository() {
        return (RepoNFCeMovimentoCaixa)super.getRepository();
    }

    @Override
    public Long getCountForSinc(Date dataUltSinc) {
        return this.getRepository().getCountForSinc(dataUltSinc);
    }

    @Override
    public void saveSinc(List<NFCeMovimentoCaixa> data, List<PackObjectsSinc> res) {
        for (PackObjectsSinc p : res) {
            this.getRepository().updateSinc(p.getIdObjectMentor(), p.getStatus(), p.getSerialObjetoOrigem());
        }
    }

    @Override
    public List<NFCeMovimentoCaixa> getAllForSincZip(Date lastSinc, int atualPage, int regPerTime) {
        return this.getRepository().getForSinc(lastSinc, (Pageable)PageRequest.of((int)atualPage, (int)regPerTime));
    }

    public List<NFCeMovimentoCaixa> getUltimosMovimentosEntrada() {
        return this.getRepository().getUltimosMovimentosEntrada();
    }

    public List<NFCeMovimentoCaixa> getUltimosMovimentosSaida() {
        return this.getRepository().getUltimosSaida();
    }
}

