/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.service.impl;

import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.repo.RepoBaseJPA;
import com.touchcomp.touchnfce.repo.impl.unidadefatcliente.RepoUnidadeFatcliente;
import com.touchcomp.touchnfce.service.ServiceEntityAPI;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ServiceUnidadeFatCliente
extends ServiceEntityAPI<UnidadeFatCliente, Long> {
    public ServiceUnidadeFatCliente(RepoBaseJPA<UnidadeFatCliente, Long> repository) {
        super(repository);
    }

    @Override
    public RepoUnidadeFatcliente getRepository() {
        return (RepoUnidadeFatcliente)super.getRepository();
    }

    public List<UnidadeFatCliente> searchUnidadeFatCliente(String aux, Integer nrRegistros, Integer page) {
        LinkedList<UnidadeFatCliente> pessoas = new LinkedList<UnidadeFatCliente>();
        if (!ToolMethods.isStrWithData((String)aux)) {
            return pessoas;
        }
        if (aux.startsWith("=")) {
            pessoas.addAll(this.getRepository().getClienteCodigoCliente(aux.substring(1)));
        } else {
            if (ToolString.isAIntegerNumber((String)aux) && aux.length() <= 18) {
                pessoas.addAll(this.getRepository().getClienteCpfCnpj(aux));
            }
            if (aux.length() <= 25) {
                pessoas.addAll(this.getRepository().getClienteCodigoCliente(aux));
            }
            pessoas.addAll(this.getRepository().getClienteNome(aux, nrRegistros, page));
        }
        return pessoas;
    }

    public List<UnidadeFatCliente> getUnidadeFatClienteByCpfCnpj(String aux) {
        return this.getRepository().getClienteCpfCnpj(aux);
    }
}

