/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.sinc.receive;

import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorexceptions.exceptions.impl.zip.ExceptionZip;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import com.touchcomp.basementortools.tools.zip.ToolZipUtils;
import com.touchcomp.touchnfce.service.ServiceEntityAPI;
import com.touchcomp.touchnfce.sinc.ToolWebService;
import com.touchcomp.touchnfce.sinc.converters.ConverterBase;
import com.touchcomp.touchnfce.sinc.receive.SincListener;
import com.touchcomp.touchnfce.sinc.receive.SincParams;
import com.touchcomp.touchvomodel.webservices.RespostaWebService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.springframework.util.ResourceUtils;

public abstract class SincBase<T extends Serializable, S, ID extends Serializable> {
    private final SincParams params;
    private ServiceEntityAPI<T, ID> service;
    private List<Converter> converters = new LinkedList<Converter>();
    private ModelMapper modelMapper;
    private long numberOfRegisters = 0L;
    private long atualPage = 0L;
    private long REG_PER_TIME_DEFAULT = 5000L;
    public static final String METHOD_SINC_NAME = "getAllForSincZip";
    public static final String METHOD_SINC_NAME_EMP = "getAllForSincEmp";
    public static final String METHOD_SIZE_DATA_NAME = "countOfForSinc";
    public static final String METHOD_SIZE_DATA_NAME_EMP = "countOfForSincEmp";
    private SincListener listener;

    public SincBase(SincParams params) {
        this.params = params;
    }

    public abstract String getPath();

    public abstract String getDescSinc();

    public String getServerHost() {
        return this.getParams().getDadosSincronizacao().getServidor();
    }

    public String getServerPort() {
        return this.getParams().getDadosSincronizacao().getPortaServidor().toString();
    }

    public File getKeyStore() throws FileNotFoundException {
        try {
            return ResourceUtils.getFile((String)"src/main/resources/keystore/touchcomp.p12");
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            throw new FileNotFoundException("Certificado de sincroniza\u00e7\u00e3o n\u00e3o encontrado!");
        }
    }

    public String getStorePassword() {
        return "co68010203";
    }

    public String getWebServiceSincMethod() {
        return METHOD_SINC_NAME;
    }

    public String getWebServiceDataSizeMethod() {
        return METHOD_SIZE_DATA_NAME;
    }

    private long sincAndSaveInternal(Long last, Long atual) throws ExceptionIO, ExceptionReflection, ExceptionWebService, ExceptionDecodeHexString64, ExceptionZip, FileNotFoundException, ExceptionCertificado, Exception {
        do {
            List<T> data = this.getData(last, atual);
            this.atualPage += this.getRegPerTime();
            if (this.listener == null) continue;
            Double perc = (double)this.atualPage * 1.0 / (double)this.getNumberOfRegisters() * 100.0;
            if (perc > 100.0) {
                perc = 100.0;
            }
            this.listener.onSincProgressItemRec(perc.longValue());
        } while (this.atualPage < this.getNumberOfRegisters());
        return this.getNumberOfRegisters();
    }

    protected List<T> getData(Long last, Long atual) throws ExceptionIO, ExceptionWebService, ExceptionReflection, ExceptionDecodeHexString64, ExceptionZip, FileNotFoundException, ExceptionCertificado, Exception {
        String str = ToolWebService.getData(this.getUrlData(last, atual));
        List<Serializable> result = new LinkedList();
        RespostaWebService resp = (RespostaWebService)ToolJson.readJson((String)str, RespostaWebService.class);
        if (resp.getDetalhes() != null) {
            String encoded = ToolZipUtils.decompress((byte[])ToolHexString.decodeToByte((String)resp.getDetalhes()));
            List res = ToolJson.readJsonList((String)encoded, (Class)ToolReflections.getGenericTypeClass(this.getClass(), (int)1));
            for (Object aux : res) {
                Serializable obj = (Serializable)this.getModelMapper().map(aux, (Type)ToolReflections.getGenericTypeClass(this.getClass(), (int)0));
                result.add(obj);
            }
        }
        result = this.beforeSaveFilter(result);
        this.beforeSave((T)result);
        this.save(result);
        return result;
    }

    protected String getWebServiceSincMethodInternal(Long last, Long atual) {
        return this.getWebServiceSincMethod() + "/" + last + "&" + atual + "&" + this.atualPage + "&" + this.getRegPerTime();
    }

    protected long getRegPerTime() {
        long tempRegPerTime = this.REG_PER_TIME_DEFAULT;
        if (this.getParams().getNrRegPerTime() > 0) {
            tempRegPerTime = this.getParams().getNrRegPerTime();
        }
        return tempRegPerTime;
    }

    protected Long getDataSize(Long last, Long atual) throws Exception {
        String str = ToolWebService.getData(this.getURLDataSize(last, atual));
        Long res = new Long(str);
        this.setNumberOfRegisters(res);
        return res;
    }

    protected String getWebServiceDataSizeMethodInternal(Long last, Long atual) {
        System.out.println("Data Ultimo Envio ERP/NFCe: " + last);
        String temp = this.getWebServiceDataSizeMethod() + "/" + last + "&" + atual;
        return temp;
    }

    protected ModelMapper getModelMapper() throws ExceptionReflection {
        if (this.modelMapper == null) {
            this.modelMapper = new ModelMapper();
            this.addAllConverters();
            this.converters.forEach(c -> this.modelMapper.addConverter(c));
        }
        return this.modelMapper;
    }

    private void addAllConverters() throws ExceptionReflection {
        List aux = ToolReflections.getClassesFromInterface((String)(ConverterBase.class.getPackage().getName() + ".impl"), ConverterBase.class);
        for (Class a : aux) {
            try {
                this.addConverter((Converter)a.newInstance());
            }
            catch (InstantiationException e) {
                throw new ExceptionReflection(e);
            }
            catch (IllegalAccessException e) {
                throw new ExceptionReflection(e);
            }
        }
    }

    public void beforeSave(List<T> data) {
        for (Serializable aux : data) {
            this.beforeSave(aux);
        }
    }

    public List<T> beforeSaveFilter(List<T> data) {
        return data;
    }

    public void beforeSave(T data) {
    }

    public void addConverter(Converter converter) {
        if (converter != null && !this.converters.contains(converter)) {
            this.converters.add(converter);
        }
    }

    protected Iterable<T> save(List<T> data) {
        System.out.println("Salvando " + data.size() + ": " + this.getDescSinc());
        if (data.isEmpty()) {
            return data;
        }
        try {
            if (!this.useMergeInsteadSave()) {
                LinkedList<Serializable> ret = new LinkedList<Serializable>();
                for (Serializable o : data) {
                    try {
                        ret.add(this.service.save(o));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw ex;
                    }
                }
                return ret;
            }
            return this.service.merge(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public long sincAndSave(Long last, Long atual) throws ExceptionIO, ExceptionWebService, ExceptionReflection, ExceptionDecodeHexString64, ExceptionZip, FileNotFoundException, ExceptionCertificado, Exception {
        return this.sincAndSaveInternal(last, atual);
    }

    public void setListener(SincListener listener) {
        this.listener = listener;
    }

    protected String getURLDataSize(Long last, Long atual) {
        return this.getPath() + "/" + this.getWebServiceDataSizeMethodInternal(last, atual);
    }

    protected String getUrlData(Long last, Long atual) {
        return this.getPath() + "/" + this.getWebServiceSincMethodInternal(last, atual);
    }

    public SincParams getParams() {
        return this.params;
    }

    public long getNumberOfRegisters() {
        return this.numberOfRegisters;
    }

    public void setNumberOfRegisters(long numberOfRegisters) {
        this.numberOfRegisters = numberOfRegisters;
    }

    protected boolean useMergeInsteadSave() {
        return false;
    }

    @Generated
    public ServiceEntityAPI<T, ID> getService() {
        return this.service;
    }

    @Generated
    public void setService(ServiceEntityAPI<T, ID> service) {
        this.service = service;
    }
}

