/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.sinc.receive;

import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.exceptions.ExceptionSincronizacao;
import com.touchcomp.touchnfce.sinc.ToolWebService;
import com.touchcomp.touchvomodel.vo.cupomdesconto.nfce.DTOCupomDesconto;
import com.touchcomp.touchvomodel.vo.estatisticascliente.nfce.DTONFCeEstatisticasPessoa;
import com.touchcomp.touchvomodel.vo.geracaoboleto.DTOResultProcessGerBol;
import com.touchcomp.touchvomodel.vo.saldoestoque.DTOSaldoEstoqueGeral;
import com.touchcomp.touchvomodel.vo.saldoestoque.DTOSaldoEstoqueGeralBasico;
import com.touchcomp.touchvomodel.webservices.RespostaWebService;
import java.util.List;

public class SincOthers {
    public static Long getIDEmpresaByCnpj(String servidor, String porta, String cnpj) throws Exception {
        String str = ToolWebService.getData(servidor, porta, "empresa/getIdEmpresaByCNPJ/" + cnpj, StaticObjects.getDadosSincronizacao());
        Long res = Long.valueOf(str);
        return res;
    }

    public static DTOResultProcessGerBol getBoletoCobrancaByNFCe(Long idERP, String tipoDocumento) throws Exception {
        String str = ToolWebService.getData("nfce/getBoletoCobrancaByNFCe/" + idERP + "&" + tipoDocumento);
        RespostaWebService resp = (RespostaWebService)ToolJson.readJson((String)str, RespostaWebService.class);
        SincOthers.processaRespostaWebService(resp);
        return (DTOResultProcessGerBol)ToolJson.readJson((String)resp.getDetalhes(), DTOResultProcessGerBol.class);
    }

    private static void processaRespostaWebService(RespostaWebService res) throws ExceptionSincronizacao {
        if (ToolMethods.isEquals((Object)res.getCodStatus(), (Object)0)) {
            throw new ExceptionSincronizacao(res.getMensagem());
        }
    }

    public static List<DTOSaldoEstoqueGeral> findSaldoIdProdutoListaByCentroEstoque(Long idProdutoInicial, Long idProdutoFinal, Long empresaInicial, Long empresaFinal, Integer tipoSaldo, Integer tipoQtde, Integer tipoCarregamento, Short tipoDisponibilidade) throws Exception {
        String str = ToolWebService.getData("suprimentos/consulta-posicao-estoque/find-saldo-id-gradecor-lista/" + idProdutoInicial + "&" + idProdutoFinal + "&" + empresaInicial + "&" + empresaFinal + "&" + tipoSaldo + "&" + tipoQtde + "&" + tipoCarregamento + "&" + tipoDisponibilidade, StaticObjects.getDadosSincronizacao());
        RespostaWebService resp = (RespostaWebService)ToolJson.readJson((String)str, RespostaWebService.class);
        SincOthers.processaRespostaWebService(resp);
        String content = ToolHexString.decodeToStr((String)resp.getDetalhes());
        return ToolJson.readJsonList((String)content, DTOSaldoEstoqueGeral.class);
    }

    public static DTOSaldoEstoqueGeralBasico findSaldoIdProdutoByCentroEstoque(Long idProduto, Long idEmpresa, Integer tipoSaldo, Integer tipoQtde, Integer tipoCarregamento, Short tipoDisponibilidade) throws Exception {
        String str = ToolWebService.getData("suprimentos/consulta-posicao-estoque/find-saldo-gradecor-centro-estoque-proprio/" + idProduto + "&" + idEmpresa + "&" + tipoSaldo + "&" + tipoQtde + "&" + tipoCarregamento + "&" + tipoDisponibilidade, StaticObjects.getDadosSincronizacao());
        RespostaWebService resp = (RespostaWebService)ToolJson.readJson((String)str, RespostaWebService.class);
        SincOthers.processaRespostaWebService(resp);
        if (resp.getDetalhes() == null) {
            return null;
        }
        String content = ToolHexString.decodeToStr((String)resp.getDetalhes());
        return (DTOSaldoEstoqueGeralBasico)ToolJson.readJson((String)content, DTOSaldoEstoqueGeralBasico.class);
    }

    public static DTONFCeEstatisticasPessoa analiseCreditoCliente(Long idPessoa, Long idEmpresa) throws ExceptionSincronizacao {
        try {
            String str = ToolWebService.getData("cliente/analiseFinanceiraCliente/" + idPessoa + "&" + idEmpresa, StaticObjects.getDadosSincronizacao());
            RespostaWebService resp = (RespostaWebService)ToolJson.readJson((String)str, RespostaWebService.class);
            SincOthers.processaRespostaWebService(resp);
            return (DTONFCeEstatisticasPessoa)ToolJson.readJson((String)resp.getDetalhes(), DTONFCeEstatisticasPessoa.class);
        }
        catch (Exception ex) {
            throw new ExceptionSincronizacao(ex);
        }
    }

    public static List<DTOCupomDesconto> getCupomDesconto(Long idPessoa) throws ExceptionSincronizacao {
        try {
            String str = ToolWebService.getData("cupomdesconto/get-cupom-desconto/" + idPessoa, StaticObjects.getDadosSincronizacao());
            RespostaWebService resp = (RespostaWebService)ToolJson.readJson((String)str, RespostaWebService.class);
            SincOthers.processaRespostaWebService(resp);
            return ToolJson.readJsonList((String)resp.getDetalhes(), DTOCupomDesconto.class);
        }
        catch (Exception ex) {
            throw new ExceptionSincronizacao(ex);
        }
    }

    public static void fecharCupomDesconto(Long idCupom) throws ExceptionSincronizacao {
        try {
            String str = ToolWebService.getData("cupomdesconto/fechar-cupom-desconto/" + idCupom, StaticObjects.getDadosSincronizacao());
            RespostaWebService resp = (RespostaWebService)ToolJson.readJson((String)str, RespostaWebService.class);
            if (resp == null || resp.getCodStatus() == 0) {
                throw new ExceptionSincronizacao("Erro ao fechar o cupom de desconto \n" + (resp.getMensagem() != null ? resp.getMensagem() : ""));
            }
        }
        catch (Exception ex) {
            throw new ExceptionSincronizacao(ex);
        }
    }

    public static void abrirCupomDesconto(String serialCupom) throws ExceptionSincronizacao {
        try {
            String str = ToolWebService.getData("cupomdesconto/abrir-cupom-desconto/" + serialCupom, StaticObjects.getDadosSincronizacao());
            RespostaWebService resp = (RespostaWebService)ToolJson.readJson((String)str, RespostaWebService.class);
            if (resp == null || resp.getCodStatus() == 0) {
                throw new ExceptionSincronizacao("Erro ao abrir o cupom de desconto \n" + (resp.getMensagem() != null ? resp.getMensagem() : ""));
            }
        }
        catch (Exception ex) {
            throw new ExceptionSincronizacao(ex);
        }
    }
}

