/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.tasks.impl;

import com.touchcomp.basementorclientwebservices.nfe.model.env.cancelarnota.NFeCancelarNota;
import com.touchcomp.basementorclientwebservices.nfe.model.ret.NFeEnviaEventoRet;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.NFCeCancelamento;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.nfe.impl.versoes.ConfigCertificate;
import com.touchcomp.touchnfce.nfe.impl.versoes.ConstNFeVersoes;
import com.touchcomp.touchnfce.nfe.impl.versoes.UtilNfeSendWebServices;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeCancelamento;
import com.touchcomp.touchnfce.tasks.AppTask;
import com.touchcomp.touchnfce.tasks.TaskResult;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AppTaskCancelarNota
extends AppTask<NFCeCancelamento> {
    private NFCeCancelamento nfCeCancelamento;

    public AppTaskCancelarNota(TaskResult result, NFCeCancelamento nfCe) {
        super(result);
        this.nfCeCancelamento = nfCe;
    }

    @Override
    protected NFCeCancelamento execute() throws Exception {
        Empresa empresa = StaticObjects.getEmpresa();
        NFCeOpcoes opcoes = StaticObjects.getOpcoes();
        ServiceNFCeCancelamento serviceNFCe = Main.getBean(ServiceNFCeCancelamento.class);
        NFeCancelarNota cancelarNota = new NFeCancelarNota();
        cancelarNota.setChave(this.nfCeCancelamento.getNfce().getChaveNFCe());
        cancelarNota.setMotivo(this.nfCeCancelamento.getMotivo());
        cancelarNota.setNumeroProtocolo(this.nfCeCancelamento.getNfce().getNrProtocolo());
        ConfigCertificate config = new ConfigCertificate(empresa.getPessoa().getEndereco().getCidade().getUf(), opcoes, UtilNFCe.getTipoEmissaoNFe(this.nfCeCancelamento.getNfce()));
        NFeEnviaEventoRet stat = UtilNfeSendWebServices.cancelarNota(config, ConstNFeVersoes.VERSAO_20180005_1_20, cancelarNota, false);
        this.setXMLNFCe(stat.getDetEventos());
        this.nfCeCancelamento.setStatus(stat.getCodigoStatusReposta());
        this.nfCeCancelamento = serviceNFCe.save(this.nfCeCancelamento);
        return this.nfCeCancelamento;
    }

    private void setXMLNFCe(List<NFeEnviaEventoRet.NFEEnviaEventoRetDet> eventos) throws Exception {
        for (NFeEnviaEventoRet.NFEEnviaEventoRetDet nf : eventos) {
            Optional<NFeEnviaEventoRet.NFEEnviaEventoRetDet> found = eventos.stream().filter(i -> Objects.equals(this.nfCeCancelamento.getNfce().getChaveNFCe(), nf.getChave())).findFirst();
            if (found.isPresent()) {
                this.nfCeCancelamento.setXmlCancelamento(found.get().toString().getBytes());
                this.nfCeCancelamento.setStatus(nf.getCodigoStatus());
                this.nfCeCancelamento.setMotivo(nf.getMotivo());
                this.nfCeCancelamento.setNrProtocoloCancelamento(nf.getNumeroProtocolo());
                this.nfCeCancelamento.getNfce().setStatus(nf.getCodigoStatus());
                this.nfCeCancelamento.getNfce().setMotivo(nf.getMotivo());
                continue;
            }
            throw new ExceptionErroProgramacao("Ocorreu um erro ao comparar as notas enviadas com o retorno. Verifique a NF id " + this.nfCeCancelamento.getNfce().getNumero());
        }
    }
}

