/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.tasks.utils;

import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorexceptions.exceptions.impl.print.ExceptionPrint;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.constants.EnumConstantsStatus;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.LogEmail;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.textdynamic.ToolTextDynamic;
import com.touchcomp.touchnfce.controller.splash.ExceptionEmailNaoInformado;
import com.touchcomp.touchnfce.model.EmailPessoa;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.model.Pessoa;
import com.touchcomp.touchnfce.print.impl.PrintDanfce;
import com.touchcomp.touchnfce.print.impl.PrintDanfe;
import com.touchcomp.touchnfce.utils.UtilXML;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import net.sf.jasperreports.engine.JRException;

public class UtilEmail {
    private static final TLogger logger = TLogger.get(UtilEmail.class);

    private static StringBuilder isValidSendEmail(NFCeOpcoes opcoes, NFCe nfce, List<String> outrosEmails) {
        List<String> emails;
        StringBuilder sb = new StringBuilder();
        if (opcoes.getServidorEmail() == null) {
            sb.append("N\u00e3o foi definido um servidor de email em NFCe Op\u00e7\u00f5es.\n");
        }
        if (opcoes.getModeloEmail() == null) {
            sb.append("N\u00e3o foi definido um modelo de email em NFCe Op\u00e7\u00f5es.\n");
        }
        if (nfce.getXml() == null) {
            sb.append("NFCe sem XML. A mesma foi enviada e autorizada?\n");
        }
        if (nfce.getXmlAutorizacao() == null) {
            sb.append("NFCe sem XML de autoriza\u00e7\u00e3o. A mesma foi enviada e autorizada?\n");
        }
        if ((emails = UtilEmail.getEmails(nfce, outrosEmails)).isEmpty()) {
            sb.append("Email para envio n\u00e3o informado ou o campo est\u00e1 nulo.\n");
        }
        return sb;
    }

    public static LogEmail enviaNFePorEmail(NFCe nfce, NFCeOpcoes opcoes, boolean throwEx) throws Exception {
        return UtilEmail.enviaNFePorEmail(nfce, opcoes, new LinkedList<String>(), throwEx);
    }

    public static LogEmail enviaNFePorEmail(NFCe nfce, NFCeOpcoes opcoes, List<String> outrosEmails, boolean throwEx) throws Exception {
        List<String> emails = UtilEmail.getEmails(nfce, outrosEmails);
        StringBuilder sb = UtilEmail.isValidSendEmail(opcoes, nfce, emails);
        if (sb.length() > 0) {
            if (throwEx) {
                throw new ExceptionEmailNaoInformado(sb.toString());
            }
            return null;
        }
        try {
            Email email = new Email();
            email.addDestinatarios(emails.toArray(new String[0]));
            String nameDocFiscal = "NFC-e";
            if (ToolMethods.isEquals((Object)nfce.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
                nameDocFiscal = "NF-e";
            }
            ToolFile.createTempFile((String)nameDocFiscal, (String)".xml");
            File filePdf = UtilEmail.createPrintDanfeNFCe(nameDocFiscal, nfce);
            File fileXml = UtilEmail.createXmlNFCe(nameDocFiscal, nfce);
            email.addAnexos(new File[]{filePdf});
            email.addAnexos(new File[]{fileXml});
            email.setAssunto(opcoes.getModeloEmail().getTituloEmail());
            email.setCorpoMensagem(UtilEmail.getCorpoMensagem(nfce, opcoes));
            email.setRemetente(nfce.getEmpresa().getPessoa().getNomeFantasia());
            Email.ServidorEmail server = new Email.ServidorEmail();
            server.setEmail(opcoes.getServidorEmail().getEmail());
            server.setPortaEmail(opcoes.getServidorEmail().getPortaEmail());
            server.setSenha(opcoes.getServidorEmail().getSenha());
            server.setServidor(opcoes.getServidorEmail().getServidor());
            email.setServidor(server);
            LogEmail log = ToolSendEmail.sendEmailWhitoutException((Email)email);
            if (ToolMethods.isEquals((Object)log.getStatus(), (Object)EnumConstantsStatus.ERRO)) {
                throw new Exception(log.getException().getMessage());
            }
            return log;
        }
        catch (Exception ex) {
            if (throwEx) {
                throw ex;
            }
            return null;
        }
    }

    private static String getCorpoMensagem(NFCe nfce, NFCeOpcoes opcoes) {
        if (opcoes.getModeloEmail() == null) {
            return opcoes.getModeloEmail().getDescricao();
        }
        try {
            ToolTextDynamic.HelperSubOSFinder listener = new ToolTextDynamic.HelperSubOSFinder(){

                public String getSubOSText(Long aLong) {
                    return "null";
                }

                public String getSubOSTextCond(Long aLong) {
                    return "null";
                }
            };
            return ToolTextDynamic.build((Object)nfce, (String)new String(opcoes.getModeloEmail().getModelo()), (ToolTextDynamic.HelperSubOSFinder)listener);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            return new String(opcoes.getModeloEmail().getModelo());
        }
    }

    private static List<String> getEmails(NFCe nfce, List<String> outrosEmails) {
        LinkedList<String> emails = new LinkedList<String>();
        if (nfce.getNfCeConsumidor() != null && nfce.getNfCeConsumidor().getEmail() != null && nfce.getNfCeConsumidor().getEmail().length() > 0) {
            emails.add(nfce.getNfCeConsumidor().getEmail());
        }
        if (nfce.getUnidadeFatCliente() != null) {
            UtilEmail.addEmails(nfce.getUnidadeFatCliente().getPessoa(), emails);
            UtilEmail.addEmails(nfce.getUnidadeFatCliente().getCliente().getPessoa(), emails);
        }
        emails.addAll(outrosEmails);
        return emails;
    }

    private static void addEmails(Pessoa pessoa, List<String> emails) {
        for (EmailPessoa em : pessoa.getComplemento().getEmails()) {
            if (em.getAtivo() == null || em.getAtivo() != 1 || em.getEnviarDadosNfe() == null || em.getEnviarDadosNfe() != 1) continue;
            emails.add(em.getEmail());
        }
    }

    private static File createPrintDanfeNFCe(String nameFile, NFCe nfce) throws ExceptionJasperReports {
        File filePdf = null;
        try {
            filePdf = ToolFile.createTempFile((String)(nameFile + "_" + nfce.getNumero() + "_" + nfce.getSerie()), (String)".pdf");
            if (ToolMethods.isEquals((Object)nfce.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
                new PrintDanfe().printDanfeWritteFile(nfce, filePdf);
            } else {
                new PrintDanfce().printDanfceWritteFile(nfce, filePdf, null);
            }
        }
        catch (ExceptionJasperReports | ExceptionPrint | FileNotFoundException | JRException ex) {
            ex.printStackTrace();
            logger.error("Erro ao imprimir DANFe. ", ex.getCause());
            throw new ExceptionJasperReports(ex.getMessage(), ex);
        }
        return filePdf;
    }

    private static File createXmlNFCe(String nameFile, NFCe nfce) throws Exception {
        File fileXml = ToolFile.createTempFile((String)(nameFile + "_" + nfce.getNumero() + "_" + nfce.getSerie()), (String)".xml");
        ToolFile.writeStringInFile((File)fileXml, (String)UtilXML.getXMLProcNFe(nfce));
        return fileXml;
    }
}

