/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.tasks.utils;

import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.eventonfe.NFeConstStatusEventoNFe;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementorclientwebservices.nfe.model.env.lotefat.NFeLoteFaturamento;
import com.touchcomp.basementorclientwebservices.nfe.model.ret.NFeEnviaEventoRet;
import com.touchcomp.basementorclientwebservices.nfe.model.ret.lotefat.NFeLoteDadosRet;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorexceptions.exceptions.impl.print.ExceptionPrint;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.constants.ConstantsNFCe;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeEventoEpec;
import com.touchcomp.touchnfce.model.NFCeLoteNotas;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.nfe.AuxEnviaNota;
import com.touchcomp.touchnfce.nfe.impl.versoes.ConfigCertificate;
import com.touchcomp.touchnfce.nfe.impl.versoes.ConstNFeVersoes;
import com.touchcomp.touchnfce.nfe.impl.versoes.UtilNfeSendWebServices;
import com.touchcomp.touchnfce.print.impl.PrintComprovantePIX;
import com.touchcomp.touchnfce.print.impl.PrintComprovanteTEF;
import com.touchcomp.touchnfce.print.impl.PrintDanfce;
import com.touchcomp.touchnfce.print.impl.PrintDanfe;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeEventoEpec;
import com.touchcomp.touchnfce.tasks.utils.UtilEmail;
import com.touchcomp.touchnfce.tasks.utils.UtilEnviaNFCeWebService;
import com.touchcomp.touchnfce.tasks.utils.UtilXMLFile;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import java.sql.Date;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import javafx.application.Platform;

public class UtilRetransmiteNFCeWebService {
    private static String DIR_AUTORIZACAO = "autorizadas";
    private static String DIR_EVENTO_EPEC = "evento_epec";

    public static NFCe execute(NFCe nfce) throws Exception {
        if (nfce.getInutilizacaoNFe() != null) {
            throw new Exception("NFCe n\u00e3o pode ser enviada, pois j\u00e1 possui uma inutiliza\u00e7\u00e3o vinculada " + String.valueOf(nfce));
        }
        if (nfce.getNfCeCancelamento() != null) {
            throw new Exception("NFCe n\u00e3o pode ser enviada, pois j\u00e1 possui um cancelamento vinculado " + String.valueOf(nfce));
        }
        nfce.setStatus(EnumConstNFeStatus.NFCE_CRIADA_ENVIADA_SEM_RET.getValue());
        nfce.setMotivo(EnumConstNFeStatus.NFCE_CRIADA_ENVIADA_SEM_RET.getDescricao());
        try {
            if (nfce.getNfceEventoEpec() != null && !ToolMethods.isEquals((Object)nfce.getNfceEventoEpec().getStatus(), (Object)NFeConstStatusEventoNFe.EVENTO_REGISTRADO_NAO_VINC_NFE.getCodigo().shortValue())) {
                UtilRetransmiteNFCeWebService.emissaoContigenciaEPEC(nfce);
            } else {
                UtilRetransmiteNFCeWebService.emissaoNormal(nfce);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        return UtilNFCe.save(nfce);
    }

    private static void emissaoNormal(NFCe nfce) throws Exception {
        NFeLoteFaturamento lt;
        NFCeOpcoes opcoes = StaticObjects.getOpcoes();
        Empresa empresa = nfce.getEmpresa();
        ConfigCertificate config = new ConfigCertificate(empresa.getPessoa().getEndereco().getCidade().getUf(), opcoes, UtilNFCe.getTipoEmissaoNFe(nfce));
        NFeLoteDadosRet stat = UtilNfeSendWebServices.enviarNota(config, ConstNFeVersoes.VERSAO_20180005_1_20, lt = new AuxEnviaNota(opcoes).criarNotaEnvio(nfce.getLoteNotas()));
        if (stat.getRetorno() != null) {
            nfce.getLoteNotas().setNumeroProtocolo(stat.getRetorno().getProtocoloRecebimentoSincrono());
            nfce.getLoteNotas().setStatus(new Short(stat.getRetorno().getStatus()));
            nfce.getLoteNotas().setRetorno(stat.getRetorno().getMotivo());
            if (stat.getRetorno().getProtocoloInfo() != null) {
                nfce.setStatus(Integer.valueOf(stat.getRetorno().getProtocoloInfo().getStatus()));
                nfce.setMotivo(stat.getRetorno().getProtocoloInfo().getMotivo());
                nfce.setTipoAmbiente(Integer.valueOf(stat.getRetorno().getProtocoloInfo().getAmbiente().getCodigo()));
                nfce.setNrProtocolo(stat.getRetorno().getProtocoloInfo().getNumeroProtocolo());
                LocalDateTime dataRec = stat.getRetorno().getProtocoloInfo().getDataRecebimento();
                nfce.setDataAutorizacao(Date.from(dataRec.atZone(ZoneId.systemDefault()).toInstant()));
            } else {
                nfce.setStatus(Integer.valueOf(stat.getRetorno().getStatus()));
                nfce.setMotivo(stat.getRetorno().getMotivo());
            }
        }
        List notas = stat.getLoteAssinado().getNotas();
        UtilRetransmiteNFCeWebService.setXMLNFCe(notas, nfce);
        UtilRetransmiteNFCeWebService.setXMLAutorizacao(stat.getRetorno(), nfce);
        UtilRetransmiteNFCeWebService.enviarPorEmail(nfce);
        UtilNFCe.atualizaStatusReenvioERP(nfce);
    }

    private static void enviarPorEmail(final NFCe nfce) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    UtilEmail.enviaNFePorEmail(nfce, StaticObjects.getOpcoes(), false);
                }
                catch (Exception e) {
                    TLogger.get(UtilEnviaNFCeWebService.class).error((Throwable)e);
                }
            }
        });
    }

    private static void setXMLAutorizacao(NFeLoteDadosRet.NFeLoteEnvioRetorno retorno, NFCe nfce) {
        if (retorno == null || retorno.getProtocoloInfo() == null || retorno.getProtocoloInfo().getXmlAutorizacao() == null) {
            return;
        }
        nfce.setXmlAutorizacao(retorno.getProtocoloInfo().getXmlAutorizacao().getBytes(ConstantsNFCe.CHARSET_ISO_8889));
    }

    private static void setXMLNFCe(List<NFNota> notas, NFCe nf) throws Exception {
        if (!EnumConstNFeStatus.isStatusAutorizadaOuContigencia((Integer)nf.getStatus())) {
            return;
        }
        NFNota found = null;
        for (NFNota n : notas) {
            if (!n.getInfo().getIdentificador().equals("NFe" + nf.getChaveNFCe())) continue;
            found = n;
        }
        if (found != null) {
            NFNota nfNota = found;
            String data = nfNota.toString();
            UtilXMLFile.saveOnFile(data, DIR_AUTORIZACAO, nf.getChaveNFCe() + ".xml");
            nf.setXml(nfNota.toString().getBytes(ConstantsNFCe.CHARSET_ISO_8889));
            nf.setDigestValue(nfNota.getAssinatura().getSignedInfo().getReference().getDigestValue());
            if (nfNota.getInfoSuplementar() != null) {
                nf.setUrlQrCode(nfNota.getInfoSuplementar().getQrCode());
                nf.setUrlConsulta(nfNota.getInfoSuplementar().getUrlConsultaChaveAcesso());
            }
        } else {
            throw new ExceptionErroProgramacao("Ocorreu um erro ao comparar as notas enviadas com o retorno. Verifique a NF id " + nf.getIdentificador());
        }
    }

    public static NFCe criaLoteNotas(NFCe nfce) {
        NFCeLoteNotas lote = nfce.getLoteNotas();
        if (lote == null) {
            lote = new NFCeLoteNotas();
            lote.getNotas().add(StaticObjects.getNfceAberta());
            lote.setVersaoNFe(StaticObjects.getOpcoes().getVersaoNFe());
            lote.setTipoAmbiente(StaticObjects.getOpcoes().getTipoAmbiente());
            nfce.setLoteNotas(lote);
        }
        return nfce;
    }

    public static NFCe posEnvio(NFCe nfce) {
        if (!EnumConstNFeStatus.isStatusAutorizadaOuContigencia((Integer)nfce.getStatus())) {
            System.out.println("\n\n\nOcorreu um problema ao enviar a NFCe de n\u00famero: " + nfce.getNumero().toString() + "\n\n\n" + nfce.getStatus() + " - " + nfce.getMotivo());
        } else if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getNaoImpNfceTransCons(), (Object)EnumConstantsMentorSimNao.NAO.getValue())) {
            UtilRetransmiteNFCeWebService.printDanfce(nfce, null);
            UtilRetransmiteNFCeWebService.printComprovanteTEF(nfce);
            UtilRetransmiteNFCeWebService.printComprovantePIX(nfce);
        }
        return nfce;
    }

    private static void printDanfce(NFCe nfce, Short tipoVia) {
        try {
            if (ToolMethods.isEquals((Object)nfce.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
                new PrintDanfe().printDanfce(nfce, StaticObjects.getOpcoes().getNrImpressoesNFe());
            } else {
                new PrintDanfce().printDanfce(nfce, tipoVia, StaticObjects.getOpcoes().getNrImpressoesNFCe());
            }
        }
        catch (ExceptionJasperReports exceptionJasperReports) {
            Alerts.showAlertError("Erro", "Erro ao imprimir a NFCe:\n\n" + exceptionJasperReports.getMessage());
            exceptionJasperReports.printStackTrace();
        }
        catch (ExceptionPrint exceptionPrint) {
            Alerts.showAlertError("Erro", "Erro ao imprimir a NFCe:\n\n" + exceptionPrint.getMessage());
            exceptionPrint.printStackTrace();
        }
    }

    private static void printComprovanteTEF(NFCe nfce) {
        PrintComprovanteTEF p = new PrintComprovanteTEF();
        try {
            p.printTEF(nfce);
        }
        catch (ExceptionJasperReports exceptionJasperReports) {
            Alerts.showAlertError("Erro", "Erro ao imprimir o comprovante do Debito/Cr\u00e9dito:\n\n" + exceptionJasperReports.getMessage());
            exceptionJasperReports.printStackTrace();
        }
        catch (ExceptionPrint exceptionPrint) {
            Alerts.showAlertError("Erro", "Erro ao imprimir o comprovante do Debito/Cr\u00e9dito:\n\n" + exceptionPrint.getMessage());
            exceptionPrint.printStackTrace();
        }
    }

    private static void emissaoContigenciaEPEC(NFCe nfce) throws Exception {
        NFCeOpcoes opcoes = StaticObjects.getOpcoes();
        Empresa empresa = nfce.getEmpresa();
        ConfigCertificate config = new ConfigCertificate(empresa.getPessoa().getEndereco().getCidade().getUf(), opcoes, UtilNFCe.getTipoEmissaoNFe(nfce));
        NFeLoteFaturamento lt = new AuxEnviaNota(opcoes).criarNotaEnvio(nfce.getLoteNotas());
        NFeEnviaEventoRet ret = UtilNfeSendWebServices.enviarNotaEPEC(config, ConstNFeVersoes.VERSAO_20180005_1_20, lt);
        UtilRetransmiteNFCeWebService.setXMLEpecNFe(ret.getDetEventos(), nfce);
    }

    private static void setXMLEpecNFe(List<NFeEnviaEventoRet.NFEEnviaEventoRetDet> eventos, NFCe nfce) throws Exception {
        NFCeEventoEpec nfceEventoEpec = null;
        if (nfce.getNfceEventoEpec() != null) {
            nfceEventoEpec = nfce.getNfceEventoEpec();
        } else {
            nfceEventoEpec = new NFCeEventoEpec();
            nfceEventoEpec.setNfce(nfce);
            nfce.setStatus(EnumConstNFeStatus.NFCE_CRIADA_CONTIGENCIA_SEM_ENVIO.getValue());
            nfce.setMotivo(EnumConstNFeStatus.NFCE_CRIADA_CONTIGENCIA_SEM_ENVIO.getDescricao());
        }
        for (NFeEnviaEventoRet.NFEEnviaEventoRetDet nf : eventos) {
            boolean isPresent = false;
            for (NFeEnviaEventoRet.NFEEnviaEventoRetDet e : eventos) {
                if (!ToolMethods.isEquals((Object)nfceEventoEpec.getNfce().getChaveNFCe(), (Object)nf.getChave())) continue;
                isPresent = true;
                break;
            }
            if (isPresent) {
                String data = nf.toString();
                UtilXMLFile.saveOnFile(data, DIR_EVENTO_EPEC, nf.getChave() + ".xml");
                nfceEventoEpec.setXmlEpec(data.getBytes());
                nfceEventoEpec.setMotivo(nf.getMotivo());
                nfceEventoEpec.setStatus(nf.getCodigoStatus().shortValue());
                nfceEventoEpec.setNrProtocolo(nf.getNumeroProtocolo());
                nfceEventoEpec.setChave(nf.getChave());
                nfceEventoEpec.setDataHoraProt(nf.getDataHoraRegistro());
                ServiceNFCeEventoEpec seviceEpec = Main.getBean(ServiceNFCeEventoEpec.class);
                seviceEpec.save(nfceEventoEpec);
                continue;
            }
            throw new ExceptionErroProgramacao("Ocorreu um erro ao comparar as notas enviadas com o retorno. Verifique a NF id " + nfceEventoEpec.getNfce().getNumero());
        }
    }

    private static void printComprovantePIX(NFCe nfce) {
        PrintComprovantePIX p = new PrintComprovantePIX();
        try {
            p.printPIX(nfce);
        }
        catch (ExceptionJasperReports | ExceptionPrint exceptionJasperReports) {
            Alerts.showAlertError("Erro", "Erro ao imprimir o comprovante do Debito/Credito:\n\n" + exceptionJasperReports.getMessage());
            exceptionJasperReports.printStackTrace();
        }
    }
}

