/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils;

import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchnfce.components.TouchDataField;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public abstract class MaskField {
    private static List<KeyCode> ignoreKeyCodes = new ArrayList<KeyCode>();

    public static void ignoreKeys(TextField textField) {
        textField.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (ignoreKeyCodes.contains(keyEvent.getCode())) {
                    keyEvent.consume();
                }
            }
        });
    }

    public static void serialTextField(TextField textField) {
        MaskField.maxField(textField, 23);
        textField.lengthProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.intValue() < 24) {
                String value = textField.getText();
                value = value.replaceAll("[^\\w]", "");
                value = value.replaceFirst("(\\w{5})(\\w)", "$1-$2");
                value = value.replaceFirst("(\\w{5})\\-(\\w{5})(\\w)", "$1-$2-$3");
                value = value.replaceFirst("(\\w{5})\\-(\\w{5})\\-(\\w{5})(\\w)", "$1-$2-$3-$4");
                textField.setText(value.toUpperCase());
                MaskField.positionCaret(textField);
            }
        });
    }

    public static void dateField(final TextField textField) {
        MaskField.maxField(textField, 10);
        textField.lengthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (newValue.intValue() < 11) {
                    String value = textField.getText();
                    value = value.replaceAll("[^0-9]", "");
                    value = value.replaceFirst("(\\d{2})(\\d)", "$1/$2");
                    value = value.replaceFirst("(\\d{2})\\/(\\d{2})(\\d)", "$1/$2/$3");
                    textField.setText(value);
                    MaskField.positionCaret(textField);
                }
            }
        });
    }

    public static void dateField(final TouchDataField textField) {
        MaskField.maxField(textField, 10);
        textField.lengthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (newValue.intValue() < 10) {
                    String value = textField.getText();
                    value = value.replaceAll("[^0-9]", "");
                    value = value.replaceFirst("(\\d{2})(\\d)", "$1/$2");
                    value = value.replaceFirst("(\\d{2})\\/(\\d{2})(\\d)", "$1/$2/$3");
                    textField.setText(value);
                    MaskField.positionCaret(textField);
                } else {
                    try {
                        ToolDate.strToDate((String)textField.getText(), (String)"dd/MM/yyyy");
                        textField.nextFocus();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public static void dateScheduleField(final TextField textField) {
        MaskField.maxField(textField, 10);
        textField.lengthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (newValue.intValue() < 11) {
                    String value = textField.getText();
                    value = value.replaceAll("[^0-9]", "");
                    value = value.replaceFirst("(\\d{2})(\\d)", "$1/$2");
                    value = value.replaceFirst("(\\d{2})\\/(\\d{2})(\\d)", "$1/$2/$3");
                    textField.setText(value);
                    MaskField.positionCaret(textField);
                }
            }
        });
    }

    public static void monthYearField(final TextField textField) {
        MaskField.maxField(textField, 5);
        textField.lengthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (newValue.intValue() < 4) {
                    String value = textField.getText();
                    value = value.replaceAll("[^0-9]", "");
                    value = value.replaceFirst("(\\d{2})(\\d)", "$1/$2");
                    value = value.replaceFirst("(\\d{2})\\/(\\d{2})", "$1/$2/$3");
                    textField.setText(value);
                    MaskField.positionCaret(textField);
                }
            }
        });
    }

    public static void numericField(final TextField textField) {
        textField.lengthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                char ch;
                if (newValue.intValue() > oldValue.intValue() && ((ch = textField.getText().charAt(oldValue.intValue())) < '0' || ch > '9')) {
                    textField.setText(textField.getText().substring(0, textField.getText().length() - 1));
                }
            }
        });
    }

    public static String double3Casas(Double value) {
        DecimalFormat df = new DecimalFormat("0.000");
        String text = df.format(value);
        return text;
    }

    public static String monetaryField(Double value) {
        DecimalFormat df = new DecimalFormat("0.00");
        String text = df.format(value);
        text = text.replaceAll("[^0-9]", "");
        text = text.replaceAll("([0-9]{1})([0-9]{14})$", "$1.$2");
        text = text.replaceAll("([0-9]{1})([0-9]{11})$", "$1.$2");
        text = text.replaceAll("([0-9]{1})([0-9]{8})$", "$1.$2");
        text = text.replaceAll("([0-9]{1})([0-9]{5})$", "$1.$2");
        text = text.replaceAll("([0-9]{1})([0-9]{2})$", "$1,$2");
        return text;
    }

    public static void monetaryField(final TextField textField) {
        textField.setAlignment(Pos.CENTER_RIGHT);
        textField.lengthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                String value = textField.getText();
                value = value.replaceAll("[^0-9]", "");
                value = value.replaceAll("([0-9]{1})([0-9]{14})$", "$1.$2");
                value = value.replaceAll("([0-9]{1})([0-9]{11})$", "$1.$2");
                value = value.replaceAll("([0-9]{1})([0-9]{8})$", "$1.$2");
                value = value.replaceAll("([0-9]{1})([0-9]{5})$", "$1.$2");
                value = value.replaceAll("([0-9]{1})([0-9]{2})$", "$1,$2");
                textField.setText(value);
                MaskField.positionCaret(textField);
            }
        });
        textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String oldValue, String newValue) {
                if (newValue.length() > 17) {
                    textField.setText(oldValue);
                }
            }
        });
        textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean aBoolean, Boolean fieldChange) {
                int length;
                if (!fieldChange.booleanValue() && (length = textField.getText().length()) > 0 && length < 3) {
                    textField.setText(textField.getText() + "00");
                }
            }
        });
    }

    public static BigDecimal monetaryValueFromField(TextField textField) {
        if (textField.getText().isEmpty()) {
            return null;
        }
        BigDecimal retorno = BigDecimal.ZERO;
        NumberFormat nf = NumberFormat.getNumberInstance();
        try {
            Number parsedNumber = nf.parse(textField.getText());
            retorno = new BigDecimal(parsedNumber.toString());
        }
        catch (ParseException ex) {
            Logger.getLogger(MaskField.class.getName()).log(Level.SEVERE, null, ex);
        }
        return retorno;
    }

    public static void cpfCnpjField(TextField textField) {
        MaskField.maxField(textField, 18);
        textField.lengthProperty().addListener((observableValue, number, number2) -> {
            String value = textField.getText();
            if (number2.intValue() <= 14) {
                value = value.replaceAll("[^0-9]", "");
                value = value.replaceFirst("(\\d{3})(\\d)", "$1.$2");
                value = value.replaceFirst("(\\d{3})(\\d)", "$1.$2");
                value = value.replaceFirst("(\\d{3})(\\d)", "$1-$2");
            } else {
                value = value.replaceAll("[^0-9]", "");
                value = value.replaceFirst("(\\d{2})(\\d)", "$1.$2");
                value = value.replaceFirst("(\\d{3})(\\d)", "$1.$2");
                value = value.replaceFirst("(\\d{3})(\\d)", "$1/$2");
                value = value.replaceFirst("(\\d{4})(\\d)", "$1-$2");
            }
            textField.setText(value);
            MaskField.positionCaret(textField);
        });
    }

    public static void cepField(TextField textField) {
        MaskField.maxField(textField, 9);
        textField.lengthProperty().addListener((observableValue, number, number2) -> {
            String value = textField.getText();
            value = value.replaceAll("[^0-9]", "");
            value = value.replaceFirst("(\\d{5})(\\d)", "$1-$2");
            textField.setText(value);
            MaskField.positionCaret(textField);
        });
    }

    public static void qtd(TextField textField) {
        MaskField.maxField(textField, 9);
        textField.lengthProperty().addListener((observableValue, number, number2) -> {
            String value = textField.getText();
            value = (value = value.replaceAll("[^0-9]", "")).length() > 3 ? value.replaceFirst("(\\d{" + (value.length() - 3) + "})(\\d{3})", "$1,$2") : value.replaceFirst("(\\d)(\\d{3})", "$1,$2");
            textField.setText(value);
            MaskField.positionCaret(textField);
        });
    }

    public static void foneField(TextField textField) {
        MaskField.maxField(textField, 14);
        textField.lengthProperty().addListener((observableValue, number, number2) -> {
            try {
                String value = textField.getText();
                value = value.replaceAll("[^0-9]", "");
                int tam = value.length();
                value = value.replaceFirst("(\\d{2})(\\d)", "($1)$2");
                value = value.replaceFirst("(\\d{4})(\\d)", "$1-$2");
                if (tam > 10) {
                    value = value.replaceAll("-", "");
                    value = value.replaceFirst("(\\d{5})(\\d)", "$1-$2");
                }
                textField.setText(value);
                MaskField.positionCaret(textField);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static String cpfField(String text) {
        String value = text;
        value = value.replaceAll("[^0-9]", "");
        value = value.replaceFirst("(\\d{3})(\\d)", "$1.$2");
        value = value.replaceFirst("(\\d{3})(\\d)", "$1.$2");
        value = value.replaceFirst("(\\d{3})(\\d)", "$1-$2");
        return value;
    }

    public static String cnpjField(String text) {
        String value = text;
        value = value.replaceAll("[^0-9]", "");
        value = value.replaceFirst("(\\d{2})(\\d)", "$1.$2");
        value = value.replaceFirst("(\\d{3})(\\d)", "$1.$2");
        value = value.replaceFirst("(\\d{3})(\\d)", "$1/$2");
        value = value.replaceFirst("(\\d{4})(\\d)", "$1-$2");
        return value;
    }

    public static void cnpjField(TextField textField) {
        MaskField.maxField(textField, 18);
        textField.lengthProperty().addListener((observableValue, number, number2) -> {
            String value = textField.getText();
            value = value.replaceAll("[^0-9]", "");
            value = value.replaceFirst("(\\d{2})(\\d)", "$1.$2");
            value = value.replaceFirst("(\\d{3})(\\d)", "$1.$2");
            value = value.replaceFirst("(\\d{3})(\\d)", "$1/$2");
            value = value.replaceFirst("(\\d{4})(\\d)", "$1-$2");
            textField.setText(value);
            MaskField.positionCaret(textField);
        });
    }

    public static void alfaNumericField(TextField textField) {
        textField.textProperty().addListener((observableValue, oldValue, newValue) -> {});
    }

    public static void positionCaret(TextField textField) {
        Platform.runLater(() -> {
            if (textField.getText().length() != 0) {
                textField.positionCaret(textField.getText().length());
            }
        });
    }

    public static void maxField(TextField textField, Integer length) {
        textField.textProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue == null || newValue.length() > length) {
                textField.setText(oldValue);
            }
        });
    }

    public static String onlyDigitsDoubleValue(TextField field) {
        String result = field.getText();
        if (result == null) {
            return null;
        }
        return result.replaceAll("[^0-9.]", "");
    }

    public static Double doubleValue(String result) {
        if (result == null) {
            return null;
        }
        result.replaceAll("[^0-9.]", "");
        Double vlr = new Double(result);
        return vlr;
    }

    public static String onlyDigitsIntValue(TextField field) {
        String result = field.getText();
        if (result == null) {
            return null;
        }
        return result.replaceAll("[^0-9]", "");
    }

    public static String onlyAlfaNumericValue(TextField field) {
        String result = field.getText();
        if (result == null) {
            return null;
        }
        return result;
    }

    static {
        Collections.addAll(ignoreKeyCodes, KeyCode.F1, KeyCode.F2, KeyCode.F3, KeyCode.F4, KeyCode.F5, KeyCode.F6, KeyCode.F7, KeyCode.F8, KeyCode.F9, KeyCode.F10, KeyCode.F11, KeyCode.F12);
    }
}

