/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoAutenticacao;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.login.LoginAutorizacaoController;
import com.touchcomp.touchnfce.exceptions.ExceptionClienteFinanceiro;
import com.touchcomp.touchnfce.exceptions.ExceptionSincronizacao;
import com.touchcomp.touchnfce.model.Cliente;
import com.touchcomp.touchnfce.model.ConfigValPedidos;
import com.touchcomp.touchnfce.model.ConfigValPedidosItem;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeLogPermissaoUsuario;
import com.touchcomp.touchnfce.modeltemp.ResAnaliseFinanceiraPessoa;
import com.touchcomp.touchnfce.utils.UtilNFCeCalculos;
import com.touchcomp.touchnfce.utils.UtilPermissaoUsuario;
import com.touchcomp.touchnfce.utils.analisefinanceira.SplashAnaliseFinanceira;
import com.touchcomp.touchvomodel.vo.estatisticascliente.nfce.DTONFCeEstatisticasPessoa;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javafx.scene.control.ButtonType;

public class UtilCliente {
    public static final String DATA_LIBERACAO_EXPIRADA = "* A data de libera\u00e7\u00e3o do cr\u00e9dito esta expirada, uma nova an\u00e1lise dever\u00e1 ser feita.\n";
    public static final String CLIENTE_INABILITADO_PARA_COMPRA = "* O cliente est\u00e1 inabilitado para compras.\n";
    public static final String LIMITE_CREDITO_INFERIOR = "* O limite de cr\u00e9dito do cliente \u00e9 R$: ";
    public static final String CLIENTE_POSSUI_TITULOS_VENCIDOS = "* Cliente possui t\u00edtulos vencidos.";
    public static final String CLIENTE_POSSUI_CHEQUES_DEVOLVIDOS = "* Cliente possui problemas com cheques.";
    public static final String LIMITE_CREDITO_INFERIOR_COMPRA = "* O valor de limite de cr\u00e9dito disponivel \u00e9 inferior ao valor total da compra.\n";
    public static final Integer CODIGO_CLIENTE_POSSUI_TITULOS_VENCIDOS = 900;
    public static final Integer CODIGO_CLIENTE_POSSUI_CHEQUES_DEVOLVIDOS = 901;
    public static final Integer CODIGO_LIMITE_CREDITO_INFERIOR = 902;
    public static final Integer CODIGO_LIMITE_CREDITO_INFERIOR_COMPRA = 903;
    public static final Integer CODIGO_CLIENTE_INABILITADO_PARA_COMPRA = 904;
    public static final Integer CODIGO_DATA_LIBERACAO_EXPIRADA = 905;
    public static final String TIPO_AVALIACAO_NAO_CADASTRADA = "* Tipo de Avalia\u00e7\u00e3o n\u00e3o cadastrada, refa\u00e7a o cadastro em Opcoes NFCe pelo ERP.";
    public static final String OPERACAO_CANCELADA = "* Opera\u00e7\u00e3o cancelada, primeiro resolva as pend\u00eancias.";
    public static final String CLIENTE_POSSUI_RESTRICOES = "* O Cliente possui restri\u00e7\u00f5es, deseja continuar?";

    public static void analiseCreditoCliente(Cliente cliente, Double newValorCompra) throws ExceptionClienteFinanceiro, ExceptionSincronizacao, Exception {
        block8: {
            if (!ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getAvaliarLimiteCredito(), (Object)1)) {
                return;
            }
            if (StaticObjects.getOpcoes().getUnidadeFatCliente() != null && ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getUnidadeFatCliente().getCliente(), (Object)cliente)) {
                return;
            }
            if (ToolMethods.isEquals((Object)cliente.getFinanceiro().getNaoAvaliarFinanceiro(), (Object)1)) {
                return;
            }
            ResAnaliseFinanceiraPessoa res = new ResAnaliseFinanceiraPessoa();
            UtilCliente.tratativasCadastroCliente(cliente, res);
            if (UtilCliente.liberadoConsultaServidor()) {
                try {
                    SplashAnaliseFinanceira splash = new SplashAnaliseFinanceira(cliente);
                    splash.showAndWait();
                    DTONFCeEstatisticasPessoa dados = (DTONFCeEstatisticasPessoa)splash.get();
                    UtilCliente.tratativasAnaliseCreditoCliente(dados, cliente, newValorCompra, res);
                }
                catch (Exception ex) {
                    TLogger.get(UtilCliente.class).error((Throwable)ex);
                    throw ex;
                }
            }
            try {
                UtilCliente.validacaoByTipoAvaliacao(res, StaticObjects.getOpcoes().getTipoAvaliacao());
            }
            catch (ExceptionClienteFinanceiro ex) {
                TLogger.get(UtilCliente.class).error((Throwable)ex);
                if (UtilCliente.criarLogPermissao(null, ex, "Houve problemas junto a an\u00e1lise financeira do cliente, deseja liberar?\n")) break block8;
                throw ex;
            }
        }
    }

    public static void analiseCreditoCliente(NFCe nfce, Double newValorCompra) throws ExceptionClienteFinanceiro, ExceptionSincronizacao, InterruptedException, ExecutionException {
        block13: {
            ResAnaliseFinanceiraPessoa res;
            block12: {
                if (!ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getAvaliarLimiteCredito(), (Object)1)) {
                    return;
                }
                if (nfce == null) {
                    return;
                }
                if (nfce.getUnidadeFatCliente() == null) {
                    return;
                }
                Cliente cliente = nfce.getUnidadeFatCliente().getCliente();
                if (StaticObjects.getOpcoes().getUnidadeFatCliente() != null && ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getUnidadeFatCliente().getCliente(), (Object)cliente)) {
                    return;
                }
                Optional<NFCeLogPermissaoUsuario> found = nfce.getLiberacoes().stream().filter(i -> ToolMethods.isEquals((Object)i.getTipoAutorizacao(), (Object)EnumConstNFCeTipoAutenticacao.AUTENTICACAO_LIBERACAO_FINANCEIRA_CLIENTE.getValue())).findFirst();
                if (found.isPresent()) {
                    return;
                }
                UtilCliente.tratativasExcecaoDireto(cliente);
                res = new ResAnaliseFinanceiraPessoa();
                if (ToolMethods.isEquals((Object)cliente.getFinanceiro().getNaoAvaliarFinanceiro(), (Object)0)) {
                    UtilCliente.tratativasCadastroCliente(cliente, res);
                }
                if (UtilCliente.liberadoConsultaServidor()) {
                    try {
                        DTONFCeEstatisticasPessoa dados = UtilCliente.consultarEDefinirLimiteCliente(nfce);
                        nfce.setValorLimiteDispPosVenda(UtilNFCeCalculos.getValorLimitePosVenda(nfce));
                        nfce.setLimiteCredito(nfce.getUnidadeFatCliente().getCliente().getFinanceiro().getLimiteCredito());
                        nfce.setTotalCompras(dados.getSaldoTitulosAbertos() + dados.getValorChequesNaoCompensados() + dados.getValorChequesDevolvidos());
                        if (ToolMethods.isEquals((Object)cliente.getFinanceiro().getNaoAvaliarFinanceiro(), (Object)0)) {
                            UtilCliente.tratativasAnaliseCreditoCliente(dados, cliente, newValorCompra, res);
                        }
                    }
                    catch (ExceptionSincronizacao | InterruptedException | ExecutionException ex) {
                        TLogger.get(UtilCliente.class).error((Throwable)ex);
                        if (UtilCliente.criarLogPermissao(nfce, ex, "Houve problemas ao consultar os dados do cliente, deseja liberar? Voc\u00ea pode tentar novamente e verificar os dados de conex\u00e3o.")) break block12;
                        throw ex;
                    }
                }
            }
            try {
                UtilCliente.validacaoByTipoAvaliacao(res, StaticObjects.getOpcoes().getTipoAvaliacao());
            }
            catch (ExceptionClienteFinanceiro ex) {
                TLogger.get(UtilCliente.class).error((Throwable)ex);
                if (UtilCliente.criarLogPermissao(nfce, ex, "Houve problemas junto a an\u00e1lise financeira do cliente, deseja liberar?\n")) break block13;
                throw ex;
            }
        }
    }

    private static Double getValorLimiteDisp(Double saldoDev, Cliente cliente) {
        return cliente.getFinanceiro().getLimiteCredito() - saldoDev;
    }

    private static void validacaoByTipoAvaliacao(ResAnaliseFinanceiraPessoa res, Short tipoAvaliacao) throws ExceptionClienteFinanceiro {
        if (!res.hasProblem()) {
            return;
        }
        if (tipoAvaliacao == null) {
            throw new ExceptionClienteFinanceiro("Tipo de Avalia\u00e7\u00e3o de cliente n\u00e3o definido");
        }
        if (ToolMethods.isEquals((Object)tipoAvaliacao, (Object)1)) {
            ArrayList<Integer> errorCode = new ArrayList<Integer>();
            for (Integer codigo : res.getErrorCode()) {
                errorCode.add(codigo);
            }
            throw new ExceptionClienteFinanceiro("Cliente possui restri\u00e7\u00f5es. Os detalhes abaixo s\u00e3o informativos. Consulte o cliente junto ao setor financeiro para mais informa\u00e7\u00f5es.\n" + res.toString() + "\n", errorCode);
        }
        EnumConstantsMentorSimNao ret = Alerts.showQuestionYesNo("", "", CLIENTE_POSSUI_RESTRICOES, null);
        if (ret.equals((Object)EnumConstantsMentorSimNao.SIM)) {
            Alerts.showAlertInfo("Restri\u00e7\u00f5es Avaliadas", res.toString());
            res.setHasProblems(false);
        }
    }

    private static void tratativasExcecaoDireto(Cliente cliente) throws ExceptionClienteFinanceiro {
        if (cliente.getPessoa() != null && ToolMethods.isEquals((Object)cliente.getPessoa().getAtivo(), (Object)0)) {
            throw new ExceptionClienteFinanceiro("Cliente/Pessoa Inativo");
        }
        if (cliente != null && ToolMethods.isEquals((Object)cliente.getAtivo(), (Object)0)) {
            throw new ExceptionClienteFinanceiro("Cliente/Pessoa Inativo");
        }
        if (ToolMethods.isEquals((Object)cliente.getFinanceiro().getHabilParaCompra(), (Object)0)) {
            throw new ExceptionClienteFinanceiro(CLIENTE_INABILITADO_PARA_COMPRA);
        }
    }

    private static boolean criarLogPermissao(NFCe nfce, Exception ex, String message) {
        Optional<ButtonType> resp = Alerts.showQuestion(message + "\n\n" + ex.getMessage());
        if (resp.isPresent() && resp.get() == ButtonType.OK) {
            HashMap<String, List<Integer>> h = new HashMap<String, List<Integer>>();
            if (ex instanceof ExceptionClienteFinanceiro) {
                h.put("validacoes_liberacao_financeira", ((ExceptionClienteFinanceiro)ex).getErrorCode());
            }
            h.put("tipo_autenticacao", (List<Integer>)EnumConstNFCeTipoAutenticacao.AUTENTICACAO_LIBERACAO_FINANCEIRA_CLIENTE);
            LoginAutorizacaoController loginController = (LoginAutorizacaoController)Main.get().showDialog(Controllers.LOGIN_AUTORIZACAO, h);
            if (loginController.getUsuario() == null) {
                Alerts.showAlertError("Voc\u00ea n\u00e3o possui autoriza\u00e7\u00e3o para realizar essa opera\u00e7\u00e3o");
                return false;
            }
            if (nfce != null) {
                nfce.getLiberacoes().add(UtilPermissaoUsuario.createLogPermissaoUser(loginController.getUsuario(), EnumConstNFCeTipoAutenticacao.AUTENTICACAO_LIBERACAO_FINANCEIRA_CLIENTE, nfce, null));
            }
            return true;
        }
        return false;
    }

    private static DTONFCeEstatisticasPessoa restAnaliseCreditoCliente(Cliente cliente) throws ExceptionSincronizacao, InterruptedException, ExecutionException {
        SplashAnaliseFinanceira splash = new SplashAnaliseFinanceira(cliente);
        splash.showAndWait();
        DTONFCeEstatisticasPessoa dados = (DTONFCeEstatisticasPessoa)splash.get();
        return dados;
    }

    public static Integer analiseFinanceiraDataValidade(Date dataLiberacao, Integer diasLimite) {
        diasLimite = diasLimite == null ? 0 : diasLimite;
        if (dataLiberacao != null) {
            dataLiberacao = ToolDate.nextDays((Date)dataLiberacao, (int)diasLimite);
        }
        if (dataLiberacao == null) {
            return -1;
        }
        if (ToolDate.dataSemHora((Date)new Date()).after(ToolDate.dataSemHora((Date)dataLiberacao))) {
            return -1;
        }
        return ToolDate.diferenceDayBetweenDates((Date)new Date(), (Date)dataLiberacao);
    }

    private static void tratativasAnaliseCreditoCliente(DTONFCeEstatisticasPessoa det, Cliente cliente, Double newValorCompra, ResAnaliseFinanceiraPessoa res) throws ExceptionClienteFinanceiro {
        Boolean achou;
        Boolean achou2;
        ConfigValPedidos config = StaticObjects.getOpcoes().getConfigValPedidos();
        if (det.getSaldoTitulosVencidosAbertosCarencia() > 0.0) {
            achou2 = false;
            achou2 = ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getTipoAvaliacaoFinanceira(), (Object)1) ? UtilCliente.getConfigAvalItemPedidoAtivo(config, CODIGO_CLIENTE_POSSUI_TITULOS_VENCIDOS) : Boolean.valueOf(true);
            if (achou2.booleanValue()) {
                res.addProblem(CLIENTE_POSSUI_TITULOS_VENCIDOS, CODIGO_CLIENTE_POSSUI_TITULOS_VENCIDOS);
            }
        }
        if (det.getNumTitulosCartorio() > 0L) {
            achou2 = false;
            achou2 = ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getTipoAvaliacaoFinanceira(), (Object)1) ? UtilCliente.getConfigAvalItemPedidoAtivo(config, CODIGO_CLIENTE_POSSUI_TITULOS_VENCIDOS) : Boolean.valueOf(true);
            if (achou2.booleanValue()) {
                res.addProblem(CLIENTE_POSSUI_TITULOS_VENCIDOS, CODIGO_CLIENTE_POSSUI_TITULOS_VENCIDOS);
            }
        }
        if (det.getNumTitulosProtestados() > 0L) {
            achou2 = false;
            achou2 = ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getTipoAvaliacaoFinanceira(), (Object)1) ? UtilCliente.getConfigAvalItemPedidoAtivo(config, CODIGO_CLIENTE_POSSUI_TITULOS_VENCIDOS) : Boolean.valueOf(true);
            if (achou2.booleanValue()) {
                res.addProblem(CLIENTE_POSSUI_TITULOS_VENCIDOS, CODIGO_CLIENTE_POSSUI_TITULOS_VENCIDOS);
            }
        }
        if (det.getValorChequesDevolvidos() > 0.0) {
            achou2 = false;
            achou2 = ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getTipoAvaliacaoFinanceira(), (Object)1) ? UtilCliente.getConfigAvalItemPedidoAtivo(config, CODIGO_CLIENTE_POSSUI_CHEQUES_DEVOLVIDOS) : Boolean.valueOf(true);
            if (achou2.booleanValue()) {
                res.addProblem(CLIENTE_POSSUI_CHEQUES_DEVOLVIDOS, CODIGO_CLIENTE_POSSUI_CHEQUES_DEVOLVIDOS);
            }
        }
        if (cliente.getFinanceiro().getLimiteCredito() <= 0.0) {
            achou2 = false;
            achou2 = ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getTipoAvaliacaoFinanceira(), (Object)1) ? UtilCliente.getConfigAvalItemPedidoAtivo(config, CODIGO_LIMITE_CREDITO_INFERIOR) : Boolean.valueOf(true);
            if (achou2.booleanValue()) {
                res.addProblem("* O limite de cr\u00e9dito do cliente \u00e9 R$:  " + ToolFormatter.formataNumero((Number)cliente.getFinanceiro().getLimiteCredito(), (int)2), CODIGO_LIMITE_CREDITO_INFERIOR);
                return;
            }
        }
        Boolean validacaoSaldoDevedorVerificada = false;
        if (det.getSaldoDevedor() > cliente.getFinanceiro().getLimiteCredito()) {
            achou = false;
            achou = ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getTipoAvaliacaoFinanceira(), (Object)1) ? UtilCliente.getConfigAvalItemPedidoAtivo(config, CODIGO_LIMITE_CREDITO_INFERIOR) : Boolean.valueOf(true);
            if (achou.booleanValue()) {
                res.addProblem("* O limite de cr\u00e9dito do cliente \u00e9 R$:  \nSaldo Devedor: " + ToolFormatter.formataNumero((Number)det.getSaldoDevedor(), (int)2) + " \nValor Limite: " + ToolFormatter.formataNumero((Number)cliente.getFinanceiro().getLimiteCredito(), (int)2) + " \nSaldo: " + ToolFormatter.formataNumero((Number)(cliente.getFinanceiro().getLimiteCredito() - Math.abs(det.getSaldoDevedor())), (int)2), CODIGO_LIMITE_CREDITO_INFERIOR);
                validacaoSaldoDevedorVerificada = true;
            }
        }
        if (det.getSaldoDevedor() + newValorCompra > cliente.getFinanceiro().getLimiteCredito() && !validacaoSaldoDevedorVerificada.booleanValue()) {
            achou = false;
            achou = ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getTipoAvaliacaoFinanceira(), (Object)1) ? UtilCliente.getConfigAvalItemPedidoAtivo(config, CODIGO_LIMITE_CREDITO_INFERIOR_COMPRA) : Boolean.valueOf(true);
            if (achou.booleanValue()) {
                res.addProblem("* O valor de limite de cr\u00e9dito disponivel \u00e9 inferior ao valor total da compra.\n \nSaldo Devedor: " + ToolFormatter.formataNumero((Number)det.getSaldoDevedor(), (int)2) + " \nValor Limite: " + ToolFormatter.formataNumero((Number)cliente.getFinanceiro().getLimiteCredito(), (int)2) + " \nValor Compra: " + ToolFormatter.formataNumero((Number)newValorCompra, (int)2) + " \nValor Compra + Saldo: " + ToolFormatter.formataNumero((Number)(newValorCompra + det.getSaldoDevedor()), (int)2) + " \nSaldo C/ Compra: " + ToolFormatter.formataNumero((Number)(cliente.getFinanceiro().getLimiteCredito() - newValorCompra - Math.abs(det.getSaldoDevedor())), (int)2), CODIGO_LIMITE_CREDITO_INFERIOR_COMPRA);
            }
        }
    }

    public static DTONFCeEstatisticasPessoa consultarEDefinirLimiteCliente(NFCe nfce) throws ExceptionSincronizacao, InterruptedException, ExecutionException {
        if (UtilCliente.liberadoConsultaServidor()) {
            DTONFCeEstatisticasPessoa dados = UtilCliente.restAnaliseCreditoCliente(nfce.getUnidadeFatCliente().getCliente());
            nfce.setValorLimiteDispAntesVenda(UtilCliente.getValorLimiteDisp(dados.getSaldoDevedor(), nfce.getUnidadeFatCliente().getCliente()));
            nfce.setValorLimiteDispPosVenda(nfce.getValorLimiteDispAntesVenda());
            nfce.setLimiteCredito(nfce.getUnidadeFatCliente().getCliente().getFinanceiro().getLimiteCredito());
            nfce.setTotalCompras(dados.getSaldoTitulosAbertos() + dados.getValorChequesNaoCompensados() + dados.getValorChequesDevolvidos());
            return dados;
        }
        return null;
    }

    private static void tratativasCadastroCliente(Cliente cliente, ResAnaliseFinanceiraPessoa res) {
        Boolean achou;
        ConfigValPedidos config = StaticObjects.getOpcoes().getConfigValPedidos();
        if (ToolMethods.isEquals((Object)cliente.getFinanceiro().getHabilParaCompra(), (Object)0)) {
            achou = false;
            achou = ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getTipoAvaliacaoFinanceira(), (Object)1) ? UtilCliente.getConfigAvalItemPedidoAtivo(config, CODIGO_CLIENTE_INABILITADO_PARA_COMPRA) : Boolean.valueOf(true);
            if (achou.booleanValue()) {
                res.addProblem(CLIENTE_INABILITADO_PARA_COMPRA, CODIGO_CLIENTE_INABILITADO_PARA_COMPRA);
            }
        }
        if (ToolMethods.isNull((Object)cliente.getFinanceiro().getDataLiberacaoCredito()).booleanValue() || cliente.getFinanceiro().getDiasVigorLimiteCred() < 0 || ToolDate.nextDays((Date)cliente.getFinanceiro().getDataLiberacaoCredito(), (int)cliente.getFinanceiro().getDiasVigorLimiteCred()).before(ToolDate.dataSemHora((Date)new Date()))) {
            achou = false;
            achou = ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getTipoAvaliacaoFinanceira(), (Object)1) ? UtilCliente.getConfigAvalItemPedidoAtivo(config, CODIGO_DATA_LIBERACAO_EXPIRADA) : Boolean.valueOf(true);
            if (achou.booleanValue()) {
                res.addProblem(DATA_LIBERACAO_EXPIRADA, CODIGO_DATA_LIBERACAO_EXPIRADA);
            }
        }
    }

    private static boolean liberadoConsultaServidor() {
        return true;
    }

    private static Boolean getConfigAvalItemPedidoAtivo(ConfigValPedidos config, Integer codigo) {
        for (ConfigValPedidosItem item : config.getItens()) {
            if (!ToolMethods.isEquals((Object)item.getCodigo(), (Object)codigo) || !ToolMethods.isEquals((Object)item.getAtivo(), (Object)1)) continue;
            return true;
        }
        return false;
    }
}

