/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils;

import com.touchcomp.basementor.constants.enums.EnumConstPercentualValor;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.cfop.EnumConstCfop;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstMotivoDesoneracaoIcms;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstNFeIncidenciaIcms;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoAliquotaFCP;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoAliquotaIcms;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoCalcIcmsST;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoCalculoDiferencaAliquota;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoIcmsDispensado;
import com.touchcomp.basementor.constants.enums.impostos.ipi.EnumConstNFeIncidenciaIpi;
import com.touchcomp.basementor.constants.enums.impostos.piscofins.EnumConstNFeIncidenciaCofins;
import com.touchcomp.basementor.constants.enums.impostos.piscofins.EnumConstTipoCalcPisCofins;
import com.touchcomp.basementor.constants.enums.modalidadeicms.EnumConstModIcms;
import com.touchcomp.basementor.constants.enums.modalidadeicmsst.EnumConstModIcmsST;
import com.touchcomp.basementor.constants.enums.modelofiscalicms.EnumConstModFiscalDifal;
import com.touchcomp.basementor.constants.enums.modelofiscalicms.EnumConstModFiscalDifalST;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndIntermediador;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoPagNFe;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeVersao;
import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementor.constants.enums.regimetributario.EnumConstRegimeTributario;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoipi.ExceptionImpostoIPI;
import com.touchcomp.basementorexceptions.exceptions.impl.impostopiscofins.ExceptionImpostoPisCofins;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorrules.impostos.icms.CompImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;
import com.touchcomp.basementorrules.impostos.ipi.CompImpostoIPI;
import com.touchcomp.basementorrules.impostos.ipi.model.IPICalculado;
import com.touchcomp.basementorrules.impostos.ipi.model.IPIParams;
import com.touchcomp.basementorrules.impostos.piscofins.CompImpostoPisCofins;
import com.touchcomp.basementorrules.impostos.piscofins.model.PisCofinsCalculado;
import com.touchcomp.basementorrules.impostos.piscofins.model.PisCofinsParams;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.ItemUnidadeMedida;
import com.touchcomp.touchnfce.model.ModeloFiscalIcms;
import com.touchcomp.touchnfce.model.ModeloFiscalIpi;
import com.touchcomp.touchnfce.model.ModeloFiscalPisCofins;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeItemIpi;
import com.touchcomp.touchnfce.model.NFCePagamento;
import com.touchcomp.touchnfce.model.NFCeTotalizadores;
import com.touchcomp.touchnfce.model.NFCeVolume;
import com.touchcomp.touchnfce.model.Produto;
import com.touchcomp.touchnfce.model.UnidadeFederativa;
import com.touchcomp.touchnfce.model.UnidadeMedida;
import com.touchcomp.touchnfce.utils.HelperObservacoesFaturamento;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import com.touchcomp.touchnfce.utils.UtilNFCeSerial;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class UtilNFCeCalculos {
    public static void calcularValoresBasicosSemCalcImp(NFCe nfCe) throws ExceptionImpostoPisCofins, ExceptionImpostoIcms, ExceptionImpostoIPI, ExceptionAvaliadorExpressoes, ExceptionInvalidData {
        Date in = new Date();
        UtilNFCeCalculos.calcularValorProduto(nfCe);
        UtilNFCeCalculos.calcularValoresAcessoriosItens(nfCe.getItens());
        UtilNFCeCalculos.calcularValoresAcessoriosNFCe(nfCe);
        UtilNFCeCalculos.ratearValoresAcessoriesNFCeItem(nfCe);
        UtilNFCeCalculos.calcularTotaisDespAcessoriasItem(nfCe);
        UtilNFCeCalculos.calculartTotaisItens(nfCe);
        UtilNFCeCalculos.calcularTotalizadores(nfCe);
        UtilNFCeCalculos.definirObservacoes(nfCe);
        UtilNFCeCalculos.definirIndicadorPresenca(nfCe);
        UtilNFCeCalculos.definirSincManual(nfCe);
        UtilNFCeCalculos.recalcularTroco(nfCe);
        Date end = new Date();
        System.out.println("Tempo Calcular Valores: " + ToolDate.difBetweenDatesInMiliseconds((Date)in, (Date)end));
    }

    public static void calcularValores(NFCe nfCe) throws ExceptionImpostoPisCofins, ExceptionImpostoIcms, ExceptionImpostoIPI {
        Date in = new Date();
        UtilNFCeCalculos.calcularValorProduto(nfCe);
        UtilNFCeCalculos.calcularValoresAcessoriosItens(nfCe.getItens());
        UtilNFCeCalculos.calcularValoresAcessoriosNFCe(nfCe);
        UtilNFCeCalculos.ratearValoresAcessoriesNFCeItem(nfCe);
        UtilNFCeCalculos.calcularTotaisDespAcessoriasItem(nfCe);
        UtilNFCeCalculos.calculartTotaisItens(nfCe);
        UtilNFCeCalculos.calcularImpostos(nfCe);
        UtilNFCeCalculos.calcularTotalizadores(nfCe);
        UtilNFCeCalculos.definirIndicadorPresenca(nfCe);
        UtilNFCeCalculos.recalcularTroco(nfCe);
        UtilNFCeCalculos.definirPesoVolunes(nfCe);
        UtilNFCeCalculos.definirSincManual(nfCe);
        try {
            UtilNFCeCalculos.definirObservacoes(nfCe);
        }
        catch (Exception ex) {
            TLogger.get(UtilNFCeCalculos.class).error((Throwable)ex);
        }
        Date end = new Date();
        System.out.println("Tempo Calcular Valores: " + ToolDate.difBetweenDatesInMiliseconds((Date)in, (Date)end));
    }

    private static void definirSincManual(NFCe nfCe) {
        if (ToolMethods.isWithData((Number)nfCe.getIdentificadorERP())) {
            return;
        }
        if (ToolMethods.isEquals((Object)nfCe.getStatusSincERP(), (Object)1)) {
            return;
        }
        if (UtilNFCe.possuiPagBoleto(nfCe)) {
            nfCe.setSincronizacaoManual((short)1);
            return;
        }
        if (UtilNFCe.possuiItensReceita(nfCe)) {
            nfCe.setSincronizacaoManual((short)1);
            return;
        }
    }

    public static Double getValorLimitePosVenda(NFCe nfCe) {
        if (ToolMethods.isWithData((Number)nfCe.getValorLimiteDispAntesVenda())) {
            Double valorPrazo = nfCe.getPagamentos().stream().mapToDouble(i -> {
                if (ToolMethods.isAffirmative((Number)i.getStatus()) && EnumConstNFeTipoPagNFe.necessitaAnaliseCredito((String)i.getTipoPagamentoNFe().getCodigo())) {
                    return i.getValorLiquido();
                }
                return 0.0;
            }).sum();
            return nfCe.getValorLimiteDispAntesVenda() - valorPrazo;
        }
        return 0.0;
    }

    private static void definirPesoVolunes(NFCe nfCe) {
        NFCeVolume first;
        if (!ToolMethods.isAffirmative((Number)StaticObjects.getOpcoes().getTipoCalcVolNFe())) {
            nfCe.getVolumes().clear();
            return;
        }
        if (StaticObjects.getOpcoes().getEmbalagem() == null) {
            nfCe.getVolumes().clear();
            return;
        }
        double peso = 0.0;
        for (NFCeItem item : nfCe.getItens()) {
            if (!ToolMethods.isAffirmative((Number)item.getStatus()) || !ToolMethods.isWithData((Number)item.getProduto().getPesoUnitario())) continue;
            peso += item.getProduto().getPesoUnitario() * item.getQuantidadeComercial();
        }
        if (peso <= 0.0) {
            nfCe.getVolumes().clear();
            return;
        }
        if (ToolMethods.isWithData(nfCe.getVolumes())) {
            first = nfCe.getVolumes().get(0);
        } else {
            first = new NFCeVolume();
            first.setSerialForSinc(UtilNFCeSerial.getSerial(first));
            nfCe.getVolumes().add(first);
        }
        first.setQuantidade(1);
        first.setEmbalagem(StaticObjects.getOpcoes().getEmbalagem());
        first.setMarca(StaticObjects.getOpcoes().getEmbalagem().getNome());
        first.setPesoBruto(peso + first.getEmbalagem().getPeso());
        first.setPesoLiquido(peso);
        first.setNumeroVolume(1L);
        first.setNfCe(nfCe);
    }

    private static void recalcularTroco(NFCe nfCe) {
        Double totalNF = nfCe.getTotalizadores().getValorTotalNFe();
        Double totalPag = 0.0;
        for (NFCePagamento pag : nfCe.getPagamentos()) {
            if (!ToolMethods.isEquals((Object)pag.getStatus(), (Object)1)) continue;
            totalPag = totalPag + pag.getValor();
        }
        Double troco = totalPag - totalNF;
        Double totalTroco = 0.0;
        NFCePagamento ultimo = null;
        for (NFCePagamento pag : nfCe.getPagamentos()) {
            if (ToolMethods.isEquals((Object)pag.getStatus(), (Object)1) && UtilNFCe.permiteTroco(pag.getTipoPagamentoNFe(), StaticObjects.getOpcoes())) {
                pag.setValorTroco(ToolFormatter.arrredondarNumero((Double)(troco * (pag.getValor() / totalPag)), (int)2));
                pag.setValorLiquido(ToolFormatter.arrredondarNumero((Double)(pag.getValor() - pag.getValorTroco()), (int)2));
                totalTroco = totalTroco + pag.getValorTroco();
                ultimo = pag;
                continue;
            }
            pag.setValorTroco(0.0);
        }
        if (ultimo != null) {
            ultimo.setValorTroco(ToolFormatter.arrredondarNumero((Double)(ultimo.getValorTroco() + (troco - totalTroco)), (int)2));
            ultimo.setValorLiquido(ToolFormatter.arrredondarNumero((Double)(ultimo.getValor() - ultimo.getValorTroco()), (int)2));
        }
    }

    private static void definirIndicadorPresenca(NFCe nfCe) {
        if (nfCe.getEnderecoEntrega() != null && nfCe.getModeloDocFiscal().getCodigo().equals(EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
            nfCe.setIndicadorPresencaConsumidor(EnumConstNFeIndicadorPresConsumidor.NFCE_EM_OPERACAO_COM_ENTREGA_DOMICILIO.getValue());
            nfCe.setTipoIntermediadorComercial(EnumConstNFeIndIntermediador.PLATAFORMA_PROPRIA_NAO_SE_APLICA.getValue());
        }
    }

    public static void calcularValorProduto(NFCe nfCe) {
        boolean nfeTransferencia = UtilNFCe.isNotaTransferencia(nfCe);
        for (NFCeItem item : nfCe.getItens()) {
            item.setQuantidadeComercial(ToolFormatter.arrredondarNumero((Double)item.getQuantidadeComercial(), (int)3));
            if (item.getPreAbastecimento() != null) {
                if (nfeTransferencia) {
                    item.setValorUnitarioComercial(item.getPreAbastecimento().getValorUnitarioSugerido());
                    if (!ToolMethods.isWithData((Number)item.getValorUnitarioComercial())) {
                        item.setValorUnitarioComercial(item.getValorCusto());
                    }
                    item.setValorTotalBruto(item.getQuantidadeComercial() * item.getValorUnitarioComercial());
                } else {
                    item.setValorTotalBruto(item.getPreAbastecimento().getValorTotal());
                }
            } else if (ToolMethods.isAffirmative((Number)item.getCodigoBarrasPesavel())) {
                item.setValorTotalBruto(item.getValorTotal());
            } else {
                item.setValorTotalBruto(UtilNFCeCalculos.arredondarNumero(item.getQuantidadeComercial() * item.getValorUnitarioComercial()));
            }
            UtilNFCeCalculos.setQuantidadeAndValorTributario(item);
        }
    }

    private static void setQuantidadeAndValorTributario(NFCeItem it) {
        UnidadeMedida unidadeTributaria = null;
        Double fatorConversao = 1.0;
        if (it.getProduto().getItemUnidadeMedida() != null && !it.getProduto().getItemUnidadeMedida().isEmpty()) {
            for (ItemUnidadeMedida i : it.getProduto().getItemUnidadeMedida()) {
                if (!ToolMethods.isEquals((Object)i.getUtilizarConversaoSaida(), (Object)1) || !ToolMethods.isEquals((Object)i.getAtivo(), (Object)1)) continue;
                unidadeTributaria = i.getUnidadeMedida();
                fatorConversao = i.getFatorConversao();
                break;
            }
        }
        if (unidadeTributaria != null && !unidadeTributaria.equals(it.getProduto().getUnidadeMedida())) {
            Double qtdeTrib = ToolFormatter.arrredondarNumero((Double)(it.getQuantidadeComercial() * fatorConversao), (int)4);
            if (it.getProduto().getQtdeNaoFracionada() != null && it.getProduto().getQtdeNaoFracionada().equals((short)1)) {
                qtdeTrib = ToolFormatter.arrredondarNumero((Double)qtdeTrib, (int)0);
            }
            Double valorTrib = ToolFormatter.arrredondarNumero((Double)(it.getValorUnitarioComercial() / qtdeTrib * it.getQuantidadeComercial()), (int)6);
            it.setQuantidadeTributaria(qtdeTrib);
            it.setValorUnitarioTributario(valorTrib);
            it.setUnidadeMedidaTrib(unidadeTributaria);
            it.setFatorConversao(fatorConversao);
        } else {
            it.setQuantidadeTributaria(it.getQuantidadeComercial());
            it.setValorUnitarioTributario(it.getValorUnitarioComercial());
            it.setUnidadeMedidaTrib(it.getProduto().getUnidadeMedida());
            it.setFatorConversao(fatorConversao);
        }
    }

    private static void calculartTotaisItens(NFCe nfCe) {
        for (NFCeItem item : nfCe.getItens()) {
            if (!ToolMethods.isEquals((Object)item.getStatus(), (Object)1)) continue;
            Double valorTotal = item.getValorTotalBruto() - item.getValorDesconto() + item.getValorFrete() + item.getValorSeguro() + item.getValorDespesasAcessorias();
            item.setValorTotal(UtilNFCeCalculos.arredondarNumero(valorTotal));
        }
    }

    private static void calcularImpostos(NFCe nfCe) throws ExceptionImpostoPisCofins, ExceptionImpostoIcms, ExceptionImpostoIPI {
        for (NFCeItem item : nfCe.getItens()) {
            UtilNFCeCalculos.calcularImpostos(item);
        }
    }

    public static void calcularImpostos(NFCeItem item) throws ExceptionImpostoPisCofins, ExceptionImpostoIcms, ExceptionImpostoIPI {
        UtilNFCeCalculos.calcularIpi(item);
        UtilNFCeCalculos.calcularIcms(item);
        UtilNFCeCalculos.calcularPisCofins(item);
        item.setValorTotalTributos(UtilNFCeCalculos.arredondarNumero(item.getValorTotal() * item.getPercTributosPrevistos() / 100.0));
        if (ToolMethods.isWithData((Number)item.getPercTributosPrevistosEst())) {
            item.setValorTributosPrevistosEst(UtilNFCeCalculos.arredondarNumero(item.getValorTotal() * item.getPercTributosPrevistosEst() / 100.0));
        }
        if (ToolMethods.isWithData((Number)item.getPercTributosPrevistosFed())) {
            item.setValorTributosPrevistosFed(UtilNFCeCalculos.arredondarNumero(item.getValorTotal() * item.getPercTributosPrevistosFed() / 100.0));
        }
        if (ToolMethods.isWithData((Number)item.getPercTributosPrevistosMun())) {
            item.setValorTributosPrevistosMun(UtilNFCeCalculos.arredondarNumero(item.getValorTotal() * item.getPercTributosPrevistosMun() / 100.0));
        }
    }

    private static void calcularIcms(NFCeItem item) throws ExceptionImpostoIcms {
        ModeloFiscalIcms mod = item.getModeloFiscal().getModeloFiscalIcms();
        Produto prod = item.getProduto();
        Empresa empresa = item.getNfce().getEmpresa();
        UnidadeFederativa uf = empresa.getPessoa().getEndereco().getCidade().getUf();
        Short tipoAliqFCP = 0;
        Double aliqIcms = 0.0;
        Double percRedBCIcms = 0.0;
        Double percDiferimento = 0.0;
        if (ToolMethods.isEquals((Object)mod.getTipoAliquotaIcms(), (Object)1)) {
            aliqIcms = prod.getAliquotaIcms();
        } else if (ToolMethods.isEquals((Object)mod.getTipoAliquotaIcms(), (Object)2)) {
            aliqIcms = mod.getAliquotaIcms();
        }
        if (mod.getTipoAliquotaIcms() == null) {
            throw new ExceptionErroProgramacao("Tipo Aliquota de icms nula. Verifique modelo fiscal e produto: " + String.valueOf(prod) + " / " + String.valueOf(mod));
        }
        if (ToolMethods.isEquals((Object)mod.getTipoPercReducaoBaseCalcIcms(), (Object)1)) {
            percRedBCIcms = prod.getReducaoBaseCalcIcms();
        } else if (ToolMethods.isEquals((Object)mod.getTipoPercReducaoBaseCalcIcms(), (Object)2)) {
            percRedBCIcms = mod.getReducaoBaseCalcIcms();
        }
        if (mod.getTipoPercReducaoBaseCalcIcms() == null) {
            throw new ExceptionErroProgramacao("Tipo Percentual Reducao de icms nula. Verifique modelo fiscal e produto: " + String.valueOf(prod) + " / " + String.valueOf(mod));
        }
        String codIncIcms = mod.getIncidenciaIcms().getCodigo().substring(1);
        if ((ToolMethods.isEquals((Object)"20", (Object)codIncIcms) || ToolMethods.isEquals((Object)"70", (Object)codIncIcms)) && !ToolMethods.isWithData((Number)percRedBCIcms)) {
            throw new ExceptionErroProgramacao("As incidencias 20/70 possuem reducao, mas nao foi informada: " + String.valueOf(prod) + " / " + String.valueOf(mod));
        }
        if (ToolMethods.isEquals((Object)mod.getTipoPercDiferimento(), (Object)1)) {
            percDiferimento = prod.getPercentualDiferimento();
        } else if (ToolMethods.isEquals((Object)mod.getTipoPercReducaoBaseCalcIcms(), (Object)2)) {
            percDiferimento = mod.getPercentualDiferimento();
        }
        if (mod.getTipoPercDiferimento() == null) {
            throw new ExceptionErroProgramacao("Tipo Percentual diferimento nula. Verifique modelo fiscal e produto: " + String.valueOf(prod) + " / " + String.valueOf(mod));
        }
        IcmsParams.ParamsCalcIcms paramsCalcIcms = new IcmsParams.ParamsCalcIcms(EnumConstTipoAliquotaIcms.get((Object)mod.getTipoAliquotaIcms()), EnumConstTipoIcmsDispensado.get((Object)mod.getIcmsDispensadoDesconto()), EnumConstTipoAliquotaFCP.get((Object)tipoAliqFCP), EnumConstTipoCalculoDiferencaAliquota.NAO_CALCULAR, EnumConstantsMentorSimNao.get((Object)mod.getIncluiDesconto()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiFrete()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiSeguro()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiDespAcess()), EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.get((Object)mod.getIncluirIcmsDesonerado()), EnumConstantsMentorSimNao.get((Object)mod.getCalcularIcmsSimples()), EnumConstantsMentorSimNao.NAO, aliqIcms, percRedBCIcms, Double.valueOf(0.0), prod.getAliquotaIcms(), item.getNfce().getEmpresa().getEmpresaDados().getAliquotaSimples(), Double.valueOf(0.0), item.getIcms().getAliquotaIcmsFundoCombPobreza(), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), EnumConstModIcms.get((Object)mod.getModalidadeIcms().getCodigo()), EnumConstantsMentorSimNao.NAO, EnumConstModFiscalDifal.TIPO_DIFAL_NAO_CALCULAR, mod.getMotivoDesoneracaoIcms() != null ? EnumConstMotivoDesoneracaoIcms.get((Object)mod.getMotivoDesoneracaoIcms().getCodigo()) : null, new LinkedList(), new LinkedList());
        IcmsParams.ParamsCalcST paramsCalcSt = new IcmsParams.ParamsCalcST(EnumConstModIcmsST.MARGEM_VLR_AGREG, EnumConstTipoCalcIcmsST.NAO_CALCULAR, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_CAT_PRODUTO, Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), item.getIcms().getValorUnidIcmsSTRetAnt(), item.getIcms().getValorUnidBCIcmsSTRetAnt());
        paramsCalcIcms.setPercDiferimento(percDiferimento);
        IcmsParams params = new IcmsParams(EnumConstNFeIncidenciaIcms.valueOfCodigo((String)item.getIcms().getIncidenciaIcms().getCodigo().substring(1)), null, item.getValorFrete(), item.getValorSeguro(), item.getValorDespesasAcessorias(), item.getValorDesconto(), item.getValorTotalBruto(), Double.valueOf(0.0), Double.valueOf(0.0), EnumConstCfop.CFOP_INTERNO, EnumConstTipoArredondamento.ROUND_HALF_EVEN, EnumConstNFeVersao.VERSAO_4_00, Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), item.getQuantidadeComercial(), EnumConstantsMentorSimNao.SIM, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstContrEstadoIcms.NAO_CONTRIBUINTE, EnumConstantsMentorEntSaida.SAIDA, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.SIM, item.getProduto().getNcm().getCodigo(), item.getProduto().getNome(), item.getProduto().getIdentificador(), EnumConstRegimeTributario.valueOfCodigo((short)empresa.getEmpresaDados().getRegimeTributario().getCodigo().shortValue()), EnumConstUF.get((Object)uf.getSigla()), EnumConstUF.get((Object)uf.getSigla()), paramsCalcSt, paramsCalcIcms, item.getNfce().getDataEmissao(), EnumConstantsMentorSimNao.NAO, Double.valueOf(0.0));
        IcmsCalculado calc = CompImpostoIcms.calcularIcms((IcmsParams)params);
        item.getIcms().setAliquotaIcms(calc.getAliquotaIcms());
        item.getIcms().setPercRedBCIcms(calc.getPercentualRedBC());
        item.getIcms().setPercDiferimento(calc.getPercentualDiferimento());
        item.getIcms().setValorBcCalculoIcms(calc.getBaseCalculoIcms());
        item.getIcms().setValorIcms(calc.getValorIcms());
        item.getIcms().setAliquotaIcmsSimples(calc.getAliquotaIcmsSimples());
        item.getIcms().setValorIcmsSimples(calc.getValorIcmsSimples());
        item.getIcms().setValorIcmsIsento(calc.getValorIcmsIsento());
        item.getIcms().setValorIcmsOutros(calc.getValorIcmsOutros());
        item.getIcms().setValorIcmsTributado(calc.getValorIcmsTributado());
        item.getIcms().setValorBcCalculoIcmsStRetido(calc.getVrBCICMSSTRetido());
        item.getIcms().setValorIcmsStRetido(calc.getVrICMSSTRetido());
        item.getIcms().setVrNaoTribIcms(calc.getValorBCIcmsNaoTributado());
        if (item.getIcms().getMotivoDesoneracaoIcms() != null) {
            item.getIcms().setValorIcmsDesonerado(ToolFormatter.arrredondarNumero((Double)calc.getValorIcmsDispensado(), (int)2));
        }
        item.getIcms().setValorIcmsFundoCombPobreza(calc.getValorFCP());
        item.getIcms().setValorBcCalculoIcmsFundoCombPobreza(calc.getBaseCalculoFCP());
        item.getIcms().setAliquotaIcmsFundoCombPobreza(calc.getAliquotaFCP());
        item.getIcms().setQtdeBCIcmsMonoRetAnt(calc.getQtdeBCIcmsMonoRetAnt());
        item.getIcms().setAliquotaAdRemIcmsRetAnt(calc.getAliquotaAdRemIcmsRetAnt());
        item.getIcms().setValorIcmsMonoRetAnt(calc.getValorIcmsMonoRetAnt());
        if (ToolMethods.isAffirmative((Number)item.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto())) {
            item.setValorTotal(item.getValorTotal() - item.getIcms().getValorIcmsDesonerado());
        }
    }

    private static PisCofinsCalculado calcularPisCofins(NFCeItem item) throws ExceptionImpostoPisCofins {
        ModeloFiscalPisCofins mod = item.getModeloFiscal().getModeloFiscalPisCofins();
        PisCofinsParams params = new PisCofinsParams(EnumConstNFeIncidenciaCofins.valueOfCodigo((String)mod.getIncidenciaPisCofins().getCodigo()), item.getProduto().getAliquotaPis(), item.getProduto().getAliquotaCofins(), EnumConstantsMentorEntSaida.SAIDA, EnumConstTipoCalcPisCofins.get((Object)mod.getCalcularPisNormal()), EnumConstTipoCalcPisCofins.get((Object)mod.getCalcularCofinsNormal()), EnumConstTipoCalcPisCofins.get((Object)mod.getCalcularPisSt()), EnumConstTipoCalcPisCofins.get((Object)mod.getCalcularCofinsSt()), item.getValorTotalBruto(), item.getValorDesconto(), item.getValorDespesasAcessorias(), item.getValorFrete(), item.getValorSeguro(), item.getQuantidadeTributaria(), EnumConstantsMentorSimNao.get((Object)mod.getIncluiDesconto()), EnumConstantsMentorSimNao.SIM, EnumConstantsMentorSimNao.get((Object)mod.getIncluiDespAcess()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiFrete()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiSeguro()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiDesconto()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiDespAcess()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiFrete()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiSeguro()), EnumConstantsMentorSimNao.get((Object)mod.getAbaterValorIcms()), EnumConstantsMentorSimNao.SIM, null, null, EnumConstantsMentorSimNao.get((Object)mod.getAbaterValorIcms()), null, null, null, Double.valueOf(0.0), Double.valueOf(0.0), item.getIcms().getValorIcms(), item.getIcms().getValorIcmsDesonerado(), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), mod.getValorMinimoPis(), mod.getValorMinimoCofins());
        PisCofinsCalculado calc = CompImpostoPisCofins.calcularPisCofins((PisCofinsParams)params);
        item.getPis().setAliquota(calc.getAliquotaPis());
        item.getPis().setValorBaseCalculo(calc.getValorBCPis());
        item.getPis().setValor(calc.getValorPis());
        item.getCofins().setAliquota(calc.getAliquotaCofins());
        item.getCofins().setValorBaseCalculo(calc.getValorBCCofins());
        item.getCofins().setValor(calc.getValorCofins());
        return calc;
    }

    private static void calcularTotaisDespAcessoriasItem(NFCe nfCe) {
        for (NFCeItem item : nfCe.getItens()) {
            if (!ToolMethods.isEquals((Object)item.getStatus(), (Object)1)) continue;
            item.setValorSeguro(UtilNFCeCalculos.arredondarNumero(item.getValorSeguroInf() + item.getValorSeguroRat()));
            if (nfCe.getTotalizadores().getValorTotalBruto() > 0.0) {
                item.setPercentualSeguro(UtilNFCeCalculos.arredondarNumero(item.getValorSeguro() / item.getValorTotalBruto() * 100.0, 4));
            }
            item.setValorFrete(UtilNFCeCalculos.arredondarNumero(item.getValorFreteInf() + item.getValorFreteRat()));
            if (nfCe.getTotalizadores().getValorTotalBruto() > 0.0) {
                item.setPercentualFrete(UtilNFCeCalculos.arredondarNumero(item.getValorFrete() / item.getValorTotalBruto() * 100.0, 4));
            }
            item.setValorDespesasAcessorias(UtilNFCeCalculos.arredondarNumero(item.getValorDespesasAcessoriasInf() + item.getValorDespesasAcessoriasRat()));
            if (nfCe.getTotalizadores().getValorTotalBruto() > 0.0) {
                item.setPercentualDespAcess(UtilNFCeCalculos.arredondarNumero(item.getValorDespesasAcessorias() / item.getValorTotalBruto() * 100.0, 4));
            }
            item.setValorDesconto(UtilNFCeCalculos.arredondarNumero(item.getValorDescontoInf() + item.getValorDescontoRat()));
            if (item.getValorDescontoPromocional() != null && item.getValorDescontoPromocional() > 0.0) {
                item.setValorDesconto(item.getValorDesconto() + item.getValorDescontoPromocional());
            }
            if (!(item.getValorDesconto() > 0.0) || !(item.getValorTotalBruto() > 0.0)) continue;
            item.setPercentualDesconto(UtilNFCeCalculos.arredondarNumero(item.getValorDesconto() / item.getValorTotalBruto() * 100.0, 4));
            if (item.getValorDescontoPromocional() == null || !(item.getValorDescontoPromocional() > 0.0)) continue;
            item.setPercentualDescontoPromocional(UtilNFCeCalculos.arredondarNumero(item.getValorDescontoPromocional() / item.getValorTotalBruto() * 100.0));
        }
    }

    private static Double arredondarNumero(double valor) {
        return UtilNFCeCalculos.arredondarNumero(valor, 2);
    }

    private static Double arredondarNumero(double valor, int casasDec) {
        return ToolFormatter.arrredondarNumero((Double)valor, (int)casasDec);
    }

    private static void ratearValoresAcessoriesNFCeItem(NFCe nfCe) {
        NFCeTotalizadores tot = nfCe.getTotalizadores();
        Double vlrTotalBruto = tot.getValorTotalBruto();
        double totalDescCalc = 0.0;
        double totalFreteCalc = 0.0;
        double totalSegCalc = 0.0;
        double totalOutrasDespCalc = 0.0;
        NFCeItem maiorValorItem = null;
        for (NFCeItem item : nfCe.getItens()) {
            if (item.getStatus() != 1) continue;
            double perc = 0.0;
            if (vlrTotalBruto > 0.0) {
                perc = ToolFormatter.arrredondarNumero((Double)(item.getValorTotalBruto() / vlrTotalBruto), (int)6);
            }
            if (tot.getValorDescontoInf() > 0.0) {
                item.setValorDescontoRat(UtilNFCeCalculos.arredondarNumero(tot.getValorDescontoInf() * perc));
                item.setPercentualDescontoRat(ToolFormatter.arrredondarNumero((Double)(item.getValorDescontoRat() / item.getValorTotalBruto() * 100.0), (int)6));
            } else {
                item.setValorDescontoRat(0.0);
                item.setPercentualDescontoRat(0.0);
            }
            if (tot.getValorFreteInf() > 0.0) {
                item.setValorFreteRat(UtilNFCeCalculos.arredondarNumero(tot.getValorFreteInf() * perc));
                item.setPercentualFreteRat(item.getValorFreteRat() / item.getValorTotalBruto() * 100.0);
            } else {
                item.setValorFreteRat(0.0);
                item.setPercentualFreteRat(0.0);
            }
            if (tot.getValorSeguroInf() > 0.0) {
                item.setValorSeguroRat(UtilNFCeCalculos.arredondarNumero(tot.getValorSeguroInf() * perc));
                item.setPercentualSeguroRat(item.getValorSeguroRat() / item.getValorTotalBruto() * 100.0);
            } else {
                item.setValorSeguroRat(0.0);
                item.setPercentualSeguroRat(0.0);
            }
            if (tot.getValorDespAcessoriasInf() > 0.0) {
                item.setValorDespesasAcessoriasRat(UtilNFCeCalculos.arredondarNumero(tot.getValorDespAcessoriasInf() * perc));
                item.setPercentualDespAcessRat(item.getValorDespesasAcessoriasRat() / item.getValorTotalBruto() * 100.0);
            } else {
                item.setValorDespesasAcessoriasRat(0.0);
                item.setPercentualDespAcessRat(0.0);
            }
            totalOutrasDespCalc += item.getValorDespesasAcessoriasRat().doubleValue();
            totalFreteCalc += item.getValorFreteRat().doubleValue();
            totalDescCalc += item.getValorDescontoRat().doubleValue();
            totalSegCalc += item.getValorSeguroRat().doubleValue();
            if (maiorValorItem != null && !(item.getValorTotalBruto() > maiorValorItem.getValorTotalBruto())) continue;
            maiorValorItem = item;
        }
        if (maiorValorItem != null) {
            maiorValorItem.setValorFreteRat(UtilNFCeCalculos.arredondarNumero(maiorValorItem.getValorFreteRat() + (tot.getValorFreteInf() - totalFreteCalc)));
            maiorValorItem.setValorDespesasAcessoriasRat(UtilNFCeCalculos.arredondarNumero(maiorValorItem.getValorDespesasAcessoriasRat() + (tot.getValorDespAcessoriasInf() - totalOutrasDespCalc)));
            maiorValorItem.setValorDescontoRat(UtilNFCeCalculos.arredondarNumero(maiorValorItem.getValorDescontoRat() + (tot.getValorDescontoInf() - totalDescCalc)));
            maiorValorItem.setValorSeguroRat(UtilNFCeCalculos.arredondarNumero(maiorValorItem.getValorSeguroRat() + (tot.getValorSeguroInf() - totalSegCalc)));
        }
    }

    private static void calcularTotalizadores(NFCe nfCe) {
        NFCeTotalizadores tot = nfCe.getTotalizadores();
        double bcIcms = 0.0;
        double bcIcmsST = 0.0;
        double vrIcmsDesonerado = 0.0;
        double vrIcmsFundoCombPobreza = 0.0;
        double vrTotalFundoCombPobreza = 0.0;
        double vrTotalFundoCombPobrezaST = 0.0;
        double vrTotalFundoCombPobrezaSTRet = 0.0;
        double vrTotalIcms = 0.0;
        double qtdeBCIcmsMonoRetAnt = 0.0;
        double valorIcmsMonoRetAnt = 0.0;
        double vrTotalCofins = 0.0;
        double vrTotalPis = 0.0;
        double vrTotalIpi = 0.0;
        double vrTotalDesconto = 0.0;
        double vrTotalFrete = 0.0;
        double vrTotalSeguro = 0.0;
        double vrTotalOutrasDesp = 0.0;
        double vrTotalNFe = 0.0;
        double vrTotalTributos = 0.0;
        double vrTotalTributosEst = 0.0;
        double vrTotalTributosMun = 0.0;
        double vrTotalTributosFed = 0.0;
        double vrTotalProdServi = 0.0;
        for (NFCeItem i : nfCe.getItens()) {
            if (i.getStatus() != 1) continue;
            bcIcms += i.getIcms().getValorIcmsTributado().doubleValue();
            vrIcmsDesonerado += i.getIcms().getValorIcmsDesonerado().doubleValue();
            vrIcmsFundoCombPobreza += i.getIcms().getValorIcmsFundoCombPobreza().doubleValue();
            vrTotalIcms += i.getIcms().getValorIcms().doubleValue();
            vrTotalCofins += i.getCofins().getValor().doubleValue();
            vrTotalPis += i.getPis().getValor().doubleValue();
            if (i.getIpi() != null) {
                vrTotalIpi += i.getIpi().getValorIpiIndustria() + i.getIpi().getValorIpiComercio();
            }
            vrTotalDesconto += i.getValorDesconto().doubleValue();
            vrTotalFrete += i.getValorFrete().doubleValue();
            vrTotalSeguro += i.getValorSeguro().doubleValue();
            vrTotalOutrasDesp += i.getValorDespesasAcessorias().doubleValue();
            vrTotalNFe += i.getValorTotal().doubleValue();
            vrTotalProdServi += i.getValorTotalBruto().doubleValue();
            vrTotalTributos += i.getValorTotalTributos().doubleValue();
            if (ToolMethods.isWithData((Number)i.getValorTributosPrevistosEst())) {
                vrTotalTributosEst += i.getValorTributosPrevistosEst().doubleValue();
            }
            if (ToolMethods.isWithData((Number)i.getValorTributosPrevistosFed())) {
                vrTotalTributosFed += i.getValorTributosPrevistosFed().doubleValue();
            }
            if (ToolMethods.isWithData((Number)i.getValorTributosPrevistosMun())) {
                vrTotalTributosMun += i.getValorTributosPrevistosMun().doubleValue();
            }
            if (ToolMethods.isWithData((Number)i.getIcms().getQtdeBCIcmsMonoRetAnt())) {
                qtdeBCIcmsMonoRetAnt += i.getIcms().getQtdeBCIcmsMonoRetAnt().doubleValue();
            }
            if (!ToolMethods.isWithData((Number)i.getIcms().getValorIcmsMonoRetAnt())) continue;
            valorIcmsMonoRetAnt += i.getIcms().getValorIcmsMonoRetAnt().doubleValue();
        }
        tot.setBaseCalculoICMS(UtilNFCeCalculos.arredondarNumero(bcIcms));
        tot.setBaseCalculoICMSST(UtilNFCeCalculos.arredondarNumero(bcIcmsST));
        tot.setValorICMSDesonerado(UtilNFCeCalculos.arredondarNumero(vrIcmsDesonerado));
        tot.setValorICMSFundoCombatePobreza(UtilNFCeCalculos.arredondarNumero(vrIcmsFundoCombPobreza));
        tot.setValorTotalCOFINS(UtilNFCeCalculos.arredondarNumero(vrTotalCofins));
        tot.setValorTotalDesconto(UtilNFCeCalculos.arredondarNumero(vrTotalDesconto));
        tot.setValorTotalDosProdutosServicos(UtilNFCeCalculos.arredondarNumero(vrTotalProdServi));
        tot.setValorTotalFrete(UtilNFCeCalculos.arredondarNumero(vrTotalFrete));
        tot.setValorTotalFundoCombatePobreza(UtilNFCeCalculos.arredondarNumero(vrTotalFundoCombPobreza));
        tot.setValorTotalFundoCombatePobrezaST(UtilNFCeCalculos.arredondarNumero(vrTotalFundoCombPobrezaST));
        tot.setValorTotalFundoCombatePobrezaSTRetido(UtilNFCeCalculos.arredondarNumero(vrTotalFundoCombPobrezaSTRet));
        tot.setValorTotalICMS(UtilNFCeCalculos.arredondarNumero(vrTotalIcms));
        tot.setValorTotalICMSST(0.0);
        tot.setValorTotalNFe(UtilNFCeCalculos.arredondarNumero(vrTotalNFe));
        tot.setValorTotalDespAcessorias(UtilNFCeCalculos.arredondarNumero(vrTotalOutrasDesp));
        tot.setValorTotalPIS(UtilNFCeCalculos.arredondarNumero(vrTotalPis));
        tot.setValorTotalSeguro(UtilNFCeCalculos.arredondarNumero(vrTotalSeguro));
        tot.setValorTotalIPI(UtilNFCeCalculos.arredondarNumero(vrTotalIpi));
        tot.setValorTotalTributos(UtilNFCeCalculos.arredondarNumero(vrTotalTributos));
        tot.setValorTributosPrevistosEst(UtilNFCeCalculos.arredondarNumero(vrTotalTributosEst));
        tot.setValorTributosPrevistosFed(UtilNFCeCalculos.arredondarNumero(vrTotalTributosFed));
        tot.setValorTributosPrevistosMun(UtilNFCeCalculos.arredondarNumero(vrTotalTributosMun));
        if (vrTotalNFe > 0.0) {
            tot.setPercTributosPrevistosEst(UtilNFCeCalculos.arredondarNumero(ToolNumber.calcPercentual((Double)vrTotalTributosEst, (Double)vrTotalNFe)));
            tot.setPercTributosPrevistosFed(UtilNFCeCalculos.arredondarNumero(ToolNumber.calcPercentual((Double)vrTotalTributosFed, (Double)vrTotalNFe)));
            tot.setPercTributosPrevistosMun(UtilNFCeCalculos.arredondarNumero(ToolNumber.calcPercentual((Double)vrTotalTributosMun, (Double)vrTotalNFe)));
            tot.setPercTributosPrevistos(UtilNFCeCalculos.arredondarNumero(ToolNumber.calcPercentual((Double)vrTotalTributos, (Double)vrTotalNFe)));
        }
        tot.setQtdeTotalBCIcmsMonoRetAnt(qtdeBCIcmsMonoRetAnt);
        tot.setValorTotalIcmsMonoRetAnt(valorIcmsMonoRetAnt);
    }

    public static void calcularValoresAcessoriosItens(List<NFCeItem> itens) {
        itens.forEach(item -> {
            if (ToolMethods.isEquals((Object)item.getStatus(), (Object)1)) {
                if (item.getPreAbastecimento() == null) {
                    item.setValorTotalBruto(UtilNFCeCalculos.arredondarNumero(item.getQuantidadeComercial() * item.getValorUnitarioComercial()));
                } else if (item.getIdentificador() == null) {
                    item.setValorTotalBruto(UtilNFCeCalculos.arredondarNumero(item.getPreAbastecimento().getValorTotal()));
                }
                if (item.getPercValorDespAcess().shortValue() == EnumConstPercentualValor.PERCENTUAL.getValue()) {
                    item.setValorDespesasAcessoriasInf(UtilNFCeCalculos.arredondarNumero(item.getValorTotalBruto() * item.getPercentualDespAcessInf() / 100.0));
                } else if (item.getValorTotalBruto() > 0.0) {
                    item.setPercentualDespAcessInf(UtilNFCeCalculos.arredondarNumero(item.getValorDespesasAcessoriasInf() / item.getValorTotalBruto() * 100.0));
                } else {
                    item.setPercentualDespAcessInf(0.0);
                    item.setValorDespesasAcessoriasInf(0.0);
                }
                if (item.getPercValorSeguro().shortValue() == EnumConstPercentualValor.PERCENTUAL.getValue()) {
                    item.setValorSeguroInf(UtilNFCeCalculos.arredondarNumero(item.getValorTotalBruto() * item.getPercentualSeguroInf() / 100.0));
                } else if (item.getValorTotalBruto() > 0.0) {
                    item.setPercentualSeguroInf(UtilNFCeCalculos.arredondarNumero(item.getValorSeguroInf() / item.getValorTotalBruto() * 100.0));
                } else {
                    item.setPercentualSeguroInf(0.0);
                    item.setValorSeguroInf(0.0);
                }
                if (item.getPercValorFrete().shortValue() == EnumConstPercentualValor.PERCENTUAL.getValue()) {
                    item.setValorFreteInf(UtilNFCeCalculos.arredondarNumero(item.getValorTotalBruto() * item.getPercentualFreteInf() / 100.0));
                } else if (item.getValorTotalBruto() > 0.0) {
                    item.setPercentualFreteInf(UtilNFCeCalculos.arredondarNumero(item.getValorFreteInf() / item.getValorTotalBruto() * 100.0));
                } else {
                    item.setPercentualFreteInf(0.0);
                    item.setValorFreteInf(0.0);
                }
                if (item.getPercValorDesconto().shortValue() == EnumConstPercentualValor.PERCENTUAL.getValue()) {
                    item.setValorDescontoInf(UtilNFCeCalculos.arredondarNumero(item.getValorTotalBruto() * item.getPercentualDescontoInf() / 100.0));
                } else if (item.getPercValorDesconto().shortValue() == EnumConstPercentualValor.VALOR.getValue() && item.getValorDescontoInf() > 0.0) {
                    item.setPercentualDescontoInf(UtilNFCeCalculos.arredondarNumero(item.getValorDescontoInf() / item.getValorTotalBruto() * 100.0));
                } else {
                    item.setPercentualDescontoInf(0.0);
                    item.setValorDescontoInf(0.0);
                }
            }
        });
    }

    private static void calcularValoresAcessoriosNFCe(NFCe nfCe) {
        NFCeTotalizadores tot = nfCe.getTotalizadores();
        Double totalVlrBruto = 0.0;
        for (NFCeItem iten : nfCe.getItens()) {
            if (iten.getStatus() != 1) continue;
            totalVlrBruto = totalVlrBruto + iten.getValorTotalBruto();
        }
        tot.setValorTotalBruto(UtilNFCeCalculos.arredondarNumero(totalVlrBruto));
        if (tot.getPercValorDespAcess().shortValue() == EnumConstPercentualValor.PERCENTUAL.getValue()) {
            tot.setValorDespAcessoriasInf(UtilNFCeCalculos.arredondarNumero(tot.getValorTotalBruto() * tot.getPercDespAcessInf() / 100.0));
        } else if (tot.getValorTotalBruto() > 0.0) {
            tot.setPercDespAcessInf(UtilNFCeCalculos.arredondarNumero(tot.getValorDespAcessoriasInf() / tot.getValorTotalBruto() * 100.0));
        } else {
            tot.setPercDespAcessInf(0.0);
            tot.setValorDespAcessoriasInf(0.0);
        }
        if (tot.getPercValorDesconto().shortValue() == EnumConstPercentualValor.PERCENTUAL.getValue()) {
            tot.setValorDescontoInf(UtilNFCeCalculos.arredondarNumero(tot.getValorTotalBruto() * tot.getPercDescontoInf() / 100.0));
        } else if (tot.getValorTotalBruto() > 0.0) {
            tot.setPercDescontoInf(UtilNFCeCalculos.arredondarNumero(tot.getValorDescontoInf() / tot.getValorTotalBruto() * 100.0));
        } else {
            tot.setPercDescontoInf(0.0);
            tot.setValorDescontoInf(0.0);
        }
        if (tot.getPercValorFrete().shortValue() == EnumConstPercentualValor.PERCENTUAL.getValue()) {
            tot.setValorFreteInf(UtilNFCeCalculos.arredondarNumero(tot.getValorTotalBruto() * tot.getPercFreteInf() / 100.0));
        } else if (tot.getValorTotalBruto() > 0.0) {
            tot.setPercFreteInf(UtilNFCeCalculos.arredondarNumero(tot.getValorFreteInf() / tot.getValorTotalBruto() * 100.0));
        } else {
            tot.setPercFreteInf(0.0);
            tot.setValorFreteInf(0.0);
        }
        if (tot.getPercValorSeguro().shortValue() == EnumConstPercentualValor.PERCENTUAL.getValue()) {
            tot.setValorSeguroInf(UtilNFCeCalculos.arredondarNumero(tot.getValorTotalBruto() * tot.getPercSeguroInf() / 100.0));
        } else if (tot.getValorTotalBruto() > 0.0) {
            tot.setPercSeguroInf(UtilNFCeCalculos.arredondarNumero(tot.getValorSeguroInf() / tot.getValorTotalBruto() * 100.0));
        } else {
            tot.setPercSeguroInf(0.0);
            tot.setValorSeguroInf(0.0);
        }
    }

    private static void calcularIpi(NFCeItem item) throws ExceptionImpostoIPI {
        if (ToolMethods.isEquals((Object)item.getNfce().getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
            NFCeItemIpi ipi = item.getIpi();
            ModeloFiscalIpi mod = item.getModeloFiscal().getModeloFiscalIpi();
            IPIParams params = new IPIParams(EnumConstNFeIncidenciaIpi.valueOfCodigo((String)mod.getIncidenciaIpi().getCodigo()), null, null, ipi.getAliquota(), ipi.getQuantidadeVendida(), EnumConstantsMentorSimNao.NAO, EnumConstantsMentorEntSaida.SAIDA, item.getValorTotal(), item.getValorDesconto(), item.getValorDespesasAcessorias(), item.getValorFrete(), item.getValorSeguro(), EnumConstantsMentorSimNao.SIM, EnumConstantsMentorSimNao.SIM, EnumConstantsMentorSimNao.SIM, EnumConstantsMentorSimNao.SIM, EnumConstantsMentorSimNao.NAO);
            IPICalculado calc = CompImpostoIPI.calcularIpi((IPIParams)params);
            ipi.setAliquota(calc.getAliquotaIpi());
            ipi.setValorIpiComercio(calc.getValorIpiComercio());
            ipi.setValorIpiIndustria(calc.getValorIpiIndustria());
            ipi.setValorIpiIsento(calc.getValorIpiIsento());
            ipi.setValorIpiObservacao(calc.getValorIpiObservacao());
            ipi.setValorIpiOutros(calc.getValorIpiOutros());
            ipi.setValorIpiTributado(calc.getValorIpiTributado());
        }
    }

    public static void definirObservacoes(NFCe nfce) throws ExceptionAvaliadorExpressoes, ExceptionInvalidData {
        HelperObservacoesFaturamento.definirObservacoes(nfce);
    }
}

