/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils;

import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoAutenticacao;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.model.ConfigValPedidos;
import com.touchcomp.touchnfce.model.ConfigValPedidosItGrupo;
import com.touchcomp.touchnfce.model.ConfigValPedidosItem;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeLogPermissaoUsuario;
import com.touchcomp.touchnfce.model.NFCeOpcoesGrupoAfericaoAbast;
import com.touchcomp.touchnfce.model.NFCeOpcoesGrupoCanc;
import com.touchcomp.touchnfce.model.NFCeOpcoesGrupoDesc;
import com.touchcomp.touchnfce.model.NFCeOpcoesGrupoFinanc;
import com.touchcomp.touchnfce.model.NFCeOpcoesGrupoOpBomba;
import com.touchcomp.touchnfce.model.NFCePreAbastecimento;
import com.touchcomp.touchnfce.model.Usuario;
import com.touchcomp.touchnfce.model.UsuarioEmpresa;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeLogPermissaoUsuario;
import com.touchcomp.touchnfce.utils.UtilNFCeSerial;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class UtilPermissaoUsuario {
    public static boolean isPermitidoDesconto(Usuario user, Double percDesconto) {
        if (user == null) {
            return false;
        }
        if (percDesconto == null) {
            return false;
        }
        if (percDesconto == 0.0) {
            return true;
        }
        for (NFCeOpcoesGrupoDesc grupo : StaticObjects.getOpcoes().getGruposDescNFCe()) {
            for (UsuarioEmpresa aux : user.getEmpresas()) {
                if (!ToolMethods.isEquals((Object)grupo.getGrupoUsuarios(), (Object)aux.getGrupo()) || !ToolMethods.isEquals((Object)1, (Object)aux.getAtivo()) || !(grupo.getPercMaximoDesconto() >= percDesconto)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPermitidoAcrescimo(Usuario user, Double percAcrescimo) {
        if (user == null) {
            return false;
        }
        if (percAcrescimo == null) {
            return false;
        }
        if (percAcrescimo == 0.0) {
            return true;
        }
        for (NFCeOpcoesGrupoDesc grupo : StaticObjects.getOpcoes().getGruposDescNFCe()) {
            for (UsuarioEmpresa aux : user.getEmpresas()) {
                if (!ToolMethods.isEquals((Object)grupo.getGrupoUsuarios(), (Object)aux.getGrupo()) || !ToolMethods.isEquals((Object)1, (Object)aux.getAtivo()) || !(grupo.getPercMaximoAcrescimo() >= percAcrescimo)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPermitidoCancelarNFCeItem(Usuario user) {
        for (NFCeOpcoesGrupoCanc grupo : StaticObjects.getOpcoes().getGruposCancNFCe()) {
            for (UsuarioEmpresa aux : user.getEmpresas()) {
                if (!ToolMethods.isEquals((Object)grupo.getGrupoUsuarios(), (Object)aux.getGrupo()) || !ToolMethods.isEquals((Object)1, (Object)aux.getAtivo()) || !ToolMethods.isEquals((Object)1, (Object)grupo.getAtivo())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPermitidoLiberacaoFinanceira(Usuario user, List<Integer> errosLiberacaoFinanceira) {
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getTipoAvaliacaoFinanceira(), (Object)1) && ToolMethods.isWithData(errosLiberacaoFinanceira)) {
            Boolean achou = false;
            ConfigValPedidos config = StaticObjects.getOpcoes().getConfigValPedidos();
            for (Integer erro : errosLiberacaoFinanceira) {
                achou = false;
                for (ConfigValPedidosItem item : config.getItens()) {
                    if (!ToolMethods.isEquals((Object)item.getCodigo(), (Object)erro)) continue;
                    if (ToolMethods.isEquals((Object)item.getAtivo(), (Object)1)) {
                        for (ConfigValPedidosItGrupo gr : item.getGrupoUsuarios()) {
                            for (UsuarioEmpresa aux : user.getEmpresas()) {
                                if (!ToolMethods.isEquals((Object)aux.getEmpresa(), (Object)StaticObjects.getEmpresa()) || !ToolMethods.isEquals((Object)gr.getGrupoUsuarios(), (Object)aux.getGrupo()) || !ToolMethods.isEquals((Object)1, (Object)aux.getAtivo()) || !ToolMethods.isEquals((Object)1, (Object)gr.getAtivo())) continue;
                                achou = true;
                            }
                        }
                        continue;
                    }
                    achou = true;
                }
                if (achou.booleanValue()) continue;
                return false;
            }
            return achou;
        }
        for (NFCeOpcoesGrupoFinanc grupo : StaticObjects.getOpcoes().getGruposLibFinancNFCe()) {
            for (UsuarioEmpresa aux : user.getEmpresas()) {
                if (!ToolMethods.isEquals((Object)grupo.getGrupoUsuarios(), (Object)aux.getGrupo()) || !ToolMethods.isEquals((Object)1, (Object)aux.getAtivo()) || !ToolMethods.isEquals((Object)1, (Object)grupo.getAtivo())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPermitidoCancelarNFCeItem() {
        return UtilPermissaoUsuario.isPermitidoCancelarNFCeItem(StaticObjects.getUsuario());
    }

    public static boolean isPermitidoAcessarOpcoesAvancadasAbastecimento(Usuario user) {
        for (NFCeOpcoesGrupoOpBomba grupo : StaticObjects.getOpcoes().getGruposOpBombaNFCe()) {
            for (UsuarioEmpresa aux : user.getEmpresas()) {
                if (!ToolMethods.isEquals((Object)grupo.getGrupoUsuarios(), (Object)aux.getGrupo()) || !ToolMethods.isEquals((Object)1, (Object)aux.getAtivo()) || !ToolMethods.isEquals((Object)1, (Object)grupo.getAtivo())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPermitidoCancelar(Usuario user) {
        for (NFCeOpcoesGrupoCanc grupo : StaticObjects.getOpcoes().getGruposCancNFCe()) {
            for (UsuarioEmpresa aux : user.getEmpresas()) {
                if (!ToolMethods.isEquals((Object)grupo.getGrupoUsuarios(), (Object)aux.getGrupo()) || !ToolMethods.isEquals((Object)1, (Object)aux.getAtivo()) || !ToolMethods.isEquals((Object)1, (Object)grupo.getAtivo())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPermitidoAcessarOpcoesAvancadasAbastecimento() {
        Usuario user = StaticObjects.getUsuario();
        return UtilPermissaoUsuario.isPermitidoAcessarOpcoesAvancadasAbastecimento(user);
    }

    public static boolean isPermitidoAcessarAbastecimentoAfericao() {
        Usuario user = StaticObjects.getUsuario();
        return UtilPermissaoUsuario.isPermitidoAcessarOpcoesAvancadasAbastecimento(user);
    }

    public static boolean isPermitidoAcessarAbastecimentoAfericao(Usuario user) {
        for (NFCeOpcoesGrupoAfericaoAbast grupo : StaticObjects.getOpcoes().getGrupoAfericaoAbastecimento()) {
            for (UsuarioEmpresa aux : user.getEmpresas()) {
                if (!ToolMethods.isEquals((Object)grupo.getGrupoUsuarios(), (Object)aux.getGrupo()) || !ToolMethods.isEquals((Object)1, (Object)aux.getAtivo()) || !ToolMethods.isEquals((Object)1, (Object)grupo.getAtivo())) continue;
                return true;
            }
        }
        return false;
    }

    public static void createAndAddLogNotExists(Usuario u, EnumConstNFCeTipoAutenticacao tipoAutenticacao, NFCe nfce, NFCePreAbastecimento abs) {
        Optional<NFCeLogPermissaoUsuario> found;
        List<NFCeLogPermissaoUsuario> logs = nfce.getLiberacoes();
        if (logs == null) {
            logs = new LinkedList<NFCeLogPermissaoUsuario>();
        }
        if ((found = logs.stream().filter(i -> ToolMethods.isEquals((Object)i.getTipoAutorizacao(), (Object)tipoAutenticacao.getValue()) && ToolMethods.isEquals((Object)i.getUsuario(), (Object)u)).findFirst()).isPresent()) {
            return;
        }
        UtilPermissaoUsuario.createAndAddLog(u, tipoAutenticacao, nfce, abs);
    }

    private static void createAndAddLog(Usuario u, EnumConstNFCeTipoAutenticacao tipoAutenticacao, NFCe nfce, NFCePreAbastecimento abs) {
        List<NFCeLogPermissaoUsuario> logs = nfce.getLiberacoes();
        if (logs == null) {
            logs = new LinkedList<NFCeLogPermissaoUsuario>();
        }
        NFCeLogPermissaoUsuario log = UtilPermissaoUsuario.createLogPermissaoUser(u, tipoAutenticacao, nfce, abs);
        logs.add(log);
    }

    public static NFCeLogPermissaoUsuario createLogPermissaoUser(Usuario u, EnumConstNFCeTipoAutenticacao tipoAutenticacao, NFCe nfce, NFCePreAbastecimento abs) {
        ServiceNFCeLogPermissaoUsuario serviceLog = Main.getBean(ServiceNFCeLogPermissaoUsuario.class);
        NFCeLogPermissaoUsuario log = new NFCeLogPermissaoUsuario();
        log.setDataAutorizacao(new Date());
        log.setTipoAutorizacao(tipoAutenticacao.getValue());
        log.setDescricaoAlteracao(tipoAutenticacao.getDescricao());
        log.setSerialForSinc(UtilNFCeSerial.getSerial(StaticObjects.getNFCeCaixa()));
        log.setUsuario(u);
        log.setNfce(nfce);
        log.setPreAbastecimento(abs);
        return serviceLog.save(log);
    }
}

